/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

class ColumnManager
implements LayoutManager,
Serializable {
    static final long serialVersionUID = -5706896066699438744L;
    private ColumnManager columnManager;
    private int height;
    private static float CRUCIAL_RATIO = 0.3f;

    public ColumnManager() {
        this(null);
    }

    public ColumnManager(LayoutManager manager) {
        if (manager instanceof ColumnManager) {
            this.columnManager = (ColumnManager)manager;
        }
    }

    public void addLayoutComponent(String position, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container target) {
        int k = target.getComponentCount();
        if (k < 1) {
            return new Dimension(1, 1);
        }
        int width = 1;
        if (this.columnManager != null) {
            this.height = this.columnManager.getComponentHeight();
        } else {
            this.height = target.getComponent((int)0).getPreferredSize().height;
            int i = 0;
            while (i < k) {
                width = Math.max(width, target.getComponent((int)i).getPreferredSize().width);
                ++i;
            }
            int wholeWidth = target.getParent().getWidth();
            int crucialWidth = (int)((float)wholeWidth * CRUCIAL_RATIO);
            width = Math.max(Math.min(width, wholeWidth - crucialWidth), crucialWidth);
        }
        return new Dimension(width, this.height * k);
    }

    public int getComponentHeight() {
        return this.height;
    }

    public Dimension minimumLayoutSize(Container target) {
        return this.preferredLayoutSize(target);
    }

    public void layoutContainer(Container target) {
        if (target.getComponentCount() < 1) {
            return;
        }
        Insets insets = target.getInsets();
        int k = target.getComponentCount();
        int y = 0;
        int width = target.getSize().width - (insets.left + insets.right);
        int compHeight = this.columnManager != null ? this.columnManager.getComponentHeight() : target.getComponent((int)0).getPreferredSize().height;
        int i = 0;
        while (i < k) {
            target.getComponent(i).setBounds(0, y, width, compHeight);
            y += compHeight;
            ++i;
        }
    }
}

