/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Image;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import org.openide.awt.EnabledButtonModel;

public class ToolbarButton
extends JButton {
    static final long serialVersionUID = 6564434578524381134L;
    boolean disabled;

    public ToolbarButton(Icon icon) {
        super(null, icon);
        this.setModel(new EnabledButtonModel());
        this.setMargin(new Insets(2, 1, 0, 1));
        this.setBorderPainted(false);
        this.setRolloverEnabled(true);
    }

    public void processMouseEvent(MouseEvent e) {
        if (e.getID() == 504) {
            this.setBorderPainted(true);
        }
        if (e.getID() == 505) {
            this.setBorderPainted(false);
        }
        super.processMouseEvent(e);
    }

    public Icon getDisabledIcon() {
        if (!this.disabled) {
            this.setDisabledIcon(ToolbarButton.createDisabledIcon(this.getIcon()));
            this.disabled = true;
        }
        return super.getDisabledIcon();
    }

    public boolean isFocusTraversable() {
        return super.isFocusTraversable();
    }

    static Icon createDisabledIcon(Icon icon) {
        if (!(icon instanceof ImageIcon)) {
            return null;
        }
        ImageIcon imgIcon = (ImageIcon)icon;
        Image img = imgIcon.getImage();
        if (!(img instanceof BufferedImage)) {
            return null;
        }
        BufferedImage srcImg = (BufferedImage)img;
        int w = srcImg.getWidth();
        int h = srcImg.getHeight();
        int wh = w * h;
        int[] rgbArray = srcImg.getRGB(0, 0, w, h, new int[wh], 0, w);
        GrayFilter grayFilter = new GrayFilter(true, 50);
        int i = 0;
        while (i < wh) {
            rgbArray[i] = grayFilter.filterRGB(0, 0, rgbArray[i]);
            ++i;
        }
        BufferedImage destImg = new BufferedImage(w, h, 2);
        destImg.setRGB(0, 0, w, h, rgbArray, 0, w);
        return new ImageIcon(destImg);
    }
}

