/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import org.openide.awt.JInlineMenu;
import org.openide.awt.JPopupMenuUtils;

public class JMenuPlus
extends JMenu {
    static final long serialVersionUID = -7700146216422707913L;

    public JMenuPlus() {
        this("");
    }

    public JMenuPlus(String label) {
        super(label);
        this.enableInputMethods(false);
        this.getAccessibleContext().setAccessibleDescription(label);
    }

    public void setPopupMenuVisible(boolean b) {
        boolean isVisible = this.isPopupMenuVisible();
        if (b != isVisible) {
            if (b && this.isShowing()) {
                JPopupMenu popup = this.getPopupMenu();
                JInlineMenu.prepareItemsInContainer(popup);
                Point p = this.getPopupMenuOrigin();
                popup.show(this, p.x, p.y);
            } else {
                this.getPopupMenu().setVisible(false);
            }
        }
    }

    protected Point getPopupMenuOrigin() {
        int x = 0;
        int y = 0;
        JPopupMenu pm = this.getPopupMenu();
        Rectangle screenRect = JPopupMenuUtils.getScreenRect();
        Dimension s = this.getSize();
        Dimension pmSize = pm.getSize();
        int screenRight = screenRect.x + screenRect.width;
        int screenBottom = screenRect.y + screenRect.height;
        if (pmSize.width == 0) {
            pmSize = pm.getPreferredSize();
        }
        Point position = this.getLocationOnScreen();
        Container parent = this.getParent();
        if (parent instanceof JPopupMenu) {
            x = position.x + s.width + pmSize.width < screenRight ? s.width : 0 - pmSize.width;
            y = position.y + pmSize.height < screenBottom ? 0 : s.height - pmSize.height;
        } else {
            x = position.x + pmSize.width < screenRight ? 0 : s.width - pmSize.width;
            y = position.y + s.height + pmSize.height < screenBottom ? s.height : 0 - pmSize.height;
        }
        if (y < -position.y) {
            y = -position.y;
        }
        if (x < -position.x) {
            x = -position.x;
        }
        return new Point(x, y);
    }
}

