/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.utility.openide;

import com.sun.jdo.spi.persistence.utility.logging.AbstractLogger;
import org.openide.ErrorManager;

public class IDELogger
extends AbstractLogger {
    private final ErrorManager _errorManager;

    public IDELogger(String loggerName, String bundleName, ClassLoader loader) {
        super(loggerName, bundleName, loader);
        System.setProperty(loggerName, "" + IDELogger.getErrorManagerLevel(this.getLevel()));
        this._errorManager = ErrorManager.getDefault().getInstance(loggerName);
    }

    private ErrorManager getErrorManager() {
        return this._errorManager;
    }

    public synchronized void log(int level, String msg, Throwable thrown) {
        if (this.isLoggable(level)) {
            ErrorManager errorManager = this.getErrorManager();
            Throwable throwable = errorManager.annotate(thrown, this.getMessageWithPrefix(level, this.getMessage(msg)));
            errorManager.notify(IDELogger.getErrorManagerLevel(level), throwable);
        }
    }

    protected synchronized void logInternal(int level, String message) {
        this.getErrorManager().log(IDELogger.getErrorManagerLevel(level), this.getMessageWithPrefix(level, message));
    }

    private static int getErrorManagerLevel(int level) {
        switch (level) {
            case 0x7FFFFFFF: {
                return 0;
            }
            case -2147483648: 
            case 300: 
            case 400: 
            case 500: {
                return 1;
            }
            case 800: {
                return 256;
            }
            case 700: 
            case 900: {
                return 16;
            }
            case 1000: {
                return 65536;
            }
        }
        return level;
    }
}

