/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.utility.openide;

import java.net.URL;
import javax.help.HelpSet;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;

public class HelpUtils {
    public static String getHelpID(Object obj) {
        return obj instanceof String ? (String)obj : obj.getClass().getName();
    }

    public static HelpCtx getHelpCtx(Object obj) {
        return new HelpCtx(HelpUtils.getHelpID(obj));
    }

    public static HelpSet getHelpSet(String xmlFileName, String urlString) {
        try {
            FileObject helpFile = Repository.getDefault().getDefaultFileSystem().findResource(xmlFileName);
            if (helpFile != null) {
                Node.Cookie instance;
                DataObject dataObject = DataObject.find(helpFile);
                if (dataObject != null && (instance = dataObject.getCookie(InstanceCookie.class)) != null) {
                    return (HelpSet)((InstanceCookie)instance).instanceCreate();
                }
            } else {
                ClassLoader classLoader = HelpUtils.class.getClassLoader();
                URL url = HelpSet.findHelpSet((ClassLoader)classLoader, (String)urlString);
                if (url != null) {
                    return new HelpSet(classLoader, url);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static boolean isValidHelpID(String key, HelpSet helpSet) {
        return helpSet == null ? false : helpSet.getCombinedMap().isValidID(key, helpSet);
    }
}

