/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.modules.persistence.mapping.core.util;

import com.sun.jdo.modules.persistence.mapping.core.util.MappingContextFactory;
import com.sun.jdo.spi.persistence.utility.StringHelper;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class Util {
    public static final String SUPPRESS_MESSAGE = "suppressDialog";
    private static final String ICON_ROOT = "com/sun/jdo/modules/persistence/mapping/core/resources/";
    private static Icon _illegalIcon;

    public static Icon getIcon(String name, String description) {
        String fullPath = name.indexOf(46) == -1 ? ICON_ROOT + name + ".gif" : name;
        return new ImageIcon(Utilities.loadImage(fullPath), description);
    }

    public static synchronized Icon getIllegalIcon() {
        if (_illegalIcon == null) {
            _illegalIcon = Util.getIcon("org/openide/resources/propertysheet/invalid.gif", MappingContextFactory.getDefault().getString("ICON_illegal"));
        }
        return _illegalIcon;
    }

    public static FileObject findFile(FileObject f, String ext) {
        if (f != null) {
            String name = f.getName();
            int index = name.indexOf(36);
            if (index > 0) {
                name = name.substring(0, index);
            }
            return f.getParent().getFileObject(name, ext);
        }
        return null;
    }

    public static Object notifyWarning(String aWarning, Object[] options, String helpID) {
        Object returnTest = options[0];
        if (aWarning != null && aWarning.length() > 0) {
            DialogDescriptor descriptor = new DialogDescriptor((Object)aWarning, NbBundle.getBundle(DialogDescriptor.class).getString("NTF_QuestionTitle"), true, options, returnTest, 0, new HelpCtx(helpID), null);
            descriptor.setMessageType(3);
            descriptor.setClosingOptions(null);
            DialogDisplayer.getDefault().createDialog(descriptor).setVisible(true);
            returnTest = descriptor.getValue();
        }
        return returnTest;
    }

    public static boolean checkForWarning(String aWarning) {
        if (aWarning != null && aWarning.length() > 0) {
            NotifyDescriptor.Confirmation desc = new NotifyDescriptor.Confirmation((Object)aWarning, 2);
            return NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify(desc));
        }
        return true;
    }

    public static void showError(Exception e) {
        String message = Util.getErrorMessage(e);
        if (message != null) {
            NotifyDescriptor.Message desc = new NotifyDescriptor.Message(message, 0);
            DialogDisplayer.getDefault().notify(desc);
        }
    }

    public static String getErrorMessage(Exception e) {
        String message = e.getMessage();
        if (!SUPPRESS_MESSAGE.equals(message)) {
            if (!StringHelper.isEmpty((String)message)) {
                return message;
            }
            return e.getClass().getName();
        }
        return null;
    }
}

