/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.mapping.core;

import com.sun.forte4j.modules.dbmodel.ColumnElement;
import com.sun.forte4j.modules.dbmodel.DBIdentifier;
import com.sun.forte4j.modules.dbmodel.ForeignKeyElement;
import com.sun.forte4j.modules.dbmodel.ReferenceKey;
import com.sun.forte4j.modules.dbmodel.SchemaElement;
import com.sun.forte4j.modules.dbmodel.TableElement;
import com.sun.forte4j.modules.dbmodel.util.NameUtil;
import com.sun.jdo.api.persistence.mapping.core.AbstractState;
import com.sun.jdo.api.persistence.mapping.core.ClassState;
import com.sun.jdo.api.persistence.mapping.core.PairState;
import com.sun.jdo.api.persistence.mapping.core.SecondaryTableState;
import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.api.persistence.model.mapping.MappingClassElement;
import com.sun.jdo.api.persistence.model.mapping.MappingReferenceKeyElement;
import com.sun.jdo.api.persistence.model.mapping.MappingTableElement;
import com.sun.jdo.spi.persistence.utility.JavaTypeHelper;
import com.sun.jdo.spi.persistence.utility.StringHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;

public class TableState
extends AbstractState
implements Cloneable {
    private ClassState _classState;
    private TableElement _newPrimaryTable;
    private boolean _removeExistingPrimaryTable = false;
    private SchemaElement _newSchema;
    private boolean _removeExistingSchema = false;
    private Map _secondaryTableStates = new HashMap();
    private Collection _deletedSecondaryTables = new ArrayList();
    private Integer _consistencyLevel;

    public TableState(Model model, MappingClassElement state) {
        super(model, state);
    }

    public TableState(ClassState declaringClass) {
        this(declaringClass.getModel(), declaringClass.getMappingClassElement());
        this._classState = declaringClass;
    }

    public Object clone() {
        TableState clonedState = (TableState)super.clone();
        clonedState._secondaryTableStates = this.getClonedMap(this._secondaryTableStates);
        clonedState._deletedSecondaryTables = new ArrayList(this._deletedSecondaryTables);
        return clonedState;
    }

    public String getDebugInfo() {
        StringBuffer lDump = new StringBuffer();
        Iterator iterator = this.getSecondaryTableStates().iterator();
        lDump.append("New schema is " + this._newSchema + "\n");
        lDump.append("New Table is " + this.getNewPrimaryTable() + "\n");
        lDump.append("Secondary Table States are : \n");
        while (iterator.hasNext()) {
            lDump.append(((SecondaryTableState)iterator.next()).getDebugInfo());
        }
        lDump.append("Removed Secondary Tables are : \n");
        iterator = this._deletedSecondaryTables.iterator();
        while (iterator.hasNext()) {
            lDump.append("\t" + iterator.next() + "\n");
        }
        lDump.append("Consistency Level is " + this.getConsistencyLevel() + "\n");
        return lDump.toString();
    }

    public ClassState getClassState() {
        return this._classState;
    }

    protected void setClassState(ClassState state) {
        this._classState = state;
    }

    protected boolean getExistingSchemaRemoved() {
        return this._removeExistingSchema;
    }

    protected boolean schemaChangedFrom(String oldSchema) {
        return oldSchema != null && !oldSchema.equals(this.getCurrentSchemaName());
    }

    private boolean schemaHasTable(String fullTableName) {
        SchemaElement currentSchema = this.getCurrentSchema();
        if (currentSchema != null) {
            return fullTableName != null && currentSchema.getTable(DBIdentifier.create((String)fullTableName)) != null;
        }
        return false;
    }

    public SchemaElement getCurrentSchema() {
        SchemaElement lReturnSchema = this._newSchema;
        if (this._newSchema == null && !this.getExistingSchemaRemoved()) {
            lReturnSchema = this.getMappedSchema();
        }
        return lReturnSchema;
    }

    public String getCurrentSchemaName() {
        SchemaElement lSchema = this.getCurrentSchema();
        return lSchema != null ? lSchema.getName().getFullName() : (!this.getExistingSchemaRemoved() ? this.getMappedSchemaName() : "");
    }

    public void setCurrentSchema(SchemaElement schema) {
        String oldSchema = this.getCurrentSchemaName();
        this._removeExistingSchema = schema == null && this._newSchema == null && this.getMappedSchemaName().trim().length() > 0;
        this._newSchema = schema;
        if (this.schemaChangedFrom(oldSchema)) {
            this.removeRelevantTables();
        }
    }

    public SchemaElement getMappedSchema() {
        String schemaName = this.getMappedSchemaName();
        SchemaElement lReturnSchema = null;
        if (!StringHelper.isEmpty((String)schemaName)) {
            lReturnSchema = SchemaElement.forName((String)schemaName);
        }
        return lReturnSchema;
    }

    public String getMappedSchemaName() {
        MappingClassElement mappingClass = this.getMappingClassElement();
        String schemaName = null;
        if (mappingClass != null) {
            schemaName = mappingClass.getDatabaseRoot();
        }
        return schemaName != null ? schemaName : "";
    }

    public List getSortedSchemaTables() {
        return this.getSortedSchemaTables(null);
    }

    public List getSortedUnusedSchemaTables() {
        return this.getSortedSchemaTables(this.getAllTables());
    }

    public List getSortedSchemaTables(Collection excludeList) {
        int count;
        SchemaElement lSchema = this.getCurrentSchema();
        TableElement[] lTableList = lSchema != null ? lSchema.getTables() : null;
        boolean hasTables = lTableList != null;
        ArrayList<TableElement> returnList = hasTables ? new ArrayList<TableElement>(Arrays.asList(lTableList)) : new ArrayList();
        int n = count = hasTables ? lTableList.length : 0;
        if (excludeList != null) {
            Iterator excludeIterator = excludeList.iterator();
            while (excludeIterator.hasNext()) {
                String tableName = (String)excludeIterator.next();
                Iterator<TableElement> iterator = returnList.iterator();
                while (iterator.hasNext()) {
                    TableElement testElement = iterator.next();
                    if (!tableName.equals(testElement.getName().getName())) continue;
                    iterator.remove();
                }
            }
        }
        Collections.sort(returnList);
        return returnList;
    }

    protected boolean getExistingPrimaryTableRemoved() {
        return this._removeExistingPrimaryTable;
    }

    protected boolean primaryTableChangedFrom(String oldTable) {
        return oldTable != null && !oldTable.equals(this.getCurrentPrimaryTableName());
    }

    public TableElement getCurrentPrimaryTable() {
        TableElement lReturnTable = this.getNewPrimaryTable();
        if (lReturnTable == null && !this.getExistingPrimaryTableRemoved()) {
            lReturnTable = this.getMappedPrimaryTable();
        }
        return lReturnTable;
    }

    public String getCurrentPrimaryTableName() {
        TableElement lTable = this.getCurrentPrimaryTable();
        return lTable != null ? lTable.getName().getName() : (!this.getExistingPrimaryTableRemoved() ? this.getMappedPrimaryTableName() : "");
    }

    public void setCurrentPrimaryTable(TableElement primaryTable) {
        boolean newIsNull;
        String oldTable = this.getCurrentPrimaryTableName();
        boolean bl = newIsNull = primaryTable == null;
        if (!newIsNull) {
            this.setCurrentSchema(primaryTable.getDeclaringSchema());
        }
        this._removeExistingPrimaryTable = newIsNull && this.getNewPrimaryTable() == null && this.getMappedPrimaryTableName().trim().length() > 0;
        this._newPrimaryTable = primaryTable;
        if (this.primaryTableChangedFrom(oldTable)) {
            this.removeAllSecondaryTables();
        }
    }

    protected TableElement getNewPrimaryTable() {
        return this._newPrimaryTable;
    }

    public TableElement getMappedPrimaryTable() {
        MappingClassElement mappingClass = this.getMappingClassElement();
        String tableName = this.getMappedPrimaryTableName();
        TableElement lReturnTable = null;
        if (mappingClass != null && !StringHelper.isEmpty((String)tableName)) {
            String absoluteTableName = NameUtil.getAbsoluteTableName((String)mappingClass.getDatabaseRoot(), (String)tableName);
            lReturnTable = TableElement.forName((String)absoluteTableName);
        }
        return lReturnTable;
    }

    public String getMappedPrimaryTableName() {
        ArrayList lTableList;
        MappingClassElement mappingClass = this.getMappingClassElement();
        String lReturnTable = null;
        if (mappingClass != null && (lTableList = mappingClass.getTables()).size() > 0) {
            MappingTableElement lElement = (MappingTableElement)lTableList.get(0);
            lReturnTable = lElement.getTable();
        }
        return lReturnTable != null ? lReturnTable : "";
    }

    private static List getPrimaryTableCandidates(SchemaElement schema) {
        TableElement[] lTableList = schema != null ? schema.getTables() : null;
        int count = lTableList != null ? lTableList.length : 0;
        ArrayList<TableElement> returnList = new ArrayList<TableElement>();
        for (int i = 0; i < count; ++i) {
            TableElement testTable = lTableList[i];
            if (testTable.getPrimaryKey() == null) continue;
            returnList.add(testTable);
        }
        return returnList;
    }

    public static List getSortedPrimaryTableCandidates(SchemaElement schema) {
        List returnList = TableState.getPrimaryTableCandidates(schema);
        Collections.sort(returnList);
        return returnList;
    }

    public TableElement getDefaultTableMapping(String className) {
        List candidates = TableState.getPrimaryTableCandidates(this.getCurrentSchema());
        String delimiter = "_";
        if (candidates != null && className != null) {
            Iterator iterator = candidates.iterator();
            className = JavaTypeHelper.getShortClassName((String)className);
            while (iterator.hasNext()) {
                TableElement next = (TableElement)iterator.next();
                String tableName = next.getName().getName();
                if (className.equalsIgnoreCase(tableName)) {
                    return next;
                }
                if (tableName.indexOf(delimiter) == -1) continue;
                String strippedTableName = "";
                StringTokenizer st = new StringTokenizer(tableName, delimiter);
                while (st.hasMoreTokens()) {
                    strippedTableName = strippedTableName + st.nextToken();
                }
                if (!className.equalsIgnoreCase(strippedTableName)) continue;
                return next;
            }
        }
        return null;
    }

    public TableElement getDefaultTableMapping(String className, List suffixes) {
        TableElement candidate = this.getDefaultTableMapping(className);
        if (candidate == null && suffixes != null) {
            Iterator iterator = suffixes.iterator();
            while (candidate == null && iterator.hasNext()) {
                String suffix = (String)iterator.next();
                int length = className.length() - (suffix != null ? suffix.length() : 0);
                String testSuffix = length > 0 ? className.substring(length) : null;
                if (StringHelper.isEmpty((String)testSuffix) || !testSuffix.equalsIgnoreCase(suffix)) continue;
                candidate = this.getDefaultTableMapping(className.substring(0, length));
            }
        }
        return candidate;
    }

    public void addDefaultTableMapping(String className, List suffixes) {
        TableElement candidate = this.getDefaultTableMapping(className, suffixes);
        if (candidate != null) {
            this.setCurrentPrimaryTable(candidate);
        }
    }

    protected Collection getSecondaryTableStates() {
        return Collections.unmodifiableCollection(this._secondaryTableStates.values());
    }

    private SecondaryTableState getSecondaryTableState(String table) {
        return table == null ? null : (SecondaryTableState)this._secondaryTableStates.get(table);
    }

    public SecondaryTableState getCurrentStateForTable(TableElement primaryTable, String secondaryTable) {
        SecondaryTableState lState = this.getSecondaryTableState(secondaryTable);
        if (lState == null) {
            lState = this.getMappedStateForTable(primaryTable, secondaryTable);
        }
        return lState;
    }

    public SecondaryTableState getMappedStateForTable(TableElement primaryTable, String secondaryTable) {
        MappingReferenceKeyElement key = this.findReferenceKey(primaryTable, secondaryTable);
        if (key != null) {
            SecondaryTableState state = new SecondaryTableState(this.getModel(), this, secondaryTable);
            state.getPairState().addColumnPairs(key.getColumnPairNames());
            return state;
        }
        return null;
    }

    public SecondaryTableState addDefaultStateForTable(TableElement primaryTable, TableElement secondaryTable) {
        ForeignKeyElement fk = TableState.findForeignKey(primaryTable, secondaryTable);
        String secondaryTableName = secondaryTable.getName().getName();
        SecondaryTableState state = null;
        if (fk != null) {
            state = new SecondaryTableState(this.getModel(), this, secondaryTableName);
            state.getPairState().addColumnPairs(fk.getColumnPairs());
        } else {
            state = this.getMappedStateForTable(primaryTable, secondaryTableName);
        }
        if (state != null) {
            this.replaceSecondaryTableState(secondaryTableName, state);
        }
        return state;
    }

    public void addSecondaryTable(TableElement secondaryTable) {
        if (secondaryTable != null) {
            String secondaryTableName = secondaryTable.getName().getName();
            this.replaceSecondaryTableState(secondaryTableName, new SecondaryTableState(this.getModel(), this, secondaryTableName));
        }
    }

    private void replaceSecondaryTableState(String secondaryTable, SecondaryTableState state) {
        if (state != null) {
            this._secondaryTableStates.put(secondaryTable, state);
        } else {
            this._secondaryTableStates.remove(secondaryTable);
        }
    }

    public SecondaryTableState editSecondaryTable(String secondaryTable) {
        SecondaryTableState lState = null;
        if (secondaryTable != null && (lState = this.getSecondaryTableState(secondaryTable)) == null && (lState = this.getMappedStateForTable(this.getCurrentPrimaryTable(), secondaryTable)) != null) {
            this._secondaryTableStates.put(secondaryTable, lState);
        }
        return lState;
    }

    public void removeSecondaryTable(String secondaryTable) {
        if (secondaryTable != null) {
            SecondaryTableState lState = this.getSecondaryTableState(secondaryTable);
            if (lState != null) {
                this._secondaryTableStates.remove(secondaryTable);
            }
            if (lState == null || this.getMappedStateForTable(this.getCurrentPrimaryTable(), secondaryTable) != null) {
                this._deletedSecondaryTables.add(secondaryTable);
            }
        }
    }

    public void removeAllSecondaryTables() {
        this._secondaryTableStates.clear();
        this._deletedSecondaryTables.clear();
        this._deletedSecondaryTables.addAll(this.getMappedSecondaryTables());
    }

    protected void updateSecondaryTables() {
        Iterator iterator = this.getSecondaryTableStates().iterator();
        while (iterator.hasNext()) {
            PairState pairState = ((SecondaryTableState)iterator.next()).getPairState();
            pairState.setColumnPairs(pairState.getColumnPairs());
        }
    }

    private Collection getCurrentSecondaryTables() {
        Object next;
        ArrayList<Object> currentTables = new ArrayList<Object>();
        Iterator iterator = this.getSecondaryTableStates().iterator();
        while (iterator.hasNext()) {
            next = (SecondaryTableState)iterator.next();
            if (!((SecondaryTableState)next).getPairState().hasCompleteRows()) continue;
            currentTables.add(((SecondaryTableState)next).getTableName());
        }
        iterator = this.getMappedSecondaryTables().iterator();
        while (iterator.hasNext()) {
            next = (String)iterator.next();
            if (next == null || this._deletedSecondaryTables.contains(next) || currentTables.contains(next)) continue;
            currentTables.add(next);
        }
        return currentTables;
    }

    public List getSortedSecondaryTables() {
        ArrayList currentTables = new ArrayList(this.getCurrentSecondaryTables());
        Collections.sort(currentTables);
        return currentTables;
    }

    public Collection getMappedSecondaryTables() {
        ArrayList lReturnArray = new ArrayList();
        MappingClassElement lMappingClass = this.getMappingClassElement();
        if (lMappingClass != null) {
            ListIterator<String> iterator = null;
            lReturnArray.addAll(lMappingClass.getTables());
            if (lReturnArray.size() > 0) {
                lReturnArray.remove(0);
            }
            iterator = lReturnArray.listIterator();
            while (iterator.hasNext()) {
                iterator.set(((MappingTableElement)iterator.next()).getTable());
            }
        }
        return lReturnArray;
    }

    protected Collection getDeletedSecondaryMappingTables() {
        MappingClassElement mappingClass = this.getMappingClassElement();
        ArrayList<MappingTableElement> lDeletedSecondaryTables = new ArrayList<MappingTableElement>();
        Iterator iterator = this._deletedSecondaryTables.iterator();
        while (iterator.hasNext()) {
            MappingTableElement mappingTable = mappingClass.getTable((String)iterator.next());
            if (mappingTable == null) continue;
            lDeletedSecondaryTables.add(mappingTable);
        }
        return lDeletedSecondaryTables;
    }

    protected ReferenceKey findCurrentKey(TableElement primaryTable, String secondaryTable) {
        SecondaryTableState state;
        if (primaryTable != null && secondaryTable != null && (state = this.getCurrentStateForTable(primaryTable, secondaryTable)) != null) {
            PairState pairs = state.getPairState();
            return pairs.hasCompleteRows() ? pairs : null;
        }
        return null;
    }

    protected MappingReferenceKeyElement findReferenceKey(TableElement primaryTable, String secondaryTable) {
        MappingClassElement mappingClass;
        MappingTableElement parentTable;
        if (primaryTable != null && secondaryTable != null && (parentTable = (mappingClass = this.getMappingClassElement()).getTable(primaryTable.toString())) != null) {
            MappingTableElement mappingTable = mappingClass.getTable(secondaryTable);
            Iterator iterator = parentTable.getReferencingKeys().iterator();
            while (iterator.hasNext()) {
                MappingReferenceKeyElement testKey = (MappingReferenceKeyElement)iterator.next();
                if (!testKey.getTable().equals(mappingTable)) continue;
                return testKey;
            }
        }
        return null;
    }

    protected static ForeignKeyElement findForeignKey(TableElement primaryTable, TableElement secondaryTable) {
        if (primaryTable != null && secondaryTable != null) {
            ForeignKeyElement[] foreignKeys = primaryTable.getForeignKeys();
            int count = foreignKeys != null ? foreignKeys.length : 0;
            for (int i = 0; i < count; ++i) {
                ForeignKeyElement fk = foreignKeys[i];
                if (secondaryTable != fk.getReferencedTable()) continue;
                return fk;
            }
        }
        return null;
    }

    protected Collection getRemovedTables(TableState newState) {
        ArrayList removedTables = new ArrayList();
        removedTables.addAll(this.getAllTables());
        if (newState != null) {
            String newPrimary = newState.getCurrentPrimaryTableName();
            removedTables.removeAll(newState.getAllTables());
            this.addIfAbsent(removedTables, this._deletedSecondaryTables);
            if (newState.getExistingPrimaryTableRemoved()) {
                this.addIfAbsent(removedTables, newState.getMappedPrimaryTableName());
                this.addIfAbsent(removedTables, newPrimary);
            }
            if (newState.schemaChangedFrom(this.getCurrentSchemaName()) && !newState.primaryTableChangedFrom(this.getCurrentPrimaryTableName())) {
                this.removeIfPresent(removedTables, newState.getMappedPrimaryTableName());
            }
            if (newPrimary != null && this.getCurrentSecondaryTables().contains(newPrimary)) {
                this.addIfAbsent(removedTables, newPrimary);
            }
        }
        return removedTables;
    }

    private void addIfAbsent(List list, Object object) {
        String string;
        if (object instanceof String && StringHelper.isEmpty((String)(string = (String)object))) {
            object = null;
        }
        if (object != null && !list.contains(object)) {
            list.add(object);
        }
    }

    private void addIfAbsent(List destinationList, Collection sourceCollection) {
        Iterator iterator = sourceCollection.iterator();
        while (iterator.hasNext()) {
            this.addIfAbsent(destinationList, iterator.next());
        }
    }

    private void removeIfPresent(List list, Object object) {
        String string;
        if (object instanceof String && StringHelper.isEmpty((String)(string = (String)object))) {
            object = null;
        }
        if (object != null && list.contains(object)) {
            list.remove(object);
        }
    }

    private void removeRelevantTables() {
        SchemaElement currentSchema = this.getCurrentSchema();
        String currentPrimaryName = this.getCurrentPrimaryTableName();
        if (currentSchema != null) {
            if (currentPrimaryName != null) {
                if (this.schemaHasTable(currentPrimaryName)) {
                    ArrayList candidateList = new ArrayList(this._secondaryTableStates.keySet());
                    ArrayList removedTables = new ArrayList();
                    Iterator<Object> iterator = null;
                    candidateList.addAll(this.getMappedSecondaryTables());
                    iterator = candidateList.iterator();
                    while (iterator.hasNext()) {
                        String nextSecondary = (String)iterator.next();
                        if (this.schemaHasTable(nextSecondary)) continue;
                        this.addIfAbsent(removedTables, nextSecondary);
                    }
                    iterator = removedTables.iterator();
                    while (iterator.hasNext()) {
                        this.removeSecondaryTable((String)iterator.next());
                    }
                } else {
                    this.setCurrentPrimaryTable(null);
                }
            }
        } else {
            this.setCurrentPrimaryTable(null);
        }
    }

    protected List getAllTables() {
        ArrayList<String> lList = new ArrayList<String>();
        String lPrimary = this.getCurrentPrimaryTableName();
        if (!StringHelper.isEmpty((String)lPrimary)) {
            lList.add(lPrimary);
        }
        this.addIfAbsent(lList, this.getCurrentSecondaryTables());
        return lList;
    }

    public List getSortedAllTables() {
        ArrayList returnList = this.getAllTables();
        if (returnList.size() > 1) {
            ArrayList tempList = new ArrayList(returnList);
            Object primary = tempList.remove(0);
            Collections.sort(tempList);
            tempList.add(0, primary);
            returnList = tempList;
        }
        return returnList;
    }

    private List getAllTables(Collection tables) {
        ArrayList<String> returnList = new ArrayList<String>();
        Iterator iterator = tables.iterator();
        while (iterator.hasNext()) {
            Object next = iterator.next();
            if (!(next instanceof TableElement) && !(next instanceof MappingTableElement)) continue;
            returnList.add(next.toString());
        }
        return returnList;
    }

    protected TableElement getTable(String memberName) {
        return TableElement.forName((String)NameUtil.getAbsoluteTableName((String)this.getCurrentSchemaName(), (String)NameUtil.getTableName((String)memberName)));
    }

    public ColumnElement getColumn(String columnName) {
        TableElement table = this.getTable(columnName);
        return table == null ? null : table.getColumn(DBIdentifier.create((String)NameUtil.getAbsoluteMemberName((String)this.getCurrentSchemaName(), (String)columnName)));
    }

    public List getSortedAllColumns() {
        return TableState.getSortedAllColumns(this.getCurrentSchemaName(), this.getSortedAllTables());
    }

    protected static List getSortedAllColumns(List tables) {
        return TableState.getSortedAllColumns(null, tables);
    }

    protected static List getSortedAllColumns(String databaseRoot, List tables) {
        ArrayList lColumns = new ArrayList();
        Iterator iterator = tables.iterator();
        while (iterator.hasNext()) {
            Object nextTable = iterator.next();
            ArrayList tableColumns = null;
            ColumnElement[] lTColumns = null;
            TableElement lTable = null;
            if (nextTable instanceof TableElement) {
                lTable = (TableElement)nextTable;
            } else {
                String absoluteTableName = null;
                if (nextTable instanceof MappingTableElement) {
                    MappingTableElement lImpl = (MappingTableElement)nextTable;
                    absoluteTableName = NameUtil.getAbsoluteTableName((String)lImpl.getDeclaringClass().getDatabaseRoot(), (String)lImpl.getTable());
                } else if (nextTable instanceof String) {
                    absoluteTableName = NameUtil.getAbsoluteTableName((String)databaseRoot, (String)((String)nextTable));
                }
                if (absoluteTableName != null) {
                    lTable = TableElement.forName(absoluteTableName);
                }
            }
            lTColumns = lTable != null ? lTable.getColumns() : null;
            tableColumns = lTColumns != null && lTColumns.length > 0 ? Arrays.asList(lTColumns) : new ArrayList();
            Collections.sort(tableColumns);
            lColumns.addAll(tableColumns);
        }
        return lColumns;
    }

    public int getConsistencyLevel() {
        if (this._consistencyLevel == null) {
            this.setConsistencyLevel(this.getMappingClassElement().getConsistencyLevel());
        }
        return this._consistencyLevel;
    }

    public void setConsistencyLevel(int consistencyLevel) {
        this._consistencyLevel = new Integer(consistencyLevel);
    }
}

