/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.mapping.core;

import com.sun.forte4j.modules.dbmodel.ColumnElement;
import com.sun.forte4j.modules.dbmodel.ColumnPairElement;
import com.sun.forte4j.modules.dbmodel.DBException;
import com.sun.forte4j.modules.dbmodel.DBIdentifier;
import com.sun.forte4j.modules.dbmodel.DBMemberElement;
import com.sun.forte4j.modules.dbmodel.TableElement;
import com.sun.forte4j.modules.dbmodel.util.NameUtil;
import com.sun.jdo.api.persistence.mapping.core.ClassState;
import com.sun.jdo.api.persistence.mapping.core.FieldHolderState;
import com.sun.jdo.api.persistence.mapping.core.FieldState;
import com.sun.jdo.api.persistence.mapping.core.PairState;
import com.sun.jdo.api.persistence.mapping.core.RelationshipState;
import com.sun.jdo.api.persistence.mapping.core.SecondaryTableState;
import com.sun.jdo.api.persistence.mapping.core.TableState;
import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.api.persistence.model.ModelException;
import com.sun.jdo.api.persistence.model.ModelVetoException;
import com.sun.jdo.api.persistence.model.jdo.PersistenceClassElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceFieldElement;
import com.sun.jdo.api.persistence.model.jdo.RelationshipElement;
import com.sun.jdo.api.persistence.model.mapping.MappingClassElement;
import com.sun.jdo.api.persistence.model.mapping.MappingFieldElement;
import com.sun.jdo.api.persistence.model.mapping.MappingReferenceKeyElement;
import com.sun.jdo.api.persistence.model.mapping.MappingRelationshipElement;
import com.sun.jdo.api.persistence.model.mapping.MappingTableElement;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingFieldElementImpl;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingRelationshipElementImpl;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.StringHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class MappingStrategy {
    public static final String messageBase = "com.sun.jdo.api.persistence.mapping.core.Bundle";
    private static final ResourceBundle _defaultMessages = I18NHelper.loadBundle((Class)MappingStrategy.class);
    private final ResourceBundle _messages;

    public MappingStrategy() {
        this(MappingStrategy.getDefaultMessages());
    }

    public MappingStrategy(ResourceBundle bundle) {
        this._messages = bundle;
    }

    protected static final ResourceBundle getDefaultMessages() {
        return _defaultMessages;
    }

    protected ResourceBundle getMessages() {
        return this._messages;
    }

    public static String swapColumnNames(String columnPairName) {
        String ret = null;
        StringTokenizer tokenizer = new StringTokenizer(columnPairName, ";");
        int nrOfTokens = tokenizer.countTokens();
        if (nrOfTokens == 2) {
            try {
                String token1 = tokenizer.nextToken();
                String token2 = tokenizer.nextToken();
                ret = token2 + ";" + token1;
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
        }
        return ret;
    }

    public static MappingFieldElement attach(PersistenceFieldElement field, ColumnElement[] columns, MappingFieldElement fieldMapping, MappingClassElement classMapping) throws ModelException {
        boolean alreadyMapped;
        boolean bl = alreadyMapped = fieldMapping != null;
        if (columns == null) {
            columns = new ColumnElement[]{};
        }
        if (field != null) {
            PersistenceClassElement declaringClass = field.getDeclaringClass();
            if (classMapping != null) {
                if (!alreadyMapped) {
                    fieldMapping = new MappingFieldElementImpl(field.getName(), classMapping);
                    classMapping.addField(fieldMapping);
                } else {
                    MappingStrategy.removeColumnMapping(fieldMapping);
                }
                for (int i = 0; i < columns.length; ++i) {
                    fieldMapping.addColumn((DBMemberElement)columns[i]);
                }
                if (!alreadyMapped) {
                    classMapping.addField(fieldMapping);
                }
            }
        }
        return fieldMapping;
    }

    protected static MappingFieldElement[] getMappingFieldElements(MappingClassElement mappingClassElement, ColumnElement[] columnElements) {
        Vector<MappingFieldElement> mappingFieldElements = null;
        if (columnElements != null) {
            for (int i = 0; i < columnElements.length; ++i) {
                String relativeColumnName = NameUtil.getRelativeMemberName((String)columnElements[i].getName().getFullName());
                Iterator ii = mappingClassElement.getFields().iterator();
                while (ii.hasNext()) {
                    MappingFieldElement mappingFieldElement = (MappingFieldElement)ii.next();
                    Iterator iii = mappingFieldElement.getColumns().iterator();
                    while (iii.hasNext()) {
                        String columnName = (String)iii.next();
                        if (!columnName.equals(relativeColumnName)) continue;
                        if (mappingFieldElements == null) {
                            mappingFieldElements = new Vector<MappingFieldElement>();
                        }
                        mappingFieldElements.addElement(mappingFieldElement);
                    }
                }
            }
        }
        return mappingFieldElements == null ? null : mappingFieldElements.toArray(new MappingFieldElement[0]);
    }

    public static void unattach(MappingClassElement mappingElement) {
        throw new UnsupportedOperationException();
    }

    public static void unattach(MappingFieldElement mappingElement) {
        throw new UnsupportedOperationException();
    }

    public static void unattach(MappingReferenceKeyElement mappingElement) {
        throw new UnsupportedOperationException();
    }

    public static String prepareAttach(ClassState oldState, ClassState state) {
        return null;
    }

    public String prepareAttach(FieldHolderState oldFieldState, TableState state) {
        TableState oldState;
        if (oldFieldState != null && (oldState = oldFieldState.getTableState()) != null) {
            Collection fieldsToUnmap = oldFieldState.getFieldsToUnmap(state);
            int count = oldState.getRemovedTables(state).size();
            boolean hasFieldsToUnmap = fieldsToUnmap.size() > 0;
            String oldSchema = oldState.getCurrentSchemaName();
            boolean hasSchemaChange = state.schemaChangedFrom(oldSchema);
            String oldPrimaryTable = oldState.getCurrentPrimaryTableName();
            if (state.primaryTableChangedFrom(oldPrimaryTable)) {
                if (hasSchemaChange && !StringHelper.isEmpty((String)oldSchema) && !StringHelper.isEmpty((String)oldPrimaryTable) || count > 1 || hasFieldsToUnmap) {
                    return I18NHelper.getMessage((ResourceBundle)this.getMessages(), (String)"table.all_mapping_lost");
                }
            } else if (count > 0) {
                if (hasSchemaChange) {
                    return I18NHelper.getMessage((ResourceBundle)this.getMessages(), (String)"table.secondary_mapping_lost");
                }
                if (hasFieldsToUnmap) {
                    return I18NHelper.getMessage((ResourceBundle)this.getMessages(), (String)(count == 1 ? "table.fields_mapping_lost_one" : "table.fields_mapping_lost_many"));
                }
            }
        }
        return null;
    }

    public String prepareAttach(FieldHolderState oldState, FieldHolderState state) {
        Iterator iterator = state.getFieldStates().iterator();
        while (iterator.hasNext()) {
            FieldState fieldState = (FieldState)iterator.next();
            if (!(fieldState instanceof RelationshipState) || !fieldState.hasInvalidMapping()) continue;
            return I18NHelper.getMessage((ResourceBundle)this.getMessages(), (String)"table.relationship_mapping_lost");
        }
        return null;
    }

    public static void attach(ClassState state) throws ModelException {
        if (state.hasTableState()) {
            MappingStrategy.attach(state.getTableState());
        }
        if (state.hasFieldHolderState()) {
            MappingStrategy.attach(state.getFieldHolderState());
        }
    }

    public static void attach(TableState state) throws ModelException {
        MappingClassElement lMappingClass = state.getMappingClassElement();
        if (lMappingClass != null) {
            String newName = state.getCurrentSchemaName();
            String oldName = state.getMappedSchemaName();
            TableElement newTable = state.getNewPrimaryTable();
            boolean oldWasNull = StringHelper.isEmpty((String)oldName);
            Iterator iterator = null;
            iterator = state.getDeletedSecondaryMappingTables().iterator();
            while (iterator.hasNext()) {
                try {
                    lMappingClass.removeTable((MappingTableElement)iterator.next());
                }
                catch (ModelException e) {
                    if (!(e instanceof ModelVetoException)) continue;
                    throw e;
                }
            }
            if (!StringHelper.isEmpty((String)newName)) {
                if (oldWasNull || state.schemaChangedFrom(oldName)) {
                    lMappingClass.setDatabaseRoot(state.getCurrentSchema());
                }
            } else if (!oldWasNull && state.getExistingSchemaRemoved()) {
                lMappingClass.setDatabaseRoot(null);
            }
            oldName = state.getMappedPrimaryTableName();
            oldWasNull = StringHelper.isEmpty((String)oldName);
            if (newTable != null) {
                if (oldWasNull || state.primaryTableChangedFrom(oldName)) {
                    if (!oldWasNull) {
                        lMappingClass.removeTable(lMappingClass.getTable(oldName));
                    }
                    lMappingClass.setPrimaryTable(newTable);
                }
            } else if (!oldWasNull && state.getExistingPrimaryTableRemoved()) {
                lMappingClass.removeTable(lMappingClass.getTable(oldName));
            }
            iterator = state.getSecondaryTableStates().iterator();
            while (iterator.hasNext()) {
                MappingStrategy.attach((SecondaryTableState)iterator.next());
            }
            lMappingClass.setConsistencyLevel(state.getConsistencyLevel());
        }
    }

    public static void attach(SecondaryTableState state) throws ModelException {
        TableState primaryState = state.getTableState();
        MappingClassElement mappingClass = state.getMappingClassElement();
        String secondaryTableName = state.getTableName();
        TableElement primaryTable = primaryState.getCurrentPrimaryTable();
        MappingReferenceKeyElement referenceKey = primaryState.findReferenceKey(primaryTable, secondaryTableName);
        if (referenceKey == null && state.getPairState().hasCompleteRows()) {
            String absoluteTableName = NameUtil.getAbsoluteTableName((String)primaryState.getCurrentSchemaName(), (String)secondaryTableName);
            TableElement secondaryTable = TableElement.forName((String)absoluteTableName);
            referenceKey = mappingClass.addSecondaryTable(mappingClass.getTable(primaryTable.toString()), secondaryTable);
        }
        if (referenceKey != null) {
            referenceKey.setColumnPairs(state.getPairState().getColumnPairs());
        }
    }

    public static void attach(FieldHolderState state) throws ModelException {
        try {
            MappingClassElement lMappingClass = state.getMappingClassElement();
            if (lMappingClass != null) {
                TableState thisTableState = state.getTableState();
                Map extraClassStates = state.getExtraClassStates();
                Iterator<Object> iterator = extraClassStates.keySet().iterator();
                while (iterator.hasNext()) {
                    ClassState classState = (ClassState)extraClassStates.get(iterator.next());
                    TableState extraState = classState.hasTableState() ? classState.getTableState() : null;
                    if (extraState == null || thisTableState == extraState) continue;
                    MappingStrategy.attach(extraState);
                }
                iterator = state.getFieldStates().iterator();
                while (iterator.hasNext()) {
                    Object lObj = iterator.next();
                    if (lObj instanceof RelationshipState) {
                        MappingStrategy.attach((RelationshipState)lObj);
                        continue;
                    }
                    if (!(lObj instanceof FieldState)) continue;
                    MappingStrategy.attach((FieldState)lObj);
                }
                Map fetchGroups = state.getFetchGroups();
                iterator = fetchGroups.keySet().iterator();
                while (iterator.hasNext()) {
                    PersistenceFieldElement field = (PersistenceFieldElement)iterator.next();
                    MappingStrategy.setFetchGroup(lMappingClass, field, (Integer)fetchGroups.get(field));
                }
            }
        }
        catch (DBException lDBError) {
            throw new ModelException(lDBError.getMessage());
        }
    }

    public static void attach(FieldState state) throws ModelException {
        MappingClassElement lMappingClass = state.getMappingClassElement();
        PersistenceFieldElement persistenceField = state.getField();
        String databaseRoot = lMappingClass.getDatabaseRoot();
        Iterator iterator = state.getColumns().iterator();
        ArrayList<DBMemberElement> columnList = new ArrayList<DBMemberElement>();
        while (iterator.hasNext()) {
            DBMemberElement column = MappingStrategy.getMember(NameUtil.getAbsoluteMemberName((String)databaseRoot, (String)((String)iterator.next())));
            if (column == null) continue;
            columnList.add(column);
        }
        MappingStrategy.attach(persistenceField, columnList.toArray(new ColumnElement[0]), lMappingClass.getField(persistenceField.getName()), lMappingClass);
    }

    private static void attach(RelationshipState state) throws DBException, ModelException {
        MappingStrategy.attach(state, true);
    }

    private static void attach(RelationshipState state, boolean followInverse) throws DBException, ModelException {
        int i;
        int count;
        MappingClassElement lMappingClass = state.getMappingClassElement();
        RelationshipElement field = (RelationshipElement)state.getField();
        String fieldName = field.getName();
        MappingRelationshipElement lMappingField = (MappingRelationshipElement)lMappingClass.getField(fieldName);
        RelationshipElement relatedField = state.getRelatedField();
        PairState pairState = state.getColumnPairState();
        ColumnPairElement[] columnPairs = null;
        Model model = state.getModel();
        pairState.removeDuplicatePairs();
        state.getAssociatedColumnPairState().removeDuplicatePairs();
        columnPairs = pairState.getColumnPairs();
        if (pairState.hasCompleteRows()) {
            if (RelationshipState.isCollection(field, model)) {
                String oldElementClass = field.getElementClass();
                String newElementClass = state.getRelatedClass();
                RelationshipElement oldInverse = field.getInverseRelationship(model);
                if (oldInverse != null && oldElementClass != null && !oldElementClass.equals(newElementClass)) {
                    oldInverse.setInverseRelationship(null, model);
                }
                field.setElementClass(newElementClass);
            }
            field.setInverseRelationship(relatedField, model);
        }
        if (lMappingField != null) {
            MappingStrategy.removeColumnMapping((MappingFieldElement)lMappingField);
        } else {
            lMappingField = new MappingRelationshipElementImpl(fieldName, lMappingClass);
            lMappingClass.addField((MappingFieldElement)lMappingField);
        }
        if (!state.isJoinRelationship()) {
            count = columnPairs != null ? columnPairs.length : 0;
            for (i = 0; i < count; ++i) {
                lMappingField.addColumn((DBMemberElement)columnPairs[i]);
            }
        } else {
            count = columnPairs != null ? columnPairs.length : 0;
            for (i = 0; i < count; ++i) {
                lMappingField.addLocalColumn(columnPairs[i]);
            }
            pairState = state.getAssociatedColumnPairState();
            columnPairs = pairState.getColumnPairs();
            count = columnPairs != null ? columnPairs.length : 0;
            for (i = 0; i < count; ++i) {
                lMappingField.addAssociatedColumn(columnPairs[i]);
            }
        }
        if (followInverse && relatedField != null) {
            RelationshipState inverse;
            FieldHolderState holderState = state.getFieldHolderState();
            FieldHolderState relatedFieldState = holderState.getRelatedState(field, false);
            if (relatedFieldState != null && relatedFieldState != holderState && (inverse = RelationshipState.getInverseStateForState(relatedFieldState, state)) != null) {
                relatedFieldState.replaceFieldState((PersistenceFieldElement)relatedField, inverse);
                MappingStrategy.attach(inverse, false);
            }
        } else if (followInverse) {
            field.setInverseRelationship(null, model);
        }
    }

    private static void setFetchGroup(MappingClassElement mappingClass, PersistenceFieldElement field, Integer fetchGroup) throws ModelException {
        int newFG;
        int oldFG;
        MappingFieldElement element = mappingClass.getField(field.getName());
        if (fetchGroup != null && element != null && (oldFG = element.getFetchGroup()) != (newFG = fetchGroup.intValue())) {
            element.setFetchGroup(newFG);
        }
    }

    private static void removeColumnMapping(MappingFieldElement element) throws ModelException {
        ArrayList columnsToRemove = new ArrayList(element.getColumns());
        if (element instanceof MappingRelationshipElement) {
            columnsToRemove.addAll(((MappingRelationshipElement)element).getAssociatedColumns());
        }
        if (!columnsToRemove.isEmpty()) {
            Iterator iterator = columnsToRemove.iterator();
            while (iterator.hasNext()) {
                element.removeColumn((String)iterator.next());
            }
        }
    }

    protected static ColumnPairElement getPairElement(ColumnElement local, ColumnElement foreign) throws DBException {
        ColumnPairElement pair = null;
        if (local != null && foreign != null) {
            TableElement table = local.getDeclaringTable();
            pair = (ColumnPairElement)table.getMember(DBIdentifier.create((String)(local.getName().getFullName() + ';' + foreign.getName().getFullName())));
        }
        return pair;
    }

    private static DBMemberElement getMember(String columnName) {
        TableElement table = TableElement.forName((String)NameUtil.getTableName((String)columnName));
        return table != null ? table.getMember(DBIdentifier.create((String)columnName)) : null;
    }
}

