/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.mapping.core;

import com.sun.forte4j.modules.dbmodel.ColumnElement;
import com.sun.forte4j.modules.dbmodel.DBMemberElement;
import com.sun.forte4j.modules.dbmodel.util.NameUtil;
import com.sun.jdo.api.persistence.mapping.core.AbstractState;
import com.sun.jdo.api.persistence.mapping.core.FieldHolderState;
import com.sun.jdo.api.persistence.mapping.core.TableState;
import com.sun.jdo.api.persistence.model.jdo.PersistenceFieldElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class FieldState
extends AbstractState
implements Cloneable {
    private List _columns;
    private PersistenceFieldElement _field;
    private FieldHolderState _holderState;

    public FieldState(FieldHolderState declaringHolder, PersistenceFieldElement field) {
        this(declaringHolder, field, (List)null);
    }

    public FieldState(FieldHolderState declaringHolder, PersistenceFieldElement field, ColumnElement column) {
        this(declaringHolder, field, column != null ? Collections.singletonList(column) : null);
    }

    public FieldState(FieldHolderState declaringHolder, PersistenceFieldElement field, List columns) {
        super(declaringHolder.getModel());
        this._holderState = declaringHolder;
        if (this._holderState != null) {
            this.setMappingClassElement(this._holderState.getMappingClassElement());
        }
        this._field = field;
        this._columns = new ArrayList();
        if (columns != null) {
            this.setMapping(columns);
        }
    }

    public Object clone() {
        FieldState clonedState = (FieldState)super.clone();
        clonedState._columns = new ArrayList(this._columns);
        return clonedState;
    }

    public String getDebugInfo() {
        StringBuffer lDump = new StringBuffer();
        lDump.append("\tField Mapping for field " + this._field.getName() + "\n");
        lDump.append("\tMapped to Columns\n");
        lDump.append(this.getColumnDebugInfo());
        return lDump.toString();
    }

    protected String getColumnDebugInfo() {
        StringBuffer lDump = new StringBuffer();
        if (this._columns != null && this._columns.size() > 0) {
            Iterator iterator = this._columns.iterator();
            while (iterator.hasNext()) {
                lDump.append("\t\tColumn name : " + iterator.next() + "\n");
            }
        } else {
            lDump.append("\t\tNone\n");
        }
        return lDump.toString();
    }

    protected PersistenceFieldElement getField() {
        return this._field;
    }

    protected List getColumns() {
        return this._columns;
    }

    protected FieldHolderState getFieldHolderState() {
        return this._holderState;
    }

    protected void setFieldHolderState(FieldHolderState state) {
        this._holderState = state;
    }

    protected void setMapping(List columns) {
        int count = columns != null ? columns.size() : 0;
        this._columns.clear();
        for (int i = 0; i < count; ++i) {
            Object member = columns.get(i);
            String memberName = null;
            if (member instanceof DBMemberElement) {
                memberName = member != null ? NameUtil.getRelativeMemberName((String)((DBMemberElement)member).getName().getFullName()) : null;
            } else if (member instanceof String) {
                memberName = (String)member;
            }
            if (memberName == null) continue;
            this._columns.add(memberName);
        }
    }

    protected void removeMapping(String columnName) {
        this._columns.remove(columnName);
    }

    protected boolean isMappedToTable(String tablePrefix) {
        Iterator iterator = this.getLocalColumns().iterator();
        while (iterator.hasNext()) {
            String nextColumn = (String)iterator.next();
            if (!NameUtil.getTableName((String)nextColumn).equals(tablePrefix)) continue;
            return true;
        }
        return false;
    }

    protected List getLocalColumns() {
        return this._columns;
    }

    public boolean hasInvalidMapping() {
        Iterator iterator = this.getColumns().iterator();
        TableState tableState = this.getFieldHolderState().getTableState();
        while (iterator.hasNext()) {
            String columnName;
            ColumnElement column;
            Object next = iterator.next();
            if (!(next instanceof String) || (column = tableState.getColumn(columnName = (String)next)) != null) continue;
            return true;
        }
        return false;
    }
}

