/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.websrv.wizard;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.util.webservice.SEIConfig;
import com.sun.enterprise.deployment.util.webservice.WSDLConfig;
import com.sun.enterprise.deployment.util.webservice.WsCompileInvokerException;
import com.sun.enterprise.deployment.util.webservice.WsCompileInvokerImpl;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.ejb.NewEjbWizard;
import com.sun.enterprise.tools.deployment.ui.shared.ModuleArchive;
import com.sun.enterprise.tools.deployment.ui.shared.ModuleContent;
import com.sun.enterprise.tools.deployment.ui.shared.WSDLParser;
import com.sun.enterprise.tools.deployment.ui.utils.FileTools;
import com.sun.enterprise.tools.deployment.ui.utils.StringTools;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIProject;
import com.sun.enterprise.tools.deployment.ui.utils.Wizard;
import com.sun.enterprise.tools.deployment.ui.war.NewWebComponentWizard;
import com.sun.enterprise.tools.deployment.ui.websrv.wizard.ComponentTypePanel;
import com.sun.enterprise.tools.deployment.ui.websrv.wizard.InputTypePanel;
import com.sun.enterprise.tools.deployment.ui.websrv.wizard.PackageEndpointPanel;
import com.sun.enterprise.tools.deployment.ui.websrv.wizard.ServiceEndpointInterfacePanel;
import com.sun.enterprise.tools.deployment.ui.websrv.wizard.WSDLPanel;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.rmi.Remote;
import javax.swing.JComponent;
import javax.xml.namespace.QName;

public class WebServiceWizard
extends Wizard {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(WebServiceWizard.class);
    protected static final String WIZARD_TITLE_NEW = localStrings.getLocalString("ui.webservicewizard.title.new", "New Web Service Wizard");
    protected static String COMPONENT_TYPE_TITLE = localStrings.getLocalString("ui.webservicewizard.component_type.title", "Choose Component Type");
    protected static String COMPONENT_TYPE_HELP = localStrings.getLocalString("ui.webservicewizard.component_type.help", "<HTML><BODY><P>&nbsp;&nbsp;&nbsp;This wizard will generate a web service component.<br>&nbsp;&nbsp;&nbsp;If you provide either a WSDL file, or an endpoint interface and implementation,<br>&nbsp;&nbsp;&nbsp;the wizard will generate the additional files necessary to create a web service component.</BODY></HTML>");
    protected static String INPUT_TYPE_TITLE = localStrings.getLocalString("ui.webservicewizard.input_type.title", "Choose Input Type");
    protected static String INPUT_TYPE_HELP = localStrings.getLocalString("ui.webservicewizard.input_type.help", "<HTML><BODY><P>&nbsp;&nbsp;&nbsp;To create a web service endpoint you must begin with either a WSDL file or a service endpoint interface and implementation.</BODY></HTML>");
    protected static String WSDL_TITLE = localStrings.getLocalString("ui.webservicewizard.wsdl.title", "WSDL File");
    protected static String WSDL_HELP = localStrings.getLocalString("ui.webservicewizard.wsdl.help", "<HTML><BODY><P>&nbsp;&nbsp;&nbsp;Provide the WSDL file for the web service, and the package name to be used for the generated classes.</BODY></HTML>");
    protected static String ENDPOINT_INTF_TITLE = localStrings.getLocalString("ui.webservicewizard.endpoint_intf.title", "Service Endpoint Interface");
    protected static String ENDPOINT_INTF_HELP = localStrings.getLocalString("ui.webservicewizard.endpoint_intf.help", "<HTML><BODY><P>&nbsp;&nbsp;&nbsp;Provide the service endpoint interface and implementation classes.<br>&nbsp;&nbsp;&nbsp;If these classes have dependencies on other classes, append the required class to the classpath</BODY></HTML>");
    protected static String PKG_ENDPOINT_TITLE = localStrings.getLocalString("ui.webservicewizard.pkg_endpoint.title", "Create Packaged Endpoint");
    protected static String ERR_MSG = localStrings.getLocalString("ui.webservicewizard.err_msg", "Please specify:");
    private static String PLEASE_SEE_LOG = localStrings.getLocalString("ui.webservicewizard.please_see_log", "Please see the logfile for more details: " + UIConfig.getLogFile());
    private static String ERR_GEN_WSDL = localStrings.getLocalString("ui.webservicewizard.error_gen_wsdl", "Error generating WSDL.");
    private static String ERR_GEN_WS_ARTIFACTS = localStrings.getLocalString("ui.webservicewizard.error_gen_ws_artifacts", "Error generating Web Service artifacts.");
    private static String ERR_GEN_NON_PORTABLE = localStrings.getLocalString("ui.webservicewizard.error_gen_non_portable", "Error generating non-portable Web Service Client JAX-RPC stubs.");
    private static String ERR_GETTING_LOGFILE = localStrings.getLocalString("ui.webservicewizard.error_getting_logfile", "error getting logfile: ");
    private static String LOGFILE_NOT_FOUND = localStrings.getLocalString("ui.webservicewizard.logfile_not_found", "logfile not found: ");
    private static String MUST_BE_IN_DIR = localStrings.getLocalString("ui.webservicewizard.must_be_in_dir", "must be in a directory with the name ");
    private static String NOT_AN_INTF = localStrings.getLocalString("ui.webservicewizard.not_an_intf", "is not an interface.  Please select the Service Endpoint Interface.");
    private static String IS_AN_INTF = localStrings.getLocalString("ui.webservicewizard.is_an_intf", "is an interface.  Please select the Service Endpoint Implementation class.");
    private static String MUST_EXTEND_REMOTE = localStrings.getLocalString("ui.webservicewizard.must_extend_remote", "must extend the java.rmi.Remote interface.");
    protected int inputIndex = -1;
    protected int wsdlIndex = -1;
    protected int endpointIndex = -1;
    protected int pkgEndpointIndex = -1;
    protected int nextStepsIndex = -1;
    protected ComponentTypePanel compTypePanel = null;
    protected InputTypePanel inputTypePanel = null;
    protected WSDLPanel wsdlPanel = null;
    protected ServiceEndpointInterfacePanel endpointPanel = null;
    protected PackageEndpointPanel pkgEndpointPanel = null;
    protected Wizard.WizardPane inputWizardPane = null;
    protected Wizard.WizardPane wsdlWizardPane = null;
    protected Wizard.WizardPane endpointWizardPane = null;
    protected Wizard.WizardPane pkgEndpointWizardPane = null;
    private String wsName = null;
    private String classPath = null;
    private FileOutputStream fos = null;
    private String mapFile = null;
    public static final String ENDPOINT_ATTR = "ui.endpointServlet";
    private String moduleName = null;

    protected static String NEXT_STEPS_WSDL_TO_JAVA_ENDPOINT(String v0) {
        return localStrings.getLocalString("ui.webservicewizard.next_steps_wsdl_to_java_endpoint", "<HTML><BODY><P>&nbsp;&nbsp;&nbsp;A service endpoint interface, a template implementation, and a mapping file have<br>&nbsp;&nbsp;&nbsp;been generated in the output directory.<br><P>&nbsp;&nbsp;&nbsp;Output Directory: {0}<br><P>&nbsp;&nbsp;&nbsp;Next steps:<br><UL><LI>Complete the template implementation class or provide another class</LI><br><LI>Create an EJB or web component using the options in the File>New menu</LI><br><LI>Add the contents of the output directory to the module</LI><br><LI>Follow the instructions to create a web service endpoint</LI></UL></BODY></HTML>", new Object[]{v0});
    }

    protected static String NEXT_STEPS_WSDL_TO_JAVA_CLIENT(String v0) {
        return localStrings.getLocalString("ui.webservicewizard.next_steps_wsdl_to_java_client", "<HTML><BODY><P>&nbsp;&nbsp;&nbsp;A service interface &lt;and a set of JAX-RPC stubs has/have&gt; been generated in the<br>&nbsp;&nbsp;&nbsp;output directory.<br><P>&nbsp;&nbsp;&nbsp;Output Directory: {0}<br><P>&nbsp;&nbsp;&nbsp;Next steps (J2EE Client):<br><UL><LI>Create an application client, an EJB or a web component using the options in the File>New menu</LI><br><LI>Add the contents of the output directory to the module</LI><br><LI>Click on the client`s Web Service Reference tab and add a reference</LI></UL><br><P>&nbsp;&nbsp;&nbsp;Next Steps (Stand-alone Java Client):<br><UL><LI>Use the generated JAX-RPC stubs to access the endpoint</LI></UL></BODY></HTML>", new Object[]{v0});
    }

    protected static String NEXT_STEPS_JAVA_TO_WSDL(String v0, String v1) {
        return localStrings.getLocalString("ui.webservicewizard.next_steps_java_to_wsdl", "<HTML><BODY><P>&nbsp;&nbsp;&nbsp;A WSDL file and a mapping file have been generated in the output directory.<br><P>&nbsp;&nbsp;&nbsp;Output Directory: {0}<br><P>&nbsp;&nbsp;&nbsp;Next steps:<br><UL><LI>Open the {1}</LI><br><LI>Add the contents of the output directory to the module</LI><br><LI>Follow the instructions to create a web service endpoint</LI></UL></BODY></HTML> ", new Object[]{v0, v1});
    }

    protected static String NEXT_STEPS_MODULE(String v0, String v1, String v2, String v3) {
        return localStrings.getLocalString("ui.webservicewizard.next_steps_module", "<HTML><BODY><P>&nbsp;&nbsp;&nbsp;A {0} module has been created in the output directory that contains your<br>&nbsp;&nbsp;&nbsp;{1} web service endpoint.<br><P>&nbsp;&nbsp;&nbsp;{0} Module Name:&nbsp;{2}<br><br>&nbsp;&nbsp;&nbsp;Output Directory:&nbsp;{3}<br><P>&nbsp;&nbsp;&nbsp;Next steps:<br><UL><LI>Click on the new module in the tree control</LI><br><LI>If necessary, edit the contents of the module</LI><br><LI>If necessary, edit the deployment descriptor for the module</LI></UL></BODY></HTML>", new Object[]{v0, v1, v2, v3});
    }

    protected static String PKG_ENDPOINT_HELP(String v0) {
        return localStrings.getLocalString("ui.webservicewizard.pkg_endpoint.help", "<HTML><BODY><P>&nbsp;&nbsp;&nbsp;The wizard can create a web service endpoint and package it into {0} module.</BODY></HTML>", new Object[]{v0});
    }

    protected static String CLASS_NOT_FOUND(String v0, String v1) {
        return localStrings.getLocalString("ui.webservicewizard.class_not_found", "The service endpoint implementation class could not be found:\n{0}\n{1}", new Object[]{v0, v1});
    }

    protected static String ERROR_RETREIVING_CLASS(String v0, String v1) {
        return localStrings.getLocalString("ui.webservicewizard.error_retreiving_class", "There was an error retrieving the service endpoint implementation class:\n{0}\n{1}", new Object[]{v0, v1});
    }

    private static String IS_NOT_IMPL_OF(String v0, String v1) {
        return localStrings.getLocalString("ui.webservicewizard.is_not_impl_of", "{0} is not an implementation of {1}.", new Object[]{v0, v1});
    }

    private static String PLEASE_SELECT_IMPL(String v0) {
        return localStrings.getLocalString("ui.webservicewizard.please_select_impl", "Please select the Service Endpoint Implementation class that implements {0}.", new Object[]{v0});
    }

    public WebServiceWizard(Frame owner) {
        super(owner, false);
        super.setTitle(WIZARD_TITLE_NEW);
        this.addPanels();
    }

    public static void newWebService(Frame owner) {
        WebServiceWizard wizard = new WebServiceWizard(owner);
        wizard.show();
    }

    public String getHelpGroup() {
        return "SW";
    }

    public Descriptor getSelectedParentDescriptor() {
        return null;
    }

    protected void addPanels() {
        String UI = UIConfig.UI_PACKAGE;
        this.compTypePanel = (ComponentTypePanel)this.addComponent(new ComponentTypePanel(), COMPONENT_TYPE_TITLE, COMPONENT_TYPE_HELP).getPane();
        this.inputWizardPane = this.addComponent(new InputTypePanel(), INPUT_TYPE_TITLE, INPUT_TYPE_HELP);
        this.inputIndex = this.inputWizardPane.getIndex();
        this.inputTypePanel = (InputTypePanel)this.inputWizardPane.getPane();
        this.wsdlWizardPane = this.addComponent(new WSDLPanel(), WSDL_TITLE, WSDL_HELP);
        this.wsdlIndex = this.wsdlWizardPane.getIndex();
        this.wsdlPanel = (WSDLPanel)this.wsdlWizardPane.getPane();
        this.endpointWizardPane = this.addComponent(new ServiceEndpointInterfacePanel(), ENDPOINT_INTF_TITLE, ENDPOINT_INTF_HELP);
        this.endpointIndex = this.endpointWizardPane.getIndex();
        this.endpointPanel = (ServiceEndpointInterfacePanel)this.endpointWizardPane.getPane();
        this.pkgEndpointWizardPane = this.addComponent(new PackageEndpointPanel(), PKG_ENDPOINT_TITLE, WebServiceWizard.PKG_ENDPOINT_HELP("WAR/EJB"));
        this.pkgEndpointPanel = (PackageEndpointPanel)this.pkgEndpointWizardPane.getPane();
        this.pkgEndpointIndex = this.pkgEndpointWizardPane.getIndex();
        this.nextStepsIndex = this.addNextStepsPanel("").getIndex();
    }

    protected boolean isInspectorAcceptable(int inspIndex) {
        boolean isAcceptable = true;
        String outputDir = this.compTypePanel.getOutputDirectory();
        if (inspIndex == this.inputIndex) {
            isAcceptable = this.compTypePanel.isEndpoint();
        } else if (inspIndex == this.wsdlIndex) {
            boolean bl = isAcceptable = this.compTypePanel.isClient() || this.inputTypePanel.isWsdlChoice();
            if (this.compTypePanel.isClient()) {
                this.wsdlPanel.setGenStubsPanelVisible(true);
            } else {
                this.wsdlPanel.setGenStubsPanelVisible(false);
            }
        } else if (inspIndex == this.endpointIndex) {
            isAcceptable = !this.compTypePanel.isClient() && this.inputTypePanel.isEndpointChoice();
        } else if (inspIndex == this.pkgEndpointIndex) {
            boolean bl = isAcceptable = !this.compTypePanel.isClient() && this.inputTypePanel.isEndpointChoice();
            if (isAcceptable) {
                if (this.endpointPanel.isEjbEndpointImpl()) {
                    this.pkgEndpointWizardPane.setHelpText(WebServiceWizard.PKG_ENDPOINT_HELP("an EJB"));
                    this.pkgEndpointPanel.setCreateText(PackageEndpointPanel.CREATE_HTML_DESC("An EJB", "an EJB"));
                } else {
                    this.pkgEndpointWizardPane.setHelpText(WebServiceWizard.PKG_ENDPOINT_HELP("a WAR"));
                    this.pkgEndpointPanel.setCreateText(PackageEndpointPanel.CREATE_HTML_DESC("A servlet", "a WAR"));
                }
            }
        } else if (inspIndex == this.nextStepsIndex) {
            Wizard.WizardPane p = this.getNextStepsPanel();
            if (this.compTypePanel.isEndpoint() && this.inputTypePanel.isWsdlChoice()) {
                if (!p.getHelpText().equals(WebServiceWizard.NEXT_STEPS_WSDL_TO_JAVA_ENDPOINT(outputDir))) {
                    p.setHelpText(WebServiceWizard.NEXT_STEPS_WSDL_TO_JAVA_ENDPOINT(outputDir));
                }
            } else if (this.compTypePanel.isClient() && this.inputTypePanel.isWsdlChoice()) {
                if (!p.getHelpText().equals(WebServiceWizard.NEXT_STEPS_WSDL_TO_JAVA_CLIENT(outputDir))) {
                    p.setHelpText(WebServiceWizard.NEXT_STEPS_WSDL_TO_JAVA_CLIENT(outputDir));
                }
            } else if (this.pkgEndpointPanel.isSkip()) {
                String wizard = null;
                wizard = this.endpointPanel.isEjbEndpointImpl() ? NewEjbWizard.WIZARD_TITLE_NEW : NewWebComponentWizard.WIZARD_TITLE_NEW;
                if (!p.getHelpText().equals(WebServiceWizard.NEXT_STEPS_JAVA_TO_WSDL(outputDir, wizard))) {
                    p.setHelpText(WebServiceWizard.NEXT_STEPS_JAVA_TO_WSDL(outputDir, wizard));
                }
            } else if (this.pkgEndpointPanel.isCreate()) {
                if (this.endpointPanel.isEjbEndpointImpl()) {
                    this.setModuleName(this.endpointPanel.getServiceName() + ".jar");
                    if (!p.getHelpText().equals(WebServiceWizard.NEXT_STEPS_MODULE("JAR", "EJB", this.getModuleName(), outputDir))) {
                        p.setHelpText(WebServiceWizard.NEXT_STEPS_MODULE("JAR", "EJB", this.getModuleName(), outputDir));
                    }
                } else {
                    this.setModuleName(this.endpointPanel.getServiceName() + ".war");
                    if (!p.getHelpText().equals(WebServiceWizard.NEXT_STEPS_MODULE("WAR", "servlet", this.getModuleName(), outputDir))) {
                        p.setHelpText(WebServiceWizard.NEXT_STEPS_MODULE("WAR", "servlet", this.getModuleName(), outputDir));
                    }
                }
            }
        }
        return isAcceptable;
    }

    public boolean validateComponent(Component currentComponent) {
        boolean valid = true;
        StringBuffer errMsg = new StringBuffer(ERR_MSG);
        if (currentComponent == this.compTypePanel) {
            String outputDir = this.compTypePanel.getOutputDirectory();
            if (StringTools.isEmpty(outputDir)) {
                errMsg.append("\n" + StringTools.trimColon(ComponentTypePanel.OUTPUT_DIR));
                valid = false;
            } else {
                valid = this.compTypePanel.isOutputDirectoryValid();
            }
        }
        if (currentComponent == this.wsdlPanel) {
            String wsdl = this.wsdlPanel.getWsdlFile();
            if (StringTools.isEmpty(wsdl)) {
                errMsg.append("\n" + StringTools.trimColon(WSDLPanel.WSDL_FILE));
                valid = false;
            } else {
                valid = this.wsdlPanel.isWsdlFileValid(wsdl, true);
            }
            String pkg = this.wsdlPanel.getPkgName();
            if (StringTools.isEmpty(pkg)) {
                errMsg.append("\n" + StringTools.trimColon(WSDLPanel.PKG_NAME));
                valid = false;
            } else if (valid) {
                valid = this.wsdlPanel.isPkgNameValid(pkg, true);
            }
        }
        if (currentComponent == this.endpointPanel) {
            String svcName;
            String endpointImpl;
            String endpointIntf = this.endpointPanel.getSvcEndpointIntf();
            if (StringTools.isEmpty(endpointIntf)) {
                errMsg.append("\n" + StringTools.trimColon(ServiceEndpointInterfacePanel.ENDPOINT_INTF));
                valid = false;
            }
            if (StringTools.isEmpty(endpointImpl = this.endpointPanel.getSvcEndpointImpl())) {
                errMsg.append("\n" + StringTools.trimColon(ServiceEndpointInterfacePanel.ENDPOINT_IMPL));
                valid = false;
            }
            if (StringTools.isEmpty(svcName = this.endpointPanel.getServiceName())) {
                errMsg.append("\n" + StringTools.trimColon(ServiceEndpointInterfacePanel.SERVICE_NAME));
                valid = false;
            }
            Class intfClass = null;
            if (!StringTools.isEmpty(endpointIntf)) {
                String intfClassName = this.endpointPanel.getIntfClassName();
                String pkg = this.endpointPanel.getIntfPkgName();
                String intfClassFile = FileTools.GetFileName(endpointIntf, true);
                if (!this.endpointPanel.isClassInPkgDir(endpointIntf, intfClassName)) {
                    errMsg.append("\n\n" + ServiceEndpointInterfacePanel.ENDPOINT_INTF + "\n " + intfClassFile + " " + MUST_BE_IN_DIR + pkg.replace('.', File.separatorChar));
                    valid = false;
                } else {
                    intfClass = this.endpointPanel.getClass(endpointIntf, intfClassName);
                    if (intfClass != null) {
                        if (!intfClass.isInterface()) {
                            errMsg.append("\n\n" + ServiceEndpointInterfacePanel.ENDPOINT_INTF + "\n" + intfClassFile + " " + NOT_AN_INTF);
                            valid = false;
                        } else if (!Remote.class.isAssignableFrom(intfClass)) {
                            errMsg.append("\n\n" + ServiceEndpointInterfacePanel.ENDPOINT_INTF + "\n" + intfClassFile + " " + MUST_EXTEND_REMOTE);
                            valid = false;
                        }
                    }
                }
            }
            Class implClass = null;
            if (!StringTools.isEmpty(endpointImpl)) {
                String implClassName = this.endpointPanel.getImplClassName();
                String pkg = this.endpointPanel.getImplPkgName();
                String implClassFile = FileTools.GetFileName(endpointImpl, true);
                if (!this.endpointPanel.isClassInPkgDir(endpointImpl, implClassName)) {
                    errMsg.append("\n\n" + ServiceEndpointInterfacePanel.ENDPOINT_IMPL + "\n" + implClassFile + " " + MUST_BE_IN_DIR + pkg.replace('.', File.separatorChar));
                    valid = false;
                } else {
                    implClass = this.endpointPanel.getClass(endpointImpl, implClassName);
                    if (implClass != null) {
                        if (implClass.isInterface()) {
                            errMsg.append("\n\n" + ServiceEndpointInterfacePanel.ENDPOINT_IMPL + "\n" + implClassFile + IS_AN_INTF);
                            valid = false;
                        } else if (intfClass != null) {
                            Class<?>[] intf = implClass.getInterfaces();
                            boolean implementsIntf = false;
                            for (int i = 0; i < intf.length; ++i) {
                                if (!intf[i].getName().equals(intfClass.getName())) continue;
                                implementsIntf = true;
                                break;
                            }
                            if (!implementsIntf) {
                                errMsg.append("\n\n" + ServiceEndpointInterfacePanel.ENDPOINT_IMPL + "\n" + WebServiceWizard.IS_NOT_IMPL_OF(implClassFile, intfClass.getName()) + "\n" + WebServiceWizard.PLEASE_SELECT_IMPL(intfClass.getName()));
                                valid = false;
                            }
                        }
                    }
                }
            }
        }
        if (!valid && errMsg.length() > ERR_MSG.length()) {
            UIOptionPane.showErrorDialog(this, errMsg);
        }
        return valid;
    }

    protected void _goForward() {
        JComponent currentComponent = this.getCurrentComponent();
        if (currentComponent == this.endpointPanel) {
            String endpointImpl;
            String endpointIntf = this.endpointPanel.getSvcEndpointIntf();
            if (!StringTools.isEmpty(endpointIntf)) {
                this.endpointPanel.intfAction(endpointIntf);
            }
            if (!StringTools.isEmpty(endpointImpl = this.endpointPanel.getSvcEndpointImpl())) {
                this.endpointPanel.implAction(endpointImpl);
            }
        }
        super._goForward();
    }

    public void goForward() {
        super.goForward();
    }

    public void goBackward() {
        super.goBackward();
    }

    public void finishAction() {
        super.finishAction();
        if (this.didComplete()) {
            String outputDir = this.compTypePanel.getOutputDirectory();
            if (this.compTypePanel.isClient()) {
                if (this.wsdlPanel.isGenNonPortable()) {
                    this.genJAXRPCWSClientUsingWSDL();
                } else {
                    this.genJavaUsingWSDL();
                }
            } else if (this.compTypePanel.isEndpoint()) {
                if (this.inputTypePanel.isWsdlChoice()) {
                    this.genJavaUsingWSDL();
                } else if (this.inputTypePanel.isEndpointChoice()) {
                    this.genWSDLUsingEndpoint();
                    if (this.pkgEndpointPanel.isCreate()) {
                        try {
                            this.createPackagedEndpoint();
                        }
                        catch (IOException ioe) {
                            Print.printStackTrace((String)"Error packaging endpoint", (Throwable)ioe);
                        }
                    }
                }
            }
        }
    }

    private void genJAXRPCWSClientUsingWSDL() {
        WSDLConfig wsdlConfig = this.createWsdlConfig();
        WsCompileInvokerImpl wsCompile = this.createWsCompilerInvoker();
        wsCompile.addWsCompileOption("-classpath", this.getToolsJarPath());
        try {
            wsCompile.generateClientStubs(wsdlConfig);
        }
        catch (WsCompileInvokerException wcie) {
            UIOptionPane.showErrorDialog(this, ERR_GEN_NON_PORTABLE + "\n" + PLEASE_SEE_LOG);
            Print.dprintStackTrace((String)ERR_GEN_NON_PORTABLE, (Throwable)wcie);
        }
        catch (IOException ioe) {
            UIOptionPane.showErrorDialog(this, ERR_GEN_NON_PORTABLE + "\n" + PLEASE_SEE_LOG);
            Print.dprintStackTrace((String)ERR_GEN_NON_PORTABLE, (Throwable)ioe);
        }
    }

    private void genJavaUsingWSDL() {
        WSDLConfig wsdlConfig = this.createWsdlConfig();
        WsCompileInvokerImpl wsCompile = this.createWsCompilerInvoker();
        wsCompile.addWsCompileOption("-classpath", this.getToolsJarPath());
        try {
            wsCompile.generateSEI(wsdlConfig);
        }
        catch (WsCompileInvokerException wcie) {
            UIOptionPane.showErrorDialog(this, ERR_GEN_WS_ARTIFACTS + "\n" + PLEASE_SEE_LOG);
            Print.dprintStackTrace((String)ERR_GEN_WS_ARTIFACTS, (Throwable)wcie);
        }
        catch (IOException ioe) {
            UIOptionPane.showErrorDialog(this, ERR_GEN_WS_ARTIFACTS + "\n" + PLEASE_SEE_LOG);
            Print.dprintStackTrace((String)ERR_GEN_WS_ARTIFACTS, (Throwable)ioe);
        }
    }

    private void genWSDLUsingEndpoint() {
        SEIConfig seiConfig = this.createSEIConfig();
        WsCompileInvokerImpl wsCompile = this.createWsCompilerInvoker();
        wsCompile.addWsCompileOption("-classpath", this.endpointPanel.getClassPath());
        try {
            wsCompile.generateWSDL(seiConfig);
            this.fos.close();
        }
        catch (WsCompileInvokerException wcie) {
            UIOptionPane.showErrorDialog(this, ERR_GEN_WSDL + "\n" + PLEASE_SEE_LOG);
            Print.printStackTrace((String)ERR_GEN_WSDL, (Throwable)wcie);
        }
        catch (IOException ioe) {
            UIOptionPane.showErrorDialog(this, ERR_GEN_WSDL + "\n" + PLEASE_SEE_LOG);
            Print.printStackTrace((String)ERR_GEN_WSDL, (Throwable)ioe);
        }
    }

    private WsCompileInvokerImpl createWsCompilerInvoker() {
        WsCompileInvokerImpl wsCompile = null;
        String logfile = UIConfig.getLogFile();
        try {
            this.fos = new FileOutputStream(logfile, true);
            wsCompile = new WsCompileInvokerImpl((OutputStream)this.fos);
        }
        catch (FileNotFoundException fnfe) {
            Print.printStackTrace((String)(LOGFILE_NOT_FOUND + logfile), (Throwable)fnfe);
        }
        catch (IOException ioe) {
            Print.printStackTrace((String)(ERR_GETTING_LOGFILE + logfile), (Throwable)ioe);
        }
        String outputDir = this.compTypePanel.getOutputDirectory();
        this.mapFile = outputDir + File.separator + this.wsName + "Mapping.xml";
        wsCompile.addWsCompileOption("-mapping", this.mapFile);
        wsCompile.addWsCompileOption("-d", outputDir);
        return wsCompile;
    }

    private WSDLConfig createWsdlConfig() {
        this.wsName = this.wsdlPanel.getWebServiceName();
        String wsdl = this.wsdlPanel.getWsdlFile();
        String pkg = this.wsdlPanel.getPkgName();
        if (StringTools.isEmpty(this.wsName)) {
            this.wsdlPanel.defaultWebServiceName(wsdl);
            this.wsName = this.wsdlPanel.getWebServiceName();
        }
        WSDLConfig wsdlConfig = new WSDLConfig(this.wsName, wsdl, pkg);
        return wsdlConfig;
    }

    private SEIConfig createSEIConfig() {
        this.wsName = this.endpointPanel.getServiceName();
        String nameSpace = this.endpointPanel.getNameSpace();
        String pkg = this.endpointPanel.getPkgName();
        String intf = this.endpointPanel.getIntfClassName();
        String impl = this.endpointPanel.getImplClassName();
        SEIConfig seiConfig = new SEIConfig(this.wsName, nameSpace, pkg, intf, impl);
        return seiConfig;
    }

    private String getToolsJarPath() {
        String javaHome = UIConfig.getJavaHome();
        String toolsJar = javaHome + File.separator + "lib" + File.separator + "tools.jar";
        return toolsJar;
    }

    private String getMapFile() {
        return this.mapFile;
    }

    private void createPackagedEndpoint() throws IOException {
        WebBundleDescriptor bd = null;
        String intf = this.endpointPanel.getSvcEndpointIntf();
        String impl = this.endpointPanel.getSvcEndpointImpl();
        String implName = FileTools.GetFileName(impl, false);
        String implClass = this.endpointPanel.getImplClassName();
        String intfClass = this.endpointPanel.getIntfClassName();
        String wsdl = this.getGeneratedWsdlFile();
        String mapping = this.getMapFile();
        String wsdlUri = null;
        String mappingUri = FileTools.GetFileName(mapping, true);
        WebServiceEndpoint wse = this.createWebServiceEndpoint(wsdl);
        if (this.endpointPanel.isEjbEndpointImpl()) {
            wsdlUri = "META-INF/wsdl/" + FileTools.GetFileName(wsdl, true);
            wse.setEjbLink(implName);
            EjbSessionDescriptor esd = this.createEjbSessionDescriptor(implName, implClass, intfClass);
            bd = this.createEjbBundleDescriptor(this.wsName, esd);
        } else {
            wsdlUri = "WEB-INF/wsdl/" + FileTools.GetFileName(wsdl, true);
            wse.setWebComponentLink(implName);
            WebComponentDescriptor wcd = this.createWebComponentDescriptor(implName, implClass);
            bd = this.createWebBundleDescriptor(this.wsName, wcd);
            bd.setSpecVersion("2.4");
        }
        WebService ws = this.createWebService(this.wsName, wsdlUri, mappingUri, wse);
        WebServicesDescriptor wsd = bd.getWebServices();
        wsd.addWebService(ws);
        ws.setWebServicesDescriptor(wsd);
        String archUri = this.getModArchUri();
        this.createModuleArchiveFile(this.getModuleDir(), archUri);
        String intfPkgDir = this.endpointPanel.getIntfPkgName().replace('.', File.separatorChar);
        String implPkgDir = this.endpointPanel.getImplPkgName().replace('.', File.separatorChar);
        ModuleContent mc = this.createModuleContent(wsdl, mapping, intfPkgDir, implPkgDir, intf, impl);
        ModuleArchive ma = ModuleArchive.newModuleArchive((Descriptor)bd, archUri, mc.getEntryNameMap());
        ma.save();
        DT.getModuleManager().addModule((Descriptor)bd);
        UIProject.resetProject((Descriptor)bd);
    }

    private WebBundleDescriptor createWebBundleDescriptor(String name, WebComponentDescriptor wcd) {
        WebBundleDescriptor wbd = new WebBundleDescriptor();
        wbd.setDisplayName(this.wsName);
        wbd.addWebComponentDescriptor(wcd);
        return wbd;
    }

    private EjbBundleDescriptor createEjbBundleDescriptor(String name, EjbSessionDescriptor esd) {
        EjbBundleDescriptor ebd = new EjbBundleDescriptor();
        ebd.setDisplayName(name);
        ebd.addEjb((EjbDescriptor)esd);
        return ebd;
    }

    private WebComponentDescriptor createWebComponentDescriptor(String name, String impl) {
        WebComponentDescriptor wcd = new WebComponentDescriptor();
        wcd.setServlet(true);
        wcd.setDisplayName(name);
        wcd.setCanonicalName(name);
        wcd.setWebComponentImplementation(this.endpointPanel.getImplClassName());
        wcd.getExtraAttributes().put(ENDPOINT_ATTR, ENDPOINT_ATTR);
        return wcd;
    }

    private EjbSessionDescriptor createEjbSessionDescriptor(String name, String className, String wsIntf) {
        EjbSessionDescriptor esd = new EjbSessionDescriptor();
        esd.setDisplayName(name);
        esd.setStateless(true);
        esd.setEjbClassName(className);
        esd.setWebServiceEndpointInterfaceName(wsIntf);
        return esd;
    }

    private WebService createWebService(String wsName, String wsdlUri, String mappingUri, WebServiceEndpoint wse) {
        WebService ws = new WebService();
        ws.setWsdlFileUri(wsdlUri);
        ws.setMappingFileUri(mappingUri);
        ws.setWebServiceName(wsName);
        ws.setDisplayName(wsName);
        ws.addEndpoint(wse);
        return ws;
    }

    private WebServiceEndpoint createWebServiceEndpoint(String wsdl) {
        WebServiceEndpoint wse = new WebServiceEndpoint();
        wse.setServiceEndpointInterface(this.endpointPanel.getIntfClassName());
        WSDLParser parser = new WSDLParser(wsdl);
        WSDLParser.QName[] wqname = parser.getAllPortQNames();
        QName qname = new QName(wqname[0].namespace, wqname[0].localpart);
        wse.setWsdlPort(qname);
        String intf = FileTools.GetFileName(this.endpointPanel.getSvcEndpointIntf(), false);
        wse.setEndpointName(intf);
        wse.setDisplayName(intf);
        return wse;
    }

    private void createModuleArchiveFile(String modDir, String archUri) {
        File f = new File(archUri);
        File d = new File(modDir);
        if (d.mkdir()) {
            Print.dprintln((String)("Successfully create new directory: " + modDir));
        } else {
            Print.dprintln((String)("New directory not created: " + modDir));
        }
        try {
            if (f.createNewFile()) {
                Print.dprintln((String)("Successfully created new file: " + archUri));
            } else {
                Print.dprintln((String)(archUri + " alread exists."));
            }
        }
        catch (IOException ioe) {
            Print.printStackTrace((String)("Could not create file: " + archUri), (Throwable)ioe);
        }
    }

    private ModuleContent createModuleContent(String wsdl, String mapping, String intfPkgDir, String implPkgDir, String intf, String impl) {
        ModuleContent mc = new ModuleContent();
        String intfEntry = null;
        String implEntry = null;
        String wsdlEntry = null;
        String mappingEntry = FileTools.GetFileName(mapping, true);
        if (this.endpointPanel.isEjbEndpointImpl()) {
            intfEntry = intfPkgDir + File.separator + FileTools.GetFileName(intf, true);
            implEntry = implPkgDir + File.separator + FileTools.GetFileName(impl, true);
            wsdlEntry = "META-INF" + File.separator + "wsdl" + File.separator + FileTools.GetFileName(wsdl, true);
        } else {
            intfEntry = "WEB-INF" + File.separator + "classes" + File.separator + intfPkgDir + File.separator + FileTools.GetFileName(intf, true);
            implEntry = "WEB-INF" + File.separator + "classes" + File.separator + implPkgDir + File.separator + FileTools.GetFileName(impl, true);
            wsdlEntry = "WEB-INF" + File.separator + "wsdl" + File.separator + FileTools.GetFileName(wsdl, true);
        }
        mc.addEntry(intfEntry, new File(intf));
        mc.addEntry(implEntry, new File(impl));
        mc.addEntry(wsdlEntry, new File(wsdl));
        mc.addEntry(mappingEntry, new File(mapping));
        return mc;
    }

    private String getModArchUri() {
        return this.compTypePanel.getOutputDirectory() + File.separator + "module" + File.separator + this.getModuleName();
    }

    private String getModuleDir() {
        return this.compTypePanel.getOutputDirectory() + File.separator + "module";
    }

    private String getGeneratedWsdlFile() {
        return this.compTypePanel.getOutputDirectory() + File.separator + this.wsName + ".wsdl";
    }

    private String getModuleName() {
        return this.moduleName;
    }

    private void setModuleName(String name) {
        this.moduleName = name;
    }
}

