/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.websrv.wizard;

import com.sun.enterprise.tools.deployment.ui.utils.DTClassLoader;
import com.sun.enterprise.tools.deployment.ui.utils.FileTools;
import com.sun.enterprise.tools.deployment.ui.utils.StringTools;
import com.sun.enterprise.tools.deployment.ui.utils.UIClassPackage;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIPanel;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.tools.deployment.ui.websrv.wizard.WebServiceWizard;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.help.CSH;

public class ServiceEndpointInterfacePanel
extends UIPanel {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ServiceEndpointInterfacePanel.class);
    private static final String ENDPOINT_INTF_PNL_ACC_DSC = localStrings.getLocalString("ui.serviceendpointinterfacepanel.acc_dsc", "Provide the service endpoint interface and implementation classes. If these classes have dependencies on other classes, append the required class to the classpath.");
    static final String ENDPOINT_INTF = localStrings.getLocalString("ui.serviceendpointinterfacepanel.service_endpoint_intf.tflabel", "Service Endpoint Interface:");
    private static final String ENDPOINT_INTF_MNEMONIC = localStrings.getLocalString("ui.serviceendpointinterfacepanel.service_endpoint_intf.mnemonic", "E");
    private static final String ENDPOINT_INTF_ACC_DESC = localStrings.getLocalString("ui.serviceendpointinterfacepanel.service_endpoint_intf.acc_desc", "Use the Browse button to select the service endpoint interface to be used.");
    private static final String ENDPOINT_INTF_BROWSE_MNEMONIC = localStrings.getLocalString("ui.serviceendpointinterfacepane._endpoint_intf_browse_btn.mnemonic", "r");
    static final String ENDPOINT_IMPL = localStrings.getLocalString("ui.serviceendpointinterfacepanel.service_endpoint_impl.tflabel", "Service Endpoint Implementation:");
    private static final String ENDPOINT_IMPL_MNEMONIC = localStrings.getLocalString("ui.serviceendpointinterfacepanel.service_endpoint_impl.mnemonic", "I");
    private static final String ENDPOINT_IMPL_ACC_DESC = localStrings.getLocalString("ui.serviceendpointinterfacepanel.service_endpoint_impl.acc_desc", "Use the Browse button to select the service endpoint implementation to be used.");
    private static final String ENDPOINT_IMPL_BROWSE_MNEMONIC = localStrings.getLocalString("ui.serviceendpointinterfacepane._endpoint_impl_browse_btn.mnemonic", "o");
    static final String SERVICE_NAME = localStrings.getLocalString("ui.serviceendpointinterfacepanel.service_name.tflabel", "Service Name:");
    private static final String SERVICE_NAME_MNEMONIC = localStrings.getLocalString("ui.serviceendpointinterfacepanel.service_name.mnemonic", "S");
    private static final String SERVICE_NAME_ACC_DESC = localStrings.getLocalString("ui.serviceendpointinterfacepanel.service_name.acc_desc", "The service name will default to the name of the service endpoint interface.");
    private static final String CLASSPATH = localStrings.getLocalString("ui.serviceendpointinterfacepanel.classpath.tflabel", "Append to Classpath:");
    private static final String CLASSPATH_MNEMONIC = localStrings.getLocalString("ui.serviceendpointinterfacepanel.classpath.mnemonic", "A");
    private static final String CLASSPATH_ACC_DESC = localStrings.getLocalString("ui.serviceendpointinterfacepanel.classpath.acc_desc", "If other classes are referenced by the endpoint, the classpath must indicate where these can be found.");
    private static final String INVALID_CLASS = localStrings.getLocalString("ui.serviceendpointinterfacepanel.invalid_class", "Invalid class: ");
    private static final String FILE_NOT_FOUND = localStrings.getLocalString("ui.serviceendpointinterfacepanel.file_not_found", "File not found: ");
    private static final String ERR_LOADING_CLASS = localStrings.getLocalString("ui.serviceendpointinterfacepanel.error_loading_class", "Error loading class: ");
    private UITitledTextField svcEndpointIntf = null;
    private UITitledTextField svcEndpointImpl = null;
    private UITitledTextField svcName = null;
    private UITitledTextField appendClassPath = null;
    private String intFileName = null;
    private String implFileName = null;
    private String intfClassName = null;
    private String implClassName = null;
    private Class implClass = null;
    private Class intfClass = null;
    private String pkgName = null;
    private String intfPkgName = null;
    private String implPkgName = null;
    private String classpath = null;
    private String errMsg = null;

    private static final String COULD_NOT_FIND_CLASS(String v0, String v1) {
        return localStrings.getLocalString("ui.serviceendpointinterfacepanel.could_not_find_class", "Could not find class: {0} in directory {1}.", new Object[]{v0, v1});
    }

    public String getHelpID() {
        return "Endpoint";
    }

    public ServiceEndpointInterfacePanel() {
        super(WebServiceWizard.WIZARD_TITLE_NEW + " " + WebServiceWizard.ENDPOINT_INTF_TITLE, ENDPOINT_INTF_PNL_ACC_DSC);
        this.initializeLayout();
    }

    private void initializeLayout() {
        CSH.setHelpIDString((Component)this, (String)("SW" + this.getHelpID()));
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        this.svcEndpointIntf = new UITitledTextField(ENDPOINT_INTF, false);
        this.svcEndpointIntf.setMnemonic(ENDPOINT_INTF_MNEMONIC.charAt(0));
        this.svcEndpointIntf.setToolTipText(ENDPOINT_INTF_ACC_DESC);
        this.svcEndpointIntf.setAccessibleDescription(ENDPOINT_INTF_ACC_DESC);
        this.svcEndpointIntf.setBrowserFilterKey("ClassFiles");
        this.svcEndpointIntf.setBrowserMnemonic(ENDPOINT_INTF_BROWSE_MNEMONIC.charAt(0));
        this.svcEndpointIntf.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ServiceEndpointInterfacePanel.this.defaultServiceName(ServiceEndpointInterfacePanel.this.svcEndpointIntf.getText());
            }
        });
        this.svcEndpointIntf.setRequired(true);
        c.weightx = 0.1;
        c.weighty = 0.03;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(20, 5, 5, 200);
        c.fill = 2;
        c.anchor = 11;
        this.add((Component)this.svcEndpointIntf, c);
        this.svcEndpointImpl = new UITitledTextField(ENDPOINT_IMPL);
        this.svcEndpointImpl.setMnemonic(ENDPOINT_IMPL_MNEMONIC.charAt(0));
        this.svcEndpointImpl.setToolTipText(ENDPOINT_IMPL_ACC_DESC);
        this.svcEndpointImpl.setAccessibleDescription(ENDPOINT_IMPL_ACC_DESC);
        this.svcEndpointImpl.setEditable(true);
        this.svcEndpointImpl.setBrowserFilterKey("ClassFiles");
        this.svcEndpointImpl.setBrowserMnemonic(ENDPOINT_IMPL_BROWSE_MNEMONIC.charAt(0));
        this.svcEndpointImpl.setRequired(true);
        c.weighty = 0.03;
        c.gridy = 1;
        c.insets = new Insets(5, 5, 5, 200);
        this.add((Component)this.svcEndpointImpl, c);
        this.svcName = new UITitledTextField(SERVICE_NAME, false);
        this.svcName.setMnemonic(SERVICE_NAME_MNEMONIC.charAt(0));
        this.svcName.setToolTipText(SERVICE_NAME_ACC_DESC);
        this.svcName.setAccessibleDescription(SERVICE_NAME_ACC_DESC);
        this.svcName.setRequired(true);
        c.weighty = 0.03;
        c.gridy = 2;
        c.insets = new Insets(5, 5, 5, 450);
        this.add((Component)this.svcName, c);
        this.appendClassPath = new UITitledTextField(CLASSPATH, false);
        this.appendClassPath.setMnemonic(CLASSPATH_MNEMONIC.charAt(0));
        this.appendClassPath.setToolTipText(CLASSPATH_ACC_DESC);
        this.appendClassPath.setAccessibleDescription(CLASSPATH_ACC_DESC);
        this.appendClassPath.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ServiceEndpointInterfacePanel.this.appendClassPath(ServiceEndpointInterfacePanel.this.appendClassPath.getText());
            }
        });
        c.weighty = 0.91;
        c.gridy = 4;
        c.insets = new Insets(5, 5, 5, 200);
        this.add((Component)this.appendClassPath, c);
    }

    void intfAction(String intfText) {
        this.setIntfClassName(intfText);
        if (this.isClassInPkgDir(intfText, this.getIntfClassName())) {
            String cp = this.findClassPath(intfText, this.getIntfClassName());
            this.appendClassPath(cp);
        }
        this.defaultPkgName(intfText);
    }

    void implAction(String implText) {
        this.setImplClassName(implText);
        if (this.isClassInPkgDir(implText, this.getImplClassName())) {
            this.appendClassPath(this.findClassPath(implText, this.getImplClassName()));
        }
    }

    private void defaultPkgName(String endpointIntf) {
        String s = FileTools.GetFileName(endpointIntf, false);
        this.pkgName = s = s.toLowerCase();
    }

    private void defaultServiceName(String endpointIntf) {
        this.svcName.setText(FileTools.GetFileName(endpointIntf, false));
    }

    private void setSvcEndpointIntf(String intfText) {
        this.svcEndpointIntf.setText(intfText);
    }

    public String getSvcEndpointIntf() {
        return this.svcEndpointIntf.getText();
    }

    private void setSvcEndpointImpl(String implText) {
        this.svcEndpointImpl.setText(implText);
    }

    public String getSvcEndpointImpl() {
        return this.svcEndpointImpl.getText();
    }

    public String getIntfClassName() {
        return this.intfClassName;
    }

    private void setIntfClassName(String fileName) {
        if (!StringTools.isEmpty(fileName)) {
            UIClassPackage uicp = null;
            try {
                uicp = new UIClassPackage(fileName);
            }
            catch (IOException ioe) {
                UIOptionPane.showErrorDialog(this, FILE_NOT_FOUND + fileName);
                Print.dprintStackTrace((String)(FILE_NOT_FOUND + fileName), (Throwable)ioe);
            }
            catch (UIClassPackage.InvalidClassFileException icfe) {
                UIOptionPane.showErrorDialog(this, INVALID_CLASS + fileName);
                Print.dprintStackTrace((String)(INVALID_CLASS + fileName), (Throwable)icfe);
            }
            this.intfClassName = uicp.getClassName();
            this.intfPkgName = uicp.getPackageName();
        } else {
            this.intfClassName = null;
            this.intfPkgName = null;
        }
    }

    public String getIntfPkgName() {
        return this.intfPkgName;
    }

    public String getImplClassName() {
        return this.implClassName;
    }

    private void setImplClassName(String fileName) {
        if (!StringTools.isEmpty(fileName)) {
            UIClassPackage uicp = null;
            try {
                uicp = new UIClassPackage(fileName);
            }
            catch (IOException ioe) {
                UIOptionPane.showErrorDialog(this, FILE_NOT_FOUND + fileName);
                Print.dprintStackTrace((String)(FILE_NOT_FOUND + fileName), (Throwable)ioe);
            }
            catch (UIClassPackage.InvalidClassFileException icfe) {
                UIOptionPane.showErrorDialog(this, INVALID_CLASS + fileName);
                Print.dprintStackTrace((String)(INVALID_CLASS + fileName), (Throwable)icfe);
            }
            this.implClassName = uicp.getClassName();
            this.implPkgName = uicp.getPackageName();
        } else {
            this.implClassName = null;
            this.implPkgName = null;
        }
    }

    public String getImplPkgName() {
        return this.implPkgName;
    }

    public String getServiceName() {
        return this.svcName.getText();
    }

    public String getNameSpace() {
        return this.getServiceName();
    }

    public String getPkgName() {
        return this.pkgName;
    }

    public String getClassPath() {
        return this.classpath;
    }

    private void appendClassPath(String appendCP) {
        if (appendCP != null && appendCP.trim().length() != 0) {
            StringBuffer sb = null;
            sb = this.classpath == null ? new StringBuffer() : new StringBuffer(this.classpath);
            if (sb.indexOf(appendCP) == -1) {
                sb.append(appendCP);
                sb.append(File.pathSeparator);
            }
            this.classpath = sb.toString();
        }
    }

    private String findClassPath(String fileName, String className) {
        String newClassName;
        StringBuffer sb;
        int index;
        String classpath = null;
        if (fileName != null && className != null && (index = (sb = new StringBuffer(fileName)).lastIndexOf(newClassName = className.replace('.', File.separatorChar))) != -1) {
            classpath = fileName.substring(0, index);
        }
        DTClassLoader dtClassLoader = new DTClassLoader();
        dtClassLoader.addFile(classpath);
        try {
            Class clas = dtClassLoader.loadClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            classpath = null;
            Print.dprintStackTrace((String)ServiceEndpointInterfacePanel.COULD_NOT_FIND_CLASS(className, classpath), (Throwable)cnfe);
        }
        return classpath;
    }

    public boolean isClassInPkgDir(String classFile, String className) {
        boolean valid = true;
        String cp = this.findClassPath(classFile, className);
        DTClassLoader dtClassLoader = new DTClassLoader();
        dtClassLoader.addFile(cp);
        try {
            Class clas = dtClassLoader.loadClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            valid = false;
            Print.dprintStackTrace((String)ServiceEndpointInterfacePanel.COULD_NOT_FIND_CLASS(className, cp), (Throwable)cnfe);
        }
        return valid;
    }

    public Class getClass(String classFile, String className) {
        Class clas = null;
        String cp = this.findClassPath(classFile, className);
        DTClassLoader dtClassLoader = new DTClassLoader();
        dtClassLoader.addFile(cp);
        try {
            clas = dtClassLoader.loadClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            Print.dprintStackTrace((String)(ERR_LOADING_CLASS + className), (Throwable)cnfe);
        }
        return clas;
    }

    public boolean isEjbEndpointImpl() {
        Class implClass = this.getClass(this.getSvcEndpointImpl(), this.getImplClassName());
        Class<?>[] intf = implClass.getInterfaces();
        boolean implementsSessionBean = false;
        for (int i = 0; i < intf.length; ++i) {
            if (!intf[i].getName().equals("javax.ejb.SessionBean")) continue;
            implementsSessionBean = true;
            break;
        }
        return implementsSessionBean;
    }
}

