/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.websrv;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WritableJndiNameEnvironment;
import com.sun.enterprise.tools.common.dd.ServiceRef;
import com.sun.enterprise.tools.common.dd.SunBaseBean;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorTools;
import com.sun.enterprise.tools.deployment.ui.shared.IconInspector;
import com.sun.enterprise.tools.deployment.ui.shared.ModuleContent;
import com.sun.enterprise.tools.deployment.ui.sunone.SunOneUtils;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.ListTools;
import com.sun.enterprise.tools.deployment.ui.utils.StringTools;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledQName;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.tools.deployment.ui.utils.Wizard;
import com.sun.enterprise.tools.deployment.ui.websrv.WSHandlers;
import com.sun.enterprise.tools.deployment.ui.websrv.WSInspector;
import com.sun.enterprise.tools.deployment.ui.websrv.WSPortMapping;
import com.sun.enterprise.tools.deployment.ui.websrv.WebServiceReference;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import java.util.Vector;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.xml.rpc.Service;

public class WSRefsInspector
extends InspectorPane
implements IconInspector.UpdateListener {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(WSRefsInspector.class);
    private static final String WS_REFS_TITLE = localStrings.getLocalString("ui.wsrefsinspector.ws_refs.title", "Web Services References");
    private static final String TABLE_CODED_NAME = localStrings.getLocalString("ui.wsrefsinspector.ws_refs.table.coded_name", "Coded Name");
    private static final String TABLE_SERVICE_IFACE_NAME = localStrings.getLocalString("ui.wsrefsinspector.ws_refs.table.service_interface", "Service Interface");
    private static final String TABNAME = localStrings.getLocalString("ui.wsrefsinspector.tabname", "Web Service Refs");
    private static final String CODED_NAME_REQUIRED = localStrings.getLocalString("ui.wsrefsinspector.coded_name_required", "Coded Name is required.");
    private static final String SERVICE_INTERFACE_REQUIRED = localStrings.getLocalString("ui.wsrefsinspector.service_interface_required", "Service Interface is required.");
    private static final char TABLE_CODED_NAME_MNEMONIC = localStrings.getLocalString("ui.wsrefsinspector.ws_refs.table.coded_name_mnemonic", "C").charAt(0);
    private static final char TABLE_SERVICE_IFACE_NAME_MNEMONIC = localStrings.getLocalString("ui.wsrefsinspector.ws_refs.table.service_interface_mnemonic", "S").charAt(0);
    private static final char DIAG_WSDL_FILE_NAME_MNEMONIC = localStrings.getLocalString("ui.wsrefsinspector.ws_refs_wsdl_file_name_mnemonic", "W").charAt(0);
    private static final char DIAG_MAPPING_FILE_NAME_MNEMONIC = localStrings.getLocalString("ui.wsrefsinspector.dialog.mapping_file_name_mnemonic", "M").charAt(0);
    private static final char DIAG_ENDPT_HANDLERS_MNEMONIC = localStrings.getLocalString("ui.wsrefsinspector.dialog.handlers_mnemonic", "n").charAt(0);
    private static final char DIAG_PORT_MAPPING_MNEMONIC = localStrings.getLocalString("ui.wsrefsinspector.dialog.container_managed_ports_mnemonic", "P").charAt(0);
    private static final char DIAG_DEP_SETTINGS_MNEMONIC = localStrings.getLocalString("ui.wsrefsinspector.dialog.deployment_settings_mnemonic", "S").charAt(0);
    private static String wizardHelpID = "WebServRef";
    private static String deployHelpID = "WebServRef";
    private static String EMPTY_STRING = " ";
    private WritableJndiNameEnvironment descriptor = null;
    private UITitledTable wsRefsTablePanel = null;
    private static final String DIAG_SERVICE_TITLE_ADD = localStrings.getLocalString("ui.wsrefsinspector.dialog.add_title", "Add Web Service Reference");
    private static final String DIAG_SERVICE_TITLE_EDIT = localStrings.getLocalString("ui.wsrefsinspector.dialog.edit_title", "Edit Web Service Reference");
    private static final String DIAG_WSDL_FILE_NAME = localStrings.getLocalString("ui.wsrefsinspector.ws_refs_wsdl_file_name", "WSDL File:");
    private static final String DIAG_MAPPING_FILE_NAME = localStrings.getLocalString("ui.wsrefsinspector.dialog.mapping_file_name", "Mapping File:");
    private static final String DIAG_DISPLAY_NAME = localStrings.getLocalString("ui.wsrefsinspector.dialog.display_name", "Display Name:");
    private static final String DIAG_SERVICE_QNAME = localStrings.getLocalString("at.wsrefsinspector.dialog.service_qname", "Service QName:");
    private static final String DIAG_ENDPT_HANDLERS = localStrings.getLocalString("ui.wsrefsinspector.dialog.handlers", "Handlers...");
    private static final String DIAG_PORT_MAPPING = localStrings.getLocalString("ui.wsrefsinspector.dialog.container_managed_ports", "Container-Managed Ports...");
    private static final String DIAG_DEP_SETTINGS = localStrings.getLocalString("ui.wsrefsinspector.dialog.deployment_settings", "Sun-specific Settings");
    private static final String DEPLOYMENT_SETTINGS = localStrings.getLocalString("ui.wsrefsinspector.dialog.depsettings.title", "Sun-specific Settings");
    private static final String DS_PORT_INFO = localStrings.getLocalString("ui.wsrefsinspector.dialog.depsettings.port_info", "Port Info:");
    private static final String DS_WSDL_OVERRIDE = localStrings.getLocalString("ui.wsrefsinspector.dialog.depsettings.wsdl_override", "WSDL Override:");
    private static final String DS_SERVICE_IMPL = localStrings.getLocalString("ui.wsrefsinspector.dialog.depsettings.service_imple_class", "Service Implementation Class:");
    private static String wsRefsDialogHelpSetMapID = "WWSRDIALOG";
    private ServiceRefDialog serviceRefDiag = null;

    public static InspectorPane newInspectorPane(String mode) {
        return new WSRefsInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isWizardMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return WritableJndiNameEnvironment.class;
    }

    public Descriptor getDescriptor() {
        return (Descriptor)this.descriptor;
    }

    public void setDescriptor(Descriptor d) {
        if (this.descriptor != d) {
            this.descriptor = d instanceof WritableJndiNameEnvironment ? (WritableJndiNameEnvironment)d : null;
            this.wsRefsTablePanel.clear();
        }
    }

    private WSRefsInspector(String mode) {
        this.setInspectorMode(mode);
        this.initializeLayout();
    }

    private void initializeLayout() {
        this.setLayout(new GridBagLayout());
        UITitledBox wsRefsTablePanelBox = new UITitledBox(WS_REFS_TITLE, true);
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = -1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)wsRefsTablePanelBox, c);
        this.wsRefsTablePanel = new UITitledTable(null, false);
        wsRefsTablePanelBox.addWithGBConstraints(this.wsRefsTablePanel);
        this.wsRefsTablePanel.setTableView(new WebServRefsTable(new WebServRefsTableModel()));
        this.wsRefsTablePanel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
            }
        });
        this.wsRefsTablePanel.addControlButton(UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WSRefsInspector.this.addEditServiceAction(null);
            }
        }, true));
        this.wsRefsTablePanel.addSelectionEnabledButton(UIButton.createEditButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ServiceReferenceDescriptor sel = WSRefsInspector.this.getSelectedServiceReferenceDescriptor();
                if (sel == null) {
                    return;
                }
                WSRefsInspector.this.addEditServiceAction(sel);
            }
        }, true));
        this.wsRefsTablePanel.addSelectionEnabledButton(UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WSRefsInspector.this.deleteServiceAction();
            }
        }, true));
    }

    private ServiceReferenceDescriptor getSelectedServiceReferenceDescriptor() {
        return (ServiceReferenceDescriptor)this.wsRefsTablePanel.getSelectedRowObject();
    }

    public void refresh() {
        this.wsRefsTablePanel.updateTableData(this.descriptor.getServiceReferenceDescriptors());
    }

    public void setReadOnly(boolean state) {
        super.setReadOnly(state);
        this.wsRefsTablePanel.setReadOnly(state);
    }

    private void addEditServiceAction(ServiceReferenceDescriptor sel) {
        if (this.serviceRefDiag == null) {
            this.serviceRefDiag = new ServiceRefDialog(this.getMyParentFrame(), this.getOwner(), (Object)this);
        }
        this.serviceRefDiag.setServiceIfaces(this.getArchiveInterfaces(new Class[]{Service.class}));
        ServiceReferenceDescriptor newSel = this.serviceRefDiag.showDialog(sel);
        if (newSel != null) {
            this.wsRefsTablePanel.selectRowWithValueOnUpdate(0, newSel.getDisplayName());
            this.getDescriptor().changed();
        }
        this.invokeRefresh();
    }

    private void deleteServiceAction() {
        Object[] list = this.wsRefsTablePanel.confirmDeleteSelection(null, null);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                ServiceReferenceDescriptor ref = (ServiceReferenceDescriptor)list[i];
                this.descriptor.removeServiceReferenceDescriptor(ref);
                SunOneUtils.removeServiceRef(this.getDescriptor(), ref.getDisplayName());
            }
            this.getDescriptor().changed();
            this.invokeRefresh();
        }
    }

    public void addLargeIcon(File iconFile) {
        if (this.isDeploymentMode()) {
            this._addDeploymentIcon("large", iconFile, (Descriptor)this.descriptor, (Descriptor)this.descriptor);
        } else {
            ModuleContent contentsMap = ((Wizard)this.getOwner()).getContentsFCD();
            this._addWizardIcon("large", iconFile, contentsMap, (Descriptor)this.descriptor);
        }
    }

    public void addSmallIcon(File iconFile) {
        if (this.isDeploymentMode()) {
            this._addDeploymentIcon("small", iconFile, (Descriptor)this.descriptor, (Descriptor)this.descriptor);
        } else {
            ModuleContent contentsMap = ((Wizard)this.getOwner()).getContentsFCD();
            this._addWizardIcon("small", iconFile, contentsMap, (Descriptor)this.descriptor);
        }
    }

    private class WebServRefsTableModel
    extends InspectorTableModel {
        public WebServRefsTableModel() {
            super(new String[]{TABLE_CODED_NAME, TABLE_SERVICE_IFACE_NAME});
            this.setDataOrdering(2);
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public Object getObjectValue(Object obj, int col) {
            ServiceReferenceDescriptor ref = (ServiceReferenceDescriptor)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = ref.getDisplayName();
                    break;
                }
                case 1: {
                    value = ref.getServiceInterface();
                }
            }
            return value != null ? value : "";
        }

        public void setObjectValue(Object obj, int col, Object value) {
            ServiceReferenceDescriptor ref = (ServiceReferenceDescriptor)obj;
        }
    }

    private class WebServRefsTable
    extends InspectorTable {
        public WebServRefsTable(WebServRefsTableModel model) {
            super(model);
            this.setHandleDescriptionUpdates(true);
        }
    }

    private class ServiceRefDialog
    extends UIDialog {
        boolean okSelected;
        private Object ownerInspector;
        private UITitledTextField txCodedName;
        private UITitledTextField txDisplayName;
        private UITitledComboBox cbServiceIface;
        private UITitledComboBox cbWsdlFile;
        private UITitledComboBox cbMappingFile;
        private DescriptionInspector.DialogDisplayButton descInspector;
        private Vector serviceIfaces;
        private ServiceReferenceDescriptor srvRefDescriptorOrig;
        private ServiceReferenceDescriptor srvRefDescriptor;
        private ServiceRef sunServiceRefOrig;
        private ServiceRef sunServiceRef;
        private UITitledQName diagServiceQName;

        public ServiceRefDialog(Frame owner, InspectorPane.InspectorPaneOwner inspOwner, Object inspector) {
            super(owner, true);
            this.okSelected = false;
            this.ownerInspector = null;
            this.txCodedName = null;
            this.txDisplayName = null;
            this.cbServiceIface = null;
            this.cbWsdlFile = null;
            this.cbMappingFile = null;
            this.descInspector = null;
            this.serviceIfaces = null;
            this.srvRefDescriptorOrig = null;
            this.srvRefDescriptor = null;
            this.sunServiceRefOrig = null;
            this.sunServiceRef = null;
            this.diagServiceQName = null;
            this.ownerInspector = inspector;
            this.initLayout();
        }

        public ServiceRefDialog(Dialog owner, InspectorPane.InspectorPaneOwner inspOwner, Object inspector) {
            super(owner, true);
            this.okSelected = false;
            this.ownerInspector = null;
            this.txCodedName = null;
            this.txDisplayName = null;
            this.cbServiceIface = null;
            this.cbWsdlFile = null;
            this.cbMappingFile = null;
            this.descInspector = null;
            this.serviceIfaces = null;
            this.srvRefDescriptorOrig = null;
            this.srvRefDescriptor = null;
            this.sunServiceRefOrig = null;
            this.sunServiceRef = null;
            this.diagServiceQName = null;
            this.ownerInspector = inspector;
            this.initLayout();
        }

        private ServiceRef getSunServiceRef(ServiceReferenceDescriptor srd) {
            if (srd == null) {
                return null;
            }
            SunBaseBean sbb = SunOneUtils.getSunDescriptor((Descriptor)WSRefsInspector.this.descriptor);
            ServiceRef sr = SunOneUtils.getServiceRefByName(sbb, srd.getDisplayName());
            SunOneUtils.setSunDescriptor((Descriptor)srd, (SunBaseBean)sr);
            return sr;
        }

        public ServiceReferenceDescriptor showDialog(ServiceReferenceDescriptor editSel) {
            this.okSelected = false;
            this.srvRefDescriptorOrig = editSel;
            this.sunServiceRefOrig = this.getSunServiceRef(editSel);
            if (editSel != null) {
                this.srvRefDescriptor = new ServiceReferenceDescriptor(editSel);
                this.sunServiceRef = (ServiceRef)this.sunServiceRefOrig.clone();
            } else {
                this.srvRefDescriptor = new ServiceReferenceDescriptor();
                this.sunServiceRef = new ServiceRef();
                BundleDescriptor bd = DescriptorTools.getBundleDescriptor((Descriptor)WSRefsInspector.this.descriptor);
                if (bd != null) {
                    this.srvRefDescriptor.setBundleDescriptor(bd);
                }
            }
            this.setTitle(editSel != null ? DIAG_SERVICE_TITLE_EDIT : DIAG_SERVICE_TITLE_ADD);
            this.setInitValues();
            this.setSize(600, 340);
            this.setLocationRelativeTo(WSRefsInspector.this);
            this.show();
            ServiceReferenceDescriptor srvRefOrig = this.srvRefDescriptorOrig;
            ServiceReferenceDescriptor srvRef = this.srvRefDescriptor;
            this.srvRefDescriptorOrig = null;
            this.srvRefDescriptor = null;
            if (this.okSelected) {
                if (srvRefOrig != null) {
                    ListTools.replaceElement(WSRefsInspector.this.descriptor.getServiceReferenceDescriptors(), srvRefOrig, srvRef);
                } else {
                    WSRefsInspector.this.descriptor.addServiceReferenceDescriptor(srvRef);
                }
                SunOneUtils.replaceServiceRef(SunOneUtils.getSunDescriptor((Descriptor)WSRefsInspector.this.descriptor), this.sunServiceRefOrig, this.sunServiceRef);
                Print.dprintln((String)("WSDL File: " + srvRef.getWsdlFileUri()));
                return srvRef;
            }
            return null;
        }

        public void setServiceIfaces(Vector newIfaces) {
            this.serviceIfaces = newIfaces;
        }

        private void setInitValues() {
            Vector vec = WSRefsInspector.this.getArchiveInterfaces(new Class[]{class$javax$xml$rpc$Service == null ? (class$javax$xml$rpc$Service = WSRefsInspector.class$("javax.xml.rpc.Service")) : class$javax$xml$rpc$Service});
            vec.add(0, EMPTY_STRING);
            this.cbServiceIface.setModel(vec);
            List wsdlList = WSRefsInspector.this.getArchiveContents(WSInspector.WSDL_EXTN);
            wsdlList.add(0, EMPTY_STRING);
            this.cbWsdlFile.setModel(wsdlList);
            List mf = WSRefsInspector.this.getArchiveContentsFiltered(WSInspector.MAPPING_EXTN_FILTERS);
            mf.add(0, EMPTY_STRING);
            this.cbMappingFile.setModel(mf);
            this.txCodedName.setText(this.srvRefDescriptor.getDisplayName());
            this.txDisplayName.setText(this.srvRefDescriptor.getDisplayName());
            this.cbServiceIface.setSelectedItem(this.srvRefDescriptor.getServiceInterface(), true);
            this.cbMappingFile.setSelectedItem(this.srvRefDescriptor.getMappingFileUri(), true);
            this.cbWsdlFile.setSelectedItem(this.srvRefDescriptor.getWsdlFileUri(), true);
            Descriptor d = WSRefsInspector.this.getDescriptor();
            String wsdlFile = (String)this.cbWsdlFile.getSelectedItem();
            this.diagServiceQName.setQNameModel(d, wsdlFile, 1, true);
            this.diagServiceQName.setNamespace(this.srvRefDescriptor.getServiceNamespaceUri());
            this.diagServiceQName.setLocalPart(this.srvRefDescriptor.getServiceLocalPart());
            this.descInspector.setDescriptionInspector((Descriptor)this.srvRefDescriptor);
        }

        private void initLayout() {
            UITitledBox contentPanel = new UITitledBox(null, false);
            GridBagConstraints gbc = contentPanel.getGBConstraintsCopy();
            gbc.weightx = 0.5;
            gbc.weighty = 0.0;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.insets = new Insets(0, 5, 5, 0);
            gbc.fill = 2;
            gbc.anchor = 17;
            gbc.gridx = 0;
            this.txCodedName = new UITitledTextField(TABLE_CODED_NAME, false);
            this.txCodedName.setMnemonic(TABLE_CODED_NAME_MNEMONIC);
            this.txCodedName.setRequired(true);
            this.txCodedName.addActionListener(new ActionListener(this){
                private final /* synthetic */ ServiceRefDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    if (ServiceRefDialog.access$900(this.this$1).getText().equals("")) {
                        ServiceRefDialog.access$900(this.this$1).setText(ServiceRefDialog.access$1000(this.this$1).getDisplayName());
                        return;
                    }
                    ServiceRefDialog.access$1000(this.this$1).setDisplayName(ServiceRefDialog.access$900(this.this$1).getText());
                    ServiceRefDialog.access$1100(this.this$1).setServiceRefName(ServiceRefDialog.access$900(this.this$1).getText());
                }
            });
            gbc.gridy = 0;
            contentPanel.add((Component)this.txCodedName, gbc);
            this.cbServiceIface = new UITitledComboBox(TABLE_SERVICE_IFACE_NAME, false);
            this.cbServiceIface.setMnemonic(TABLE_SERVICE_IFACE_NAME_MNEMONIC);
            this.cbServiceIface.setRequired(true);
            this.cbServiceIface.addActionListener(new ActionListener(this){
                private final /* synthetic */ ServiceRefDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    String inf = ServiceRefDialog.access$1400(this.this$1).getText();
                    if (StringTools.isEmpty(inf)) {
                        inf = null;
                    }
                    ServiceRefDialog.access$1000(this.this$1).setServiceInterface(inf);
                }
            });
            gbc.gridy = 1;
            contentPanel.add((Component)this.cbServiceIface, gbc);
            this.cbWsdlFile = new UITitledComboBox(DIAG_WSDL_FILE_NAME, false);
            this.cbWsdlFile.setMnemonic(DIAG_WSDL_FILE_NAME_MNEMONIC);
            this.cbWsdlFile.addActionListener(new ActionListener(this){
                private final /* synthetic */ ServiceRefDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    String wsdlFile = ServiceRefDialog.access$1700(this.this$1).getText();
                    if (StringTools.isEmpty(wsdlFile)) {
                        wsdlFile = null;
                    }
                    Descriptor d = ServiceRefDialog.access$1800(this.this$1).getDescriptor();
                    ServiceRefDialog.access$1000(this.this$1).setWsdlFileUri(wsdlFile);
                    ServiceRefDialog.access$1900(this.this$1).setQNameModel(d, wsdlFile, 1, true);
                }
            });
            gbc.gridy = 2;
            contentPanel.add((Component)this.cbWsdlFile, gbc);
            this.diagServiceQName = new UITitledQName(DIAG_SERVICE_QNAME, true, false);
            this.diagServiceQName.addActionListener(new ActionListener(this){
                private final /* synthetic */ ServiceRefDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    ServiceRefDialog.access$1000(this.this$1).setServiceNamespaceUri(ServiceRefDialog.access$1900(this.this$1).getNamespace());
                    ServiceRefDialog.access$1000(this.this$1).setServiceLocalPart(ServiceRefDialog.access$1900(this.this$1).getLocalPart());
                }
            });
            gbc.gridy = 3;
            gbc.gridheight = 3;
            contentPanel.add((Component)this.diagServiceQName, gbc);
            gbc.gridheight = 1;
            gbc.gridx = 1;
            gbc.insets.left = 10;
            this.txDisplayName = new UITitledTextField(DIAG_DISPLAY_NAME, false);
            this.txDisplayName.addActionListener(new ActionListener(this){
                private final /* synthetic */ ServiceRefDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                }
            });
            this.txDisplayName.setReadOnly(true);
            gbc.gridy = 0;
            contentPanel.add((Component)this.txDisplayName, gbc);
            this.cbMappingFile = new UITitledComboBox(DIAG_MAPPING_FILE_NAME, false);
            this.cbMappingFile.setMnemonic(DIAG_MAPPING_FILE_NAME_MNEMONIC);
            this.cbMappingFile.addActionListener(new ActionListener(this){
                private final /* synthetic */ ServiceRefDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    String mf = ServiceRefDialog.access$2400(this.this$1).getText();
                    if (StringTools.isEmpty(mf)) {
                        mf = null;
                    }
                    ServiceRefDialog.access$1000(this.this$1).setMappingFileUri(mf);
                }
            });
            gbc.gridy = 1;
            contentPanel.add((Component)this.cbMappingFile, gbc);
            UIButton endPtHandlers = new UIButton(DIAG_ENDPT_HANDLERS, DIAG_ENDPT_HANDLERS_MNEMONIC, new ActionListener(this){
                private final /* synthetic */ ServiceRefDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    WSHandlers wsd = WSHandlers.newDialog(this.this$1);
                    Vector clzNames = ServiceRefDialog.access$1800(this.this$1).getArchiveClassNames();
                    wsd.showDialog((Descriptor)ServiceRefDialog.access$1000(this.this$1), clzNames);
                }
            });
            UITitledBox endPtHandlerBox = new UITitledBox(" ", false);
            endPtHandlerBox.addWithGBConstraints(endPtHandlers);
            gbc.gridy = 2;
            contentPanel.add((Component)endPtHandlerBox, gbc);
            UIButton portMapping = new UIButton(DIAG_PORT_MAPPING, DIAG_PORT_MAPPING_MNEMONIC, new ActionListener(this){
                private final /* synthetic */ ServiceRefDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    WSPortMapping wsd = WSPortMapping.newDialog(this.this$1);
                    wsd.showDialog(ServiceRefDialog.access$1000(this.this$1), ServiceRefDialog.access$1100(this.this$1));
                }
            });
            gbc.gridy = 3;
            gbc.insets.top = 7;
            gbc.insets.bottom = 7;
            contentPanel.add((Component)portMapping, gbc);
            gbc.insets.top = 0;
            this.descInspector = new DescriptionInspector.DialogDisplayButton(false);
            gbc.gridy = 4;
            contentPanel.add((Component)this.descInspector, gbc);
            UIButton dsButton = new UIButton(DIAG_DEP_SETTINGS, DIAG_DEP_SETTINGS_MNEMONIC, new ActionListener(this){
                private final /* synthetic */ ServiceRefDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    String mode = ServiceRefDialog.access$1800(this.this$1).isWizardMode() ? "WizardMode" : "DeploymentMode";
                    WebServiceReference.WSRefInspectorPaneDialog dialog = (WebServiceReference.WSRefInspectorPaneDialog)WebServiceReference.createDialog(ServiceRefDialog.access$1800(this.this$1).getOwner(), this.this$1, true, mode);
                    dialog.setDescriptor((Descriptor)ServiceRefDialog.access$1000(this.this$1));
                    dialog.setSunDescriptor(ServiceRefDialog.access$1100(this.this$1));
                    dialog.show();
                }
            });
            gbc.gridy = 5;
            gbc.insets.bottom = 0;
            contentPanel.add((Component)dsButton, gbc);
            UIControlButtonBox dialogPane = new UIControlButtonBox(null, false);
            dialogPane.setControlButtonLocation(101);
            dialogPane.setView(contentPanel);
            dialogPane.addControlButton(UIButton.createOkButton(new ActionListener(this){
                private final /* synthetic */ ServiceRefDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.okAction();
                }
            }));
            dialogPane.addControlButton(UIButton.createCancelButton(new ActionListener(this){
                private final /* synthetic */ ServiceRefDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.cancelAction();
                }
            }));
            dialogPane.addControlButton(new UIHelpButton(wsRefsDialogHelpSetMapID));
            this.getContentBox().addWithGBConstraints(dialogPane);
        }

        public boolean validateEntries() {
            boolean valid = true;
            String msg = null;
            if (this.txCodedName.getText().equals("")) {
                msg = CODED_NAME_REQUIRED;
                valid = false;
            }
            if (this.cbServiceIface.getText().equals("")) {
                msg = msg == null ? SERVICE_INTERFACE_REQUIRED : msg + "\n" + SERVICE_INTERFACE_REQUIRED;
                valid = false;
            }
            if (msg != null) {
                UIOptionPane.showErrorDialog(null, msg);
            }
            return valid;
        }

        public void okAction() {
            if (!this.validateEntries()) {
                return;
            }
            this.okSelected = true;
            this.hide();
        }

        public void cancelAction() {
            this.okSelected = false;
            this.hide();
        }

        static /* synthetic */ UITitledTextField access$900(ServiceRefDialog x0) {
            return x0.txCodedName;
        }

        static /* synthetic */ ServiceReferenceDescriptor access$1000(ServiceRefDialog x0) {
            return x0.srvRefDescriptor;
        }

        static /* synthetic */ ServiceRef access$1100(ServiceRefDialog x0) {
            return x0.sunServiceRef;
        }

        static /* synthetic */ UITitledComboBox access$1400(ServiceRefDialog x0) {
            return x0.cbServiceIface;
        }

        static /* synthetic */ UITitledComboBox access$1700(ServiceRefDialog x0) {
            return x0.cbWsdlFile;
        }

        static /* synthetic */ WSRefsInspector access$1800(ServiceRefDialog x0) {
            return x0.WSRefsInspector.this;
        }

        static /* synthetic */ UITitledQName access$1900(ServiceRefDialog x0) {
            return x0.diagServiceQName;
        }

        static /* synthetic */ UITitledComboBox access$2400(ServiceRefDialog x0) {
            return x0.cbMappingFile;
        }
    }
}

