/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.websrv;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.tools.common.dd.WebserviceDescription;
import com.sun.enterprise.tools.common.dd.ejb.EnterpriseBeans;
import com.sun.enterprise.tools.common.dd.ejb.SunEjbJar;
import com.sun.enterprise.tools.common.dd.webapp.SunWebApp;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorTools;
import com.sun.enterprise.tools.deployment.ui.shared.IconInspector;
import com.sun.enterprise.tools.deployment.ui.shared.ModuleContent;
import com.sun.enterprise.tools.deployment.ui.sunone.SunOneUtils;
import com.sun.enterprise.tools.deployment.ui.utils.FileTools;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.tools.deployment.ui.utils.Wizard;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class WSInspector
extends InspectorPane
implements IconInspector.UpdateListener {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(WSInspector.class);
    private static final String TABLE_TITLE = localStrings.getLocalString("ui.wsinspector.table.title", "Web Services");
    private static final String WS_DESC = localStrings.getLocalString("ui.wsinspector.wsdesc.title", "Sun-specific Settings");
    private static final String WS_DESC_WSDL_LOC = localStrings.getLocalString("ui.wsinspector.wsdesc.wsdl_publish_location", "WSDL Publish Location:");
    private static final String TABLE_SERVICE_NAME = localStrings.getLocalString("ui.wsinspector.table.service_name", "Service Name");
    private static final String TABLE_SERVICE_DISPLAY_NAME = localStrings.getLocalString("ui.wsinspector.table.service_display_name", "Service Display Name");
    private static final String TABNAME = localStrings.getLocalString("ui.wsinspector.tabname", "Web Services");
    public static final String[] WSDL_EXTN = new String[]{".wsdl"};
    public static final String[] MAPPING_EXTN = new String[]{".xml", ".gz"};
    public static final String[] MAPPING_EXTN_FILTERS = new String[]{".class", ".java", ".html", ".jsp", ".gif", ".jpg", ".wsdl", ".dbschema", ".mf", ".tld", ".properties"};
    private static String wizardHelpID = "WSServices";
    private static String deployHelpID = "WSServices";
    private BundleDescriptor descriptor = null;
    private SunWebApp sunWebApp = null;
    private SunEjbJar sunEjbJar = null;
    private EnterpriseBeans enterpriseBeans = null;
    private WebserviceDescription[] wsdArray = null;
    private HashMap wsdMap = new HashMap();
    private UITitledTable wsTablePanel = null;
    private SettingsBox settingsBox = null;
    private UITitledTextField webSrvPublishLocation = null;
    private static final String SETTINGS_SERVICE_NAME = localStrings.getLocalString("ui.wsinspector.settings.service_name", "Service Name:");
    private static final String PLEASE_SELECT_WSDL = localStrings.getLocalString("ui.wsinspector.settings.please_select_wsdl", "Please select the appropriate WSDL File");
    private static final String PLEASE_SELECT_MAPPING_FILE = localStrings.getLocalString("ui.wsinspector.settings.please_select_mapping_file", "Please select the appropriate Mapping File");
    private static final String PLEASE_PROVIDE_SERVICE_NAME = localStrings.getLocalString("ui.wsinspector.settings.please_provide_service_name", "Please provide a unique Service Name");
    private static final String PLEASE_PROVIDE_SERVICE_DISPLAY_NAME = localStrings.getLocalString("ui.wsinspector.settings.please_provide_service_display_name", "Please provide a unique Service Display Name");
    private static final String SETTINGS_DISPLAY_NAME = localStrings.getLocalString("ui.wsinspector.settings.service_display_name", "Service Display Name:");
    private static final String SETTINGS_WSDL_FILE = localStrings.getLocalString("ui.wsinspector.settings.wsdl_file", "WSDL File:");
    private static final String SETTINGS_MAPPING_FILE = localStrings.getLocalString("ui.wsinspector.settings.mapping_file", "Mapping File:");
    private static final String SETTINGS_ENDPOINTS = localStrings.getLocalString("ui.wsinspector.settings.endpoints", "Web Service Endpoints:");
    private static final String SETTINGS_ENDPOINT_NAME = localStrings.getLocalString("ui.wsinspector.settings.endpoint_name", "Port Component Name");
    private static final String DIAG_SERVICE_TITLE_ADD = localStrings.getLocalString("ui.wsinspector.dialog.add_title", "Add Service Definition");
    private static final String DIAG_SERVICE_TITLE_EDIT = localStrings.getLocalString("ui.wsinspector.dialog.edit_title", "Edit Service Definition");
    private static final String DIAG_WSDL_FILE_NAME = localStrings.getLocalString("ui.wsinspector.dialog.wsdl_file_name", "WSDL File:");
    private static final String DIAG_MAPPING_FILE_NAME = localStrings.getLocalString("ui.wsinspector.dialog.mapping_file_name", "Mapping File:");
    private static final String DIAG_SERVICE_NAME = localStrings.getLocalString("ui.wsinspector.dialog.service_qname", "Service Name:");
    private static final String DIAG_DISPLAY_NAME = localStrings.getLocalString("ui.wsinspector.dialog.display_name", "Service Display Name:");
    private static String wsDefDialogHelpSetMapID = "WWSDIALOG";
    private ServiceDefDialog serviceDefDiag = null;

    public static InspectorPane newInspectorPane(String mode) {
        return new WSInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isWizardMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return BundleDescriptor.class;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor d) {
        if (this.descriptor != d) {
            this.descriptor = d instanceof BundleDescriptor ? (BundleDescriptor)d : null;
            this.wsTablePanel.clear();
            this.setSunDescriptor(d);
        }
    }

    private void setSunDescriptor(Descriptor d) {
        if (d instanceof WebBundleDescriptor) {
            this.sunWebApp = (SunWebApp)SunOneUtils.getSunDescriptor((Descriptor)this.descriptor);
            this.wsdArray = this.sunWebApp.getWebserviceDescription();
        } else if (d instanceof EjbBundleDescriptor) {
            this.sunEjbJar = (SunEjbJar)SunOneUtils.getSunDescriptor((Descriptor)this.descriptor);
            this.wsdArray = this.sunEjbJar.getEnterpriseBeans().getWebserviceDescription();
        }
    }

    private WSInspector(String mode) {
        this.setInspectorMode(mode);
        this.initializeLayout();
    }

    private void initializeLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        UITitledBox wsTablePanelBox = new UITitledBox(TABLE_TITLE, true);
        c.weighty = 0.5;
        c.gridy = 0;
        c.fill = 1;
        this.add((Component)wsTablePanelBox, c);
        this.wsTablePanel = new UITitledTable(null, false);
        wsTablePanelBox.addWithGBConstraints(this.wsTablePanel);
        this.wsTablePanel.setTableView(new WebServTable(new WebServTableModel()));
        this.wsTablePanel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                WSInspector.this.refreshSettings();
            }
        });
        this.wsTablePanel.addControlButton(UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WSInspector.this.addServiceAction();
            }
        }, true));
        this.wsTablePanel.addSelectionEnabledButton(UIButton.createEditButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WSInspector.this.editServiceAction();
            }
        }, true));
        this.wsTablePanel.addSelectionEnabledButton(UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WSInspector.this.deleteServiceAction();
            }
        }, true));
        this.settingsBox = new SettingsBox();
        wsTablePanelBox.addWithGBConstraints(this.settingsBox);
        UITitledBox wsDescBox = new UITitledBox(WS_DESC, true);
        wsTablePanelBox.getGBConstraints().weighty = 0.0;
        wsTablePanelBox.getGBConstraints().fill = 2;
        wsTablePanelBox.addWithGBConstraints(wsDescBox);
        this.webSrvPublishLocation = new UITitledTextField(WS_DESC_WSDL_LOC, false);
        this.webSrvPublishLocation.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent ke) {
                WSInspector.this.setWsdlPublishLocation(WSInspector.this.getSelectedWebService().getWebServiceName(), WSInspector.this.webSrvPublishLocation.getText().trim());
            }

            public void keyPressed(KeyEvent ke) {
            }

            public void keyTyped(KeyEvent ke) {
            }
        });
        wsDescBox.addWithGBConstraints(this.webSrvPublishLocation);
    }

    private WebService getSelectedWebService() {
        return (WebService)this.wsTablePanel.getSelectedRowObject();
    }

    private WebserviceDescription getWebserviceDescription(String wsName) {
        WebserviceDescription wsd = (WebserviceDescription)this.wsdMap.get(wsName);
        if (wsd == null) {
            if (this.wsdArray != null) {
                for (int i = 0; i < this.wsdArray.length; ++i) {
                    String wsdName = this.wsdArray[i].getWebserviceDescriptionName();
                    if (!wsdName.equals(wsName)) continue;
                    this.wsdMap.put(wsdName, this.wsdArray[i]);
                    wsd = (WebserviceDescription)this.wsdMap.get(wsName);
                    break;
                }
            }
            if (wsd == null) {
                wsd = new WebserviceDescription();
                wsd.setWebserviceDescriptionName(wsName);
            }
        }
        return wsd;
    }

    private void editWebserviceDescription(String oldWsName, String newWsName) {
        WebserviceDescription wsd = null;
        wsd = this.removeWebserviceDescription(oldWsName);
        if (wsd != null) {
            this.setWebserviceDescription(newWsName, wsd);
        }
    }

    private WebserviceDescription removeWebserviceDescription(String wsName) {
        WebserviceDescription wsd = (WebserviceDescription)this.wsdMap.remove(wsName);
        this.updateWebserviceDescription();
        return wsd;
    }

    private void setWebserviceDescription(String wsName, WebserviceDescription wsd) {
        wsd.setWebserviceDescriptionName(wsName);
        this.wsdMap.put(wsName, wsd);
        this.updateWebserviceDescription();
    }

    private void updateWebserviceDescription() {
        this.wsdArray = this.wsdMap.values().toArray(new WebserviceDescription[0]);
        if (this.descriptor instanceof WebBundleDescriptor) {
            this.sunWebApp.setWebserviceDescription(this.wsdArray);
        } else if (this.descriptor instanceof EjbBundleDescriptor) {
            this.sunEjbJar.getEnterpriseBeans().setWebserviceDescription(this.wsdArray);
        }
    }

    private String getWsdlPublishLocation(String wsName) {
        WebserviceDescription wsd = this.getWebserviceDescription(wsName);
        return wsd.getWsdlPublishLocation();
    }

    private void setWsdlPublishLocation(String wsName, String wsdlPublishLocation) {
        if (wsdlPublishLocation == null || wsdlPublishLocation.equals("")) {
            this.removeWebserviceDescription(wsName);
        } else {
            WebserviceDescription wsd = this.getWebserviceDescription(wsName);
            wsd.setWsdlPublishLocation(wsdlPublishLocation);
            this.setWebserviceDescription(wsName, wsd);
        }
    }

    public void refresh() {
        this.wsTablePanel.updateTableData(this.descriptor.getWebServices().getWebServices());
        this.refreshSettings();
    }

    private void refreshSettings() {
        WebService sel = this.getSelectedWebService();
        this.settingsBox.setWebService(sel);
        if (sel == null) {
            this.webSrvPublishLocation.setEnabled(false);
            this.webSrvPublishLocation.setText(null);
        } else {
            this.webSrvPublishLocation.setEnabled(true);
            this.webSrvPublishLocation.setText(this.getWsdlPublishLocation(sel.getWebServiceName()));
        }
    }

    public void setReadOnly(boolean state) {
        super.setReadOnly(state);
        this.wsTablePanel.setReadOnly(state);
    }

    private static String SETTINGS_TITLE_FOR(Object v0) {
        return localStrings.getLocalString("ui.wsinspector.settings.title_for", "Settings for {0}", new Object[]{v0});
    }

    private void addServiceAction() {
        if (this.serviceDefDiag == null) {
            this.serviceDefDiag = new ServiceDefDialog(this.getMyParentFrame(), this.getOwner(), (Object)this);
        }
        this.serviceDefDiag.showDialog(null);
        this.invokeRefresh();
    }

    private void editServiceAction() {
        WebService sel = this.getSelectedWebService();
        if (sel == null) {
            return;
        }
        if (this.serviceDefDiag == null) {
            this.serviceDefDiag = new ServiceDefDialog(this.getMyParentFrame(), this.getOwner(), (Object)this);
        }
        this.serviceDefDiag.showDialog(sel);
        this.invokeRefresh();
    }

    private void deleteServiceAction() {
        Object[] list = this.wsTablePanel.confirmDeleteSelection(null, null);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                WebService ref = (WebService)list[i];
                this.descriptor.getWebServices().removeWebService(ref);
                WebserviceDescription wsd = this.removeWebserviceDescription(ref.getWebServiceName());
            }
            this.invokeRefresh();
        }
    }

    public void addLargeIcon(File iconFile) {
        if (this.isDeploymentMode()) {
            this._addDeploymentIcon("large", iconFile, (Descriptor)this.descriptor, (Descriptor)this.descriptor);
        } else {
            ModuleContent contentsMap = ((Wizard)this.getOwner()).getContentsFCD();
            this._addWizardIcon("large", iconFile, contentsMap, (Descriptor)this.descriptor);
        }
    }

    public void addSmallIcon(File iconFile) {
        if (this.isDeploymentMode()) {
            this._addDeploymentIcon("small", iconFile, (Descriptor)this.descriptor, (Descriptor)this.descriptor);
        } else {
            ModuleContent contentsMap = ((Wizard)this.getOwner()).getContentsFCD();
            this._addWizardIcon("small", iconFile, contentsMap, (Descriptor)this.descriptor);
        }
    }

    private class WebServTableModel
    extends InspectorTableModel {
        public WebServTableModel() {
            super(new String[]{TABLE_SERVICE_NAME, TABLE_SERVICE_DISPLAY_NAME});
        }

        public boolean isCellEditable(int ro, int col) {
            return false;
        }

        public Object getObjectValue(Object obj, int col) {
            WebService ref = (WebService)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = ref.getWebServiceName();
                    break;
                }
                case 1: {
                    value = ref.getDisplayName();
                }
            }
            return value != null ? value : "";
        }

        public void setObjectValue(Object obj, int col, Object value) {
            WebService ref = (WebService)obj;
        }
    }

    private class WebServTable
    extends InspectorTable {
        public WebServTable(WebServTableModel model) {
            super(model);
            this.setHandleDescriptionUpdates(true);
        }
    }

    private class ServiceDefDialog
    extends UIDialog {
        private Vector wsNames;
        private Object ownerInspector;
        private UITitledComboBox cbWsdlFile;
        private UITitledComboBox cbMappingFile;
        private UITitledTextField txServiceName;
        private UITitledTextField txDisplayName;
        private DescriptionInspector.DialogDisplayButton descInspector;
        private IconInspector.DialogDisplayButton iconInspector;
        private Vector serviceIfaces;
        private WebService srvDefDescriptorOrig;
        private WebService srvDefDescriptor;
        boolean okSelected;

        public ServiceDefDialog(Frame owner, InspectorPane.InspectorPaneOwner inspOwner, Object inspector) {
            super(owner, true);
            this.wsNames = null;
            this.ownerInspector = null;
            this.cbWsdlFile = null;
            this.cbMappingFile = null;
            this.txServiceName = null;
            this.txDisplayName = null;
            this.descInspector = null;
            this.iconInspector = null;
            this.serviceIfaces = null;
            this.srvDefDescriptorOrig = null;
            this.srvDefDescriptor = null;
            this.okSelected = false;
            this.ownerInspector = inspector;
            this.initLayout();
        }

        public ServiceDefDialog(Dialog owner, InspectorPane.InspectorPaneOwner inspOwner, Object inspector) {
            super(owner, true);
            this.wsNames = null;
            this.ownerInspector = null;
            this.cbWsdlFile = null;
            this.cbMappingFile = null;
            this.txServiceName = null;
            this.txDisplayName = null;
            this.descInspector = null;
            this.iconInspector = null;
            this.serviceIfaces = null;
            this.srvDefDescriptorOrig = null;
            this.srvDefDescriptor = null;
            this.okSelected = false;
            this.ownerInspector = inspector;
            this.initLayout();
        }

        public void showDialog(WebService editSel) {
            this.srvDefDescriptorOrig = editSel;
            this.srvDefDescriptor = editSel != null ? new WebService(editSel) : new WebService();
            this.setTitle(editSel != null ? DIAG_SERVICE_TITLE_EDIT : DIAG_SERVICE_TITLE_ADD);
            this.setInitValues();
            this.setSize(500, 365);
            this.setLocationRelativeTo(WSInspector.this);
            this.show();
            this.srvDefDescriptor = null;
        }

        private void setInitValues() {
            this.cbWsdlFile.setModel(WSInspector.this.getArchiveContents(WSDL_EXTN));
            this.cbWsdlFile.setSelectedItem(this.srvDefDescriptor.getWsdlFileUri());
            this.cbMappingFile.setModel(WSInspector.this.getArchiveContentsFiltered(MAPPING_EXTN_FILTERS));
            this.cbMappingFile.setSelectedItem(this.srvDefDescriptor.getMappingFileUri());
            this.txServiceName.setText(this.srvDefDescriptor.getWebServiceName());
            this.txDisplayName.setText(this.srvDefDescriptor.getDisplayName());
            this.descInspector.setDescriptionInspector((Descriptor)this.srvDefDescriptor);
        }

        private void initLayout() {
            UITitledBox contentPanel = new UITitledBox(null, false);
            GridBagConstraints gbc = contentPanel.getGBConstraintsCopy();
            gbc.gridx = 0;
            gbc.weightx = 0.5;
            gbc.weighty = 0.0;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.insets = new Insets(0, 5, 5, 0);
            gbc.fill = 2;
            gbc.anchor = 17;
            this.cbWsdlFile = new UITitledComboBox(DIAG_WSDL_FILE_NAME, false);
            this.cbWsdlFile.setRequired(true);
            this.cbWsdlFile.addActionListener(new ActionListener(this){
                private final /* synthetic */ ServiceDefDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    String uri = ServiceDefDialog.access$1700(this.this$1).getText();
                    ServiceDefDialog.access$1800(this.this$1).setWsdlFileUri(uri);
                    String dftName = FileTools.GetFileName(uri, false);
                    if (!dftName.equals(ServiceDefDialog.access$1900(this.this$1).getText())) {
                        ServiceDefDialog.access$1900(this.this$1).setText(dftName);
                        ServiceDefDialog.access$1900(this.this$1).fireUpdate();
                    }
                    if (!dftName.equals(ServiceDefDialog.access$2000(this.this$1).getText())) {
                        ServiceDefDialog.access$2000(this.this$1).setText(dftName);
                        ServiceDefDialog.access$2000(this.this$1).fireUpdate();
                    }
                }
            });
            gbc.gridy = 0;
            contentPanel.add((Component)this.cbWsdlFile, gbc);
            this.cbMappingFile = new UITitledComboBox(DIAG_MAPPING_FILE_NAME, false);
            this.cbMappingFile.setRequired(true);
            this.cbMappingFile.addActionListener(new ActionListener(this){
                private final /* synthetic */ ServiceDefDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    ServiceDefDialog.access$1800(this.this$1).setMappingFileUri(ServiceDefDialog.access$2200(this.this$1).getText());
                }
            });
            gbc.gridy = 1;
            contentPanel.add((Component)this.cbMappingFile, gbc);
            this.txServiceName = new UITitledTextField(DIAG_SERVICE_NAME, false);
            this.txServiceName.setRequired(true);
            this.txServiceName.addActionListener(new ActionListener(this){
                private final /* synthetic */ ServiceDefDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    String n1 = ServiceDefDialog.access$1900(this.this$1).getText();
                    String n2 = !n1.equals("") ? n1 : FileTools.GetFileName(ServiceDefDialog.access$1700(this.this$1).getText(), false);
                    n2 = DescriptorTools.createUniqueWebServiceName(WSInspector.access$2500(ServiceDefDialog.access$2400(this.this$1)).getWebServices(), n2);
                    if (!n1.equals(n2)) {
                        ServiceDefDialog.access$1900(this.this$1).setText(n2);
                    }
                    ServiceDefDialog.access$1800(this.this$1).setWebServiceName(n2);
                }
            });
            gbc.gridy = 2;
            contentPanel.add((Component)this.txServiceName, gbc);
            this.txDisplayName = new UITitledTextField(DIAG_DISPLAY_NAME, false);
            this.txDisplayName.setRequired(true);
            this.txDisplayName.addActionListener(new ActionListener(this){
                private final /* synthetic */ ServiceDefDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    String n = ServiceDefDialog.access$2000(this.this$1).getText();
                    if (n.equals("")) {
                        n = FileTools.GetFileName(ServiceDefDialog.access$1700(this.this$1).getText(), false);
                        ServiceDefDialog.access$2000(this.this$1).setText(n);
                    }
                    ServiceDefDialog.access$1800(this.this$1).setDisplayName(n);
                }
            });
            gbc.gridy = 3;
            contentPanel.add((Component)this.txDisplayName, gbc);
            this.descInspector = new DescriptionInspector.DialogDisplayButton(false);
            gbc.gridy = 4;
            contentPanel.add((Component)this.descInspector, gbc);
            this.iconInspector = new IconInspector.DialogDisplayButton((IconInspector.UpdateListener)this.ownerInspector);
            gbc.gridy = 5;
            gbc.insets.bottom = 0;
            contentPanel.add((Component)this.iconInspector, gbc);
            UIControlButtonBox dialogPane = new UIControlButtonBox(null, false);
            dialogPane.setControlButtonLocation(101);
            dialogPane.setView(contentPanel);
            dialogPane.addControlButton(UIButton.createOkButton(new ActionListener(this){
                private final /* synthetic */ ServiceDefDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.okAction();
                }
            }));
            dialogPane.addControlButton(UIButton.createCancelButton(new ActionListener(this){
                private final /* synthetic */ ServiceDefDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.cancelAction();
                }
            }));
            dialogPane.addControlButton(new UIHelpButton(wsDefDialogHelpSetMapID));
            this.getContentBox().addWithGBConstraints(dialogPane);
        }

        public void okAction() {
            String wsdlUri = this.srvDefDescriptor.getWsdlFileUri();
            if (wsdlUri == null || wsdlUri.equals("")) {
                UIOptionPane.showErrorDialog(this, PLEASE_SELECT_WSDL);
                return;
            }
            String mappingFileUri = this.srvDefDescriptor.getMappingFileUri();
            if (mappingFileUri == null || mappingFileUri.equals("")) {
                UIOptionPane.showErrorDialog(this, PLEASE_SELECT_MAPPING_FILE);
                return;
            }
            String newWsn = this.srvDefDescriptor.getWebServiceName();
            if (newWsn.equals("")) {
                UIOptionPane.showErrorDialog(this, PLEASE_PROVIDE_SERVICE_NAME);
                return;
            }
            String newWsdn = this.srvDefDescriptor.getDisplayName();
            if (newWsdn.equals("")) {
                UIOptionPane.showErrorDialog(this, PLEASE_PROVIDE_SERVICE_DISPLAY_NAME);
                return;
            }
            boolean wsnExists = WSInspector.this.wsTablePanel.getRowWithValue(0, newWsn) != null;
            boolean wsdnExists = !newWsdn.equals("") && WSInspector.this.wsTablePanel.getRowWithValue(1, newWsdn) != null;
            this.okSelected = true;
            if (this.srvDefDescriptorOrig != null) {
                String oldWsn = this.srvDefDescriptorOrig.getWebServiceName();
                String oldWsdn = this.srvDefDescriptorOrig.getDisplayName();
                if (wsnExists && !newWsn.equals(oldWsn)) {
                    UIOptionPane.showErrorDialog(this, PLEASE_PROVIDE_SERVICE_NAME);
                    return;
                }
                if (wsdnExists && !newWsdn.equals(oldWsdn)) {
                    UIOptionPane.showErrorDialog(this, PLEASE_PROVIDE_SERVICE_DISPLAY_NAME);
                    return;
                }
                WSInspector.this.editWebserviceDescription(oldWsn, newWsn);
                this.srvDefDescriptorOrig.setWebServiceName(newWsn);
                this.srvDefDescriptorOrig.setDisplayName(newWsdn);
                this.srvDefDescriptorOrig.setWsdlFileUri(wsdlUri);
                this.srvDefDescriptorOrig.setMappingFileUri(mappingFileUri);
                this.srvDefDescriptorOrig.setDescription(this.srvDefDescriptor.getDescription());
            } else {
                if (wsnExists) {
                    UIOptionPane.showErrorDialog(this, PLEASE_PROVIDE_SERVICE_NAME);
                    return;
                }
                if (wsdnExists) {
                    UIOptionPane.showErrorDialog(this, PLEASE_PROVIDE_SERVICE_DISPLAY_NAME);
                    return;
                }
                WSInspector.this.descriptor.getWebServices().addWebService(this.srvDefDescriptor);
            }
            this.hide();
        }

        public void cancelAction() {
            this.okSelected = false;
            this.hide();
        }

        static /* synthetic */ UITitledComboBox access$1700(ServiceDefDialog x0) {
            return x0.cbWsdlFile;
        }

        static /* synthetic */ WebService access$1800(ServiceDefDialog x0) {
            return x0.srvDefDescriptor;
        }

        static /* synthetic */ UITitledTextField access$1900(ServiceDefDialog x0) {
            return x0.txServiceName;
        }

        static /* synthetic */ UITitledTextField access$2000(ServiceDefDialog x0) {
            return x0.txDisplayName;
        }

        static /* synthetic */ UITitledComboBox access$2200(ServiceDefDialog x0) {
            return x0.cbMappingFile;
        }

        static /* synthetic */ WSInspector access$2400(ServiceDefDialog x0) {
            return x0.WSInspector.this;
        }
    }

    private class EndpointsTableModel
    extends InspectorTableModel {
        public EndpointsTableModel() {
            super(new String[]{SETTINGS_ENDPOINT_NAME, "Link"});
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public Object getObjectValue(Object obj, int col) {
            WebServiceEndpoint ref = (WebServiceEndpoint)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = ref.getEndpointName();
                    break;
                }
                case 1: {
                    value = ref.implementedByEjbComponent() ? ref.getEjbLink() : ref.getWebComponentLink();
                }
            }
            return value != null ? value : "";
        }

        public void setObjectValue(Object obj, int col, Object value) {
            WebService ref = (WebService)obj;
        }
    }

    private class EndpointsTable
    extends InspectorTable {
        public EndpointsTable(EndpointsTableModel model) {
            super(model);
            this.setHandleDescriptionUpdates(true);
        }
    }

    private class SettingsBox
    extends UITitledBox {
        private UITitledTextField srvName;
        private UITitledTextField dspName;
        private UITitledTextField wsdlFile;
        private UITitledTextField mapFile;
        private UITitledTable endpoints;

        public SettingsBox() {
            super("<>", true);
            this.srvName = null;
            this.dspName = null;
            this.wsdlFile = null;
            this.mapFile = null;
            this.endpoints = null;
            this._initLayout();
        }

        private void _initLayout() {
            GridBagConstraints gbc = this.getGBConstraints();
            gbc.weighty = 0.25;
            gbc.insets = new Insets(5, 5, 5, 5);
            gbc.fill = 2;
            gbc.anchor = 10;
            this.srvName = new UITitledTextField(SETTINGS_SERVICE_NAME, false);
            this.srvName.setReadOnly(true);
            gbc.gridy = 0;
            this.add((Component)this.srvName, gbc);
            this.dspName = new UITitledTextField(SETTINGS_DISPLAY_NAME, false);
            this.dspName.setReadOnly(true);
            gbc.gridy = 1;
            this.add((Component)this.dspName, gbc);
            this.wsdlFile = new UITitledTextField(SETTINGS_WSDL_FILE, false);
            this.wsdlFile.setReadOnly(true);
            gbc.gridy = 2;
            this.add((Component)this.wsdlFile, gbc);
            this.mapFile = new UITitledTextField(SETTINGS_MAPPING_FILE, false);
            this.mapFile.setReadOnly(true);
            gbc.gridy = 3;
            this.add((Component)this.mapFile, gbc);
            this.endpoints = new UITitledTable(SETTINGS_ENDPOINTS, false);
            this.endpoints.setTableView(new EndpointsTable(new EndpointsTableModel()));
            this.endpoints.setReadOnly(true);
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.weighty = 1.0;
            gbc.gridheight = 4;
            gbc.fill = 1;
            this.add((Component)this.endpoints, gbc);
        }

        public void setWebService(WebService ws) {
            if (ws != null) {
                this.setTitle(WSInspector.SETTINGS_TITLE_FOR(ws.getWebServiceName()));
                this.srvName.setText(ws.getWebServiceName());
                this.dspName.setText(ws.getDisplayName());
                this.wsdlFile.setText(ws.getWsdlFileUri());
                this.mapFile.setText(ws.getMappingFileUri());
                this.endpoints.clear();
                this.endpoints.setModel(ws.getEndpoints());
            } else {
                this.setTitle(WSInspector.SETTINGS_TITLE_FOR("?"));
                this.srvName.setText(null);
                this.dspName.setText(null);
                this.wsdlFile.setText(null);
                this.mapFile.setText(null);
                this.endpoints.clear();
            }
        }
    }
}

