/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.websrv;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.NameValuePairDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServiceHandler;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorTools;
import com.sun.enterprise.tools.deployment.ui.shared.ModuleArchive;
import com.sun.enterprise.tools.deployment.ui.shared.NameValuePairTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.tools.deployment.ui.utils.WinTools;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.xml.namespace.QName;

public class WSHandlers
extends UIDialog {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(WSHandlers.class);
    private static final String HANDLERS = localStrings.getLocalString("ui.wshandlers.handlers.title", "Handlers");
    private static final String BUTTON_PORTS = localStrings.getLocalString("ui.wshandlers.buttons.ports", "Ports...");
    private static final String BUTTON_SOAP_HEADERS = localStrings.getLocalString("ui.wshandlers.buttons.soap_headers", "SOAP Headers...");
    private static final String BUTTON_SOAP_ROLES = localStrings.getLocalString("ui.wshandlers.buttons.soap_headers", "SOAP Roles...");
    private static final String BLANK_HANDLER = localStrings.getLocalString("ui.wshandlers.msg.validation", "may not be empty.");
    private static final char mnemonic_AddHandler = localStrings.getLocalString("ui.wshandlers.handlers.add_button_mnemonic", "N").charAt(0);
    private static final char mnemonic_DelHandler = localStrings.getLocalString("ui.wshandlers.handlers.del_button_mnemonic", "T").charAt(0);
    private static final char mnemonic_AddPort = localStrings.getLocalString("ui.wshandlers.ports.add_button_mnemonic", "P").charAt(0);
    private static final char mnemonic_DelPort = localStrings.getLocalString("ui.wshandlers.ports.del_button_mnemonic", "R").charAt(0);
    private static final char mnemonic_AddSoapHandler = localStrings.getLocalString("ui.wshandlers.soap_headers.add_button_mnemonic", "E").charAt(0);
    private static final char mnemonic_DelSoapHandler = localStrings.getLocalString("ui.wshandlers.soap_headers.del_button_mnemonic", "V").charAt(0);
    private static final char mnemonic_AddSoapRoles = localStrings.getLocalString("ui.wshandlers.soap_roles.add_button_mnemonic", "L").charAt(0);
    private static final char mnemonic_DelSoapRoles = localStrings.getLocalString("ui.wshandlers.soap_roles.del_button_mnemonic", "S").charAt(0);
    private boolean isOK = false;
    private BundleDescriptor bundleDescriptor = null;
    private WebServiceHandlerContainer descriptor = null;
    private List handlerClasses = null;
    private HandlerTableView handlerTablePanel = null;
    private NameValuePairTable iniParmTable = null;
    private HandlerPortsTableView portsTablePanel = null;
    private HandlerSoapHeaderTableView soapHeaderTablePanel = null;
    private HandlerSoapRolesTableView soapRolesTablePanel = null;
    private static String HANDLER_TABLE_CLASS = localStrings.getLocalString("ui.wshandlers.handlers.class", "Class");
    private static String HANDLER_TABLE_NAME = localStrings.getLocalString("ui.wshandlers.handlers.name", "Name");
    private static String HANDLER_TABLE_DISPLAY_NAME = localStrings.getLocalString("ui.wshandlers.handlers.display_name", "Display Name");
    private static final String PORTS_TITLE = localStrings.getLocalString("ui.wshandlers.ports.title", "Ports");
    private static final String PORTS_PORTS = localStrings.getLocalString("ui.wshandlers.ports.ports", "Ports");
    private static final String SOAP_HEADER_TITLE = localStrings.getLocalString("ui.wshandlers.soap_headers.title", "SOAP Headers");
    private static final String SOAP_HEADER_NAMESPACE = localStrings.getLocalString("ui.wshandlers.soap_headers.namespace", "Namespace");
    private static final String SOAP_HEADER_LOCAL_PART = localStrings.getLocalString("ui.wshandlers.soap_headers.local_part", "Local Part");
    private static final String SOAP_ROLES_TITLE = localStrings.getLocalString("ui.wshandlers.soap_roles.title", "SOAP Roles");

    private static String DIALOG_TITLE(Object v0) {
        return localStrings.getLocalString("ui.wshandlers.title", "Handlers - {0}", new Object[]{v0});
    }

    public static WSHandlers newDialog(Component comp) {
        Window win = WinTools.getAncestorWindow(comp);
        WSHandlers dialog = null;
        if (win instanceof Dialog) {
            dialog = new WSHandlers((Dialog)win);
        } else if (win instanceof Frame) {
            dialog = new WSHandlers((Frame)win);
        }
        return dialog;
    }

    public WSHandlers(Dialog d) {
        super(d, true);
        this.initLayout();
    }

    public WSHandlers(Frame f) {
        super(f, true);
        this.initLayout();
    }

    public void showDialog(Descriptor d) {
        this.showDialog(d, null);
    }

    public void showDialog(Descriptor d, List classList) {
        this.setDescriptor(d, classList);
        this.isOK = false;
        this.setSize(650, 700);
        this.setLocationRelativeToOwner();
        this.show();
    }

    public void setDescriptor(Descriptor d) {
        this.setDescriptor(d, null);
    }

    public void setDescriptor(Descriptor d, List classList) {
        BundleDescriptor bd;
        this.handlerClasses = classList != null ? classList : ((bd = DescriptorTools.getBundleDescriptor(d)) != null ? ModuleArchive.getModuleArchive((Descriptor)bd).getClassNames() : new Vector());
        this.portsTablePanel.setVisible(!(d instanceof WebServiceEndpoint));
        LinkedList handlers = WSHandlers.getHandlerChain(d);
        if (handlers != null) {
            String n = d.getDisplayName();
            this.descriptor = new WebServiceHandlerContainer(n, handlers, true);
            this.setTitle(WSHandlers.DIALOG_TITLE(n));
        } else {
            this.descriptor = null;
            this.setTitle(WSHandlers.DIALOG_TITLE("?"));
        }
        this.handlerTablePanel.refresh();
    }

    private static LinkedList getHandlerChain(Descriptor d) {
        if (d instanceof WebServiceEndpoint) {
            return ((WebServiceEndpoint)d).getHandlerChain();
        }
        if (d instanceof ServiceReferenceDescriptor) {
            return ((ServiceReferenceDescriptor)d).getHandlerChain();
        }
        Print.dprintStackTrace((String)("Can't getHandlerChain: " + DT.className(d)));
        return null;
    }

    private void initLayout() {
        UIControlButtonBox container = new UIControlButtonBox(null, false);
        container.setControlButtonLocation(101);
        this.getContentBox().addWithGBConstraints(container);
        container.setView(this.initViewLayout());
        container.addControlButton(UIButton.createOkButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WSHandlers.this.okAction();
            }
        }));
        container.addControlButton(UIButton.createCancelButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WSHandlers.this.cancelAction();
            }
        }));
        container.addControlButton(new UIHelpButton("WSHandlers"));
    }

    private UITitledBox initViewLayout() {
        UITitledBox handlers = new UITitledBox(HANDLERS, true);
        this.handlerTablePanel = new HandlerTableView();
        handlers.addWithGBConstraints(this.handlerTablePanel);
        this.handlerTablePanel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                WSHandlers.this.refreshHandlerSelection();
            }
        });
        this.iniParmTable = new NameValuePairTable(){

            public void refresh() {
                WebServiceHandler wsh = (WebServiceHandler)this.getDescriptor();
                if (wsh != null) {
                    this.setReadOnly(false);
                    this.setModel(wsh.getInitParams());
                } else {
                    this.clear();
                    this.setReadOnly(true);
                }
            }

            public void addRecord() {
                WebServiceHandler wsh = (WebServiceHandler)this.getDescriptor();
                if (wsh != null) {
                    wsh.addInitParam(new NameValuePairDescriptor());
                }
                this.refresh();
            }

            public void deleteRecord(Object ref) {
                WebServiceHandler wsh = (WebServiceHandler)this.getDescriptor();
                if (wsh != null) {
                    wsh.removeInitParam((NameValuePairDescriptor)ref);
                }
                this.refresh();
            }
        };
        handlers.addWithGBConstraints(this.iniParmTable);
        this.portsTablePanel = new HandlerPortsTableView();
        handlers.addWithGBConstraints(this.portsTablePanel);
        this.soapHeaderTablePanel = new HandlerSoapHeaderTableView();
        handlers.addWithGBConstraints(this.soapHeaderTablePanel);
        this.soapRolesTablePanel = new HandlerSoapRolesTableView();
        handlers.addWithGBConstraints(this.soapRolesTablePanel);
        return handlers;
    }

    protected void refreshHandlerSelection() {
        WebServiceHandler wsh = (WebServiceHandler)this.handlerTablePanel.getSelectedRowObject();
        this.iniParmTable.setDescriptor((Descriptor)wsh);
        if (this.portsTablePanel.isVisible()) {
            this.portsTablePanel.setDescriptor(wsh);
        }
        this.soapHeaderTablePanel.setDescriptor(wsh);
        this.soapRolesTablePanel.setDescriptor(wsh);
    }

    public boolean validateEntries(boolean showErrors) {
        String fields = null;
        boolean valid = true;
        if (this.handlerTablePanel.getRowWithValue(0, "") != null) {
            fields = HANDLERS + " " + HANDLER_TABLE_NAME;
            valid = false;
        }
        if (this.handlerTablePanel.getRowWithValue(1, "") != null) {
            fields = fields + "\n" + HANDLERS + " " + HANDLER_TABLE_CLASS;
            valid = false;
        }
        if (this.iniParmTable.getRowWithValue(0, "") != null) {
            fields = fields + "\n" + NameValuePairTable.TABLE_TITLE + " " + NameValuePairTable.TABLE_NAME;
            valid = false;
        }
        if (this.iniParmTable.getRowWithValue(1, "") != null) {
            fields = fields + "\n" + NameValuePairTable.TABLE_TITLE + " " + NameValuePairTable.TABLE_VALUE;
            valid = false;
        }
        if (this.soapHeaderTablePanel.getRowWithValue(0, "") != null) {
            fields = fields + "\n" + SOAP_HEADER_TITLE + " " + SOAP_HEADER_NAMESPACE;
            valid = false;
        }
        if (this.soapHeaderTablePanel.getRowWithValue(1, "") != null) {
            fields = fields + "\n" + SOAP_HEADER_TITLE + " " + SOAP_HEADER_LOCAL_PART;
            valid = false;
        }
        if (this.soapRolesTablePanel.getRowWithValue(0, "") != null) {
            fields = fields + "\n" + SOAP_ROLES_TITLE;
            valid = false;
        }
        if (showErrors && !valid) {
            UIOptionPane.showErrorDialog(this, fields + "\n" + BLANK_HANDLER);
        }
        return valid;
    }

    protected void okAction() {
        if (this.validateEntries(true)) {
            this.isOK = true;
            this.descriptor.commit();
            this.hide();
        }
    }

    protected void cancelAction() {
        this.isOK = false;
        this.hide();
    }

    private static String PORTS_TITLE_FOR(Object v0) {
        return localStrings.getLocalString("ui.wshandlers.ports.title_for", "Ports for {0}", new Object[]{v0});
    }

    private static String SOAP_HEADER_TITLE_FOR(Object v0) {
        return localStrings.getLocalString("ui.wshandlers.soap_headers.title_for", "SOAP Headers for {0}", new Object[]{v0});
    }

    private static String SOAP_ROLES_TITLE_FOR(Object v0) {
        return localStrings.getLocalString("ui.wshandlers.soap_roles.title_for", "SOAP Roles for {0}", new Object[]{v0});
    }

    private class HandlerSoapRolesTableModel
    extends InspectorTableModel {
        public HandlerSoapRolesTableModel() {
            super(new String[]{SOAP_ROLES_TITLE});
        }

        public Object getObjectValue(Object obj, int col) {
            InspectorTableModel.InspectorDataWrapper ref = (InspectorTableModel.InspectorDataWrapper)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = (String)ref.getObject();
                }
            }
            return value != null ? value : "";
        }

        public void setObjectValue(Object obj, int col, Object value) {
            InspectorTableModel.InspectorDataWrapper ref = (InspectorTableModel.InspectorDataWrapper)obj;
            WebServiceHandler wsh = ((HandlerSoapRolesTableView)this.getTableOwner()).getDescriptor();
            if (wsh == null) {
                return;
            }
            switch (col) {
                case 0: {
                    wsh.removeSoapRole((String)ref.getObject());
                    ref.setObject(value.toString());
                    wsh.addSoapRole((String)ref.getObject());
                }
            }
        }
    }

    private class HandlerSoapRolesTable
    extends InspectorTable {
        public HandlerSoapRolesTable(HandlerSoapRolesTableModel model) {
            super(model);
        }
    }

    private class HandlerSoapRolesTableView
    extends UITitledTable {
        private WebServiceHandler wshDesc;

        public HandlerSoapRolesTableView() {
            super(SOAP_ROLES_TITLE, true);
            this.wshDesc = null;
            this.setTableView(new HandlerSoapRolesTable(new HandlerSoapRolesTableModel()));
            this.setControlButtonLocation(13);
            this.addControlButton(UIButton.createAddButton(localStrings.getLocalString("ui.wshandlers.soap_roles.add_button", "Add Roles"), mnemonic_AddSoapRoles, new ActionListener(this){
                private final /* synthetic */ HandlerSoapRolesTableView this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    this.this$1.addSoapRoleAction();
                }
            }, false));
            this.addSelectionEnabledButton(UIButton.createDeleteButton(localStrings.getLocalString("ui.wshandlers.soap_roles.del_button", "Delete Roles..."), mnemonic_DelSoapRoles, new ActionListener(this){
                private final /* synthetic */ HandlerSoapRolesTableView this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    this.this$1.deleteSoapRoleAction();
                }
            }, true));
        }

        public void setDescriptor(WebServiceHandler wsh) {
            this.wshDesc = wsh;
            this.refresh();
        }

        public WebServiceHandler getDescriptor() {
            return this.wshDesc;
        }

        private void refresh() {
            this.clear();
            WebServiceHandler wsh = this.getDescriptor();
            if (wsh != null) {
                this.setReadOnly(false);
                this.setTitle(WSHandlers.SOAP_ROLES_TITLE_FOR(wsh.getDisplayName()));
                this.setModel(this.wrapData(wsh.getSoapRoles()));
            } else {
                this.setTitle(SOAP_ROLES_TITLE);
                this.clear();
                this.setReadOnly(true);
            }
        }

        protected void addSoapRoleAction() {
            WebServiceHandler wsh = this.getDescriptor();
            if (wsh != null && this.getRowWithValue(0, "") == null) {
                wsh.addSoapRole("");
            }
            this.selectRowWithValueOnUpdate(0, "");
            this.refresh();
        }

        protected void deleteSoapRoleAction() {
            WebServiceHandler wsh = this.getDescriptor();
            Object[] list = this.confirmDeleteSelection(null, null);
            if (wsh != null && list != null) {
                for (int i = 0; i < list.length; ++i) {
                    String sr = (String)((InspectorTableModel.InspectorDataWrapper)list[i]).getObject();
                    wsh.removeSoapRole(sr);
                }
                this.refresh();
            }
        }
    }

    private class HandlerSoapHeadersTableModel
    extends InspectorTableModel {
        public HandlerSoapHeadersTableModel() {
            super(new String[]{SOAP_HEADER_NAMESPACE, SOAP_HEADER_LOCAL_PART});
        }

        public Object getObjectValue(Object obj, int col) {
            InspectorTableModel.InspectorDataWrapper ref = (InspectorTableModel.InspectorDataWrapper)obj;
            QName qn = (QName)ref.getObject();
            String value = null;
            switch (col) {
                case 0: {
                    value = qn.getNamespaceURI();
                    break;
                }
                case 1: {
                    value = qn.getLocalPart();
                }
            }
            return value != null ? value : "";
        }

        public void setObjectValue(Object obj, int col, Object value) {
            InspectorTableModel.InspectorDataWrapper ref = (InspectorTableModel.InspectorDataWrapper)obj;
            QName qn = (QName)ref.getObject();
            WebServiceHandler wsh = ((HandlerSoapHeaderTableView)this.getTableOwner()).getDescriptor();
            if (wsh == null) {
                return;
            }
            switch (col) {
                case 0: {
                    wsh.removeSoapHeader(qn);
                    ref.setObject(new QName(value.toString(), qn.getLocalPart()));
                    wsh.addSoapHeader((QName)ref.getObject());
                    break;
                }
                case 1: {
                    wsh.removeSoapHeader(qn);
                    ref.setObject(new QName(qn.getNamespaceURI(), value.toString()));
                    wsh.addSoapHeader((QName)ref.getObject());
                }
            }
        }
    }

    private class HandlerSoapHeadersTable
    extends InspectorTable {
        public HandlerSoapHeadersTable(HandlerSoapHeadersTableModel model) {
            super(model);
        }
    }

    private class HandlerSoapHeaderTableView
    extends UITitledTable {
        private WebServiceHandler wshDesc;

        public HandlerSoapHeaderTableView() {
            super(SOAP_HEADER_TITLE, true);
            this.wshDesc = null;
            this.setTableView(new HandlerSoapHeadersTable(new HandlerSoapHeadersTableModel()));
            this.setControlButtonLocation(13);
            this.addControlButton(UIButton.createAddButton(localStrings.getLocalString("ui.wshandlers.soap_headers.add_button", "Add Headers"), mnemonic_AddSoapHandler, new ActionListener(this){
                private final /* synthetic */ HandlerSoapHeaderTableView this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    this.this$1.addSoapHeaderAction();
                }
            }, false));
            this.addSelectionEnabledButton(UIButton.createDeleteButton(localStrings.getLocalString("ui.wshandlers.soap_headers.del_button", "Remove Headers..."), mnemonic_DelSoapHandler, new ActionListener(this){
                private final /* synthetic */ HandlerSoapHeaderTableView this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    this.this$1.deleteSoapHeaderAction();
                }
            }, true));
        }

        public void setDescriptor(WebServiceHandler wsh) {
            this.wshDesc = wsh;
            this.refresh();
        }

        public WebServiceHandler getDescriptor() {
            return this.wshDesc;
        }

        private void refresh() {
            this.clear();
            WebServiceHandler wsh = this.getDescriptor();
            if (wsh != null) {
                this.setReadOnly(false);
                this.setTitle(WSHandlers.SOAP_HEADER_TITLE_FOR(wsh.getDisplayName()));
                this.setModel(this.wrapData(wsh.getSoapHeaders()));
            } else {
                this.setTitle(SOAP_HEADER_TITLE);
                this.clear();
                this.setReadOnly(true);
            }
        }

        protected void addSoapHeaderAction() {
            WebServiceHandler wsh = this.getDescriptor();
            if (wsh != null && this.getRowWithValue(0, "") == null) {
                wsh.addSoapHeader(new QName("", ""));
            }
            this.selectRowWithValueOnUpdate(0, "");
            this.refresh();
        }

        protected void deleteSoapHeaderAction() {
            WebServiceHandler wsh = this.getDescriptor();
            Object[] list = this.confirmDeleteSelection(null, null);
            if (wsh != null && list != null) {
                for (int i = 0; i < list.length; ++i) {
                    QName qn = (QName)((InspectorTableModel.InspectorDataWrapper)list[i]).getObject();
                    wsh.removeSoapHeader(qn);
                }
                this.refresh();
            }
        }
    }

    private class HandlerPortsTableModel
    extends InspectorTableModel {
        public HandlerPortsTableModel() {
            super(new String[]{PORTS_PORTS});
        }

        public Object getObjectValue(Object obj, int col) {
            InspectorTableModel.InspectorDataWrapper ref = (InspectorTableModel.InspectorDataWrapper)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = (String)ref.getObject();
                }
            }
            return value != null ? value : "";
        }

        public void setObjectValue(Object obj, int col, Object value) {
            InspectorTableModel.InspectorDataWrapper ref = (InspectorTableModel.InspectorDataWrapper)obj;
            WebServiceHandler wsh = ((HandlerPortsTableView)this.getTableOwner()).getDescriptor();
            if (wsh == null) {
                return;
            }
            switch (col) {
                case 0: {
                    wsh.removePortName((String)ref.getObject());
                    ref.setObject(value.toString());
                    wsh.addPortName((String)ref.getObject());
                }
            }
        }
    }

    private class HandlerPortsTable
    extends InspectorTable {
        public HandlerPortsTable(HandlerPortsTableModel model) {
            super(model);
            this.setHandleDescriptionUpdates(true);
        }
    }

    private class HandlerPortsTableView
    extends UITitledTable {
        private WebServiceHandler wshDesc;

        public HandlerPortsTableView() {
            super(PORTS_TITLE, true);
            this.wshDesc = null;
            this.setTableView(new HandlerPortsTable(new HandlerPortsTableModel()));
            this.setControlButtonLocation(13);
            this.addControlButton(UIButton.createAddButton(localStrings.getLocalString("ui.wshandlers.ports.add_button", "Add Port"), mnemonic_AddPort, new ActionListener(this){
                private final /* synthetic */ HandlerPortsTableView this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    this.this$1.addPortAction();
                }
            }, false));
            this.addSelectionEnabledButton(UIButton.createDeleteButton(localStrings.getLocalString("ui.wshandlers.ports.del_button", "Delete Port..."), mnemonic_DelPort, new ActionListener(this){
                private final /* synthetic */ HandlerPortsTableView this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    this.this$1.deletePortAction();
                }
            }, true));
        }

        public void setDescriptor(WebServiceHandler wsh) {
            this.wshDesc = wsh;
            this.refresh();
        }

        public WebServiceHandler getDescriptor() {
            return this.wshDesc;
        }

        private void refresh() {
            this.clear();
            WebServiceHandler wsh = this.getDescriptor();
            if (wsh != null) {
                this.setReadOnly(false);
                this.setTitle(WSHandlers.PORTS_TITLE_FOR(wsh.getDisplayName()));
                this.setModel(this.wrapData(wsh.getPortNames()));
            } else {
                this.setTitle(PORTS_TITLE);
                this.clear();
                this.setReadOnly(true);
            }
        }

        protected void addPortAction() {
            WebServiceHandler wsh = this.getDescriptor();
            if (wsh != null && this.getRowWithValue(0, "") == null) {
                wsh.addPortName("");
            }
            this.selectRowWithValueOnUpdate(0, "");
            this.refresh();
        }

        protected void deletePortAction() {
            WebServiceHandler wsh = this.getDescriptor();
            Object[] list = this.confirmDeleteSelection(null, null);
            if (wsh != null && list != null) {
                for (int i = 0; i < list.length; ++i) {
                    String pn = (String)((InspectorTableModel.InspectorDataWrapper)list[i]).getObject();
                    wsh.removePortName(pn);
                }
                this.refresh();
            }
        }
    }

    private class HandlerTableModel
    extends InspectorTableModel {
        public HandlerTableModel() {
            super(new String[]{HANDLER_TABLE_CLASS, HANDLER_TABLE_NAME, HANDLER_TABLE_DISPLAY_NAME, DescriptionInspector.DESCRIPTION_COLUMN_INIT});
        }

        public Object getObjectValue(Object obj, int col) {
            WebServiceHandler ref = (WebServiceHandler)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = ref.getHandlerClass();
                    break;
                }
                case 1: {
                    value = ref.getHandlerName();
                    break;
                }
                case 2: {
                    value = ref.getDisplayName();
                    break;
                }
                case 3: {
                    value = ref.getDescription();
                }
            }
            return value != null ? value : "";
        }

        public void setObjectValue(Object obj, int col, Object value) {
            WebServiceHandler ref = (WebServiceHandler)obj;
            switch (col) {
                case 0: {
                    String clz;
                    String clzName = value.toString();
                    ref.setHandlerClass(clzName);
                    int p = clzName.lastIndexOf(".");
                    String string = clz = p >= 0 ? clzName.substring(p + 1) : clzName;
                    if (ref.getHandlerName() == null || ref.getHandlerName().equals("")) {
                        ref.setHandlerName(clz);
                        super.fireTableCellUpdated(super.getCurrentRow(), 1);
                    }
                    if (!ref.getDisplayName().equals("")) break;
                    ref.setDisplayName(clz);
                    super.fireTableCellUpdated(super.getCurrentRow(), 2);
                    break;
                }
                case 1: {
                    ref.setHandlerName(value.toString());
                    break;
                }
                case 2: {
                    ref.setDisplayName(value.toString());
                    break;
                }
                case 3: {
                    ref.setDescription(value.toString());
                }
            }
        }
    }

    private class HandlerTable
    extends InspectorTable {
        private InspectorTable.TableComboBoxEditor archiveClassNamesEditor;

        public HandlerTable(HandlerTableModel model) {
            super(model);
            this.archiveClassNamesEditor = null;
            this.setHandleDescriptionUpdates(true);
        }

        public TableCellEditor getCellEditor(int row, int col) {
            if (col == 0) {
                TableCellEditor rtn = this.getClassesCellEditor();
                return rtn != null ? rtn : super.getCellEditor(row, col);
            }
            return super.getCellEditor(row, col);
        }

        public void clear() {
            super.clear();
            this.archiveClassNamesEditor = null;
        }

        private TableCellEditor getClassesCellEditor() {
            if (this.archiveClassNamesEditor == null) {
                this.archiveClassNamesEditor = this.getComboBoxEditor(WSHandlers.this.handlerClasses);
                this.archiveClassNamesEditor.setEditable(UIConfig.debugMode());
            }
            return this.archiveClassNamesEditor;
        }
    }

    private class HandlerTableView
    extends UITitledTable {
        public HandlerTableView() {
            super((String)null, false);
            this.setTableView(new HandlerTable(new HandlerTableModel()));
            this.setControlButtonLocation(13);
            this.addControlButton(UIButton.createAddButton(localStrings.getLocalString("ui.wshandlers.handlers.add_button", "Add Handlers"), mnemonic_AddHandler, new ActionListener(this){
                private final /* synthetic */ HandlerTableView this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    this.this$1.addHandlerAction();
                }
            }, false));
            this.addSelectionEnabledButton(UIButton.createDeleteButton(localStrings.getLocalString("ui.wshandlers.handlers.del_button", "Delete Handlers..."), mnemonic_DelHandler, new ActionListener(this){
                private final /* synthetic */ HandlerTableView this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    this.this$1.deleteHandlerAction();
                }
            }, true));
            this.addSelectionEnabledButton(UIButton.createMoveUpButton(new ActionListener(this){
                private final /* synthetic */ HandlerTableView this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    this.this$1.moveHandlerAction(-1);
                }
            }));
            this.addSelectionEnabledButton(UIButton.createMoveDownButton(new ActionListener(this){
                private final /* synthetic */ HandlerTableView this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    this.this$1.moveHandlerAction(1);
                }
            }));
        }

        public void refresh() {
            this.clear();
            if (WSHandlers.this.descriptor != null) {
                this.setModel(WSHandlers.this.descriptor.getHandlerChain());
            }
            WSHandlers.this.refreshHandlerSelection();
        }

        protected void addHandlerAction() {
            if (WSHandlers.this.descriptor == null) {
                Print.dprintln((String)"Descriptor is null!");
                return;
            }
            if (this.getRowWithValue(0, "") == null) {
                WSHandlers.this.descriptor.addHandler(new WebServiceHandler());
            }
            this.selectRowWithValueOnUpdate(0, "");
            this.refresh();
        }

        protected void deleteHandlerAction() {
            Object[] list = this.confirmDeleteSelection(null, null);
            if (list != null) {
                for (int i = 0; i < list.length; ++i) {
                    WSHandlers.this.descriptor.removeHandler((WebServiceHandler)list[i]);
                }
                this.refresh();
            }
        }

        protected void moveHandlerAction(int loc) {
            int selPos = this.getSelectedRow();
            int newLoc = selPos + loc;
            if (selPos >= 0 && newLoc >= 0 && newLoc != selPos && newLoc < this.getRowCount()) {
                LinkedList list = WSHandlers.this.descriptor.getHandlerChain();
                WebServiceHandler wsh = (WebServiceHandler)list.remove(selPos);
                list.add(newLoc, wsh);
                this.selectRowWithValueOnUpdate(0, wsh.getHandlerClass());
                this.refresh();
            }
        }
    }

    private class WebServiceHandlerContainer
    extends Descriptor {
        private LinkedList handlersOriginal;
        private LinkedList handlers;

        public WebServiceHandlerContainer(String displayName, LinkedList handlers, boolean copy) {
            super(displayName, "");
            this.handlersOriginal = null;
            this.handlers = null;
            if (copy && handlers != null) {
                this.handlersOriginal = handlers;
                this.handlers = new LinkedList();
                Iterator i = handlers.iterator();
                while (i.hasNext()) {
                    this.handlers.addLast(new WebServiceHandler((WebServiceHandler)i.next()));
                }
            } else {
                this.handlersOriginal = null;
                this.handlers = handlers != null ? handlers : new LinkedList();
            }
        }

        public LinkedList getHandlerChain() {
            return this.handlers;
        }

        public void addHandler(WebServiceHandler handler) {
            this.handlers.add(handler);
        }

        public void removeHandler(WebServiceHandler handler) {
            this.handlers.remove(handler);
        }

        public void commit() {
            if (this.handlersOriginal != null && this.handlersOriginal != this.handlers) {
                this.handlersOriginal.clear();
                this.handlersOriginal.addAll(this.handlers);
            }
        }
    }
}

