/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.websrv;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.tools.common.dd.LoginConfig;
import com.sun.enterprise.tools.common.dd.WebserviceEndpoint;
import com.sun.enterprise.tools.common.dd.ejb.Ejb;
import com.sun.enterprise.tools.common.dd.ejb.SunEjbJar;
import com.sun.enterprise.tools.common.dd.webapp.Servlet;
import com.sun.enterprise.tools.common.dd.webapp.SunWebApp;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.ejb.NewEjbWizard;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorInspector;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorTools;
import com.sun.enterprise.tools.deployment.ui.shared.IconInspector;
import com.sun.enterprise.tools.deployment.ui.shared.ModuleContent;
import com.sun.enterprise.tools.deployment.ui.sunone.SunOneUtils;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIProject;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledQName;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.tools.deployment.ui.war.NewWebComponentWizard;
import com.sun.enterprise.tools.deployment.ui.websrv.WSHandlers;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Vector;
import javax.xml.namespace.QName;

public class WSEndpointInspector
extends InspectorPane
implements IconInspector.UpdateListener {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(WSEndpointInspector.class);
    private static String WSDL_PORT = localStrings.getLocalString("ui.wsendpointinspector.wsdl_port", "WSDL Port");
    private static String ENDPOINT_INTERFACE = localStrings.getLocalString("ui.wsendpointinspector.endpoint_interface", "Service Endpoint Interface:");
    private static String PORT_NAME = localStrings.getLocalString("ui.wsendpointinspector.wsdl_port.name", "Port Component Name:");
    private static String PORT_DISPLAY_NAME = localStrings.getLocalString("ui.wsendpointinspector.wsdl_port.display_name", "Port Component Display Name:");
    private static String ENDPOINT_HANDLERS = localStrings.getLocalString("ui.wsendpointinspector.endpoint_handlers", "Handlers...");
    private static String DEPLOYMENT_SETTINGS = localStrings.getLocalString("ui.wsendpointinspector.dep_settings.title", "Sun-specific Settings");
    private static String DS_ENDPOINT_URI = localStrings.getLocalString("ui.wsendpointinspector.dep_settings.endpoint_addr_uri", "Endpoint Address:");
    private static String DS_LOGIN_CONFIG = localStrings.getLocalString("ui.wsendpointinspector.dep_settings.login_config", "Login Config:");
    private static String DS_TRANSPORT_GUARANTEE = localStrings.getLocalString("ui.wsendpointinspector.dep_settings.transport_guarantee", "Transport Guarantee:");
    private static String DS_SERVICE_QNAME = localStrings.getLocalString("ui.wsendpointinspector.dep_settings.service_qname", "Service QName");
    private static String DS_TIE_CLASS = localStrings.getLocalString("ui.wsendpointinspector.dep_settings.tie_class", "Tie Class:");
    private static String TABNAME = localStrings.getLocalString("ui.wsendpointinspector.tabname", "Endpoint");
    private Descriptor descriptor = null;
    private BundleDescriptor bundleDescriptor = null;
    private WebServiceEndpoint webServiceEndpoint = null;
    private WebserviceEndpoint endpoint = null;
    private SunWebApp sunWebApp = null;
    private SunEjbJar sunEjbJar = null;
    private Servlet servlet = null;
    private Ejb ejb = null;
    private UITitledComboBox endptInterface = null;
    private UITitledQName wsdlPortQName = null;
    private UITitledTextField portName = null;
    private UITitledTextField portDisplayName = null;
    private UIButton endptHandlers = null;
    private DescriptionInspector.DialogDisplayButton descInspector = null;
    private IconInspector.DialogDisplayButton iconInspector = null;
    private UITitledTextField ejbEndpointAddressURI = null;
    private UITitledComboBox servletEndpointAddressURI = null;
    private UITitledComboBox loginConfig = null;
    private UITitledComboBox transportGuarantee = null;
    private ActionListener URIListener = new ActionListener(){

        public void actionPerformed(ActionEvent ae) {
            if (WSEndpointInspector.this.webServiceEndpoint == null) {
                return;
            }
            if ((WSEndpointInspector.this.getEndpointAddressURI() == null || WSEndpointInspector.this.getEndpointAddressURI().equals("")) && WSEndpointInspector.this.removeEndpointAddressUri()) {
                return;
            }
            WSEndpointInspector.this.setEndpoint();
            WSEndpointInspector.this.endpoint.setEndpointAddressUri(WSEndpointInspector.this.getEndpointAddressURI().trim());
            WSEndpointInspector.this.addEndpoint();
            if (WSEndpointInspector.this.isDeploymentMode()) {
                WSEndpointInspector.this.descriptor.changed();
            }
        }
    };

    public static InspectorPane newInspectorPane(String mode) {
        return new WSEndpointInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return "WebSrvEndpoint";
    }

    public Class getDescriptorClass() {
        InspectorPane.InspectorPaneOwner owner = this.getOwner();
        if (owner instanceof DescriptorInspector) {
            Class clz = ((DescriptorInspector)((Object)owner)).getDescriptorClass();
            if (clz.equals(EjbBundleDescriptor.class) || EjbDescriptor.class.isAssignableFrom(clz)) {
                return EjbDescriptor.class;
            }
            if (clz.equals(WebBundleDescriptor.class) || WebComponentDescriptor.class.isAssignableFrom(clz)) {
                return WebComponentDescriptor.class;
            }
            Print.dprintStackTrace((String)("Unsupported descriptor type: " + DT.className(clz)));
            return Descriptor.class;
        }
        Print.dprintStackTrace((String)("Owner doesn't implement DescriptorInspector: " + DT.className(owner)));
        return Descriptor.class;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor d) {
        if (this.descriptor != d) {
            if (d != null && this.getDescriptorClass().isAssignableFrom(d.getClass())) {
                this.descriptor = d;
                this.bundleDescriptor = DescriptorTools.getBundleDescriptor(d);
                if (this.isWizardMode()) {
                    this.webServiceEndpoint = new WebServiceEndpoint();
                } else {
                    WebServicesDescriptor wsd = this.bundleDescriptor.getWebServices();
                    Collection wse = null;
                    if (this.descriptor instanceof EjbDescriptor) {
                        wse = wsd.getEndpointsImplementedBy((EjbDescriptor)this.descriptor);
                        this.ejb = (Ejb)SunOneUtils.getSunDescriptor((Descriptor)((EjbDescriptor)this.descriptor));
                        if (this.ejb == null) {
                            this.ejb = this.searchEjb();
                        }
                    } else if (this.descriptor instanceof WebComponentDescriptor) {
                        wse = wsd.getEndpointsImplementedBy((WebComponentDescriptor)this.descriptor);
                        if (this.descriptor instanceof WebComponentDescriptor && ((WebComponentDescriptor)this.descriptor).isServlet()) {
                            if (this.isServletPresent()) {
                                this.servlet = (Servlet)SunOneUtils.getSunDescriptor(this.descriptor);
                            }
                            if (this.servlet == null) {
                                this.servlet = this.searchServlet();
                            }
                        }
                    } else {
                        Print.dprintStackTrace((String)("Unsupported Descriptor: " + DT.className(this.descriptor)));
                    }
                    if (wse != null && wse.size() > 0) {
                        this.webServiceEndpoint = (WebServiceEndpoint)wse.iterator().next();
                        this.endpoint = (WebserviceEndpoint)SunOneUtils.getSunDescriptor((Descriptor)this.webServiceEndpoint);
                        if (this.endpoint == null) {
                            if (this.descriptor instanceof WebComponentDescriptor && this.servlet != null) {
                                this.endpoint = this.searchWebserviceEndpoint(this.servlet);
                            } else if (this.descriptor instanceof EjbDescriptor && this.ejb != null) {
                                this.endpoint = this.searchWebserviceEndpoint(this.ejb);
                            }
                        }
                        Print.dprintln((String)("Found Endpoint: " + DescriptorTools.getDisplayName(this.webServiceEndpoint)));
                        if (wse.size() > 1) {
                            Print.dprintln((String)("( " + wse.size() + " Endpoints)"));
                        }
                    } else {
                        this.webServiceEndpoint = null;
                        Print.dprintln((String)"No Endpoints Found.");
                    }
                }
            } else {
                if (d != null) {
                    Print.dprintln((String)("INVALID Descriptor!!! " + DT.className(d)));
                }
                this.descriptor = null;
                this.bundleDescriptor = null;
                this.webServiceEndpoint = null;
            }
        }
    }

    public WebServiceEndpoint getWebServiceEndpoint() {
        return this.webServiceEndpoint;
    }

    private WSEndpointInspector(String mode) {
        super.setInspectorMode(mode);
        this.initializeLayout();
    }

    private void initializeLayout() {
        this.setLayout(new GridBagLayout());
        UITitledBox container = new UITitledBox(null, false);
        container.getGBConstraints().insets.bottom = 5;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 0.5;
        gbc.weighty = 0.5;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.fill = 2;
        gbc.anchor = 18;
        this.add((Component)container, gbc);
        this.endptInterface = new UITitledComboBox(ENDPOINT_INTERFACE, false);
        this.endptInterface.setShowSelectionAsToolTip(true);
        this.endptInterface.setShowWidePopups(true);
        this.endptInterface.setRequired(true);
        this.endptInterface.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                int p;
                String dftName;
                EjbDescriptor ejb;
                if (WSEndpointInspector.this.webServiceEndpoint == null) {
                    return;
                }
                String selClass = WSEndpointInspector.this.endptInterface.getText();
                if (selClass == null) {
                    return;
                }
                if (!selClass.equals(WSEndpointInspector.this.webServiceEndpoint.getServiceEndpointInterface())) {
                    WSEndpointInspector.this.webServiceEndpoint.setServiceEndpointInterface(selClass);
                }
                if (WSEndpointInspector.this.isDeploymentMode() && WSEndpointInspector.this.descriptor instanceof EjbDescriptor && !selClass.equals((ejb = (EjbDescriptor)WSEndpointInspector.this.descriptor).getWebServiceEndpointInterfaceName())) {
                    ejb.setWebServiceEndpointInterfaceName(selClass);
                }
                String string = dftName = (p = selClass.lastIndexOf(".")) >= 0 ? selClass.substring(p + 1) : selClass;
                if (!dftName.equals(WSEndpointInspector.this.portName.getText())) {
                    WSEndpointInspector.this.portName.setText(dftName);
                    WSEndpointInspector.this.portName.fireUpdate();
                }
                if (!dftName.equals(WSEndpointInspector.this.portDisplayName.getText())) {
                    WSEndpointInspector.this.portDisplayName.setText(dftName);
                    WSEndpointInspector.this.portDisplayName.fireUpdate();
                }
                if (WSEndpointInspector.this.isDeploymentMode()) {
                    WSEndpointInspector.this.descriptor.changed();
                }
            }
        });
        this.endptInterface.setReadOnly(this.isDeploymentMode());
        container.addWithGBConstraints(this.endptInterface);
        this.wsdlPortQName = new UITitledQName(WSDL_PORT);
        this.wsdlPortQName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WSEndpointInspector.this.setWSDLPort();
                if (WSEndpointInspector.this.isDeploymentMode()) {
                    WSEndpointInspector.this.descriptor.changed();
                }
            }
        });
        container.addWithGBConstraints(this.wsdlPortQName);
        this.portName = new UITitledTextField(PORT_NAME, false);
        this.portName.setRequired(true);
        this.portName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (WSEndpointInspector.this.webServiceEndpoint == null) {
                    return;
                }
                String n = WSEndpointInspector.this.portName.getText();
                if (n.equals("")) {
                    String selClass = WSEndpointInspector.this.endptInterface.getText();
                    int p = selClass.lastIndexOf(".");
                    n = p >= 0 ? selClass.substring(p + 1) : selClass;
                    WSEndpointInspector.this.portName.setText(n);
                }
                WSEndpointInspector.this.webServiceEndpoint.setEndpointName(n);
                if (WSEndpointInspector.this.endpoint != null) {
                    WSEndpointInspector.this.endpoint.setPortComponentName(WSEndpointInspector.this.getWebServiceEndpoint().getEndpointName());
                }
                if (WSEndpointInspector.this.isDeploymentMode()) {
                    WSEndpointInspector.this.descriptor.changed();
                }
            }
        });
        container.addWithGBConstraints(this.portName);
        this.portDisplayName = new UITitledTextField(PORT_DISPLAY_NAME, false);
        this.portDisplayName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (WSEndpointInspector.this.webServiceEndpoint == null) {
                    return;
                }
                String n = WSEndpointInspector.this.portDisplayName.getText();
                if (n.equals("")) {
                    String selClass = WSEndpointInspector.this.endptInterface.getText();
                    int p = selClass.lastIndexOf(".");
                    n = p >= 0 ? selClass.substring(p + 1) : selClass;
                    WSEndpointInspector.this.portDisplayName.setText(n);
                }
                WSEndpointInspector.this.webServiceEndpoint.setDisplayName(n);
                if (WSEndpointInspector.this.isDeploymentMode()) {
                    WSEndpointInspector.this.descriptor.changed();
                }
            }
        });
        container.addWithGBConstraints(this.portDisplayName);
        this.endptHandlers = new UIButton(ENDPOINT_HANDLERS, new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (WSEndpointInspector.this.webServiceEndpoint == null) {
                    return;
                }
                WSHandlers wsd = WSHandlers.newDialog(WSEndpointInspector.this);
                Vector clzNames = WSEndpointInspector.this.getArchiveClassNames();
                wsd.showDialog((Descriptor)WSEndpointInspector.this.webServiceEndpoint, clzNames);
            }
        });
        container.addWithGBConstraints(this.endptHandlers);
        this.descInspector = new DescriptionInspector.DialogDisplayButton();
        container.addWithGBConstraints(this.descInspector);
        this.iconInspector = new IconInspector.DialogDisplayButton(this);
        UITitledBox depSettings = new UITitledBox(DEPLOYMENT_SETTINGS, true);
        container.addWithGBConstraints(depSettings);
        depSettings.getGBConstraints().weighty = 0.0;
        depSettings.getGBConstraints().fill = 2;
        this.servletEndpointAddressURI = this.createServletEndpointAddressURI(DS_ENDPOINT_URI, false);
        this.ejbEndpointAddressURI = this.createEjbEndpointAddressURI(DS_ENDPOINT_URI, false);
        depSettings.addWithGBConstraints(this.servletEndpointAddressURI);
        depSettings.addWithGBConstraints(this.ejbEndpointAddressURI);
        this.loginConfig = new UITitledComboBox(DS_LOGIN_CONFIG, false);
        this.loginConfig.setShowSelectionAsToolTip(true);
        this.loginConfig.setShowWidePopups(true);
        this.loginConfig.setModel(new String[]{" ", "None", "Basic", "Certificate"});
        if (this.descriptor instanceof WebComponentDescriptor) {
            this.loginConfig.setVisible(false);
        } else if (this.descriptor instanceof EjbDescriptor) {
            this.loginConfig.setVisible(true);
        }
        this.loginConfig.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (WSEndpointInspector.this.webServiceEndpoint == null) {
                    return;
                }
                String selClass = WSEndpointInspector.this.loginConfig.getText();
                if (selClass == null) {
                    return;
                }
                if ((WSEndpointInspector.this.loginConfig.getText().trim().equals("") || WSEndpointInspector.this.loginConfig.getText() == null) && WSEndpointInspector.this.removeLoginConfig()) {
                    return;
                }
                WSEndpointInspector.this.setEndpoint();
                if (WSEndpointInspector.this.endpoint.getLoginConfig() == null) {
                    WSEndpointInspector.this.endpoint.setLoginConfig(new LoginConfig());
                }
                if (!selClass.equals(WSEndpointInspector.this.endpoint.getLoginConfig().getAuthMethod())) {
                    WSEndpointInspector.this.endpoint.getLoginConfig().setAuthMethod(selClass);
                }
                WSEndpointInspector.this.addEndpoint();
                if (WSEndpointInspector.this.isDeploymentMode()) {
                    WSEndpointInspector.this.descriptor.changed();
                }
            }
        });
        depSettings.addWithGBConstraints(this.loginConfig);
        this.transportGuarantee = new UITitledComboBox(DS_TRANSPORT_GUARANTEE, false);
        this.transportGuarantee.setShowSelectionAsToolTip(true);
        this.transportGuarantee.setShowWidePopups(true);
        this.transportGuarantee.setModel(new String[]{" ", "None", "Integral", "Confidential"});
        if (this.descriptor instanceof WebComponentDescriptor) {
            this.transportGuarantee.setVisible(false);
        } else if (this.descriptor instanceof EjbDescriptor) {
            this.transportGuarantee.setVisible(true);
        }
        this.transportGuarantee.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (WSEndpointInspector.this.webServiceEndpoint == null) {
                    return;
                }
                String selClass = WSEndpointInspector.this.transportGuarantee.getText();
                if (selClass == null) {
                    return;
                }
                if ((WSEndpointInspector.this.transportGuarantee.getText().trim().equals("") || WSEndpointInspector.this.transportGuarantee.getText() == null) && WSEndpointInspector.this.removeTransportGuarantee()) {
                    return;
                }
                WSEndpointInspector.this.setEndpoint();
                if (!selClass.equals(WSEndpointInspector.this.endpoint.getTransportGuarantee())) {
                    WSEndpointInspector.this.endpoint.setTransportGuarantee(selClass);
                }
                WSEndpointInspector.this.addEndpoint();
                if (WSEndpointInspector.this.isDeploymentMode()) {
                    WSEndpointInspector.this.descriptor.changed();
                }
            }
        });
        depSettings.addWithGBConstraints(this.transportGuarantee);
    }

    public void setReadOnly(boolean state) {
        super.setReadOnly(state);
        this.endptInterface.setReadOnly(this.isDeploymentMode());
        this.wsdlPortQName.setReadOnly(state);
        this.portName.setReadOnly(state);
        this.portDisplayName.setReadOnly(state);
        this.endptHandlers.setReadOnly(state);
        this.descInspector.setReadOnly(state);
    }

    public void refresh() {
        if (this.descriptor instanceof WebComponentDescriptor) {
            this.servletEndpointAddressURI.setVisible(true);
            this.servletEndpointAddressURI.setModel(this.getServletEndpointAddressSet());
            this.servletEndpointAddressURI.setEditable(true);
            this.ejbEndpointAddressURI.setVisible(false);
            this.loginConfig.setVisible(false);
            this.transportGuarantee.setVisible(false);
        } else if (this.descriptor instanceof EjbDescriptor || this.bundleDescriptor instanceof EjbBundleDescriptor) {
            this.servletEndpointAddressURI.setVisible(false);
            this.ejbEndpointAddressURI.setVisible(true);
            this.loginConfig.setVisible(true);
            this.transportGuarantee.setVisible(true);
        }
        if (this.webServiceEndpoint == null) {
            this.endptInterface.setText(null);
            this.endptInterface.setEnabled(false);
            this.wsdlPortQName.setEnabled(false);
            this.portName.setText(null);
            this.portName.setEnabled(false);
            this.portDisplayName.setText(null);
            this.portDisplayName.setEnabled(false);
            this.descInspector.setDescriptionInspector(null);
            this.descInspector.setEnabled(false);
            return;
        }
        this.endptInterface.setEnabled(true);
        this.wsdlPortQName.setEnabled(true);
        this.portName.setEnabled(true);
        this.portDisplayName.setEnabled(true);
        this.descInspector.setEnabled(true);
        String srvEndPtIntf = this.webServiceEndpoint.getServiceEndpointInterface();
        if (this.isWizardMode()) {
            this.endptInterface.setModel(this.getArchiveInterfaceNames());
        } else {
            this.endptInterface.setModel(new String[]{srvEndPtIntf});
        }
        this.endptInterface.setSelectedItem(srvEndPtIntf);
        String wsdlFile = this.getWsdlFile();
        this.wsdlPortQName.setQNameModel(this.descriptor, wsdlFile, 2, false);
        this.wsdlPortQName.setQName(this.getWSDLPort());
        this.portName.setText(this.webServiceEndpoint.getEndpointName());
        this.portDisplayName.setText(this.webServiceEndpoint.getDisplayName());
        this.descInspector.setDescriptionInspector((Descriptor)this.webServiceEndpoint);
        if ((this.descriptor instanceof EjbDescriptor || this.bundleDescriptor instanceof EjbBundleDescriptor) && this.ejbEndpointAddressURI.isBlank()) {
            this.ejbEndpointAddressURI.setText(this.descriptor.getName());
        }
        if (this.getEndpointAddressURI() != null && this.getEndpointAddressURI().length() > 0 && this.endpoint == null) {
            this.setEndpoint();
            this.endpoint.setEndpointAddressUri(this.getEndpointAddressURI().trim());
            this.addEndpoint();
        }
        if (this.endpoint != null) {
            this.setEndpointAddressURI(this.endpoint.getEndpointAddressUri());
            if (this.descriptor instanceof EjbDescriptor) {
                if (this.endpoint.getLoginConfig() != null) {
                    this.loginConfig.setSelectedItem(this.endpoint.getLoginConfig().getAuthMethod());
                }
                this.transportGuarantee.setSelectedItem(this.endpoint.getTransportGuarantee());
            }
        }
    }

    private void refreshDeploymentSettings() {
        SunWebApp swa;
        if (!this.isServletPresent() && this.descriptor instanceof WebComponentDescriptor) {
            swa = (SunWebApp)SunOneUtils.getSunDescriptor((Descriptor)DescriptorTools.getBundleDescriptor(this.getDescriptor()));
            boolean isServletAlreadyCreated = false;
            if (swa != null) {
                for (int i = 0; i < swa.sizeServlet(); ++i) {
                    if (!swa.getServlet(i).getServletName().equals(((WebComponentDescriptor)this.descriptor).getCanonicalName())) continue;
                    this.servlet = swa.getServlet(i);
                    isServletAlreadyCreated = true;
                    break;
                }
            }
            if (!isServletAlreadyCreated) {
                this.servlet = null;
            }
        }
        if (this.isServletPresent() && this.descriptor instanceof WebComponentDescriptor && this.getEndpointAddressURI() != null && (swa = (SunWebApp)SunOneUtils.getSunDescriptor((Descriptor)DescriptorTools.getBundleDescriptor(this.getDescriptor()))) != null) {
            for (int i = 0; i < swa.sizeServlet(); ++i) {
                if (!swa.getServlet(i).getServletName().equals(((WebComponentDescriptor)this.descriptor).getCanonicalName()) || swa.getServlet(i).sizeWebserviceEndpoint() != 0) continue;
                if (this.endpoint != null) {
                    this.endpoint.setEndpointAddressUri(null);
                }
                this.endpoint = null;
            }
        }
        if ((this.descriptor instanceof WebComponentDescriptor || this.descriptor instanceof WebBundleDescriptor) && this.servlet == null || (this.descriptor instanceof EjbDescriptor || this.descriptor instanceof EjbBundleDescriptor) && this.ejb == null) {
            this.endpoint = null;
        }
        if (this.endpoint == null) {
            this.setEndpointAddressURI(null);
        } else {
            this.setEndpointAddressURI(this.endpoint.getEndpointAddressUri());
            if (this.descriptor instanceof EjbDescriptor) {
                if (this.endpoint.getLoginConfig() != null) {
                    this.loginConfig.setSelectedItem(this.endpoint.getLoginConfig().getAuthMethod());
                }
                this.transportGuarantee.setSelectedItem(this.endpoint.getTransportGuarantee());
            }
        }
    }

    private QName getWSDLPort() {
        QName port = null;
        try {
            port = this.webServiceEndpoint.getWsdlPort();
        }
        catch (Throwable npe) {
            Print.dprintStackTrace((String)"Can't get WSDL port", (Throwable)npe);
        }
        return port;
    }

    private void setWSDLPort() {
        if (this.webServiceEndpoint == null) {
            return;
        }
        this.webServiceEndpoint.setWsdlPort(this.wsdlPortQName.getQName());
    }

    private WebService getWebService() {
        if (this.isWizardMode()) {
            InspectorPane.InspectorPaneOwner inspOwner = this.getOwner();
            if (inspOwner instanceof NewWebComponentWizard) {
                return ((NewWebComponentWizard)inspOwner).getWebService();
            }
            if (inspOwner instanceof NewEjbWizard) {
                return ((NewEjbWizard)inspOwner).getWebService();
            }
            return null;
        }
        return this.webServiceEndpoint.getWebService();
    }

    private String getWsdlFile() {
        String wsdlFileEntry;
        File wsdlFile = null;
        WebService websrv = this.getWebService();
        String string = wsdlFileEntry = websrv != null ? websrv.getWsdlFileUri() : null;
        if (wsdlFileEntry != null && !wsdlFileEntry.equals("")) {
            Print.dprintln((String)("WSDL File Entry: " + wsdlFileEntry));
            if (this.isWizardMode()) {
                ModuleContent content = null;
                InspectorPane.InspectorPaneOwner inspOwner = this.getOwner();
                if (inspOwner instanceof NewWebComponentWizard) {
                    content = ((NewWebComponentWizard)inspOwner).getMergedModuleContent();
                } else if (inspOwner instanceof NewEjbWizard) {
                    content = ((NewEjbWizard)inspOwner).getMergedModuleContent();
                }
                if (content != null && (wsdlFile = content.getFileFor(wsdlFileEntry)) != null) {
                    Print.dprintln((String)("Found WSDL file: " + wsdlFile));
                    return wsdlFile.getPath();
                }
                Print.dprintln((String)("Didn't find WSDL file entry: " + wsdlFileEntry));
                return null;
            }
            UIProject proj = UIProject.getProject((Descriptor)this.bundleDescriptor);
            wsdlFile = proj.getArchiveEntryFile(null, wsdlFileEntry);
            if (wsdlFile != null) {
                Print.dprintln((String)("Found WSDL file: " + wsdlFile));
                return wsdlFile.getPath();
            }
            Print.dprintln((String)("Didn't find WSDL file entry: " + wsdlFileEntry));
            return null;
        }
        return null;
    }

    public boolean validateEntries(boolean showErrors) {
        if (!this.endptInterface.checkRequired(showErrors)) {
            return false;
        }
        if (!this.wsdlPortQName.checkRequired(showErrors)) {
            return false;
        }
        return this.portName.checkRequired(showErrors);
    }

    public void addLargeIcon(File iconFile) {
        if (this.isDeploymentMode()) {
            this._addDeploymentIcon("large", iconFile, (Descriptor)this.webServiceEndpoint, (Descriptor)this.webServiceEndpoint);
        } else {
            NewWebComponentWizard nwcw = (NewWebComponentWizard)this.getOwner();
            ModuleContent contents = nwcw.getArchiveModuleContent();
            this._addWizardIcon("large", iconFile, contents, (Descriptor)this.webServiceEndpoint);
        }
    }

    public void addSmallIcon(File iconFile) {
        if (this.isDeploymentMode()) {
            this._addDeploymentIcon("small", iconFile, (Descriptor)this.webServiceEndpoint, (Descriptor)this.webServiceEndpoint);
        } else if (this.getOwner() instanceof NewWebComponentWizard) {
            NewWebComponentWizard nwcw = (NewWebComponentWizard)this.getOwner();
            ModuleContent contents = nwcw.getArchiveModuleContent();
            this._addWizardIcon("small", iconFile, contents, (Descriptor)this.webServiceEndpoint);
        }
    }

    private void setEndpoint() {
        if (this.endpoint == null) {
            this.endpoint = SunOneUtils.createSunWebserviceEndpoint(this.getWebServiceEndpoint());
        } else if (this.isWizardMode()) {
            if (this.endpoint != (WebserviceEndpoint)SunOneUtils.getSunDescriptor((Descriptor)this.getWebServiceEndpoint())) {
                this.endpoint = SunOneUtils.createSunWebserviceEndpoint(this.getWebServiceEndpoint());
            }
        } else {
            this.endpoint.setPortComponentName(this.getWebServiceEndpoint().getEndpointName());
        }
    }

    private void addEndpoint() {
        if (this.isDeploymentMode()) {
            if (this.descriptor instanceof WebComponentDescriptor) {
                if (this.servlet == null) {
                    this.servlet = this.searchServlet();
                    if (this.servlet == null) {
                        this.servlet = SunOneUtils.createSunServlet((WebComponentDescriptor)this.descriptor);
                    }
                    this.servlet.addWebserviceEndpoint(this.endpoint);
                    ((SunWebApp)SunOneUtils.getSunDescriptor((Descriptor)DescriptorTools.getBundleDescriptor(this.getDescriptor()))).addServlet(this.servlet);
                } else {
                    if (!this.isEndpointPresent()) {
                        this.servlet.addWebserviceEndpoint(this.endpoint);
                    }
                    if (!this.isServletPresent()) {
                        ((SunWebApp)SunOneUtils.getSunDescriptor((Descriptor)DescriptorTools.getBundleDescriptor(this.getDescriptor()))).addServlet(this.servlet);
                    }
                }
            } else if (this.descriptor instanceof EjbDescriptor && !this.isEndpointPresent()) {
                this.ejb.addWebserviceEndpoint(this.endpoint);
            }
        }
    }

    private boolean removeEndpointAddressUri() {
        if (this.descriptor instanceof WebComponentDescriptor) {
            if (this.endpoint != null && this.servlet != null) {
                this.endpoint.setPortComponentName(null);
                this.endpoint.setEndpointAddressUri(null);
                this.servlet.removeWebserviceEndpoint(this.endpoint);
                if (this.servlet.sizeWebserviceEndpoint() == 0 && this.servlet.getPrincipalName() == null) {
                    ((SunWebApp)SunOneUtils.getSunDescriptor((Descriptor)DescriptorTools.getBundleDescriptor(this.getDescriptor()))).removeServlet(this.servlet);
                }
                return true;
            }
            return this.endpoint == null && this.servlet == null;
        }
        if (this.descriptor instanceof EjbDescriptor) {
            if (this.endpoint != null && this.ejb != null) {
                this.endpoint.setEndpointAddressUri(null);
                if ((this.endpoint.getLoginConfig() == null || this.endpoint.getLoginConfig().getAuthMethod() == null) && this.endpoint.getTransportGuarantee() == null) {
                    this.endpoint.setPortComponentName(null);
                    this.ejb.removeWebserviceEndpoint(this.endpoint);
                }
                return true;
            }
            return this.endpoint == null;
        }
        return false;
    }

    private boolean removeLoginConfig() {
        if (this.endpoint != null && this.ejb != null) {
            this.endpoint.setLoginConfig(null);
            if (this.endpoint.getEndpointAddressUri() == null && this.endpoint.getTransportGuarantee() == null) {
                this.endpoint.setPortComponentName(null);
                this.ejb.removeWebserviceEndpoint(this.endpoint);
            }
            return true;
        }
        return this.endpoint == null;
    }

    private boolean removeTransportGuarantee() {
        if (this.endpoint != null && this.ejb != null) {
            this.endpoint.setTransportGuarantee(null);
            if (this.endpoint.getEndpointAddressUri() == null && this.endpoint.getLoginConfig() == null) {
                this.endpoint.setPortComponentName(null);
                this.ejb.removeWebserviceEndpoint(this.endpoint);
            }
            return true;
        }
        return this.endpoint == null;
    }

    private Ejb searchEjb() {
        SunEjbJar sej = (SunEjbJar)SunOneUtils.getSunDescriptor((Descriptor)DescriptorTools.getBundleDescriptor(this.getDescriptor()));
        for (int i = 0; i < sej.getEnterpriseBeans().sizeEjb(); ++i) {
            if (!sej.getEnterpriseBeans().getEjb(i).getEjbName().equals(((EjbDescriptor)this.descriptor).getDisplayName())) continue;
            return sej.getEnterpriseBeans().getEjb(i);
        }
        return null;
    }

    private Servlet searchServlet() {
        SunWebApp swa = (SunWebApp)SunOneUtils.getSunDescriptor((Descriptor)DescriptorTools.getBundleDescriptor(this.getDescriptor()));
        for (int i = 0; i < swa.sizeServlet(); ++i) {
            if (!swa.getServlet(i).getServletName().equals(((WebComponentDescriptor)this.descriptor).getCanonicalName())) continue;
            return swa.getServlet(i);
        }
        return null;
    }

    private WebserviceEndpoint searchWebserviceEndpoint(Servlet servlet) {
        for (int i = 0; i < servlet.sizeWebserviceEndpoint(); ++i) {
            if (!servlet.getWebserviceEndpoint(i).getPortComponentName().equals(this.getWebServiceEndpoint().getEndpointName())) continue;
            return servlet.getWebserviceEndpoint(i);
        }
        return null;
    }

    private WebserviceEndpoint searchWebserviceEndpoint(Ejb ejb) {
        for (int i = 0; i < ejb.sizeWebserviceEndpoint(); ++i) {
            if (!ejb.getWebserviceEndpoint(i).getPortComponentName().equals(this.getWebServiceEndpoint().getEndpointName())) continue;
            return ejb.getWebserviceEndpoint(i);
        }
        return null;
    }

    private boolean isServletPresent() {
        if (this.servlet != null) {
            SunWebApp swa = (SunWebApp)SunOneUtils.getSunDescriptor((Descriptor)DescriptorTools.getBundleDescriptor(this.getDescriptor()));
            for (int i = 0; i < swa.sizeServlet(); ++i) {
                if (!swa.getServlet(i).getServletName().equals(this.servlet.getServletName())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isEndpointPresent() {
        WebserviceEndpoint[] endpoints = null;
        if (this.descriptor instanceof WebComponentDescriptor) {
            endpoints = this.servlet.getWebserviceEndpoint();
        } else if (this.descriptor instanceof EjbDescriptor) {
            endpoints = this.ejb.getWebserviceEndpoint();
        }
        if (endpoints != null) {
            for (int i = 0; i < endpoints.length; ++i) {
                if (!endpoints[i].getPortComponentName().equals(this.endpoint.getPortComponentName())) continue;
                return true;
            }
        }
        return false;
    }

    private String getEndpointAddressURI() {
        String uri = null;
        if (this.descriptor instanceof WebComponentDescriptor) {
            uri = this.servletEndpointAddressURI.getText();
        } else if (this.descriptor instanceof EjbDescriptor || this.bundleDescriptor instanceof EjbBundleDescriptor) {
            uri = this.ejbEndpointAddressURI.getText();
        }
        return uri;
    }

    private void setEndpointAddressURI(String uri) {
        if (this.descriptor instanceof WebComponentDescriptor) {
            this.servletEndpointAddressURI.setText(uri);
        } else if (this.descriptor instanceof EjbDescriptor || this.bundleDescriptor instanceof EjbBundleDescriptor) {
            this.ejbEndpointAddressURI.setText(uri);
        }
    }

    private UITitledTextField createEjbEndpointAddressURI(String title, boolean showBorder) {
        UITitledTextField textField = new UITitledTextField(title, showBorder);
        textField.addActionListener(this.URIListener);
        return textField;
    }

    private UITitledComboBox createServletEndpointAddressURI(String title, boolean showBorder) {
        UITitledComboBox comboBox = new UITitledComboBox(title, showBorder);
        comboBox.setShowWidePopups(true);
        comboBox.addActionListener(this.URIListener);
        return comboBox;
    }

    private String cleanUrlPattern(String urlPattern) {
        if (urlPattern != null) {
            if (urlPattern.startsWith("/")) {
                urlPattern = urlPattern.substring(1);
            }
            if (urlPattern.endsWith("/")) {
                urlPattern = urlPattern.substring(0, urlPattern.length() - 1);
            }
            if (urlPattern.indexOf("*") >= 0 || urlPattern.indexOf("/") >= 0 || urlPattern.trim().length() == 0) {
                urlPattern = null;
            }
        }
        return urlPattern;
    }

    private Set getUrlPatterns() {
        return this.descriptor == null ? Collections.EMPTY_SET : ((WebComponentDescriptor)this.descriptor).getUrlPatternsSet();
    }

    private String getServletName() {
        return this.descriptor == null ? "" : ((WebComponentDescriptor)this.descriptor).getCanonicalName();
    }

    Set getServletEndpointAddressSet() {
        LinkedHashSet<String> linkedSet = new LinkedHashSet<String>();
        Set set = this.getUrlPatterns();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            String s = this.cleanUrlPattern((String)iter.next());
            if (s == null) continue;
            linkedSet.add(s);
        }
        linkedSet.add(this.getServletName());
        return linkedSet;
    }
}

