/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.war;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.ServletFilterDescriptor;
import com.sun.enterprise.deployment.ServletFilterMappingDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.web.ServletFilterMapping;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorTools;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UICheckBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIRadioButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.tools.deployment.ui.utils.WinTools;
import com.sun.enterprise.tools.deployment.ui.war.WebServletFiltersInspector;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class WebServletFilterMapInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(WebServletFilterMapInspector.class);
    private static final String MAP_TABLE_TITLE = localStrings.getLocalString("ui.webservletfiltermapinspector.map_table_title", "Servlet Filter Mapping");
    private static final String MOVE_UP = localStrings.getLocalString("ui.webservletfiltermapinspector.move_up", "Move Up");
    private static final String MOVE_DOWN = localStrings.getLocalString("ui.webservletfiltermapinspector.move_down", "Move Down");
    private static final String EDIT_FILTER = localStrings.getLocalString("ui.webservletfiltermapinspector.edit_filter", "Edit Filter List...");
    private static final String URL_PATTERN = localStrings.getLocalString("ui.webservletfiltermapinspector.type_url_pattern", "URL Pattern");
    private static final String SERVLET = localStrings.getLocalString("ui.webservletfiltermapinspector.type_servlet", "Servlet");
    private static final String TABLE_FILTER_NAME = localStrings.getLocalString("ui.webservletfiltermapinspector.table.filter_name", "Filter Name");
    private static final String TABLE_TARGET = localStrings.getLocalString("ui.webservletfiltermapinspector.table.target", "Target");
    private static final String TABLE_DISPATCHER = localStrings.getLocalString("ui.webservletfiltermapinspector.table.dispatcher", "Dispatcher");
    private static final String TABNAME = localStrings.getLocalString("ui.webservletfiltermapinspector.tabname", "Filter Mapping");
    private static final char MOVE_UP_MNEMONIC = localStrings.getLocalString("ui.webservletfiltermapinspector.move_up_mnemonic", "u").charAt(0);
    private static final char MOVE_DOWN_MNEMONIC = localStrings.getLocalString("ui.webservletfiltermapinspector.move_down_mnemonic", "m").charAt(0);
    private static final char EDIT_FILTER_MNEMONIC = localStrings.getLocalString("ui.webservletfiltermapinspector.edit_filter_mnemonic", "F").charAt(0);
    private static final String _INCLUDE = ServletFilterMappingDescriptor.INCLUDE;
    private static final String _REQUEST = ServletFilterMappingDescriptor.REQUEST;
    private static final String _FORWARD = ServletFilterMappingDescriptor.FORWARD;
    private static final String _ERROR = "ERROR";
    private static String wizardHelpID = "ServletFilterMaps";
    private static String deployHelpID = "ServletFilterMaps";
    private WebBundleDescriptor descriptor = null;
    private UITitledTable mapPanel = null;
    private InspectorPane.InspectorPaneDialog servletFilterDialog = null;
    private AddEditFilterMappingDialog addEditDialog = null;
    private static final String DIALOG_TITLE_ADD = localStrings.getLocalString("ui.webservletfiltermapinspector.adddialog.add_title", "Add Servlet Filter Mapping");
    private static final String DIALOG_TITLE_EDIT = localStrings.getLocalString("ui.webservletfiltermapinspector.adddialog.edit_title", "Edit Servlet Filter Mapping");
    private static final String DIALOG_FILTER_NAME = localStrings.getLocalString("ui.webservletfiltermapinspector.add_dialog.filter_name", "Filter Name:");
    private static final String DIALOG_FILTER_TARGET = localStrings.getLocalString("ui.webservletfiltermapinspector.add_dialog.filter_target", "Filter Target");
    private static final String DIALOG_FILTER_TARGET_RB_URL = localStrings.getLocalString("ui.webservletfiltermapinspector.add_dialog.filter_target.url_title", "Filter Servlets that Match this URL Pattern");
    private static final String DIALOG_FILTER_TARGET_URL_PATTERN = localStrings.getLocalString("ui.webservletfiltermapinspector.add_dialog.filter_target.url_field", "URL Pattern:");
    private static final String DIALOG_FILTER_TARGET_RB_SERVLET = localStrings.getLocalString("ui.webservletfiltermapinspector.add_dialog.filter_target.servlet_title", "Filter this Servlet");
    private static final String DIALOG_FILTER_TARGET_SERVLET_NAME = localStrings.getLocalString("ui.webservletfiltermapinspector.add_dialog.filter_target.servlet_field", "Servlet Name:");
    private static final String DIALOG_DISPATCHER = localStrings.getLocalString("ui.webservletfiltermapinspector.add_dialog.dispatcher.title", "Dispatcher Options");
    private static final String DIALOG_DISPATCHER_FORWARD = localStrings.getLocalString("ui.webservletfiltermapinspector.add_dialog.dispatcher.forward", "Forward [Apply to RequestDispatcher.forward() calls]");
    private static final String DIALOG_DISPATCHER_INCLUDE = localStrings.getLocalString("ui.webservletfiltermapinspector.add_dialog.dispatcher.include", "Include [Apply to RequestDispatcher.include() calls]");
    private static final String DIALOG_DISPATCHER_REQUEST = localStrings.getLocalString("ui.webservletfiltermapinspector.add_dialog.dispatcher.request", "Request [Apply to ordinary client calls]");
    private static final String DIALOG_DISPATCHER_ERROR = localStrings.getLocalString("ui.webservletfiltermapinspector.add_dialog.dispatcher.error", "Error [Apply under the error page mechanism]");

    private static final String SERVLET_FILTERS_FOR(String v0) {
        return localStrings.getLocalString("ui.webservletfiltermapinspector.servlet_filters_for", "Servlet Filters for {0}", new Object[]{v0});
    }

    public static InspectorPane newInspectorPane(String mode) {
        return new WebServletFilterMapInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return WebBundleDescriptor.class;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor desc) {
        if (this.descriptor != desc) {
            this.descriptor = desc instanceof WebBundleDescriptor ? (WebBundleDescriptor)desc : (desc instanceof WebComponentDescriptor ? ((WebComponentDescriptor)desc).getWebBundleDescriptor() : null);
            this.mapPanel.clear();
            if (this.descriptor != null && this.servletFilterDialog != null) {
                this.servletFilterDialog.setDescriptor((Descriptor)this.descriptor);
            }
        }
    }

    private WebServletFilterMapInspector(String mode) {
        this.setInspectorMode(mode);
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.mapPanel = new UITitledTable(MAP_TABLE_TITLE, true);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)this.mapPanel, c);
        this.mapPanel.setTableView(new ServletFilterMapTable(new ServletFilterMapTableModel()));
        this.mapPanel.addControlButton(UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WebServletFilterMapInspector.this.addEditAction(null);
            }
        }, true));
        this.mapPanel.addSelectionEnabledButton(UIButton.createEditButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WebServletFilterMapInspector.this.addEditAction(WebServletFilterMapInspector.this.getSelectedServletFilterMappingDescriptor());
            }
        }, true));
        this.mapPanel.addSelectionEnabledButton(UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WebServletFilterMapInspector.this.deleteAction();
            }
        }, true));
        this.mapPanel.addControlSpacer();
        this.mapPanel.addSelectionEnabledButton(new UIButton(MOVE_UP, MOVE_UP_MNEMONIC, null, new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WebServletFilterMapInspector.this.moveUpAction();
            }
        }));
        this.mapPanel.addSelectionEnabledButton(new UIButton(MOVE_DOWN, MOVE_DOWN_MNEMONIC, null, new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WebServletFilterMapInspector.this.moveDownAction();
            }
        }));
        if (this.isDeploymentMode()) {
            this.mapPanel.addControlSpacer();
            this.mapPanel.addControlButton(new UIButton(EDIT_FILTER, EDIT_FILTER_MNEMONIC, null, new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    WebServletFilterMapInspector.this.editFilterAction();
                }
            }));
        }
    }

    public void refresh() {
        this.mapPanel.updateTableData(this.descriptor.getServletFilterMappingDescriptors());
    }

    public void setReadOnly(boolean state) {
        super.setReadOnly(state);
        this.mapPanel.setReadOnly(state);
    }

    private WebBundleDescriptor getWebBundleDescriptor() {
        Descriptor d = this.getBundleDescriptor();
        if (d == null) {
            return null;
        }
        if (d instanceof WebBundleDescriptor) {
            return (WebBundleDescriptor)d;
        }
        Print.printStackTrace((String)("Unrecognized descriptor: " + DT.className(d)));
        return null;
    }

    private Vector getFilterNames() {
        Vector<String> v = new Vector<String>();
        Vector sf = this.descriptor.getServletFilterDescriptors();
        Enumeration e = sf.elements();
        while (e.hasMoreElements()) {
            Descriptor d = (Descriptor)e.nextElement();
            v.add(((ServletFilterDescriptor)d).getDisplayName());
        }
        return v;
    }

    private ServletFilterDescriptor getFilterByName(String name) {
        Vector sf = this.descriptor.getServletFilterDescriptors();
        Enumeration e = sf.elements();
        while (e.hasMoreElements()) {
            ServletFilterDescriptor sfd = (ServletFilterDescriptor)e.nextElement();
            if (!sfd.getDisplayName().equals(name)) continue;
            return sfd;
        }
        return null;
    }

    private List getServlets() {
        Vector<String> v = new Vector<String>();
        WebBundleDescriptor wbd = this.getWebBundleDescriptor();
        if (wbd != null) {
            Iterator i = wbd.getWebComponentDescriptorsSet().iterator();
            while (i.hasNext()) {
                WebComponentDescriptor d = (WebComponentDescriptor)i.next();
                if (!d.isServlet()) continue;
                v.add(DescriptorTools.getDisplayName(d));
            }
        } else {
            Print.dprintln((String)"No WebBundleDescriptor?");
        }
        return v;
    }

    private ServletFilterMappingDescriptor getSelectedServletFilterMappingDescriptor() {
        return (ServletFilterMappingDescriptor)this.mapPanel.getSelectedRowObject();
    }

    private void addEditAction(ServletFilterMappingDescriptor sel) {
        if (this.addEditDialog == null) {
            Window win = WinTools.getAncestorWindow(this);
            if (win instanceof Dialog) {
                this.addEditDialog = new AddEditFilterMappingDialog((Dialog)win);
            } else if (win instanceof Frame) {
                this.addEditDialog = new AddEditFilterMappingDialog((Frame)win);
            }
        }
        this.addEditDialog.showDialog(sel);
        this.invokeRefresh();
    }

    private void deleteAction() {
        Object[] list = this.mapPanel.confirmDeleteSelection(null, null);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                ServletFilterMappingDescriptor ref = (ServletFilterMappingDescriptor)list[i];
                this.descriptor.removeServletFilterMapping((ServletFilterMapping)ref);
            }
        }
        this.invokeRefresh();
    }

    private void moveUpAction() {
        ServletFilterMappingDescriptor ref = this.getSelectedServletFilterMappingDescriptor();
        if (ref != null) {
            this.descriptor.moveServletFilterMapping((ServletFilterMapping)ref, -1);
        }
        this.invokeRefresh();
    }

    private void moveDownAction() {
        ServletFilterMappingDescriptor ref = this.getSelectedServletFilterMappingDescriptor();
        if (ref != null) {
            this.descriptor.moveServletFilterMapping((ServletFilterMapping)ref, 1);
        }
        this.invokeRefresh();
    }

    private void editFilterAction() {
        if (this.servletFilterDialog == null) {
            InspectorPane ip = WebServletFiltersInspector.newInspectorPane(this.getInspectorMode());
            this.servletFilterDialog = ip.createInspectorPaneDialog(this.getOwner(), this, true);
        }
        this.servletFilterDialog.setDescriptor((Descriptor)this.descriptor);
        this.servletFilterDialog.setLocationRelativeTo(this);
        this.servletFilterDialog.setTitle(WebServletFilterMapInspector.SERVLET_FILTERS_FOR(this.descriptor.getDisplayName()));
        this.servletFilterDialog.show();
        this.invokeRefresh();
        this.servletFilterDialog.dispose();
        this.servletFilterDialog = null;
    }

    private class AddEditFilterMappingDialog
    extends UIDialog {
        private boolean okSelected;
        private ServletFilterMappingDescriptor sfmOriginal;
        private ServletFilterMappingDescriptor sfmCopy;
        private UITitledComboBox filterName;
        private UIRadioButtonBox filterTarget;
        private UITitledTextField filterTargetURL;
        private UITitledComboBox filterTargetServlet;
        private UICheckBox dispatchForward;
        private UICheckBox dispatchInclude;
        private UICheckBox dispatchRequest;
        private UICheckBox dispatchError;

        public AddEditFilterMappingDialog(Dialog d) {
            super(d, true);
            this.okSelected = false;
            this.sfmOriginal = null;
            this.sfmCopy = null;
            this.filterName = null;
            this.filterTarget = null;
            this.filterTargetURL = null;
            this.filterTargetServlet = null;
            this.dispatchForward = null;
            this.dispatchInclude = null;
            this.dispatchRequest = null;
            this.dispatchError = null;
            this.initDialogLayout();
        }

        public AddEditFilterMappingDialog(Frame f) {
            super(f, true);
            this.okSelected = false;
            this.sfmOriginal = null;
            this.sfmCopy = null;
            this.filterName = null;
            this.filterTarget = null;
            this.filterTargetURL = null;
            this.filterTargetServlet = null;
            this.dispatchForward = null;
            this.dispatchInclude = null;
            this.dispatchRequest = null;
            this.dispatchError = null;
            this.initDialogLayout();
        }

        public void showDialog(ServletFilterMappingDescriptor d) {
            this.sfmOriginal = d;
            this.sfmCopy = this.sfmOriginal != null ? new ServletFilterMappingDescriptor(this.sfmOriginal) : new ServletFilterMappingDescriptor();
            this.setTitle(this.sfmOriginal != null ? DIALOG_TITLE_EDIT : DIALOG_TITLE_ADD);
            this.refreshDialog();
            this.setSize(400, 450);
            this.setLocationRelativeToOwner();
            this.show();
            if (this.okSelected) {
                if (this.sfmOriginal != null) {
                    this.sfmOriginal.setDisplayName(this.sfmCopy.getDisplayName());
                    this.sfmOriginal.setTargetType(this.sfmCopy.getTargetType());
                    this.sfmOriginal.setTarget(this.sfmCopy.getTarget());
                    this.sfmOriginal.getDispatchers().clear();
                    this.sfmOriginal.getDispatchers().addAll(this.sfmCopy.getDispatchers());
                    this.sfmOriginal.setDescription(this.sfmCopy.getDescription());
                } else {
                    WebServletFilterMapInspector.this.descriptor.addServletFilterMapping(this.sfmCopy);
                }
            }
            this.sfmOriginal = null;
            this.sfmCopy = null;
        }

        private void okAction() {
            if (this.sfmCopy.getDisplayName().equals("")) {
                UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.webservletfiltermapinspector.please_enter_display_name", "Please Provide a Filter Name"));
                return;
            }
            this.okSelected = true;
            this.hide();
        }

        protected void cancelAction() {
            this.okSelected = false;
            this.hide();
        }

        private void initDialogLayout() {
            UIControlButtonBox container = new UIControlButtonBox(null, false);
            container.setControlButtonLocation(101);
            this.getContentBox().addWithGBConstraints(container);
            container.setView(this.initDialogViewLayout());
            container.addControlButton(UIButton.createOkButton(new ActionListener(this){
                private final /* synthetic */ AddEditFilterMappingDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    AddEditFilterMappingDialog.access$1600(this.this$1);
                }
            }));
            container.addControlButton(UIButton.createCancelButton(new ActionListener(this){
                private final /* synthetic */ AddEditFilterMappingDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    this.this$1.cancelAction();
                }
            }));
            container.addControlButton(new UIHelpButton("SFMapping"));
        }

        private UITitledBox initDialogViewLayout() {
            UITitledBox box = new UITitledBox(null, false);
            box.getGBConstraints().insets.bottom = 7;
            box.getGBConstraints().weighty = 0.0;
            box.getGBConstraints().fill = 2;
            this.filterName = new UITitledComboBox(DIALOG_FILTER_NAME, false);
            this.filterName.setRequired(true);
            this.filterName.setEditable(UIConfig.debugMode());
            this.filterName.addActionListener(new ActionListener(this){
                private final /* synthetic */ AddEditFilterMappingDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    AddEditFilterMappingDialog.access$1900(this.this$1).setDisplayName(AddEditFilterMappingDialog.access$1800(this.this$1).getText());
                }
            });
            box.addWithGBConstraints(this.filterName);
            this.filterTarget = new UIRadioButtonBox(DIALOG_FILTER_TARGET, true);
            GridBagConstraints ftGbc = this.filterTarget.getGBConstraintsCopy();
            ftGbc.insets.left = 25;
            this.filterTarget.addActionListener(new ActionListener(this){
                private final /* synthetic */ AddEditFilterMappingDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    if (AddEditFilterMappingDialog.access$2100(this.this$1).getSelectedIndex() == 0) {
                        AddEditFilterMappingDialog.access$1900(this.this$1).setTargetType("URLPattern");
                        AddEditFilterMappingDialog.access$2200(this.this$1).fireUpdate();
                    } else {
                        AddEditFilterMappingDialog.access$1900(this.this$1).setTargetType("Servlet");
                        AddEditFilterMappingDialog.access$2300(this.this$1).fireUpdate();
                    }
                }
            });
            this.filterTarget.addItem(DIALOG_FILTER_TARGET_RB_URL);
            this.filterTargetURL = new UITitledTextField(DIALOG_FILTER_TARGET_URL_PATTERN, false);
            this.filterTargetURL.addActionListener(new ActionListener(this){
                private final /* synthetic */ AddEditFilterMappingDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    if (AddEditFilterMappingDialog.access$1900(this.this$1).isURLPatternTarget()) {
                        AddEditFilterMappingDialog.access$1900(this.this$1).setTarget(AddEditFilterMappingDialog.access$2200(this.this$1).getText());
                    } else {
                        Print.printStackTrace((String)"Invalid ActionListener invocation");
                    }
                }
            });
            this.filterTarget.add((Component)this.filterTargetURL, ftGbc);
            this.filterTarget.addSelectionEnabledComponent(this.filterTargetURL, null);
            this.filterTarget.addItem(DIALOG_FILTER_TARGET_RB_SERVLET);
            this.filterTargetServlet = new UITitledComboBox(DIALOG_FILTER_TARGET_SERVLET_NAME, false);
            this.filterTargetServlet.addActionListener(new ActionListener(this){
                private final /* synthetic */ AddEditFilterMappingDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    if (AddEditFilterMappingDialog.access$1900(this.this$1).isServletNameTarget()) {
                        AddEditFilterMappingDialog.access$1900(this.this$1).setTarget(AddEditFilterMappingDialog.access$2300(this.this$1).getText());
                    } else {
                        Print.printStackTrace((String)"Invalid ActionListener invocation");
                    }
                }
            });
            this.filterTarget.add((Component)this.filterTargetServlet, ftGbc);
            this.filterTarget.addSelectionEnabledComponent(this.filterTargetServlet, null);
            box.addWithGBConstraints(this.filterTarget);
            UITitledBox dispatcherBox = new UITitledBox(DIALOG_DISPATCHER, true);
            this.dispatchForward = new UICheckBox(DIALOG_DISPATCHER_FORWARD);
            this.dispatchForward.addActionListener(new ActionListener(this){
                private final /* synthetic */ AddEditFilterMappingDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    AddEditFilterMappingDialog.access$3100(this.this$1, WebServletFilterMapInspector.access$900(), AddEditFilterMappingDialog.access$3000(this.this$1).isSelected());
                }
            });
            dispatcherBox.addWithGBConstraints(this.dispatchForward);
            this.dispatchInclude = new UICheckBox(DIALOG_DISPATCHER_INCLUDE);
            this.dispatchInclude.addActionListener(new ActionListener(this){
                private final /* synthetic */ AddEditFilterMappingDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    AddEditFilterMappingDialog.access$3100(this.this$1, WebServletFilterMapInspector.access$1000(), AddEditFilterMappingDialog.access$3300(this.this$1).isSelected());
                }
            });
            dispatcherBox.addWithGBConstraints(this.dispatchInclude);
            this.dispatchRequest = new UICheckBox(DIALOG_DISPATCHER_REQUEST);
            this.dispatchRequest.addActionListener(new ActionListener(this){
                private final /* synthetic */ AddEditFilterMappingDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    AddEditFilterMappingDialog.access$3100(this.this$1, WebServletFilterMapInspector.access$1100(), AddEditFilterMappingDialog.access$3500(this.this$1).isSelected());
                }
            });
            dispatcherBox.addWithGBConstraints(this.dispatchRequest);
            this.dispatchError = new UICheckBox(DIALOG_DISPATCHER_ERROR);
            this.dispatchError.addActionListener(new ActionListener(this){
                private final /* synthetic */ AddEditFilterMappingDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    AddEditFilterMappingDialog.access$3100(this.this$1, "ERROR", AddEditFilterMappingDialog.access$3700(this.this$1).isSelected());
                }
            });
            dispatcherBox.addWithGBConstraints(this.dispatchError);
            box.addWithGBConstraints(dispatcherBox);
            return box;
        }

        private void setDispatcher(String dispatcher, boolean state) {
            if (state) {
                this.sfmCopy.addDispatcher(dispatcher);
            } else {
                this.sfmCopy.removeDispatcher(dispatcher);
            }
        }

        public void refreshDialog() {
            this.filterName.setModel(WebServletFilterMapInspector.this.getFilterNames());
            this.filterName.setSelectedItem(this.sfmCopy.getDisplayName(), true);
            List servletList = WebServletFilterMapInspector.this.getServlets();
            this.filterTargetServlet.setModel(servletList);
            if (this.sfmCopy.isURLPatternTarget()) {
                this.filterTarget.setSelectedIndex(0);
                this.filterTargetURL.setText(this.sfmCopy.getTarget());
            } else {
                this.filterTarget.setSelectedIndex(1);
                this.filterTargetServlet.setSelectedItem(this.sfmCopy.getTarget(), true);
            }
            Set disp = this.sfmCopy.getDispatchers();
            this.dispatchForward.setSelected(disp.contains(_FORWARD));
            this.dispatchInclude.setSelected(disp.contains(_INCLUDE));
            this.dispatchRequest.setSelected(disp.contains(_REQUEST));
            this.dispatchError.setSelected(disp.contains(WebServletFilterMapInspector._ERROR));
        }

        static /* synthetic */ void access$1600(AddEditFilterMappingDialog x0) {
            x0.okAction();
        }

        static /* synthetic */ UITitledComboBox access$1800(AddEditFilterMappingDialog x0) {
            return x0.filterName;
        }

        static /* synthetic */ ServletFilterMappingDescriptor access$1900(AddEditFilterMappingDialog x0) {
            return x0.sfmCopy;
        }

        static /* synthetic */ UIRadioButtonBox access$2100(AddEditFilterMappingDialog x0) {
            return x0.filterTarget;
        }

        static /* synthetic */ UITitledTextField access$2200(AddEditFilterMappingDialog x0) {
            return x0.filterTargetURL;
        }

        static /* synthetic */ UITitledComboBox access$2300(AddEditFilterMappingDialog x0) {
            return x0.filterTargetServlet;
        }

        static /* synthetic */ UICheckBox access$3000(AddEditFilterMappingDialog x0) {
            return x0.dispatchForward;
        }

        static /* synthetic */ void access$3100(AddEditFilterMappingDialog x0, String x1, boolean x2) {
            x0.setDispatcher(x1, x2);
        }

        static /* synthetic */ UICheckBox access$3300(AddEditFilterMappingDialog x0) {
            return x0.dispatchInclude;
        }

        static /* synthetic */ UICheckBox access$3500(AddEditFilterMappingDialog x0) {
            return x0.dispatchRequest;
        }

        static /* synthetic */ UICheckBox access$3700(AddEditFilterMappingDialog x0) {
            return x0.dispatchError;
        }
    }

    private class ServletFilterMapTableModel
    extends InspectorTableModel {
        public ServletFilterMapTableModel() {
            super(new String[]{TABLE_FILTER_NAME, TABLE_TARGET, TABLE_DISPATCHER});
            this.setDataOrdering(2);
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public Object getObjectValue(Object obj, int col) {
            ServletFilterMappingDescriptor ref = (ServletFilterMappingDescriptor)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = ref.getDisplayName();
                    break;
                }
                case 1: {
                    value = ref.getTarget();
                    break;
                }
                case 2: {
                    String v = "";
                    if (ref.getDispatchers().contains(_FORWARD)) {
                        v = v + "F";
                    }
                    if (ref.getDispatchers().contains(_INCLUDE)) {
                        v = v + "I";
                    }
                    if (ref.getDispatchers().contains(_REQUEST)) {
                        v = v + "R";
                    }
                    if (ref.getDispatchers().contains(WebServletFilterMapInspector._ERROR)) {
                        v = v + "E";
                    }
                    value = v;
                    break;
                }
            }
            return value != null ? value : "";
        }

        public void setObjectValue(Object obj, int col, Object value) {
            ServletFilterMappingDescriptor ref = (ServletFilterMappingDescriptor)obj;
        }
    }

    private class ServletFilterMapTable
    extends InspectorTable {
        public ServletFilterMapTable(ServletFilterMapTableModel model) {
            super(model);
        }
    }
}

