/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.war;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.web.InitializationParameter;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class WebComponentParametersInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(WebComponentParametersInspector.class);
    private static final String TABLE_TITLE = localStrings.getLocalString("ui.webcomponentparametersinspector.inzparm_title", "Initialization Parameters Referenced in Code");
    private static final String TABLE_TOOLTIP = localStrings.getLocalString("ui.webcomponentparametersinspector.inzparm_tooltip", "Table of parameters");
    private static final String TABLE_INIT_PARM = localStrings.getLocalString("ui.webcomponentparametersinspector.inzparm_name", "Coded Parameter");
    private static final String TABLE_VALUE = localStrings.getLocalString("ui.webcomponentparametersinspector.inzparm_value", "Value");
    private static String MISSING_CODED_PARAM = localStrings.getLocalString("at.webcomponentparametersinspector.missing_coded_param", "All References must specify a coded paramater");
    private static String MISSING_VALUE = localStrings.getLocalString("at.webcomponentparametersinspector.missing_value", "All References must specify a Value");
    private static String TABNAME = localStrings.getLocalString("ui.webcomponentparametersinspector.tabname", "Init Parameters");
    private static String wizardHelpID = "InitParam";
    private static String deployHelpID = "Params";
    private WebComponentDescriptor descriptor = null;
    private UITitledTable initParmsPanel = null;
    private ParametersTable parametersTable = null;

    public static InspectorPane newInspectorPane(String mode) {
        return new WebComponentParametersInspector();
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return WebComponentDescriptor.class;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor desc) {
        if (this.descriptor != desc) {
            this.descriptor = desc instanceof WebComponentDescriptor ? (WebComponentDescriptor)desc : null;
            this.parametersTable.clearTableData();
        }
    }

    private WebComponentParametersInspector() {
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout gb1 = new GridBagLayout();
        this.setLayout(gb1);
        this.initParmsPanel = new UITitledTable(TABLE_TITLE, true);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)this.initParmsPanel, c);
        this.parametersTable = new ParametersTable(new ParametersTableModel());
        this.initParmsPanel.getGBConstraints().weighty = 0.85;
        this.initParmsPanel.setTableView(this.parametersTable);
        UIButton btnAdd = UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WebComponentParametersInspector.this.addAction();
            }
        });
        this.initParmsPanel.addControlButton(btnAdd);
        UIButton btnDelete = UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WebComponentParametersInspector.this.deleteAction();
            }
        }, true);
        this.initParmsPanel.addSelectionEnabledButton(btnDelete);
    }

    public void refresh() {
        this.parametersTable.updateTableData(this.descriptor.getInitializationParameters());
    }

    public void setReadOnly(boolean state) {
        super.setReadOnly(state);
        this.initParmsPanel.setReadOnly(state);
    }

    public boolean validateEntries(boolean showErrors) {
        if (this.parametersTable.getRowWithValue(0, "") != null) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, MISSING_CODED_PARAM);
            }
            return false;
        }
        if (this.parametersTable.getRowWithValue(1, "") != null) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, MISSING_VALUE);
            }
            return false;
        }
        return true;
    }

    private void addAction() {
        if (this.parametersTable.getRowWithValue(0, "") == null) {
            this.descriptor.addInitializationParameter((InitializationParameter)new EnvironmentProperty("", "", ""));
        }
        this.parametersTable.selectRowWithValueOnUpdate(0, "");
        this.invokeRefresh();
    }

    private void deleteAction() {
        Object[] list = this.parametersTable.confirmDeleteSelection(null, null);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                EnvironmentProperty ref = (EnvironmentProperty)list[i];
                this.descriptor.removeInitializationParameter((InitializationParameter)ref);
            }
            this.invokeRefresh();
        }
    }

    private class ParametersTableModel
    extends InspectorTableModel {
        public ParametersTableModel() {
            super(new String[]{TABLE_INIT_PARM, TABLE_VALUE, DescriptionInspector.DESCRIPTION_COLUMN_INIT});
        }

        public EnvironmentProperty getRow(int index) {
            return (EnvironmentProperty)this.getRowObject(index);
        }

        public Object getObjectValue(Object obj, int col) {
            EnvironmentProperty ref = (EnvironmentProperty)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = ref.getDisplayName();
                    break;
                }
                case 1: {
                    value = ref.getValue();
                    break;
                }
                case 2: {
                    value = ref.getDescription();
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            EnvironmentProperty ref = (EnvironmentProperty)obj;
            if (ref == null) {
                return;
            }
            switch (col) {
                case 0: {
                    ref.setDisplayName(value.toString());
                    break;
                }
                case 1: {
                    ref.setValue(value.toString());
                    break;
                }
                case 2: {
                    ref.setDescription(value.toString());
                }
            }
            WebComponentParametersInspector.this.descriptor.changed();
        }
    }

    private class ParametersTable
    extends InspectorTable {
        public ParametersTable(ParametersTableModel model) {
            super(model);
            this.setToolTipText(TABLE_TOOLTIP);
            this.setSelectionMode(0);
            this.setHandleDescriptionUpdates(true);
        }
    }
}

