/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.war;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorTools;
import com.sun.enterprise.tools.deployment.ui.shared.IconInspector;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.ListTools;
import com.sun.enterprise.tools.deployment.ui.utils.UIPanel;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.tools.deployment.ui.war.NewWebComponentWizard;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.servlet.Servlet;

public class WebComponentGeneralInspector
extends InspectorPane
implements IconInspector.UpdateListener,
DescriptionInspector.UpdateListener {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(WebComponentGeneralInspector.class);
    private static final String SERVLET_CLASSFILE_LABEL = localStrings.getLocalString("ui.webcomponentgeneralinspector.servlet_class", "Servlet Class:");
    private static final String JSP_CLASSFILE_LABEL = localStrings.getLocalString("ui.webcomponentgeneralinspector.jsp_filename", "JSP Filename:");
    private static final String SERVICE_ENDPOINT_LABEL = localStrings.getLocalString("ui.webcomponentgeneralinspector.service_endpoint", "Service Endpoint Implementation:");
    private static final String WEB_COMP_NAME = localStrings.getLocalString("ui.webcomponentgeneralinspector.name", "Web Component Name:");
    private static final String WEB_COMP_DISPLAY_NAME = localStrings.getLocalString("ui.webcomponentgeneralinspector.display_name", "Web Component Display Name:");
    private static final String STARTUP_LOAD_SEQ = localStrings.getLocalString("ui.webcomponentgeneralinspector.startup_seq_pos", "Startup load sequence position:");
    private static final String DEFAULT_STARTUP_SEQ = localStrings.getLocalString("ui.webcomponentgeneralinspector.default_startup_seq_pos", "Load at any time");
    private static final String TABNAME = localStrings.getLocalString("ui.webcomponentgeneralinspector.tabname", "General");
    private static String wizardHelpID = "Prop";
    private static String deployHelpID = "General";
    private WebComponentDescriptor descriptor;
    public static final int COMP_UNKNOWN = 0;
    public static final int COMP_SERVLET = 1;
    public static final int COMP_JSP = 2;
    public static final int COMP_ENDPOINT = 3;
    private UITitledBox fieldContainer = null;
    private UITitledComboBox jspServletCombo = null;
    private UITitledTextField webCompName = null;
    private UITitledTextField webCompDisplayName = null;
    private UITitledComboBox startupLoadSeqPos = null;
    IconInspector.DialogDisplayButton iconInspector = null;
    DescriptionInspector.DialogDisplayButton descInspector = null;

    public static InspectorPane newInspectorPane(String mode) {
        return new WebComponentGeneralInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isWizardMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return WebComponentDescriptor.class;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor desc) {
        if (this.descriptor != desc) {
            this.descriptor = desc instanceof WebComponentDescriptor ? (WebComponentDescriptor)desc : null;
        }
    }

    private WebComponentGeneralInspector(String mode) {
        this.setInspectorMode(mode);
        this.initializeLayout();
    }

    private void initializeLayout() {
        this.setLayout(new GridBagLayout());
        this.fieldContainer = new UITitledBox(null, false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 0.7;
        gbc.weighty = 0.5;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(5, 5, 0, 0);
        gbc.fill = 2;
        gbc.anchor = 18;
        this.add((Component)this.fieldContainer, gbc);
        gbc.weightx = 0.3;
        gbc.gridx = 1;
        this.add((Component)new UIPanel(), gbc);
        GridBagConstraints c = this.fieldContainer.getGBConstraints();
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = -1;
        c.insets = new Insets(7, 0, 0, 0);
        c.fill = 2;
        c.anchor = 18;
        this.jspServletCombo = new UITitledComboBox("", false);
        this.fieldContainer.add((Component)this.jspServletCombo, c);
        this.jspServletCombo.setRequired(true);
        this.jspServletCombo.setShowSelectionAsToolTip(true);
        this.jspServletCombo.setShowWidePopups(true);
        this.jspServletCombo.setMaximumPreferredSize(new Dimension(100, -1));
        this.jspServletCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String dftName;
                String item;
                if (WebComponentGeneralInspector.this.descriptor == null) {
                    return;
                }
                Object sel = WebComponentGeneralInspector.this.jspServletCombo.getSelectedItem();
                if (sel == null) {
                    return;
                }
                String string = item = sel instanceof Class ? ((Class)sel).getName() : sel.toString();
                if (!WebComponentGeneralInspector.this.descriptor.getWebComponentImplementation().equals(item)) {
                    WebComponentGeneralInspector.this.descriptor.setWebComponentImplementation(item);
                }
                if (!(dftName = WebComponentGeneralInspector.this._getDefaultComponentName()).equals(WebComponentGeneralInspector.this.webCompName.getText())) {
                    WebComponentGeneralInspector.this.webCompName.setText(dftName);
                    WebComponentGeneralInspector.this.webCompName.fireUpdate();
                }
                if (!dftName.equals(WebComponentGeneralInspector.this.webCompDisplayName.getText())) {
                    WebComponentGeneralInspector.this.webCompDisplayName.setText(dftName);
                    WebComponentGeneralInspector.this.webCompDisplayName.fireUpdate();
                }
            }
        });
        this.jspServletCombo.setReadOnly(this.isDeploymentMode());
        this.webCompName = new UITitledTextField(WEB_COMP_NAME, false);
        this.fieldContainer.add((Component)this.webCompName, c);
        this.webCompName.setRequired(true);
        this.webCompName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String n2;
                String n1 = WebComponentGeneralInspector.this.webCompName.getText();
                String string = n2 = !n1.equals("") ? n1 : WebComponentGeneralInspector.this._getDefaultComponentName();
                if (WebComponentGeneralInspector.this.isDeploymentMode()) {
                    WebBundleDescriptor bd = WebComponentGeneralInspector.this.descriptor.getWebBundleDescriptor();
                    n2 = DescriptorTools.createUniqueComponentName((BundleDescriptor)bd, n2);
                }
                if (!n2.equals(n1)) {
                    WebComponentGeneralInspector.this.webCompName.setText(n2);
                }
                WebComponentGeneralInspector.this.updateWebServiceReferences(WebComponentGeneralInspector.this.descriptor.getCanonicalName(), n2);
                WebComponentGeneralInspector.this.descriptor.setCanonicalName(n2);
            }
        });
        this.webCompDisplayName = new UITitledTextField(WEB_COMP_DISPLAY_NAME, false);
        this.fieldContainer.add((Component)this.webCompDisplayName, c);
        this.webCompDisplayName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String n2;
                String n1 = WebComponentGeneralInspector.this.webCompDisplayName.getText();
                String string = n2 = !n1.equals("") ? n1 : WebComponentGeneralInspector.this._getDefaultComponentName();
                if (WebComponentGeneralInspector.this.isDeploymentMode()) {
                    WebBundleDescriptor bd = WebComponentGeneralInspector.this.descriptor.getWebBundleDescriptor();
                    n2 = DescriptorTools.createUniqueDisplayName((BundleDescriptor)bd, n2);
                }
                if (!n2.equals(n1)) {
                    WebComponentGeneralInspector.this.webCompDisplayName.setText(n2);
                }
                WebComponentGeneralInspector.this.descriptor.setDisplayName(n2);
            }
        });
        this.startupLoadSeqPos = new UITitledComboBox(STARTUP_LOAD_SEQ, false);
        this.startupLoadSeqPos.addItem(DEFAULT_STARTUP_SEQ);
        this.startupLoadSeqPos.setEditable(true);
        this.fieldContainer.add((Component)this.startupLoadSeqPos, c);
        this.startupLoadSeqPos.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                int val = WebComponentGeneralInspector.this.startupLoadSeqPos.getIntValue(-1);
                WebComponentGeneralInspector.this.descriptor.setLoadOnStartUp(val);
            }
        });
        this.descInspector = new DescriptionInspector.DialogDisplayButton(this);
        this.fieldContainer.add((Component)this.descInspector, c);
        this.iconInspector = new IconInspector.DialogDisplayButton(this);
        this.fieldContainer.add((Component)this.iconInspector, c);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridwidth = 1;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 1;
        this.fieldContainer.add((Component)new UIPanel(), c);
    }

    public void setReadOnly(boolean state) {
        super.setReadOnly(state);
        this.jspServletCombo.setReadOnly(this.isDeploymentMode() || state);
        this.webCompName.setReadOnly(state);
        this.webCompDisplayName.setReadOnly(state);
        this.startupLoadSeqPos.setReadOnly(state);
        this.descInspector.setReadOnly(state);
        this.iconInspector.setReadOnly(state);
    }

    private String _getDefaultComponentName() {
        int p;
        String webImp = this.descriptor.getWebComponentImplementation();
        if (this.descriptor.isServlet()) {
            int p2 = webImp.lastIndexOf(".");
            return p2 >= 0 ? webImp.substring(p2 + 1) : webImp;
        }
        int n = p = webImp.startsWith("/") ? 1 : 0;
        if (webImp.endsWith(".jsp")) {
            return webImp.substring(p, webImp.length() - 4);
        }
        if (webImp.endsWith(".jspx")) {
            return webImp.substring(p, webImp.length() - 5);
        }
        return webImp.substring(p);
    }

    public void descriptionUpdated(String description, Object ref) {
        this.descriptor.setDescription(description);
    }

    public void addLargeIcon(File iconFile) {
        if (this.isDeploymentMode()) {
            WebBundleDescriptor wbd = this.descriptor.getWebBundleDescriptor();
            this._addDeploymentIcon("large", iconFile, (Descriptor)wbd, (Descriptor)this.descriptor);
        } else {
            NewWebComponentWizard wcw = (NewWebComponentWizard)this.getOwner();
            this._addWizardIcon("large", iconFile, wcw.getArchiveModuleContent(), (Descriptor)this.descriptor);
        }
    }

    public void addSmallIcon(File iconFile) {
        if (this.isDeploymentMode()) {
            WebBundleDescriptor wbd = this.descriptor.getWebBundleDescriptor();
            this._addDeploymentIcon("small", iconFile, (Descriptor)wbd, (Descriptor)this.descriptor);
        } else {
            NewWebComponentWizard wcw = (NewWebComponentWizard)this.getOwner();
            this._addWizardIcon("small", iconFile, wcw.getArchiveModuleContent(), (Descriptor)this.descriptor);
        }
    }

    public boolean setComponentClassModel(int compType) {
        List implList = null;
        if (this.isWizardMode()) {
            String c1;
            if (compType == 2) {
                implList = this.getArchiveContents(new String[]{".jsp", ".jspx"});
            } else if (compType == 3) {
                implList = this.getArchiveImplementationNames();
            } else if (compType == 1) {
                implList = this.getArchiveClassNames(new Class[]{Servlet.class});
            } else if (compType == 0) {
                implList = null;
            }
            if (this.descriptor != null && (c1 = this.descriptor.getWebComponentImplementation()) != null) {
                String c2;
                String string = c2 = c1.startsWith("/") ? c1.substring(1) : "/" + c1;
                if (implList == null || !implList.contains(c1) && !implList.contains(c2)) {
                    this.descriptor.setWebComponentImplementation("");
                }
            }
        }
        if (implList == null || implList.size() <= 0) {
            this.jspServletCombo.clearModel();
            return false;
        }
        Vector<String> implNames = new Vector<String>();
        Iterator i = ListTools.sortList(implList).iterator();
        while (i.hasNext()) {
            Object c = i.next();
            if (compType == 2) {
                String uri = c.toString();
                if (!uri.startsWith("/")) {
                    uri = "/" + uri;
                }
                implNames.add(uri);
                continue;
            }
            if (compType == 3) {
                implNames.add(c instanceof Class ? ((Class)c).getName() : c.toString());
                continue;
            }
            if (compType != 1) continue;
            implNames.add(c instanceof Class ? ((Class)c).getName() : c.toString());
        }
        this.jspServletCombo.setModel(implNames);
        return true;
    }

    public void refresh() {
        if (this.descriptor == null) {
            return;
        }
        String currentSel = this.descriptor.getWebComponentImplementation();
        boolean isServlet = this.descriptor.isServlet();
        boolean isEndpoint = false;
        if (this.isWizardMode()) {
            isEndpoint = this.descriptor.getExtraAttributes().containsKey("ui.endpointServlet");
        } else if (isServlet) {
            isEndpoint = DescriptorTools.hasWebServiceEndpoint((Descriptor)this.descriptor);
        }
        if (!isServlet) {
            this.jspServletCombo.setTitle(JSP_CLASSFILE_LABEL);
        } else if (isEndpoint) {
            this.jspServletCombo.setTitle(SERVICE_ENDPOINT_LABEL);
        } else {
            this.jspServletCombo.setTitle(SERVLET_CLASSFILE_LABEL);
        }
        if (this.isDeploymentMode()) {
            this.jspServletCombo.clearModel();
        }
        this.jspServletCombo.setSelectedItem(currentSel, true);
        this.webCompName.setText(this.descriptor.getCanonicalName());
        if ("".equals(this.descriptor.getDisplayName())) {
            this.descriptor.setDisplayName(this.descriptor.getCanonicalName());
        }
        this.webCompDisplayName.setText(this.descriptor.getDisplayName());
        this.descInspector.setDescriptionInspector(this.descriptor.getDescription(), DescriptorTools.getDisplayName(this.descriptor), this, this.descriptor);
        int seq = this.descriptor.getLoadOnStartUp();
        if (seq < 0) {
            this.startupLoadSeqPos.setText(DEFAULT_STARTUP_SEQ);
        } else {
            this.startupLoadSeqPos.setIntValue(seq);
        }
    }

    public String getJspFileOrServerClassname() {
        return (String)this.jspServletCombo.getSelectedItem();
    }

    private void updateWebServiceReferences(String oldName, String newName) {
        Iterator iter = this.descriptor.getWebBundleDescriptor().getWebServices().getWebServices().iterator();
        while (iter.hasNext()) {
            WebService next = (WebService)iter.next();
            Iterator i = next.getEndpoints().iterator();
            while (i.hasNext()) {
                String linkName;
                WebServiceEndpoint tmpWse = (WebServiceEndpoint)i.next();
                if (tmpWse == null || (linkName = tmpWse.getWebComponentLink()) == null || !linkName.equals(oldName)) continue;
                tmpWse.setWebComponentLink(newName);
            }
        }
    }
}

