/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.war;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

public class WebComponentAliasesInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(WebComponentAliasesInspector.class);
    private static final String COMPONENT_ALIASES = localStrings.getLocalString("ui.webcomponentaliasesinspector.component_aliases", "Component Aliases");
    private static final String URL_MAPPINGS_COLUMN = localStrings.getLocalString("ui.webcomponentaliasesinspector.url_mappings", "URL Mappings");
    private static final String ALIASES_COLUMN = localStrings.getLocalString("ui.webcomponentaliasesinspector.aliases", "Aliases");
    private static String MISSING_ALIAS = localStrings.getLocalString("at.webcomponentaliasesinspector.missing_alias", "All Aliases must be filled in");
    private static String DUP_ALIAS = localStrings.getLocalString("at.webcomponentaliasesinspector.dup_alias", "Duplicate aliases");
    private static final String TABNAME = localStrings.getLocalString("ui.webcomponentaliasesinspector.tabname", "Aliases");
    private static String wizardHelpID = "Alias";
    private static String deployHelpID = "Alias";
    private WebComponentDescriptor descriptor;
    private UITitledTable mappingPanel = null;
    private UrlMappingTable urlMappingTable = null;

    public static InspectorPane newInspectorPane(String mode) {
        return new WebComponentAliasesInspector();
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return WebComponentDescriptor.class;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor desc) {
        if (this.descriptor != desc) {
            this.descriptor = desc instanceof WebComponentDescriptor ? (WebComponentDescriptor)desc : null;
            this.urlMappingTable.clearTableData();
        }
    }

    private WebComponentAliasesInspector() {
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout gb1 = new GridBagLayout();
        this.setLayout(gb1);
        this.mappingPanel = new UITitledTable(COMPONENT_ALIASES, true);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        gb1.setConstraints(this.mappingPanel, c);
        this.add(this.mappingPanel);
        this.urlMappingTable = new UrlMappingTable(new UrlMappingTableModel());
        this.mappingPanel.setTableView(this.urlMappingTable);
        UIButton addButton = UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WebComponentAliasesInspector.this.addAction();
            }
        });
        this.mappingPanel.addControlButton(addButton);
        UIButton delButton = UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WebComponentAliasesInspector.this.deleteAction();
            }
        }, true);
        this.mappingPanel.addSelectionEnabledButton(delButton);
    }

    public void refresh() {
        Vector dw = this.urlMappingTable.wrapData(this.descriptor.getUrlPatternsSet());
        this.urlMappingTable.updateTableData(dw);
    }

    public void setReadOnly(boolean state) {
        super.setReadOnly(state);
        this.mappingPanel.setReadOnly(state);
    }

    public boolean validateEntries(boolean showErrors) {
        if (this.urlMappingTable.getRowWithValue(0, "") != null) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, MISSING_ALIAS);
            }
            return false;
        }
        return true;
    }

    public void addAction() {
        String blankRef = null;
        if (this.urlMappingTable.getRowWithValue(0, "") != null) {
            blankRef = "";
        } else {
            blankRef = "";
            this.descriptor.addUrlPattern(blankRef);
        }
        this.urlMappingTable.selectRowWithValueOnUpdate(0, blankRef);
        this.invokeRefresh();
    }

    public void deleteAction() {
        Object[] list = this.urlMappingTable.confirmDeleteSelection(null, null);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                String ref = list[i].toString();
                this.descriptor.removeUrlPattern(ref);
            }
            this.invokeRefresh();
        }
    }

    private class UrlMappingTableModel
    extends InspectorTableModel {
        public UrlMappingTableModel() {
            super(new String[]{ALIASES_COLUMN});
        }

        public Object getObjectValue(Object obj, int col) {
            InspectorTableModel.InspectorDataWrapper ref = (InspectorTableModel.InspectorDataWrapper)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = ref.toString();
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            InspectorTableModel.InspectorDataWrapper ref = (InspectorTableModel.InspectorDataWrapper)obj;
            switch (col) {
                case 0: {
                    if (ref.toString().equals(value.toString())) break;
                    String oldValue = ref.toString();
                    String newValue = value.toString();
                    if (!(newValue.equals("") || newValue.startsWith("/") || newValue.startsWith("*."))) {
                        newValue = "/" + newValue;
                    }
                    if (this.getRowWithValue(0, newValue) != null) {
                        UIOptionPane.showErrorDialog(null, DUP_ALIAS);
                        return;
                    }
                    WebComponentAliasesInspector.this.descriptor.removeUrlPattern(oldValue);
                    ref.setObject(newValue);
                    WebComponentAliasesInspector.this.descriptor.addUrlPattern(newValue);
                }
            }
        }
    }

    private class UrlMappingTable
    extends InspectorTable {
        public UrlMappingTable(UrlMappingTableModel model) {
            super(model);
            this.setSelectionMode(0);
        }
    }
}

