/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.war;

import com.sun.enterprise.deployment.AuthorizationConstraintImpl;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.SecurityConstraintImpl;
import com.sun.enterprise.deployment.SecurityRoleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.web.AuthorizationConstraint;
import com.sun.enterprise.deployment.web.SecurityRole;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorInspector;
import com.sun.enterprise.tools.deployment.ui.shared.RolesDialog;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIListSelector;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.help.CSH;
import javax.swing.JButton;

class WebAppRolePicker
extends UIDialog
implements ActionListener,
DescriptorInspector {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(WebAppRolePicker.class);
    private static final String AUTHORIZED_ROLES = localStrings.getLocalString("ui.webappsecurityinspector.authorized_roles", "Authorized Roles:");
    private static String helpSetMapID = "RolePicker";
    private UIListSelector listPanel = null;
    private InspectorPane.InspectorPaneOwner inspectorOwner = null;
    private WebBundleDescriptor availRolesDescriptor = null;
    private SecurityConstraintImpl authRolesDescriptor = null;

    private static String ROLES_IN(String v0) {
        return localStrings.getLocalString("ui.webappsecurityinspector.available_roles_title", "Roles in {0}:", new Object[]{v0});
    }

    private static String DIALOG_TITLE_FOR(String v0) {
        return localStrings.getLocalString("ui.webappsecurityinspector.authorized_roles_for", "Authorized Roles for {0}", new Object[]{v0});
    }

    public WebAppRolePicker(Frame owner, InspectorPane.InspectorPaneOwner inspOwner) {
        super(owner, true);
        this.inspectorOwner = inspOwner;
        this.initDialog();
    }

    public WebAppRolePicker(Dialog owner, InspectorPane.InspectorPaneOwner inspOwner) {
        super(owner, true);
        this.inspectorOwner = inspOwner;
        this.initDialog();
    }

    private void initDialog() {
        CSH.setHelpIDString((Component)this, (String)helpSetMapID);
        this.doNothingOnClose();
        UIControlButtonBox windowPanel = new UIControlButtonBox(null, false);
        windowPanel.setControlButtonLocation(101);
        this.setContentPane(windowPanel);
        this.listPanel = new UIListSelector("<>", AUTHORIZED_ROLES);
        this.listPanel.setDescriptorCellRenderer();
        GridBagConstraints wgbc = windowPanel.getViewContainerGBConstraints();
        wgbc.insets = new Insets(5, 5, 5, 5);
        windowPanel.setView(this.listPanel);
        JButton editRoles = RolesDialog.getEditRolesButton(this, new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WebAppRolePicker.this.refreshRoles();
            }
        });
        windowPanel.addControlButton(editRoles);
        windowPanel.addControlSpacer();
        UIButton okBtn = UIButton.createOkButton(this);
        windowPanel.addControlButton(okBtn);
        UIButton cancelBtn = UIButton.createCancelButton(this);
        windowPanel.addControlButton(cancelBtn);
        UIHelpButton helpBtn = new UIHelpButton(helpSetMapID);
        windowPanel.addControlButton(helpBtn);
        this.resetBounds();
    }

    public void setLocationRelativeTo(Component comp) {
        this.resetBounds();
        super.setLocationRelativeTo(comp);
    }

    private void resetBounds() {
        Window win = this.getOwner();
        if (win != null) {
            Rectangle b = win.getBounds();
            b.x += 20;
            b.y += 20;
            b.width = 565;
            b.height = 250;
            this.setBounds(b);
        } else {
            this.setSize(565, 250);
            this.centerOnScreen();
        }
    }

    public void _showDialog() {
        this.resetBounds();
        super._showDialog();
    }

    public Class getDescriptorClass() {
        return WebBundleDescriptor.class;
    }

    public void setDescriptor(Descriptor d) {
        Print.printStackTrace((String)"Don't call this");
    }

    public Descriptor getDescriptor() {
        return this.availRolesDescriptor;
    }

    public void refreshRoles() {
        this.listPanel.setListContentsLeft(this.availRolesDescriptor.getSecurityRoles());
    }

    public void setSecurityConstraintDescriptors(WebBundleDescriptor availRoles, SecurityConstraintImpl authRoles) {
        this.setTitle(WebAppRolePicker.DIALOG_TITLE_FOR(authRoles.getDisplayName()));
        this.listPanel.setTitleLeft(WebAppRolePicker.ROLES_IN(availRoles.getDisplayName()));
        this.availRolesDescriptor = availRoles;
        this.listPanel.setListContentsLeft(this.availRolesDescriptor.getSecurityRoles());
        this.authRolesDescriptor = authRoles;
        AuthorizationConstraint aci = authRoles.getAuthorizationConstraint();
        this.listPanel.setListContentsRight(aci != null ? aci.getSecurityRoles() : null);
    }

    public AuthorizationConstraintImpl getAuthorizedRoles() {
        AuthorizationConstraintImpl aci = new AuthorizationConstraintImpl();
        Enumeration e = this.listPanel.getListContentsRight().elements();
        while (e.hasMoreElements()) {
            aci.addSecurityRole((SecurityRole)((SecurityRoleDescriptor)e.nextElement()));
        }
        return aci;
    }

    public void actionPerformed(ActionEvent ae) {
        String cmd = ((JButton)ae.getSource()).getActionCommand();
        if (cmd.equals("ok")) {
            if (this.authRolesDescriptor != null) {
                AuthorizationConstraintImpl aci = this.getAuthorizedRoles();
                this.authRolesDescriptor.setAuthorizationConstraint(aci);
            }
            this.hide();
        } else if (cmd.equals("cancel")) {
            this.hide();
        }
    }
}

