/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.war;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.web.ContextParameter;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;

public class WebAppContextParametersInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(WebAppContextParametersInspector.class);
    private static final String TABLE_TITLE = localStrings.getLocalString("ui.webappcontextparametersinspector.ctxparm.title", "Context Parameters Referenced in Code");
    private static final String TABLE_ACC_DSC = localStrings.getLocalString("at.webappcontextparametersinspector.ctxparm.acc_dsc", "List of Context Parameters Referenced in Code for Web Application. User can add or edit.");
    private static final String TABLE_CONTEXT_PARM = localStrings.getLocalString("ui.webappcontextparametersinspector.coded_parm", "Coded Parameter");
    private static final String TABLE_VALUE = localStrings.getLocalString("ui.webappcontextparametersinspector.parm_value", "Value");
    private static final String MISSING_CODE_PARAM = localStrings.getLocalString("at.webappcontextparametersinspector.missing_code_param", "All references must specify a 'Coded Parameter'");
    private static final String MISSING_VALUE = localStrings.getLocalString("at.webappcontextparametersinspector.missing_value", "All references must specify a 'Value'");
    private static final String TABNAME = localStrings.getLocalString("ui.webappcontextparametersinspector.tabname", "Context");
    private static String wizardHelpID = "ContextParam";
    private static String deployHelpID = "Context";
    private WebBundleDescriptor descriptor = null;
    private UITitledTable contextTableBox = null;
    private InspectorTable contextParametersTable = null;

    public static InspectorPane newInspectorPane(String mode) {
        return new WebAppContextParametersInspector();
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return WebBundleDescriptor.class;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor desc) {
        if (this.descriptor != desc) {
            this.descriptor = desc instanceof WebBundleDescriptor ? (WebBundleDescriptor)desc : null;
            this.contextParametersTable.clearTableData();
        }
    }

    private WebAppContextParametersInspector() {
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.contextTableBox = new UITitledTable(TABLE_TITLE, true);
        this.contextTableBox.getAccessibleContext().setAccessibleDescription(TABLE_ACC_DSC);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)this.contextTableBox, c);
        this.contextParametersTable = new ContextParametersTable(new ContextParametersTableModel());
        this.contextTableBox.setTableView(this.contextParametersTable);
        UIButton addButton = UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WebAppContextParametersInspector.this.addAction();
            }
        });
        this.contextTableBox.addControlButton(addButton);
        UIButton delButton = UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WebAppContextParametersInspector.this.deleteAction();
            }
        }, true);
        this.contextTableBox.addSelectionEnabledButton(delButton);
    }

    public void refresh() {
        this.contextParametersTable.updateTableData(this.descriptor.getContextParametersSet());
    }

    public void setReadOnly(boolean state) {
        super.setReadOnly(state);
        this.contextTableBox.setReadOnly(state);
    }

    public boolean validateEntries(boolean showErrors) {
        if (this.contextParametersTable.getRowWithValue(0, "") != null) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, MISSING_CODE_PARAM);
            }
            return false;
        }
        if (this.contextParametersTable.getRowWithValue(1, "") != null) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, MISSING_VALUE);
            }
            return false;
        }
        return true;
    }

    public void addAction() {
        if (this.contextParametersTable.getRowWithValue(0, "") == null) {
            this.descriptor.addContextParameter(new EnvironmentProperty("", "", ""));
        }
        this.contextParametersTable.selectRowWithValueOnUpdate(0, "");
        this.invokeRefresh();
    }

    public void deleteAction() {
        Object[] list = this.contextParametersTable.confirmDeleteSelection(null, null);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                EnvironmentProperty ref = (EnvironmentProperty)list[i];
                this.descriptor.removeContextParameter((ContextParameter)ref);
            }
            this.invokeRefresh();
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setBounds(0, 0, 300, 300);
        f.getContentPane().add(new WebAppContextParametersInspector());
        f.show();
    }

    private class ContextParametersTableModel
    extends InspectorTableModel {
        public ContextParametersTableModel() {
            super(new String[]{TABLE_CONTEXT_PARM, TABLE_VALUE});
        }

        public Object getObjectValue(Object obj, int col) {
            EnvironmentProperty ref = (EnvironmentProperty)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = ref.getDisplayName();
                    break;
                }
                case 1: {
                    value = ref.getValue();
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            EnvironmentProperty ref = (EnvironmentProperty)obj;
            if (ref == null) {
                return;
            }
            switch (col) {
                case 0: {
                    ref.setDisplayName(value.toString());
                    WebAppContextParametersInspector.this.descriptor.changed();
                    break;
                }
                case 1: {
                    ref.setValue(value.toString());
                    WebAppContextParametersInspector.this.descriptor.changed();
                }
            }
        }
    }

    private class ContextParametersTable
    extends InspectorTable {
        public ContextParametersTable(ContextParametersTableModel model) {
            super(model);
            this.setAutoResizeMode(4);
            this.setSelectionMode(0);
        }
    }
}

