/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.util.Print;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.SwingUtilities;

public class WinTools {
    private static Set appFrameMnemonics = null;
    private static int activeWindowListenerLevel = 0;
    private static WindowActivationListener activeWindowListener = null;

    public static Set getApplicationFrameMnemonics() {
        if (appFrameMnemonics == null) {
            appFrameMnemonics = WinTools.getWindowMnemonics(DT.getApplicationFrame());
        }
        return appFrameMnemonics;
    }

    public static Set getWindowMnemonics(Component c) {
        JMenuBar menuBar = null;
        Window win = WinTools.getAncestorWindow(c);
        if (win instanceof JFrame) {
            menuBar = ((JFrame)win).getJMenuBar();
        } else if (win instanceof JDialog) {
            menuBar = ((JDialog)win).getJMenuBar();
        }
        if (menuBar != null) {
            HashSet<Integer> hs = new HashSet<Integer>();
            int size = menuBar.getMenuCount();
            for (int i = 0; i < size; ++i) {
                JMenu menu = menuBar.getMenu(i);
                int m = menu.getMnemonic();
                if (m == 0) continue;
                Integer mi = new Integer(m);
                if (!hs.contains(mi)) {
                    hs.add(mi);
                    continue;
                }
                Print.dprintln((String)("Duplicate JMenuBar Mnemonic: " + menu.getText()));
            }
            return hs;
        }
        return null;
    }

    public static int uniqueMnemonic(String text, Set hs) {
        char[] ch = text.toCharArray();
        for (int i = 0; i < ch.length; ++i) {
            char c = ch[i];
            if (Character.isWhitespace(c)) continue;
            if (c >= 'a' && c <= 'z') {
                c = (char)(c - 32);
            }
            if (hs.contains(new Integer(c))) continue;
            return c;
        }
        return 0;
    }

    public static void resetDuplicateMnemonics(Component comp, Set reserved) {
        HashSet hs = reserved != null ? new HashSet(reserved) : new HashSet();
        WinTools._resetDuplicateMnemonics(UIUtils.debugClassName(comp), comp, hs);
    }

    public static void resetDuplicateMnemonics(JMenu menu) {
        HashSet reserved = new HashSet();
        Component[] child = menu.getMenuComponents();
        for (int i = 0; i < child.length; ++i) {
            WinTools._resetDuplicateMnemonics(menu.getText(), child[i], reserved);
        }
    }

    private static void _resetDuplicateMnemonics(String desc, Component comp, Set reserved) {
        AbstractButton btn;
        int m;
        if (comp instanceof AbstractButton && (m = (btn = (AbstractButton)comp).getMnemonic()) != 0) {
            Integer mi = new Integer(m);
            if (!reserved.contains(mi)) {
                reserved.add(mi);
            } else {
                Print.dprintln((String)("Dupl] " + (char)m + ":" + btn.getText() + " (" + desc + ")"));
                m = WinTools.uniqueMnemonic(btn.getText(), reserved);
                btn.setMnemonic(m);
                if (m != 0) {
                    reserved.add(new Integer(m));
                }
            }
        }
        if (comp instanceof Container) {
            Component[] child = ((Container)comp).getComponents();
            for (int i = 0; i < child.length; ++i) {
                WinTools._resetDuplicateMnemonics(desc, child[i], reserved);
            }
        }
    }

    public static Container getAncestorOfClass(Class c, Component comp) {
        if (comp == null || c == null) {
            Print.printStackTrace((String)"null argument");
            return null;
        }
        if (!c.isInterface() && !Container.class.isAssignableFrom(c)) {
            Print.printStackTrace((String)("Not a Container class [" + c.getName() + "]"));
            return null;
        }
        if (c.isInstance(comp)) {
            return (Container)comp;
        }
        return SwingUtilities.getAncestorOfClass(c, comp);
    }

    public static Window getAncestorWindow(Component comp) {
        Window win = (Window)WinTools.getAncestorOfClass(Dialog.class, comp);
        if (win == null) {
            win = (Window)WinTools.getAncestorOfClass(Frame.class, comp);
        }
        return win;
    }

    public static Frame getAncestorFrame(Component comp) {
        return (Frame)WinTools.getAncestorOfClass(Frame.class, comp);
    }

    public static Dialog getAncestorDialog(Component comp) {
        return (Dialog)WinTools.getAncestorOfClass(Dialog.class, comp);
    }

    public static Window getActiveWindow() {
        return WinTools.getActiveWindow(null);
    }

    public static Window getActiveWindow(Window dftWin) {
        if (activeWindowListenerLevel > 0) {
            Window win = activeWindowListener.getActiveWindow();
            return win != null ? win : dftWin;
        }
        WinTools.addWindowActivationListener();
        return dftWin;
    }

    private static void addWindowActivationListener() {
        if (activeWindowListenerLevel == 0) {
            if (activeWindowListener == null) {
                activeWindowListener = new WindowActivationListener();
            }
            activeWindowListener.reset();
            Toolkit.getDefaultToolkit().addAWTEventListener(activeWindowListener, 64L);
        }
        ++activeWindowListenerLevel;
    }

    private static void removeWindowActivationListener() {
        if (--activeWindowListenerLevel <= 0 && activeWindowListener != null) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(activeWindowListener);
            activeWindowListener.reset();
            activeWindowListenerLevel = 0;
        }
    }

    private static String _getWindowTitle(Window win) {
        return win == null ? "<null>" : (win instanceof Dialog ? ((Dialog)win).getTitle() : (win instanceof Frame ? ((Frame)win).getTitle() : "?"));
    }

    private static class WindowActivationListener
    implements AWTEventListener {
        private Window activeWindow = null;

        private WindowActivationListener() {
        }

        public void eventDispatched(AWTEvent ev) {
            switch (ev.getID()) {
                case 205: {
                    this.setActiveWindow((Window)ev.getSource());
                    break;
                }
                case 206: {
                    this.reset();
                }
            }
        }

        public void reset() {
            this.activeWindow = null;
        }

        private void setActiveWindow(Window win) {
            this.activeWindow = win;
        }

        public Window getActiveWindow() {
            return this.activeWindow;
        }
    }
}

