/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTree;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class UITreePaneViewer
extends UIControlButtonBox {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UITreePaneViewer.class);
    private static final String SPLIT_NAME = localStrings.getLocalString("ui.uitreepaneviewer.split_name", "Split Pane");
    private static final String SPLIT_DESC = localStrings.getLocalString("ui.uitreepaneviewer.split_desc", "This pane splits this window");
    public static String NodePathSeparator = "/";
    protected JSplitPane splitPane = null;
    protected UITitledTree treeView = null;
    protected UITitledBox cardView = null;

    public UITreePaneViewer(String title, boolean showBorder) {
        super(title, showBorder);
        this.initLayout();
    }

    protected void initLayout() {
        this.setControlButtonLocation(101);
        this.treeView = new UITitledTree(null, false);
        ViewNode root = new ViewNode("<root>", null);
        root.setAllowsChildren(true);
        JTree jt = new JTree(root);
        jt.getAccessibleContext().setAccessibleName(localStrings.getLocalString("ui.uitreepaneviewer.tree_name", "Tree"));
        jt.getAccessibleContext().setAccessibleDescription(localStrings.getLocalString("ui.uitreepaneviewer.tree_desc", "This is a tree view of the contents of the package"));
        this.treeView.setTreeView(jt);
        this.treeView.setRootVisible(false);
        this.treeView.setShowsRootHandles(true);
        this.treeView.addTreeSelectionListener(new SelectionListener());
        this.cardView = new UITitledBox(null, false);
        this.cardView.getGBConstraints().gridy = 0;
        this.splitPane = new JSplitPane(1, this.treeView, this.cardView);
        this.splitPane.getAccessibleContext().setAccessibleName(SPLIT_NAME);
        this.splitPane.getAccessibleContext().setAccessibleDescription(SPLIT_DESC);
        this.splitPane.setDividerLocation(150);
        this.splitPane.setResizeWeight(0.0);
        this.setView(this.splitPane);
    }

    public void setDividerLocation(int loc) {
        this.splitPane.setDividerLocation(loc);
    }

    protected void setCurrentView(Component view) {
        Component[] v = this.cardView.getComponents();
        for (int i = 0; i < v.length; ++i) {
            v[i].setVisible(view == v[i]);
        }
    }

    public void expandRoot() {
        this.expandNode(this.treeView.getRootNode());
    }

    public void expandNode(TreeNode node) {
        this.treeView.expandNode(node);
    }

    public void expandAllNodes() {
        this.treeView.expandAllNodes();
    }

    public void setSelectedNode(DefaultMutableTreeNode node) {
        this.treeView.setSelectedNode(node);
    }

    public TreeNode getNode(String nodePath, boolean create) {
        ViewNode root = (ViewNode)this.treeView.getRootNode();
        if (nodePath == null || nodePath.equals(NodePathSeparator)) {
            return root;
        }
        if (!nodePath.startsWith(NodePathSeparator)) {
            nodePath = NodePathSeparator + nodePath;
        }
        StringTokenizer st = new StringTokenizer(nodePath, NodePathSeparator);
        return this._getNode(root, st, create);
    }

    protected ViewNode _getNode(ViewNode parent, StringTokenizer pathEnum, boolean create) {
        String nextNodeName = null;
        while (pathEnum.hasMoreElements()) {
            String nodeName = pathEnum.nextToken();
            if (nodeName.equals("")) continue;
            nextNodeName = nodeName;
            break;
        }
        if (nextNodeName == null) {
            return parent;
        }
        ViewNode child = this._getChildNode(parent, nextNodeName);
        if (child == null) {
            if (!create) {
                return null;
            }
            child = new ViewNode(nextNodeName);
            this.treeView.addNode(parent, child);
        }
        return this._getNode(child, pathEnum, create);
    }

    protected ViewNode _getChildNode(ViewNode parent, String childName) {
        Enumeration<TreeNode> ch = parent.children();
        while (ch.hasMoreElements()) {
            ViewNode node = (ViewNode)ch.nextElement();
            if (!node.toString().equals(childName)) continue;
            return node;
        }
        return null;
    }

    public ViewNode getNodeForName(String name) {
        return (ViewNode)this.treeView.getNodeForName(name);
    }

    public ViewNode getNodeForName(ViewNode parent, String name) {
        return parent != null ? (ViewNode)this.treeView.getNodeForName(parent, name) : (ViewNode)this.treeView.getNodeForName(name);
    }

    public TreeNode addNode(String nodePath) {
        return this.addNode(nodePath, null);
    }

    public TreeNode addNode(String nodePath, Component view) {
        ViewNode node = (ViewNode)this.getNode(nodePath, true);
        this._setNodeView(node, view);
        return node;
    }

    public MutableTreeNode addNode(String parentPath, String nodeTitle, Component view) {
        ViewNode parent = (ViewNode)this.getNode(parentPath, true);
        ViewNode child = new ViewNode(nodeTitle);
        this.treeView.addNode(parent, child);
        this._setNodeView(child, view);
        return child;
    }

    public void setNodeView(TreeNode node, Component view) {
        if (node instanceof ViewNode) {
            this._setNodeView((ViewNode)node, view);
        }
    }

    protected ViewNode _setNodeView(ViewNode node, Component view) {
        Component oldView = node.getView();
        if (oldView != null) {
            this.cardView.remove(oldView);
        }
        node.setView(view);
        if (view != null) {
            this.cardView.addWithGBConstraints(view);
            view.setVisible(false);
        }
        return node;
    }

    protected class SelectionListener
    implements TreeSelectionListener {
        protected SelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent tse) {
            TreePath selPath = tse.getNewLeadSelectionPath();
            if (selPath != null) {
                ViewNode node = (ViewNode)selPath.getLastPathComponent();
                UITreePaneViewer.this.setCurrentView(node.getView());
            } else {
                UITreePaneViewer.this.setCurrentView(null);
            }
        }
    }

    protected class ViewNode
    extends DefaultMutableTreeNode {
        protected String title;

        public ViewNode(String title) {
            super(null, false);
            this.title = null;
            this.title = title;
        }

        public ViewNode(String title, Component view) {
            super(view, false);
            this.title = null;
            this.title = title;
        }

        public void setView(Component view) {
            super.setUserObject(view);
        }

        public Component getView() {
            return (Component)this.getUserObject();
        }

        public String toString() {
            return this.title;
        }
    }
}

