/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.WinTools;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class UITitledTextArea
extends UITitledBox {
    protected static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UITitledTextArea.class);
    private JScrollPane scrollPane = null;
    private PrivateTextArea textArea = new PrivateTextArea();
    private String lastEnabledText = null;
    private boolean isCancelled = false;

    public UITitledTextArea(String title, boolean showBorder) {
        this(title, showBorder, true);
    }

    public UITitledTextArea(String title, boolean showBorder, boolean scrollable) {
        super(title, showBorder);
        if (scrollable) {
            this.scrollPane = new JScrollPane(this.textArea);
            this.scrollPane.getAccessibleContext().setAccessibleName(localStrings.getLocalString("ui.uititledtextarea.scroll_name", "Scroll Panel"));
            this.scrollPane.getAccessibleContext().setAccessibleDescription(localStrings.getLocalString("ui.uititledtextarea.scroll_desc", "This is a scroll pane"));
            this.add((Component)this.scrollPane, this.getGBConstraints());
        } else {
            this.textArea.setDisabledBackground(this.getBackground());
            this.add((Component)this.textArea, this.getGBConstraints());
            this.setEditable(false);
        }
        this.setLabelComponent(this.textArea);
        this.textArea.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent fe) {
                if (fe.getOppositeComponent() instanceof UIButton && ((UIButton)fe.getOppositeComponent()).getActionCommand().equals("cancel")) {
                    UITitledTextArea.this.isCancelled = true;
                }
                if (!UITitledTextArea.this.isCancelled) {
                    UITitledTextArea.this.updateComponent();
                }
                UITitledTextArea.this.isCancelled = false;
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent ke) {
                if (ke.getKeyCode() == 10) {
                    UITitledTextArea.this.updateComponent();
                }
            }

            public void keyPressed(KeyEvent ke) {
                Dialog dialog = WinTools.getAncestorDialog(UITitledTextArea.this);
                if (ke.getKeyCode() == 27 && dialog != null) {
                    UITitledTextArea.this.isCancelled = true;
                } else {
                    UITitledTextArea.this.isCancelled = false;
                }
            }
        });
    }

    public UITitledTextArea(String title) {
        this(title, false);
    }

    public JTextArea getTextArea() {
        return this.textArea;
    }

    public boolean getLineWrap() {
        return this.textArea.getLineWrap();
    }

    public void setLineWrap(boolean state) {
        this.textArea.setLineWrap(state);
        this.textArea.setWrapStyleWord(state);
    }

    public Font getFont() {
        return this.textArea != null ? this.textArea.getFont() : super.getFont();
    }

    public void setFont(Font font) {
        if (this.textArea != null) {
            this.textArea.setFont(font);
        } else {
            super.setFont(font);
        }
    }

    public void setTextEnabledBackground(Color bg) {
        JTextArea ta = this.getTextArea();
        if (ta instanceof PrivateTextArea) {
            ((PrivateTextArea)ta).setEnabledBackground(bg);
        }
    }

    public void setTextDisabledBackground(Color bg) {
        JTextArea ta = this.getTextArea();
        if (ta instanceof PrivateTextArea) {
            ((PrivateTextArea)ta).setDisabledBackground(bg);
        }
    }

    public void setReadOnly(boolean state) {
        this.textArea.setReadOnly(state);
        super.setReadOnly(state);
    }

    public void setReadOnly(boolean state, boolean isSelectable) {
        this.textArea.setReadOnly(state, isSelectable);
        super.setReadOnly(state);
    }

    public void setEditable(boolean state) {
        this.textArea.setEditable(state);
        super.setReadOnly(!state);
    }

    public void setEnabled(boolean state) {
        this.textArea.setEnabled(state && !this.isReadOnly());
        super.setEnabled(state);
        if (this.clearWhenDisabled) {
            if (!this.isEnabled() && this.lastEnabledText == null) {
                this.lastEnabledText = this.getText();
                this._setText("");
            } else if (this.isEnabled() && this.lastEnabledText != null) {
                this._setText(this.lastEnabledText);
                this.lastEnabledText = null;
            }
        }
    }

    public void addKeyListener(KeyListener kl) {
        this.textArea.addKeyListener(kl);
    }

    public void removeKeyListener(KeyListener kl) {
        this.textArea.removeKeyListener(kl);
    }

    public void setText(String text) {
        if (this.clearWhenDisabled) {
            if (!this.isEnabled()) {
                this.lastEnabledText = text;
            } else {
                this._setText(text);
            }
        } else {
            this._setText(text);
        }
    }

    protected void _setText(String text) {
        if (text == null) {
            text = "";
        }
        this.textArea.setText(text);
        this.textArea.invalidate();
    }

    public void appendText(String text) {
        if (this.clearWhenDisabled) {
            if (!this.isEnabled()) {
                this.lastEnabledText = this.lastEnabledText + text;
            } else {
                this._appendText(text);
            }
        } else {
            this._appendText(text);
        }
    }

    protected void _appendText(String text) {
        this.textArea.append(text);
    }

    public String getText() {
        return this.textArea.getText();
    }

    public String toString() {
        return this.textArea.toString();
    }

    class PrivateTextArea
    extends JTextArea {
        private int isSelectable = 0;
        private Color enabledBackground = Color.white;
        private Color disabledBackground = UITitledBox.DisabledBackgroundColor;

        public PrivateTextArea() {
            this.enabledBackground = super.getBackground();
            super.setDisabledTextColor(UITitledBox.DisabledTextColor);
            super.setLineWrap(true);
            super.setWrapStyleWord(true);
            if (UITitledBox.DefaultTextBorder != null) {
                super.setBorder(UITitledBox.DefaultTextBorder);
            }
            Insets textMargin = this.getMargin();
            if (textMargin.left < 3) {
                textMargin.left = 3;
                super.setMargin(textMargin);
            }
        }

        public void setEnabledBackground(Color bg) {
            Color color = this.enabledBackground = bg != null ? bg : UITitledBox.DisabledBackgroundColor;
            if (this.isEnabled()) {
                this.setBackground(this.enabledBackground);
            }
        }

        public void setDisabledBackground(Color bg) {
            Color color = this.disabledBackground = bg != null ? bg : UITitledBox.DisabledBackgroundColor;
            if (!this.isEnabled()) {
                this.setBackground(this.disabledBackground);
            }
        }

        public void setEnabled(boolean state) {
            if (this.isSelectable == 0) {
                super.setEnabled(state);
            } else if (this.isSelectable == 1) {
                super.setEnabled(true);
                super.setEditable(state);
            } else if (this.isSelectable == -1) {
                super.setEnabled(state);
            }
            this.setBackground(state ? this.enabledBackground : this.disabledBackground);
        }

        public void setReadOnly(boolean state, boolean selectable) {
            this.isSelectable = selectable ? 1 : -1;
            super.setEnabled(!state || selectable);
            super.setEditable(!state);
        }

        public void setReadOnly(boolean state) {
            this.setReadOnly(state, !state);
        }

        public void setEditable(boolean state) {
            this.setEnabled(true);
            super.setEditable(state);
        }

        public void setBackground(Color bg) {
            super.setBackground(bg);
        }
    }
}

