/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIEventQueue;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;

public class UITitledTable
extends UIControlButtonBox {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UITitledTable.class);
    private JTable tableView = null;
    private PropertyChangeListener comboBoxFocustLost = null;
    private FocusListener textFieldFocusLost = null;
    private PopupMenuListener comboBoxPopupListener = null;
    private JComboBox comboBoxEditor = null;
    private EventListenerList selectionListeners = new EventListenerList();
    private ActionListener stopEditingAction = null;

    public UITitledTable(String title, boolean showBorder) {
        super(title, showBorder);
    }

    public UITitledTable(String title, boolean showBorder, JTable table) {
        super(title, showBorder);
        this.setTableView(table);
    }

    public void setView(JComponent comp) {
        if (comp instanceof JTable) {
            Print.printStackTrace((String)"Please use 'setTableView' to set the JTable view");
            super.setView(comp);
        } else {
            Print.printStackTrace((String)"Attempt to set a non-JTable view!");
        }
    }

    public void setTableView(JTable table) {
        super.setView(table, true);
        if (table instanceof InspectorTable) {
            ((InspectorTable)table).setTableOwner(this);
        }
        table.setEnabled(this.isEnabled());
        this.initTableAttributes(table);
    }

    public void setTableView(InspectorTableModel model) {
        this.setTableView(new InspectorTable(model));
    }

    public JTable getTableView() {
        return this.tableView != null ? this.tableView : (JTable)this.getView();
    }

    public InspectorTable getInspectorTableView() {
        return this.getInspectorTable();
    }

    public InspectorTable getInspectorTable() {
        JTable table = this.getTableView();
        if (table instanceof InspectorTable) {
            return (InspectorTable)table;
        }
        if (table == null) {
            Print.printStackTrace((String)("{" + this.getClass().getName() + "} " + "'InspectorTable' is null"));
        } else {
            Print.printStackTrace((String)("{" + this.getClass().getName() + "} " + "Not an InspectorTable: " + table.getClass().getName()));
        }
        return null;
    }

    public InspectorTableModel getInspectorTableModel() {
        InspectorTable table = this.getInspectorTableView();
        return table != null ? table.getInspectorTableModel() : null;
    }

    protected void initTableAttributes(JTable table) {
        if (this.tableView == table) {
            return;
        }
        this.tableView = table;
        this.textFieldFocusLost = new FocusListener(){

            public void focusGained(FocusEvent fe) {
            }

            public void focusLost(FocusEvent fe) {
                if (!fe.isTemporary()) {
                    UITitledTable.this.stopEditing();
                }
            }
        };
        this.comboBoxFocustLost = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent pce) {
                if ("AccessibleState".equals(pce.getPropertyName()) && AccessibleState.FOCUSED.equals(pce.getOldValue())) {
                    JComboBox cb;
                    AccessibleContext ac = (AccessibleContext)pce.getSource();
                    Accessible child = ac.getAccessibleChild(0);
                    Accessible parent = child != null ? child.getAccessibleContext().getAccessibleParent() : null;
                    JComboBox jComboBox = cb = parent instanceof JComboBox ? (JComboBox)parent : UITitledTable.this.comboBoxEditor;
                    if (!cb.isPopupVisible()) {
                        UITitledTable.this.stopEditing();
                    } else {
                        Print.dprintln((String)"'stopEditing' ignored - ComboBox is still visible");
                    }
                }
            }
        };
        PropertyChangeListener editorListener = new PropertyChangeListener(){
            DefaultCellEditor lastEditor = null;

            public void propertyChange(PropertyChangeEvent pce) {
                this._removeLastFocusListener();
                this._addNewFocusListener(pce.getNewValue());
            }

            private void _addNewFocusListener(Object editor) {
                if (editor != null && editor instanceof DefaultCellEditor) {
                    DefaultCellEditor dce = (DefaultCellEditor)editor;
                    Component c = dce.getComponent();
                    if (c instanceof JTextComponent) {
                        c.addFocusListener(UITitledTable.this.textFieldFocusLost);
                        c.requestFocus();
                        this.lastEditor = dce;
                    } else if (c instanceof JComboBox) {
                        AccessibleContext ac = ((Accessible)((Object)c)).getAccessibleContext();
                        UITitledTable.this.comboBoxEditor = (JComboBox)c;
                        ac.addPropertyChangeListener(UITitledTable.this.comboBoxFocustLost);
                        this.lastEditor = dce;
                    }
                }
            }

            private void _removeLastFocusListener() {
                if (this.lastEditor != null) {
                    Component c = this.lastEditor.getComponent();
                    if (c instanceof JTextComponent) {
                        c.removeFocusListener(UITitledTable.this.textFieldFocusLost);
                    } else if (c instanceof JComboBox) {
                        AccessibleContext ac = ((Accessible)((Object)c)).getAccessibleContext();
                        ac.removePropertyChangeListener(UITitledTable.this.comboBoxFocustLost);
                        UITitledTable.this.comboBoxEditor = null;
                    }
                    this.lastEditor = null;
                }
            }
        };
        table.addPropertyChangeListener("tableCellEditor", editorListener);
        table.getSelectionModel().addListSelectionListener(this);
        this.comboBoxPopupListener = new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent pme) {
                UITitledTable.this.stopEditing(false);
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent pme) {
                UITitledTable.this.stopEditing(false);
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent pme) {
            }
        };
        Enumeration<TableColumn> columns = this.getTableView().getColumnModel().getColumns();
        while (columns.hasMoreElements()) {
            Component c;
            TableColumn tc = columns.nextElement();
            TableCellEditor tce = tc.getCellEditor();
            if (!(tce instanceof DefaultCellEditor) || !((c = ((DefaultCellEditor)tce).getComponent()) instanceof JComboBox)) continue;
            JComboBox cb = (JComboBox)c;
            Accessible ac = cb.getUI().getAccessibleChild(cb, 0);
            if (ac instanceof JPopupMenu) {
                ((JPopupMenu)ac).addPopupMenuListener(this.comboBoxPopupListener);
                continue;
            }
            Print.dprintln((String)("Unknown Accessible class - " + ac.getClass().getName()));
        }
    }

    public void setEnabled(boolean state) {
        super.setEnabled(state);
        if (this.getTableView() != null) {
            this.getTableView().setEnabled(state);
        }
    }

    public void setReadOnly(boolean state) {
        super.setReadOnly(state);
    }

    public void stopEditing() {
        JTable tbl = this.getTableView();
        if (tbl.isEditing()) {
            tbl.editingStopped(new ChangeEvent(this));
        }
    }

    public void stopEditing(boolean now) {
        if (now) {
            this.stopEditing();
        } else {
            UIEventQueue.invokeLater(new Thread(){

                public void run() {
                    UITitledTable.this.stopEditing();
                }
            });
        }
    }

    public TableModel getModel() {
        return this.getTableView().getModel();
    }

    public boolean isSelectionEmpty() {
        InspectorTable table = this.getInspectorTableView();
        return table != null ? table.isSelectionEmpty() : true;
    }

    public Object getSelectedValue() {
        return this.getSelectedRowObject();
    }

    public int getSelectedRow() {
        return this.getTableView().getSelectedRow();
    }

    public Object getSelectedRowObject() {
        InspectorTable table = this.getInspectorTableView();
        return table != null ? table.getSelectedRowObject() : null;
    }

    public Object[] getSelectedRowObjects() {
        InspectorTable table = this.getInspectorTableView();
        return table != null ? table.getSelectedRowObjects() : null;
    }

    public void addSelectedIndex(int ndx) {
        InspectorTable table = this.getInspectorTableView();
        if (table != null) {
            table.addSelectedIndex(ndx);
        }
    }

    public void setSelectedIndex(int ndx) {
        InspectorTable table = this.getInspectorTableView();
        if (table != null) {
            table.setSelectedIndex(ndx);
        }
    }

    public void setSelectedRowObject(Object ref) {
        InspectorTable table = this.getInspectorTableView();
        if (table != null) {
            table.setSelectedRowObject(ref);
        }
    }

    public void selectRowWithValue(int col, String val) {
        InspectorTable table = this.getInspectorTableView();
        if (table != null) {
            table.selectRowWithValue(col, val);
        }
    }

    public void selectRowWithValueOnUpdate(int col, String val) {
        InspectorTable table = this.getInspectorTableView();
        if (table != null) {
            table.selectRowWithValueOnUpdate(col, val);
        }
    }

    public int findRowWithValue(int start, int col, Object val) {
        InspectorTable table = this.getInspectorTableView();
        return table != null ? table.findRowWithValue(start, col, val) : -1;
    }

    public Object getRowWithValue(int col, Object value) {
        InspectorTableModel model = this.getInspectorTableModel();
        return model != null ? model.getRowWithValue(col, value) : null;
    }

    public Object getRowWithValue(int startRow, int col, Object value) {
        InspectorTableModel model = this.getInspectorTableModel();
        return model != null ? model.getRowWithValue(startRow, col, value) : null;
    }

    public void selectBlankRow() {
        this.selectBlankRow(0);
    }

    public void selectBlankRow(int columnKey) {
        InspectorTable table = this.getInspectorTableView();
        if (table != null) {
            table.selectBlankRow(columnKey);
        }
    }

    public Object[] confirmDeleteSelection(String msg, String title) {
        InspectorTable table = this.getInspectorTableView();
        return table != null ? table.confirmDeleteSelection(msg, title) : null;
    }

    public void addRowObject(Object ref) {
        InspectorTable table = this.getInspectorTableView();
        if (table != null) {
            table.addRowObject(ref);
        }
    }

    public void removeRowObjects(Object[] list) {
        InspectorTable table = this.getInspectorTableView();
        if (table != null) {
            table.removeRowObjects(list);
        }
    }

    public int getRowCount() {
        InspectorTable table = this.getInspectorTableView();
        return table != null ? table.getRowCount() : -1;
    }

    public List getTableData() {
        InspectorTable table = this.getInspectorTableView();
        return table != null ? table.getTableData() : null;
    }

    public void clear() {
        InspectorTable table = this.getInspectorTableView();
        if (table != null) {
            table.clearTableData();
        }
    }

    public void clearTableData() {
        this.clear();
    }

    public void updateTableData(Collection c) {
        InspectorTable table = this.getInspectorTableView();
        if (table != null) {
            table.updateTableData(c);
        }
    }

    public void setModel(Collection c) {
        this.updateTableData(c);
    }

    public void updateTableData(Set s) {
        InspectorTable table = this.getInspectorTableView();
        if (table != null) {
            table.updateTableData(s);
        }
    }

    public void setModel(Set c) {
        this.updateTableData(c);
    }

    public void updateTableData(Enumeration e) {
        InspectorTable table = this.getInspectorTableView();
        if (table != null) {
            table.updateTableData(e);
        }
    }

    public void setModel(Enumeration e) {
        this.updateTableData(e);
    }

    public void updateTableData(Object[] e) {
        InspectorTable table = this.getInspectorTableView();
        if (table != null) {
            table.updateTableData(e);
        }
    }

    public void setModel(Object[] e) {
        this.updateTableData(e);
    }

    public void setButtonsEnabled(boolean state) {
        JTable tbl = this.getTableView();
        boolean hasSelection = tbl != null && tbl.getSelectedRow() >= 0;
        super.setButtonsEnabled(state, this.selectionControlList, state && hasSelection);
    }

    public ListSelectionModel getSelectionModel() {
        return this.getTableView().getSelectionModel();
    }

    public void clearSelection() {
        this.getSelectionModel().clearSelection();
    }

    public void addListSelectionListener(ListSelectionListener obj) {
        this.selectionListeners.add(ListSelectionListener.class, obj);
    }

    public void removeListSelectionListener(ListSelectionListener obj) {
        this.selectionListeners.remove(ListSelectionListener.class, obj);
    }

    public void valueChanged(ListSelectionEvent lse) {
        InspectorTable table;
        super.valueChanged(lse);
        if (lse.getValueIsAdjusting()) {
            return;
        }
        if (this.getTableView() instanceof InspectorTable && (table = this.getInspectorTableView()).isSettingSelection()) {
            return;
        }
        Object[] listeners = this.selectionListeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$ListSelectionListener == null ? UITitledTable.class$("javax.swing.event.ListSelectionListener") : class$javax$swing$event$ListSelectionListener)) continue;
            ((ListSelectionListener)listeners[i + 1]).valueChanged(lse);
        }
    }

    public InspectorTableModel.InspectorDataWrapper wrapDataItem(Object obj) {
        InspectorTableModel model = this.getInspectorTableModel();
        return model != null ? model.wrapDataItem(obj) : null;
    }

    public InspectorTableModel.InspectorDataWrapper wrapDataItem(Object[] obj) {
        InspectorTableModel model = this.getInspectorTableModel();
        return model != null ? model.wrapDataItem(obj) : null;
    }

    public Vector wrapData(Collection objSet) {
        InspectorTableModel model = this.getInspectorTableModel();
        return model != null ? model.wrapData(objSet) : null;
    }

    public Vector wrapData(Enumeration objEnum) {
        InspectorTableModel model = this.getInspectorTableModel();
        return model != null ? model.wrapData(objEnum) : null;
    }

    public Vector wrapData(Iterator objIter) {
        InspectorTableModel model = this.getInspectorTableModel();
        return model != null ? model.wrapData(objIter) : null;
    }

    public List unwrapData(List wrapperList) {
        InspectorTableModel model = this.getInspectorTableModel();
        return model != null ? model.unwrapData(wrapperList) : null;
    }

    public void initSingleColumnTable(String title) {
        this.setTableView(this.createSingleColumnTable(title));
    }

    public InspectorTable createSingleColumnTable(String title) {
        return new SingleColumnTable(title);
    }

    private void installStopEditngAction() {
        if (this.stopEditingAction == null) {
            this.stopEditingAction = new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    UITitledTable.this.stopEditing();
                }
            };
            Enumeration enumeration = this.controlList.elements();
            while (enumeration.hasMoreElements()) {
                Object comp = enumeration.nextElement();
                if (!(comp instanceof AbstractButton)) continue;
                AbstractButton btn = (AbstractButton)comp;
                btn.addActionListener(this.stopEditingAction);
            }
        }
    }

    public static class SingleColumnTableModel
    extends InspectorTableModel {
        protected boolean isEditable = true;

        public SingleColumnTableModel(String title, boolean editable) {
            super(new String[]{title});
            this.setEditable(editable);
        }

        public SingleColumnTableModel(String title) {
            this(title, true);
        }

        public void setEditable(boolean editable) {
            this.isEditable = editable;
        }

        public boolean isCellEditable() {
            return this.isEditable;
        }

        public Object getObjectValue(Object obj, int col) {
            if (col != 0) {
                return "";
            }
            if (obj instanceof InspectorTableModel.InspectorDataWrapper) {
                return ((InspectorTableModel.InspectorDataWrapper)obj).getObject();
            }
            return obj;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            if (col != 0) {
                return;
            }
            if (obj instanceof InspectorTableModel.InspectorDataWrapper) {
                ((InspectorTableModel.InspectorDataWrapper)obj).setObject(value);
            } else {
                Print.dprintln((String)("Unable to set object value: " + DT.className(obj)));
            }
        }
    }

    public static class SingleColumnTable
    extends InspectorTable {
        public SingleColumnTable(String title) {
            super(new SingleColumnTableModel(title));
        }
    }
}

