/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorTools;
import com.sun.enterprise.tools.deployment.ui.shared.WSDLParser;
import com.sun.enterprise.tools.deployment.ui.utils.UIProject;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.namespace.QName;

public class UITitledQName
extends UITitledBox {
    private static final boolean USE_NAMESPACE_COMBO = true;
    public static final int SERVICE_QNAMES = 1;
    public static final int PORT_QNAMES = 2;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UITitledQName.class);
    private static String QNAME_TITLE = localStrings.getLocalString("ui.uititledqname.qname", "QName");
    private static String QNAME_NAMESPACE = localStrings.getLocalString("ui.uititledqname.qname.namespace", "Namespace:");
    private static String QNAME_LOCALPART = localStrings.getLocalString("ui.uititledqname.wsdl_port.local_part", "Local Part:");
    private Hashtable qnameModel = null;
    private int suspendLocalPartUpdate = 0;
    private UITitledBox wsdlPortNamespace = new UITitledComboBox(QNAME_NAMESPACE, false);
    private UITitledBox wsdlPortLocalPart = null;

    public UITitledQName(String title, boolean showBorder, boolean required) {
        super(title, showBorder);
        ((UITitledComboBox)this.wsdlPortNamespace).setEditable(true);
        this.wsdlPortLocalPart = new UITitledComboBox(QNAME_LOCALPART, false);
        ((UITitledComboBox)this.wsdlPortLocalPart).setEditable(true);
        this.wsdlPortNamespace.setRequired(required);
        this.wsdlPortNamespace.setClearWhenDisabled(true);
        this.wsdlPortNamespace.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                UITitledQName.this.suspendLocalPartUpdate++;
                if (UITitledQName.this.wsdlPortLocalPart instanceof UITitledComboBox && UITitledQName.this.qnameModel != null) {
                    String text = UITitledQName.this.getNamespace();
                    Vector localParts = (Vector)UITitledQName.this.qnameModel.get(text);
                    ((UITitledComboBox)UITitledQName.this.wsdlPortLocalPart).setModel(localParts);
                    if (localParts != null && localParts.size() > 1) {
                        ((UITitledComboBox)UITitledQName.this.wsdlPortLocalPart).setSelectedIndex(-1);
                    }
                }
                UITitledQName.this.updateComponent(UITitledQName.this);
                UITitledQName.this.suspendLocalPartUpdate--;
            }
        });
        this.wsdlPortLocalPart.setRequired(required);
        this.wsdlPortLocalPart.setClearWhenDisabled(true);
        this.wsdlPortLocalPart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (UITitledQName.this.suspendLocalPartUpdate == 0) {
                    UITitledQName.this.updateComponent(UITitledQName.this);
                }
            }
        });
        this.getGBConstraints().weighty = 0.0;
        this.getGBConstraints().fill = 2;
        this.addWithGBConstraints(this.wsdlPortNamespace);
        this.addWithGBConstraints(this.wsdlPortLocalPart);
    }

    public UITitledQName(String title, boolean showBorder) {
        this(title, showBorder, true);
    }

    public UITitledQName(String title) {
        this(title, true);
    }

    public UITitledQName() {
        this(QNAME_TITLE, true);
    }

    public void setQNameModel(Descriptor d, String wsdlFile, int type, boolean updateComponent) {
        Vector localParts;
        Vector<String> namespace;
        block23: {
            namespace = new Vector<String>();
            localParts = new Vector();
            if (this.qnameModel == null) {
                this.qnameModel = new Hashtable();
            }
            this.qnameModel.clear();
            if (wsdlFile != null && !wsdlFile.equals("")) {
                try {
                    if (!new File(wsdlFile).isAbsolute() && d != null) {
                        BundleDescriptor bd = DescriptorTools.getBundleDescriptor(d);
                        if (bd != null) {
                            File jarDir = UIProject.getJarFile((Descriptor)bd, true);
                            if (jarDir.isDirectory()) {
                                wsdlFile = new File(jarDir, wsdlFile).getAbsolutePath();
                            } else {
                                Print.dprintln((String)("Not a directory: " + jarDir));
                            }
                        } else {
                            Print.dprintln((String)("Can't find BundleDescriptor: " + wsdlFile));
                        }
                    }
                    Print.dprintln((String)("Parsing file: " + wsdlFile));
                    WSDLParser doc = new WSDLParser(wsdlFile);
                    WSDLParser.QName[] qn = null;
                    if (type == 1) {
                        qn = doc.getAllServiceQNames();
                    } else if (type == 2) {
                        qn = doc.getAllPortQNames();
                    } else {
                        Print.dprintStackTrace((String)("Unknown QName request type: " + type));
                        qn = new WSDLParser.QName[]{};
                    }
                    if (qn.length > 0) {
                        for (int i = 0; i < qn.length; ++i) {
                            String ns = qn[i].namespace;
                            Print.dprintln((String)("Found Namespace: " + ns));
                            namespace.add(ns);
                            Vector<String> list = (Vector<String>)this.qnameModel.get(ns);
                            if (list == null) {
                                list = new Vector<String>();
                                this.qnameModel.put(ns, list);
                            }
                            list.add(qn[i].localpart);
                        }
                        break block23;
                    }
                    Print.println((String)"QName list is empty!");
                }
                catch (Throwable t) {
                    Print.dprintStackTrace((String)("Unable to parse WSDL file: " + wsdlFile), (Throwable)t);
                }
            } else {
                Print.dprintln((String)"Specified WSDL file is null (clearing model)");
            }
        }
        if (this.wsdlPortNamespace instanceof UITitledComboBox) {
            UITitledComboBox cb = (UITitledComboBox)this.wsdlPortNamespace;
            cb.setModel(namespace);
            if (namespace.size() > 1) {
                ((UITitledComboBox)this.wsdlPortNamespace).setSelectedIndex(-1);
            }
        }
        if (this.wsdlPortLocalPart instanceof UITitledComboBox) {
            String text = this.getNamespace();
            if (text != null && !text.trim().equals("")) {
                localParts = (Vector)this.qnameModel.get(text);
            }
            ((UITitledComboBox)this.wsdlPortLocalPart).setModel(localParts);
            if (localParts.size() > 1) {
                ((UITitledComboBox)this.wsdlPortLocalPart).setSelectedIndex(-1);
            }
            if (updateComponent) {
                this.updateComponent(this);
            }
        }
    }

    public void setReadOnly(boolean state) {
        super.setReadOnly(state);
        this.wsdlPortNamespace.setReadOnly(state);
        this.wsdlPortLocalPart.setReadOnly(state);
    }

    public void setChildrenReadOnly(boolean state) {
    }

    public void setEnabled(boolean state) {
        super.setEnabled(state);
        if (this.wsdlPortNamespace.isEnabled() != state) {
            this.wsdlPortNamespace.setEnabled(state);
            this.wsdlPortLocalPart.setEnabled(state);
        }
    }

    public void setEditable(boolean editable) {
        if (this.wsdlPortNamespace instanceof UITitledComboBox) {
            ((UITitledComboBox)this.wsdlPortNamespace).setEditable(editable);
            ((UITitledComboBox)this.wsdlPortLocalPart).setEditable(editable);
        } else if (this.wsdlPortNamespace instanceof UITitledTextField) {
            // empty if block
        }
    }

    public boolean checkRequired() {
        if (!this.wsdlPortNamespace.checkRequired()) {
            return false;
        }
        return this.wsdlPortLocalPart.checkRequired();
    }

    public boolean checkRequired(boolean showErrors) {
        if (!this.wsdlPortNamespace.checkRequired(showErrors)) {
            return false;
        }
        return this.wsdlPortLocalPart.checkRequired(showErrors);
    }

    public String getNamespace() {
        return this.wsdlPortNamespace.getText();
    }

    public void setNamespace(String namespace) {
        if (this.wsdlPortNamespace instanceof UITitledComboBox) {
            ((UITitledComboBox)this.wsdlPortNamespace).setSelectedItem(namespace, true);
        } else {
            this.wsdlPortNamespace.setText(namespace);
        }
    }

    public String getLocalPart() {
        return this.wsdlPortLocalPart.getText();
    }

    public void setLocalPart(String localpart) {
        if (this.wsdlPortLocalPart instanceof UITitledComboBox) {
            ((UITitledComboBox)this.wsdlPortLocalPart).setSelectedItem(localpart, true);
        } else {
            this.wsdlPortLocalPart.setText(localpart);
        }
    }

    public void setQName(QName port) {
        this.setNamespace(port != null ? port.getNamespaceURI() : null);
        this.setLocalPart(port != null ? port.getLocalPart() : null);
    }

    public QName getQName() {
        return new QName(this.getNamespace(), this.getLocalPart());
    }
}

