/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorTools;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIIcons;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;

public class UITitledList
extends UIControlButtonBox {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UITitledList.class);
    private static String LIST_NAME = localStrings.getLocalString("ui.uititledlist.list_name", "List");
    private static String LIST_DESC = localStrings.getLocalString("ui.uititledlist.list_desc", "This is a list of items");
    private static String LABEL_NAME = localStrings.getLocalString("ui.uititledlist.label_name", "Label");
    private static String LABEL_DESC = localStrings.getLocalString("ui.uititledlist.label_desc", "This is a label");
    private static ListCellRenderer textCellRenderer = null;
    private static ListCellRenderer descriptorCellRenderer = null;
    private static Comparator listItemComparator = null;

    public UITitledList(String title, boolean showBorder) {
        super(title, showBorder);
    }

    public UITitledList(String title, boolean showBorder, JList list) {
        super(title, showBorder);
        this.setListView(list);
        this.setLabelComponent(list);
    }

    public JList createDefaultListView() {
        return this.createDefaultListView(false);
    }

    public JList createDefaultListView(boolean includeIcon) {
        PrivateList list = new PrivateList(new PrivateListModel());
        list.setCellRenderer(this.getDefaultTextCellRenderer(includeIcon));
        return list;
    }

    public void setIncludeRendererIcon(boolean inclIcon) {
        ListCellRenderer cr = this.getListView().getCellRenderer();
        if (cr instanceof TextCellRenderer) {
            ((TextCellRenderer)cr).setIncludeIcon(inclIcon);
        } else {
            Print.printStackTrace((String)"Cannot set TextCellRender attribute");
        }
    }

    public void setListView(JList list) {
        this.setListView(list, true);
    }

    public void setListView(JList list, boolean scrollable) {
        super.setView(list, scrollable);
        list.getSelectionModel().addListSelectionListener(this);
    }

    public JList getListView() {
        if (this.getView() == null) {
            this.setListView(this.createDefaultListView(false));
        }
        return (JList)this.getView();
    }

    public void setEnabled(boolean state) {
        JList list = this.getListView();
        list.setEnabled(state);
        super.setEnabled(state);
    }

    public void setButtonsEnabled(boolean state) {
        boolean hasSelection = !this.getListView().isSelectionEmpty();
        super.setButtonsEnabled(state, this.selectionControlList, state && hasSelection);
    }

    public void setCellRenderer(ListCellRenderer lcr) {
        this.getListView().setCellRenderer(lcr);
    }

    public void setDescriptorCellRenderer() {
        Print.dprintStackTrace((int)1, (String)"'setDescriptorCellRenderer' is no longer necessary");
        this.setCellRenderer(this.getDescriptorCellRenderer());
    }

    public void setLayoutOrientation(int layoutOrientation) {
        this.getListView().setLayoutOrientation(layoutOrientation);
    }

    public void setVerticalWrap(boolean state) {
        this.setLayoutOrientation(state ? 1 : 0);
        if (state) {
            this.getListView().setVisibleRowCount(-1);
        }
    }

    public void setHorizontalWrap(boolean state) {
        this.setLayoutOrientation(state ? 2 : 0);
    }

    protected PrivateListModel getListModel() {
        PrivateListModel model = this.getListView().getModel();
        if (!(model instanceof PrivateListModel)) {
            model = new PrivateListModel(model);
            this.getListView().setModel(model);
        }
        return model;
    }

    public ListModel getModel() {
        return this.getListView().getModel();
    }

    public void setModel(ListModel model) {
        this.getListModel().setData(model);
    }

    public void setModel(Object[] data) {
        this.getListModel().setData(data);
    }

    public void updateTableData(Object[] data) {
        this.setModel(data);
    }

    public void setListData(Object[] data) {
        this.setModel(data);
    }

    public void setModel(Collection c) {
        this.getListModel().setData(c);
    }

    public void updateTableData(Collection data) {
        this.setModel(data);
    }

    public void setListData(Collection data) {
        this.setModel(data);
    }

    public void setModel(Enumeration enumeration) {
        Vector data = new Vector();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                data.add(enumeration.nextElement());
            }
        }
        this.setModel(data);
    }

    public void updateTableData(Enumeration data) {
        this.setModel(data);
    }

    public void setListData(Enumeration data) {
        this.setModel(data);
    }

    public void setModel(Iterator iter) {
        Vector data = new Vector();
        if (iter != null) {
            while (iter.hasNext()) {
                data.add(iter.next());
            }
        }
        this.setModel(data);
    }

    public void updateTableData(Iterator data) {
        this.setModel(data);
    }

    public void setListData(Iterator data) {
        this.setModel(data);
    }

    public Vector getListData() {
        Vector data = new Vector();
        ListModel model = this.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            data.add(model.getElementAt(i));
        }
        return data;
    }

    public int getListDataCount() {
        return this.getModel().getSize();
    }

    public Object getListDataAt(int row) {
        return this.getModel().getElementAt(row);
    }

    public int getIndexOf(Object item) {
        ListModel model = this.getModel();
        int size = model.getSize();
        for (int r = 0; r < size; ++r) {
            if (!model.getElementAt(r).equals(item)) continue;
            return r;
        }
        return -1;
    }

    public int getIndexOfTitle(String item) {
        ListModel model = this.getModel();
        int size = model.getSize();
        for (int i = 0; i < size; ++i) {
            if (!this.getTitleAt(i).equals(item)) continue;
            return i;
        }
        return -1;
    }

    public String getTitleAt(int ndx) {
        ListModel model = this.getModel();
        if (ndx >= 0 && ndx < model.getSize()) {
            Object obj = model.getElementAt(ndx);
            if (obj instanceof Descriptor) {
                return ((Descriptor)obj).getDisplayName();
            }
            return obj.toString();
        }
        return null;
    }

    public boolean containsListItem(Object item) {
        return this.getListModel().contains(item);
    }

    public void addListItem(Object item) {
        this.getListModel().addElement(item);
    }

    public void addListItems(Object[] items) {
        if (items == null || items.length == 0) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            if (this.containsListItem(items[i])) continue;
            this.getListModel().addElement(items[i]);
        }
    }

    public boolean removeListItem(Object item) {
        return this.getListModel().removeElement(item);
    }

    public boolean removeListItems(Object[] items) {
        if (items == null || items.length == 0) {
            return false;
        }
        boolean didRemove = true;
        for (int i = 0; i < items.length; ++i) {
            if (this.removeListItem(items[i])) continue;
            didRemove = false;
        }
        return didRemove;
    }

    public void clear() {
        this.getListModel().clear();
    }

    public void setSorted(boolean sort) {
        this.getListModel().setSorted(sort);
    }

    public boolean isSorted() {
        return this.getListModel().isSorted();
    }

    public void setHeaderText(String title) {
        JComponent b = this.getBannerView();
        if (b instanceof JLabel) {
            ((JLabel)b).setText(title);
        } else if (b instanceof AbstractButton) {
            ((AbstractButton)b).setText(title);
        } else if (b instanceof JTextComponent) {
            ((JTextComponent)b).setText(title);
        } else {
            JLabel banner = new JLabel(title, 0);
            banner.getAccessibleContext().setAccessibleName(LABEL_NAME);
            banner.getAccessibleContext().setAccessibleDescription(LABEL_DESC);
            banner.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            banner.setForeground(UIManager.getColor("TableHeader.foreground"));
            banner.setBackground(UIManager.getColor("TableHeader.background"));
            banner.setFont(UIManager.getFont("TableHeader.font"));
            super.setBannerView(banner);
        }
    }

    public int getColumnCount() {
        return 1;
    }

    public void clearTableData() {
        this.clear();
    }

    public boolean isSelectionEmpty() {
        return this.getListView().isSelectionEmpty();
    }

    public Object getSelectedValue() {
        return this.getListView().getSelectedValue();
    }

    public Object[] getSelectedValues() {
        return this.getListView().getSelectedValues();
    }

    public int getSelectedIndex() {
        return this.getListView().getSelectedIndex();
    }

    public void setSelectedIndex(int index) {
        if (index >= 0) {
            this.getListView().setSelectedIndex(index);
        } else {
            this.getListView().clearSelection();
        }
    }

    public void setSelectedValue(String val) {
        this.setSelectedIndex(this.getIndexOfTitle(val));
    }

    public void selectBlankRow() {
        this.setSelectedValue("");
    }

    public void clearSelection() {
        this.getListView().clearSelection();
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.getListView().addListSelectionListener(listener);
    }

    public void setSelectionMode(int selectionMode) {
        this.getListView().setSelectionMode(selectionMode);
    }

    public Object[] confirmDeleteSelection(String msg, String title) {
        Object[] ref = this.getSelectedValues();
        if (ref != null && ref.length > 0) {
            String optMsg;
            String string = optMsg = msg == null ? localStrings.getLocalString("ui.uititledlist.confirm_delete_selection", "Are you sure you want to delete the selected items?") : msg;
            if (UIOptionPane.showConfirmDialog(this, optMsg)) {
                return ref;
            }
        } else {
            UIOptionPane.showWarningDialog(this, localStrings.getLocalString("ui.uititledlist.firstselectitemtodelete", "You must first select an item from the list"));
        }
        return null;
    }

    public ListCellRenderer getDefaultTextCellRenderer(boolean includeIcon) {
        if (textCellRenderer == null) {
            textCellRenderer = new TextCellRenderer(includeIcon);
        }
        return textCellRenderer;
    }

    private ListCellRenderer getDescriptorCellRenderer() {
        if (descriptorCellRenderer == null) {
            descriptorCellRenderer = new TextCellRenderer();
        }
        return descriptorCellRenderer;
    }

    protected static Comparator GetListItemComparator() {
        if (listItemComparator == null) {
            listItemComparator = new SortedListItemComparator();
        }
        return listItemComparator;
    }

    protected static class SortedListItemComparator
    implements Comparator {
        protected SortedListItemComparator() {
        }

        public int compare(Object o1, Object o2) {
            return o1.toString().toLowerCase().compareTo(o2.toString().toLowerCase());
        }

        public boolean equals(Object o) {
            return super.equals(o);
        }
    }

    protected class PrivateListModel
    extends AbstractListModel {
        protected boolean isSorted = false;
        protected Vector listData = new Vector();

        public PrivateListModel() {
        }

        public PrivateListModel(ListModel lm) {
            this();
            this.setData(lm);
        }

        public PrivateListModel(Collection c) {
            this();
            this.setData(c);
        }

        public PrivateListModel(Object[] m) {
            this();
            this.setData(m);
        }

        public void setData(ListModel lm) {
            this.listData.clear();
            int size = lm.getSize();
            for (int i = 0; i < size; ++i) {
                this.addElement(lm.getElementAt(i));
            }
            this.fireContentsChanged(this, 0, this.getSize() - 1);
        }

        public void setData(Collection c) {
            this.listData.clear();
            int size = c.size();
            Iterator i = c.iterator();
            while (i.hasNext()) {
                this.addElement(i.next());
            }
            this.fireContentsChanged(this, 0, this.getSize() - 1);
        }

        public void setData(Object[] m) {
            this.listData.clear();
            int size = m.length;
            for (int i = 0; i < size; ++i) {
                this.addElement(m[i]);
            }
            this.fireContentsChanged(this, 0, this.getSize() - 1);
        }

        public void addListDataListener(ListDataListener l) {
            super.addListDataListener(l);
        }

        public void removeListDataListener(ListDataListener l) {
            super.removeListDataListener(l);
        }

        public int getSize() {
            return this.listData.size();
        }

        public boolean isEmpty() {
            return this.listData.isEmpty();
        }

        public boolean contains(Object obj) {
            return this.listData.contains(obj);
        }

        public Object getElementAt(int ndx) {
            return this.listData.elementAt(ndx);
        }

        public void addElement(Object obj) {
            if (this.isSorted()) {
                int loc = Collections.binarySearch(this.listData, obj, UITitledList.GetListItemComparator());
                if (loc < 0) {
                    loc = -(loc + 1);
                }
                this.insertElementAt(obj, loc);
            } else {
                this.insertElementAt(obj, -1);
            }
        }

        public void insertElementAt(Object obj, int ndx) {
            if (ndx >= 0) {
                this.listData.insertElementAt(obj, ndx);
                this.fireIntervalAdded(this, ndx, ndx);
            } else {
                int loc = this.getSize();
                this.listData.addElement(obj);
                this.fireIntervalAdded(this, loc, loc);
            }
        }

        public boolean removeElement(Object obj) {
            int loc = this.listData.indexOf(obj);
            if (loc >= 0) {
                boolean removed = this.listData.removeElement(obj);
                this.fireIntervalRemoved(this, loc, loc);
                return removed;
            }
            return false;
        }

        public void clear() {
            if (!this.isEmpty()) {
                int size = this.getSize();
                this.listData.clear();
                this.fireIntervalRemoved(this, 0, size - 1);
            }
        }

        public boolean isSorted() {
            return this.isSorted;
        }

        public void setSorted(boolean sort) {
            this.isSorted = sort;
            if (this.isSorted) {
                this.sort();
            }
        }

        public void sort() {
            if (!this.isEmpty()) {
                Collections.sort(this.listData, UITitledList.GetListItemComparator());
                this.fireContentsChanged(this, 0, this.getSize() - 1);
            }
        }
    }

    protected class PrivateList
    extends JList {
        public PrivateList(ListModel model) {
            super(model);
            this.getAccessibleContext().setAccessibleName(LIST_NAME);
            this.getAccessibleContext().setAccessibleDescription(LIST_DESC);
            this.setFixedCellHeight(18);
            this.setSelectionMode(0);
            this.setBackground(UIManager.getColor("Panel.background"));
        }

        public Color getBackground() {
            if (UITitledList.this == null) {
                return super.getBackground();
            }
            if (!this.isEnabled()) {
                return UITitledBox.DisabledBackgroundColor;
            }
            return UITitledList.this.isScrollable() ? super.getBackground() : UITitledList.this.getBackground();
        }

        public void setEnabled(boolean enabled) {
            if (this.isEnabled() != enabled) {
                super.setEnabled(enabled);
                this.repaint();
            }
        }

        public void setModel(ListModel model) {
            super.setModel(model);
        }
    }

    private static class TextCellRenderer
    extends DefaultListCellRenderer {
        private boolean includeIcon = false;

        public TextCellRenderer() {
        }

        public TextCellRenderer(boolean inclIcon) {
            this();
            this.setIncludeIcon(inclIcon);
        }

        public void setIncludeIcon(boolean inclIcon) {
            this.includeIcon = inclIcon;
        }

        public Component getListCellRendererComponent(JList jl, Object val, int n, boolean sel, boolean focus) {
            Object v = null;
            if (val instanceof Descriptor) {
                v = DescriptorTools.getDisplayName(val);
                if (v.equals("")) {
                    String cn = val.getClass().getName();
                    int p = cn.lastIndexOf(".");
                    if (p >= 0) {
                        cn = cn.substring(p + 1);
                    }
                    v = cn + " #" + val.hashCode();
                }
            } else {
                v = val instanceof Class ? ((Class)val).getName() : val;
            }
            super.getListCellRendererComponent((JList<?>)jl, v, n, sel, focus);
            this.setEnabled(true);
            if (this.includeIcon) {
                this.setIcon(UIIcons.getIconFor(val));
            }
            return this;
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Dimension s = this.getSize();
            g.setColor(Color.gray);
            g.drawLine(0, s.height - 1, s.width, s.height - 1);
        }
    }
}

