/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.utils.UIActionDispatcher;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UICheckBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIEventQueue;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIPanel;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextArea;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class UITitledBox
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UITitledBox.class);
    private static String LABEL_NAME = localStrings.getLocalString("ui.uititledbox.label_name", "Title Label");
    private static String LABEL_DESC = localStrings.getLocalString("ui.uititledbox.label_desc", "This is a label for the title");
    private static String PANEL_NAME = localStrings.getLocalString("ui.uititledbox.panel_name", "Panel");
    private static String PANEL_DESC = localStrings.getLocalString("ui.uititledbox.panel_desc", "This is the panel for the titled box");
    public static final String REQUIRED_LEGEND = localStrings.getLocalString("ui.uititledbox.required.legend", "* Required");
    private static final String REQUIRED_FIELD_INDICATOR = localStrings.getLocalString("ui.uititledbox.required.indicator", " *");
    private static final String REQUIRED_FIELD = localStrings.getLocalString("ui.uititledbox.required.generic_field_title", "<Required Field>");
    private static String SUN_ONE_SETTING = localStrings.getLocalString("ui.uititledbox.sunonesetting", " (Sun-specific)");
    public static final int HORIZONTAL_SPLIT = 1;
    public static final int VERTICAL_SPLIT = 0;
    public static final Color DisabledBackgroundColor = Color.lightGray;
    public static final Color EnabledBackgroundColor = Color.white;
    public static final Color DisabledTextColor = Color.darkGray;
    public static final Border DefaultTextBorder = null;
    public static final String UPDATE_REASON_UNKNOWN = "unknown";
    public static final String UPDATE_REASON_SET_SELECTION = "SetSelect";
    public static final String UPDATE_REASON_ENABLED = "Enabled";
    private static boolean suspendAllUpdates = false;
    public static final String ID_PREFIX = "$.";
    private String scriptId = null;
    private GridBagLayout gbLayout = null;
    private GridBagConstraints gbConst = null;
    private boolean hasTitle = false;
    private boolean hasVisibleBorder = false;
    private boolean hasLabeledTitle = true;
    protected boolean isReadOnly = false;
    protected boolean isEnabled = true;
    protected boolean isRequired = false;
    protected boolean isSunONE = false;
    protected boolean isNotImplemented = false;
    protected boolean clearWhenDisabled = false;
    protected boolean setEnableOnChildren = true;
    private Border border = null;
    private JComponent container = null;
    private _TitleLabel titleLabel = null;
    protected Vector updateHandlers = new Vector();
    protected boolean isUpdateEnabled = true;
    private String updateReason = "unknown";
    protected Dimension maxPreferredSize = null;
    protected Dimension minSize = null;
    protected String actionCommand = null;
    protected Vector validatorList = null;
    protected boolean validateOnUpdate = false;
    protected boolean acceptFocus = false;
    private boolean isExternalToolTipSet = false;
    private MouseListener focusMouseListener = null;
    private int _TitleGridBagLayout_adjusting = 0;
    private int _getPreferredSize = 0;
    private JPopupMenu popupMenu = null;
    private int box_updateComponent_recurse = 0;
    private Object updateEventSource = null;
    private Runnable clearLastValidation = null;
    private int lastValidation = -1;
    private static final Color NotImplementedForegroundColor = Color.red;
    static /* synthetic */ Class class$javax$swing$BorderFactory;

    private static String REQUIRES_ENTRY(Object v0) {
        return localStrings.getLocalString("ui.uititledbox.required.entry_msg", "This field requires an entry:\n ''{0}''", new Object[]{v0});
    }

    public static Color getDefaultTitleColor() {
        return UIConfig.getConfigColor("ui.Box.enabledTitleColor");
    }

    public void setSuspendAllUpdates(boolean state) {
        suspendAllUpdates = state;
    }

    public static String SCRIPT_ID(String id) {
        return ID_PREFIX + id;
    }

    public String getScriptId() {
        return this.scriptId;
    }

    public void setScriptId(String id) {
        this.scriptId = id.startsWith(ID_PREFIX) ? id : ID_PREFIX + id;
    }

    public UITitledBox(String title, boolean showBorder) {
        this.getAccessibleContext().setAccessibleName(PANEL_NAME);
        this.getAccessibleContext().setAccessibleDescription(PANEL_DESC);
        if (showBorder && title == null) {
            title = "";
        }
        if (title != null) {
            this.hasTitle = true;
            this.hasVisibleBorder = showBorder;
            if (showBorder) {
                this.titleLabel = null;
                this.border = new _TitleBorder(title);
            } else {
                this.titleLabel = new _TitleLabel(title);
                GridBagConstraints c = new GridBagConstraints();
                super.setLayout(new _TitleGridBagLayout());
                c.weightx = 0.0;
                c.weighty = 0.0;
                c.gridx = 0;
                c.gridy = -1;
                c.insets = new Insets(0, 1, 0, 0);
                c.fill = 0;
                c.anchor = 18;
                this.add((Component)this.titleLabel, c);
                c.weightx = 0.5;
                c.weighty = 0.5;
                c.fill = 1;
                c.anchor = 10;
                UIPanel box = new UIPanel();
                this.add((Component)box, c);
                this.container = box;
                this.border = new EmptyBorder(0, 0, 0, 0);
            }
        } else {
            this.titleLabel = null;
            this.border = new EmptyBorder(0, 0, 0, 0);
        }
        this.setBorder(this.border);
        this.setLayout(this.getGBLayout());
        this.getGBConstraints();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent ce) {
                UITitledBox.this.componentResized(ce);
            }
        });
        this._setDefaultToolTipText(title);
    }

    public void setToolTipText(String text) {
        this.isExternalToolTipSet = true;
        super.setToolTipText(text);
    }

    protected void _setDefaultToolTipText(String text) {
        if (!this.isExternalToolTipSet) {
            super.setToolTipText(text != null ? text : "");
        }
    }

    public void setAccessibleDescription(String text) {
        this.getAccessibleContext().setAccessibleDescription(text);
    }

    protected void setLabelComponent(Component c) {
        if (this.titleLabel != null) {
            this.titleLabel.setLabelFor(c);
        } else if (this.border instanceof _TitleBorder) {
            // empty if block
        }
    }

    public void setMnemonic(char c) {
        if (this.titleLabel != null) {
            this.titleLabel.setDisplayedMnemonic(c);
        }
    }

    public void setAcceptsFocus(boolean flag) {
        this.acceptFocus = flag;
        this.setRequestFocusEnabled(this.acceptFocus);
        if (this.focusMouseListener == null) {
            this.focusMouseListener = new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    UITitledBox.this.requestFocus();
                }
            };
        } else {
            this.removeMouseListener(this.focusMouseListener);
        }
        if (this.acceptFocus) {
            this.addMouseListener(this.focusMouseListener);
        }
    }

    public boolean acceptsFocus() {
        return this.acceptFocus;
    }

    public boolean isFocusable() {
        return this.isEnabled() && this.acceptsFocus() ? true : super.isFocusable();
    }

    public boolean hasTitle() {
        return this.hasTitle;
    }

    public boolean hasVisibleBorder() {
        return this.hasVisibleBorder;
    }

    public boolean hasLabeledTitle() {
        return this.hasLabeledTitle;
    }

    public void setEnabledTitleColor(Color color) {
        if (this.titleLabel != null) {
            this.titleLabel.setEnabledColor(color);
        } else if (this.border instanceof _TitleBorder) {
            ((_TitleBorder)this.border).setEnabledColor(color);
        }
    }

    public void setDisabledTitleColor(Color color) {
        if (this.titleLabel != null) {
            this.titleLabel.setDisabledColor(color);
        } else if (this.border instanceof _TitleBorder) {
            ((_TitleBorder)this.border).setDisabledColor(color);
        }
    }

    public void setRequired(boolean required) {
        this.isRequired = required;
        if (this.isRequired && this.hasTitle) {
            this.setTitle(this.getTitle());
        }
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public boolean checkRequired() {
        return this.checkRequired(true, null);
    }

    public boolean checkRequired(boolean showError) {
        return this.checkRequired(showError, null);
    }

    public boolean checkRequired(String msg) {
        return this.checkRequired(true, msg);
    }

    public boolean checkRequired(boolean showError, String msg) {
        if (this.isRequired() && this.isBlank()) {
            if (showError) {
                String t = null;
                if (msg != null) {
                    t = msg;
                } else {
                    t = this.getTitle();
                    if (t == null || t.equals("")) {
                        t = REQUIRED_FIELD;
                    } else if (t.endsWith(REQUIRED_FIELD_INDICATOR)) {
                        t = t.substring(0, t.length() - REQUIRED_FIELD_INDICATOR.length());
                    }
                }
                UIOptionPane.showErrorDialog(this, UITitledBox.REQUIRES_ENTRY(t));
            }
            return false;
        }
        return true;
    }

    public void setSunONE(boolean sunONE) {
        this.isSunONE = sunONE;
        if (this.hasTitle) {
            this.setTitle(this.getTitle());
        }
    }

    public boolean isSunONE() {
        return this.isSunONE;
    }

    public boolean isBlank() {
        String t = this._getText(null);
        return t != null && t.equals("");
    }

    public String getText() {
        return this._getText("");
    }

    private String _getText(String dft) {
        if (this instanceof UITitledTextField) {
            return ((UITitledTextField)this).getText();
        }
        if (this instanceof UITitledComboBox) {
            return ((UITitledComboBox)this).getText();
        }
        if (this instanceof UITitledTextArea) {
            return ((UITitledTextArea)this).getText();
        }
        return dft;
    }

    public void setText(String val) {
        if (this instanceof UITitledTextField) {
            ((UITitledTextField)this).setText(val);
        } else if (this instanceof UITitledComboBox) {
            ((UITitledComboBox)this).setText(val);
        } else if (this instanceof UITitledTextArea) {
            ((UITitledTextArea)this).setText(val);
        }
    }

    public void setLayout(LayoutManager mgr) {
        if (this.container instanceof JSplitPane) {
            Print.dprintStackTrace((String)"'<JSplitPane>.setLayout' ignored");
        } else if (this.container instanceof JPanel) {
            ((JPanel)this.container).setLayout(mgr);
        } else {
            super.setLayout(mgr);
        }
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        if (comp == null) {
            Print.printStackTrace((String)"Attempting to add 'null' component");
            return;
        }
        if (this.setEnableOnChildren) {
            if (comp instanceof UITitledBox) {
                comp.setEnabled(this.isEnabled());
            } else if (comp instanceof AbstractButton) {
                comp.setEnabled(this.isEnabled());
            }
        }
        if (this.container != null) {
            if (comp instanceof JTabbedPane) {
                try {
                    this.container.add(comp, constraints, index);
                }
                catch (Throwable t) {
                    Print.dprintStackTrace((String)"add(<JTabbedPane>) Swing Bug (1)");
                    this.container.remove(comp);
                    this.container.add(comp, constraints, index);
                }
            } else {
                this.container.add(comp, constraints, index);
            }
        } else if (comp instanceof JTabbedPane) {
            try {
                super.addImpl(comp, constraints, index);
            }
            catch (Throwable t) {
                Print.dprintStackTrace((String)"add(<JTabbedPane>) Swing Bug (2)");
                super.remove(comp);
                super.addImpl(comp, constraints, index);
            }
        } else {
            super.addImpl(comp, constraints, index);
        }
    }

    public void setMaximumPreferredSize(Dimension d) {
        this.maxPreferredSize = d;
    }

    public Dimension getPreferredSize() {
        ++this._getPreferredSize;
        Dimension ps = super.getPreferredSize();
        if (this.maxPreferredSize != null) {
            if (this.maxPreferredSize.width > 0 && ps.width > this.maxPreferredSize.width) {
                ps.width = this.maxPreferredSize.width;
            }
            if (this.maxPreferredSize.height > 0 && ps.height > this.maxPreferredSize.height) {
                ps.height = this.maxPreferredSize.height;
            }
        }
        --this._getPreferredSize;
        return ps;
    }

    public Dimension getMinimumSize() {
        if (this.minSize == null) {
            return super.getMinimumSize();
        }
        Dimension r = new Dimension(this.minSize);
        if (r.width < 0 || r.height < 0) {
            Dimension p = super.getPreferredSize();
            Dimension m = super.getMinimumSize();
            if (r.width < 0) {
                int n = r.width = m.width > p.width ? m.width : p.width;
            }
            if (r.height < 0) {
                r.height = m.height > p.height ? m.height : p.height;
            }
        }
        return r;
    }

    public void setMinimumSize(Dimension d) {
        this.minSize = new Dimension(d);
    }

    public void setMinimumWidth(int width) {
        if (this.minSize == null) {
            this.minSize = new Dimension(width, -1);
        } else {
            this.minSize.width = width;
        }
    }

    public void setMinimumHeight(int height) {
        if (this.minSize == null) {
            this.minSize = new Dimension(-1, height);
        } else {
            this.minSize.height = height;
        }
    }

    public void setPreferredWidth(int width) {
        UITitledBox.setPreferredSize(this, width, -1);
    }

    public void setPreferredHeight(int height) {
        UITitledBox.setPreferredSize(this, -1, height);
    }

    public static void setPreferredSize(JComponent c, int w, int h) {
        Dimension d = c.getPreferredSize();
        if (w >= 0) {
            d.width = w;
        }
        if (h >= 0) {
            d.height = h;
        }
        c.setPreferredSize(d);
    }

    protected GridBagConstraints getDefaultGBConstraints(GridBagConstraints c) {
        if (c == null) {
            c = new GridBagConstraints();
        }
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = -1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 1;
        c.anchor = 10;
        return c;
    }

    public GridBagConstraints getGBConstraints(Component comp) {
        return this.getGBLayout().getConstraints(comp);
    }

    public GridBagConstraints getGBConstraints() {
        if (this.gbConst == null) {
            this.gbConst = this.getDefaultGBConstraints(null);
        }
        return this.gbConst;
    }

    public GridBagConstraints getGBConstraintsCopy() {
        return (GridBagConstraints)this.getGBConstraints().clone();
    }

    public GridBagLayout getGBLayout() {
        if (this.gbLayout == null) {
            this.gbLayout = new _TitleGridBagLayout();
        }
        return this.gbLayout;
    }

    public void setGBConstraints(Component comp, GridBagConstraints constaints) {
        this.getGBLayout().setConstraints(comp, constaints);
    }

    public void setGBConstraints(Component comp) {
        this.setGBConstraints(comp, this.getGBConstraints());
    }

    public void addWithGBConstraints(Component comp) {
        this.add(comp, this.getGBConstraints());
    }

    protected Border getTextBorder() {
        int borderType = 0;
        switch (borderType) {
            case 1: {
                return BorderFactory.createLoweredBevelBorder();
            }
            case 2: {
                return BorderFactory.createBevelBorder(1, Color.gray, Color.lightGray, Color.gray, Color.darkGray);
            }
        }
        return null;
    }

    public boolean isEditable() {
        return !this.isReadOnly();
    }

    public void setEditable(boolean state) {
        this.setReadOnly(!state);
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void setReadOnly(boolean state) {
        this.isReadOnly = state;
    }

    public void setReadOnly(boolean state, boolean includingChildren) {
        this.setReadOnly(state);
        if (includingChildren) {
            this.setChildrenReadOnly(state);
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean state) {
        if (this.isEnabled != state) {
            this.isEnabled = state;
            if (this.titleLabel != null) {
                this.titleLabel.setEnabled(this.isEnabled());
                this.repaint();
            } else if (this.border instanceof _TitleBorder) {
                ((_TitleBorder)this.border).setEnabled(this.isEnabled());
                this.repaint();
            }
            if (this.setEnableOnChildren) {
                this.setChildrenEnabled(state);
            }
        }
    }

    public void setChildrenEnabled(boolean state) {
        Component[] c = this.getComponents();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] instanceof UITitledBox) {
                this.setChildEnabled(c[i], state);
                continue;
            }
            if (!(c[i] instanceof AbstractButton)) continue;
            this.setChildEnabled(c[i], state);
        }
    }

    protected void setChildEnabled(Component child, boolean state) {
        child.setEnabled(state);
    }

    protected void setChildrenReadOnly(boolean state) {
        UITitledBox._setChildrenReadOnly(this, state);
    }

    private static void _setChildrenReadOnly(Container container, boolean state) {
        Component[] c = container.getComponents();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] instanceof UITitledBox) {
                ((UITitledBox)c[i]).setReadOnly(state, true);
                continue;
            }
            if (c[i] instanceof UIButton) {
                ((UIButton)c[i]).setReadOnly(state);
                continue;
            }
            if (c[i] instanceof UICheckBox) {
                ((UICheckBox)c[i]).setReadOnly(state);
                continue;
            }
            if (!(c[i] instanceof Container)) continue;
            UITitledBox._setChildrenReadOnly((Container)c[i], state);
        }
    }

    public void setClearWhenDisabled(boolean state) {
        this.clearWhenDisabled = state;
        if (!this.isEnabled()) {
            this.setEnabled(false);
        }
    }

    public String getTitle() {
        if (this.titleLabel != null) {
            return this.titleLabel.getText();
        }
        if (this.border instanceof _TitleBorder) {
            return ((_TitleBorder)this.border).getTitle();
        }
        return null;
    }

    public void setTitle(String title) {
        if (this.hasTitle) {
            if (title != null) {
                if (this.isNotImplemented && !title.startsWith("!! ")) {
                    title = "!! " + title;
                }
                if (this.isRequired() && !this.isReadOnly() && !title.endsWith(REQUIRED_FIELD_INDICATOR)) {
                    title = title + REQUIRED_FIELD_INDICATOR;
                }
                title = this.formatSunONELabel(title);
            }
            if (this.titleLabel != null) {
                this.titleLabel.setText(title);
            } else if (this.border instanceof _TitleBorder) {
                ((_TitleBorder)this.border).setTitle(title);
                this.repaint();
            }
            this._setDefaultToolTipText(title);
        } else {
            Print.printStackTrace((String)"This box has no provision for a title");
        }
    }

    public String formatSunONELabel(String text) {
        StringBuffer sb;
        if (this.isSunONE() && text.indexOf(SUN_ONE_SETTING) == -1) {
            sb = new StringBuffer(text);
            if (text.indexOf(":") != -1) {
                sb.insert(text.indexOf(":"), SUN_ONE_SETTING);
            } else if (text.endsWith(REQUIRED_FIELD_INDICATOR)) {
                sb.insert(text.indexOf(REQUIRED_FIELD_INDICATOR), SUN_ONE_SETTING);
            } else {
                sb.append(SUN_ONE_SETTING);
            }
            text = sb.toString();
        }
        if (!this.isSunONE() && text.indexOf(SUN_ONE_SETTING) != -1) {
            sb = new StringBuffer(text);
            sb.delete(text.indexOf(SUN_ONE_SETTING), text.indexOf(SUN_ONE_SETTING) + SUN_ONE_SETTING.length());
            text = sb.toString();
        }
        return text;
    }

    public void componentResized(ComponentEvent ce) {
    }

    public void propertyChange(PropertyChangeEvent pce) {
        Object src = pce.getSource();
        if (src instanceof PropertyEditor) {
            String val = ((PropertyEditor)src).getAsText();
            Print.dprintln((String)("PropertyChangeEvent: " + val));
            this.setText(val);
        } else {
            Object val = pce.getNewValue();
            Print.dprintln((String)("PropertyChangeEvent: " + val));
            this.setText(val != null ? val.toString() : "");
        }
    }

    public void setPopupMenu(JPopupMenu pmenu) {
        if (this.popupMenu == null) {
            this.popupMenu = pmenu;
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        UITitledBox.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }

                public void mouseReleased(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        UITitledBox.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            });
        } else {
            Print.printStackTrace((String)"Only one popup menu is allowed");
        }
    }

    protected void setUpdateReason(String reason) {
        this.updateReason = reason != null ? reason : UPDATE_REASON_UNKNOWN;
    }

    public String getUpdateReason() {
        return this.updateReason;
    }

    public boolean isUnknownSelectionUpdate() {
        return this.getUpdateReason().equals(UPDATE_REASON_UNKNOWN);
    }

    public boolean isSetSelectionUpdate() {
        return this.getUpdateReason().equals(UPDATE_REASON_SET_SELECTION);
    }

    public void addActionListener(ActionListener target) {
        this.updateHandlers.add(target);
    }

    public void removeActionListener(ActionListener target) {
        this.updateHandlers.remove(target);
    }

    public void removeAllActionListeners() {
        this.updateHandlers.removeAllElements();
    }

    protected void updateComponent(Object source) {
        boolean isValid;
        if (this.box_updateComponent_recurse > 0) {
            return;
        }
        ++this.box_updateComponent_recurse;
        boolean bl = isValid = this.validateOnUpdate ? this._performValidation() : true;
        if (isValid && this.isUpdateEnabled && !suspendAllUpdates) {
            this.updateEventSource = source;
            ActionEvent actionEvent = new ActionEvent(this, 1001, this.getActionCommand());
            Enumeration e = this.updateHandlers.elements();
            while (e.hasMoreElements()) {
                Object target = e.nextElement();
                if (target instanceof UIActionDispatcher) {
                    ((UIActionDispatcher)target).invoke();
                    continue;
                }
                if (target instanceof ActionListener) {
                    ((ActionListener)target).actionPerformed(actionEvent);
                    continue;
                }
                Print.printStackTrace((String)("Unsupported target object: " + UIUtils.debugClassName(target)));
            }
        }
        --this.box_updateComponent_recurse;
    }

    protected void updateComponent() {
        this.updateComponent(null);
    }

    public void fireUpdate() {
        this.updateComponent(null);
    }

    public Object getUpdateEventSource() {
        return this.updateEventSource;
    }

    public void actionPerformed(ActionEvent ae) {
        this.fireUpdate();
    }

    public void addValidator(Validator v) {
        if (this.validatorList == null) {
            this.validatorList = new Vector();
        }
        if (!this.validatorList.contains(v)) {
            this.validatorList.add(v);
        }
    }

    public void removeValidator(Validator v) {
        this.validatorList.remove(v);
    }

    public void setValidateOnUpdate(boolean f) {
        this.validateOnUpdate = f;
    }

    public boolean performValidation() {
        boolean isValid = true;
        if (this.validatorList != null) {
            Enumeration e = this.validatorList.elements();
            while (e.hasMoreElements()) {
                Validator v = (Validator)e.nextElement();
                if (v.performValidation(this)) continue;
                isValid = false;
                break;
            }
        }
        return isValid;
    }

    protected boolean _performValidation() {
        if (this.lastValidation < 0) {
            int n = this.lastValidation = this.performValidation() ? 1 : 0;
            if (this.clearLastValidation == null) {
                this.clearLastValidation = new Runnable(){

                    public void run() {
                        UITitledBox.this.lastValidation = -1;
                    }
                };
            }
            UIEventQueue.invokeLater(this.clearLastValidation);
        }
        return this.lastValidation == 1;
    }

    public void setKeyAction(ActionListener al, String cmd, KeyStroke ks) {
        this.getInputMap(1).put(ks, cmd);
        Action action = al instanceof Action ? (Action)al : new ActionWrapper(cmd, al);
        this.getActionMap().put(cmd, action);
    }

    public void setEnterKeyAction(ActionListener al) {
        KeyStroke ks = KeyStroke.getKeyStroke("ENTER");
        this.setKeyAction(al, "VK_ENTER", ks);
    }

    public void setActionCommand(String cmd) {
        this.actionCommand = cmd;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void addXStretchy(GridBagConstraints gbc) {
        this._addXStretchy(gbc);
    }

    public JPanel _addXStretchy(GridBagConstraints gbc) {
        GridBagConstraints c = gbc != null ? (GridBagConstraints)gbc.clone() : this.getGBConstraintsCopy();
        c.weightx = 0.5;
        c.gridx = 0;
        c.gridwidth = 1;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 2;
        c.anchor = 13;
        UIPanel p = new UIPanel();
        this.add((Component)p, c);
        return p;
    }

    public void addYStretchy(GridBagConstraints gbc) {
        this._addYStretchy(gbc);
    }

    public JPanel _addYStretchy(GridBagConstraints gbc) {
        GridBagConstraints c = gbc != null ? (GridBagConstraints)gbc.clone() : this.getGBConstraintsCopy();
        c.weighty = 0.5;
        c.gridy = 0;
        c.gridheight = 1;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 3;
        c.anchor = 15;
        UIPanel p = new UIPanel();
        this.add((Component)p, c);
        return p;
    }

    public static void debugPrintGBConstraints(GridBagConstraints gbc) {
        Print.dprintln((String)"GridBagConstraints: ");
        Print.dprintln((String)("   Weight: " + gbc.weightx + "/" + gbc.weighty));
        Print.dprintln((String)("   Grid  : " + gbc.gridx + "/" + gbc.gridy));
        Print.dprintln((String)("   Size  : " + gbc.gridwidth + "/" + gbc.gridheight));
        Print.dprintln((String)("   Insets: " + gbc.insets));
        String fill = null;
        switch (gbc.fill) {
            case 2: {
                fill = "HORIZONTAL";
                break;
            }
            case 3: {
                fill = "VERTICAL";
                break;
            }
            case 1: {
                fill = "BOTH";
                break;
            }
            case 0: {
                fill = "NONE";
                break;
            }
            default: {
                fill = "?" + gbc.fill + "?";
            }
        }
        Print.dprintln((String)("   Fill  : " + fill));
        String anchor = null;
        switch (gbc.anchor) {
            case 15: {
                anchor = "SOUTH";
                break;
            }
            case 14: {
                anchor = "SOUTHEAST";
                break;
            }
            case 16: {
                anchor = "SOUTHWEST";
                break;
            }
            case 11: {
                anchor = "NORTH";
                break;
            }
            case 12: {
                anchor = "NORTHEAST";
                break;
            }
            case 18: {
                anchor = "NORTHWEST";
                break;
            }
            case 13: {
                anchor = "EAST";
                break;
            }
            case 17: {
                anchor = "WEST";
                break;
            }
            case 10: {
                anchor = "CENTER";
                break;
            }
            case 0: {
                anchor = "NONE";
                break;
            }
            default: {
                anchor = "?" + gbc.anchor + "?";
            }
        }
        Print.dprintln((String)("   Anchor: " + anchor));
    }

    public static boolean isMetalLookAndFeel() {
        return UIManager.getLookAndFeel() instanceof MetalLookAndFeel;
    }

    public static void makeFontPlain(JComponent c) {
        c.setFont(c.getFont().deriveFont(0));
        c.setForeground(Color.black);
    }

    public static void setNotImplemented(Component c) {
        if (c instanceof UITitledBox) {
            ((UITitledBox)c)._setNotImplemented();
        } else {
            c.setForeground(NotImplementedForegroundColor);
        }
    }

    private void _setNotImplemented() {
        this.isNotImplemented = true;
        this.setEnabledTitleColor(NotImplementedForegroundColor);
        this.setDisabledTitleColor(NotImplementedForegroundColor.darker());
        if (this.hasTitle) {
            this.setTitle(this.getTitle());
        }
    }

    private class ActionWrapper
    extends AbstractAction {
        private ActionListener listener;

        public ActionWrapper(String cmd, ActionListener al) {
            super(cmd);
            this.listener = null;
            this.listener = al;
        }

        public void actionPerformed(ActionEvent ae) {
            this.listener.actionPerformed(ae);
        }
    }

    private class _TitleBorder
    extends TitledBorder {
        private boolean isEnabled;
        private Color enabledColor;
        private Color disabledColor;
        private Border enabledBorder;
        private Border disabledBorder;
        private String enabledBorderType;

        public _TitleBorder(String title) {
            super(title);
            this.isEnabled = true;
            this.enabledColor = null;
            this.disabledColor = null;
            this.enabledBorder = null;
            this.disabledBorder = null;
            this.enabledBorderType = null;
            this.setEnabled(true);
        }

        public void setBorder(Border border) {
            if (border != null) {
                super.setBorder(border);
            }
        }

        public Border getBorder() {
            return super.getBorder();
        }

        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component c, Insets bn) {
            Insets insets = super.getBorderInsets(c, bn);
            insets.left += 3;
            insets.right += 3;
            insets.bottom += 3;
            return insets;
        }

        public Dimension getMinimumSize(Component c) {
            Dimension d = super.getMinimumSize(c);
            return d;
        }

        public void setEnabledColor(Color color) {
            this.enabledColor = color;
            this.setEnabled(this.isEnabled);
        }

        private Color getEnabledColor() {
            return this.enabledColor != null ? this.enabledColor : UITitledBox.getDefaultTitleColor();
        }

        public void setDisabledColor(Color color) {
            this.disabledColor = color;
            this.setEnabled(this.isEnabled);
        }

        private Color getDisabledColor() {
            return this.disabledColor != null ? this.disabledColor : UIConfig.getConfigColor("ui.Box.disabledTitleColor");
        }

        private Border getEnabledBorder() {
            String btype = UIConfig.getConfigValue("ui.Box.borderType");
            if (this.enabledBorder == null || !btype.equals(this.enabledBorderType)) {
                if (btype.equals("LineBorder")) {
                    this.enabledBorder = new LineBorder(Color.gray, 1);
                } else {
                    UIActionDispatcher bfc = new UIActionDispatcher((Object)(class$javax$swing$BorderFactory == null ? (class$javax$swing$BorderFactory = UITitledBox.class$("javax.swing.BorderFactory")) : class$javax$swing$BorderFactory), "create" + btype);
                    Border border = this.enabledBorder = bfc.isValid() ? (Border)bfc.invoke() : null;
                    if (this.enabledBorder == null) {
                        this.enabledBorder = new LineBorder(Color.darkGray, 1);
                    }
                }
            }
            return this.enabledBorder;
        }

        private Border getDisabledBorder() {
            if (this.disabledBorder == null) {
                this.disabledBorder = new LineBorder(Color.lightGray, 2);
            }
            return this.disabledBorder;
        }

        public void setEnabled(boolean enable) {
            this.isEnabled = enable;
            this.setTitleColor(enable ? this.getEnabledColor() : this.getDisabledColor());
            this.setBorder(enable ? this.getEnabledBorder() : this.getDisabledBorder());
        }
    }

    private class _TitleLabel
    extends JLabel {
        private boolean isEnabled;
        private Color enabledColor;
        private Color disabledColor;

        public _TitleLabel(String title) {
            super(title);
            this.isEnabled = true;
            this.enabledColor = null;
            this.disabledColor = null;
            this.getAccessibleContext().setAccessibleName(LABEL_NAME);
            this.getAccessibleContext().setAccessibleDescription(LABEL_DESC);
            this.setEnabled(true);
        }

        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            if (UITitledBox.this._TitleGridBagLayout_adjusting > 0) {
                d.width = 1;
            }
            return d;
        }

        public Dimension getMinimumSize() {
            Dimension d = super.getMinimumSize();
            if (UITitledBox.this._TitleGridBagLayout_adjusting > 0) {
                d.width = 1;
            }
            return d;
        }

        public void setEnabledColor(Color color) {
            this.enabledColor = color;
            this.setEnabled(this.isEnabled);
        }

        private Color getEnabledColor() {
            return this.enabledColor != null ? this.enabledColor : UITitledBox.getDefaultTitleColor();
        }

        public void setDisabledColor(Color color) {
            this.disabledColor = color;
            this.setEnabled(this.isEnabled);
        }

        private Color getDisabledColor() {
            return this.disabledColor != null ? this.disabledColor : UIConfig.getConfigColor("ui.Box.disabledTitleColor");
        }

        public void setEnabled(boolean enable) {
            this.setForeground(enable ? this.getEnabledColor() : this.getDisabledColor());
        }
    }

    private class _TitleGridBagLayout
    extends GridBagLayout {
        private _TitleGridBagLayout() {
        }

        public Dimension preferredLayoutSize(Container p) {
            UITitledBox.this._TitleGridBagLayout_adjusting++;
            Dimension d = super.preferredLayoutSize(p);
            UITitledBox.this._TitleGridBagLayout_adjusting--;
            return d;
        }

        public Dimension minimumLayoutSize(Container p) {
            UITitledBox.this._TitleGridBagLayout_adjusting++;
            Dimension d = super.minimumLayoutSize(p);
            UITitledBox.this._TitleGridBagLayout_adjusting--;
            return d;
        }
    }

    public static interface Validator {
        public boolean performValidation(UITitledBox var1);
    }
}

