/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.Role;
import com.sun.enterprise.deployment.RoleReference;
import com.sun.enterprise.deployment.Roles;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorInspector;
import com.sun.enterprise.tools.deployment.ui.shared.RolesDialog;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public abstract class UIRoleRefsTable
extends UITitledTable
implements DescriptorInspector {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UIRoleRefsTable.class);
    private static final String CBOX_NAME = localStrings.getLocalString("ui.uirolerefstable.cbox_name", "Roles and References Table ComboBox");
    private static final String CBOX_DESC = localStrings.getLocalString("ui.uirolerefstable.cbox_desc", "This is a ComboBox for the roles and references table in this window");
    private static String ROLE_TABLE_TITLE = localStrings.getLocalString("ui.uirolerefstable.role_table_title", "Role names referenced in code");
    private static String TYPE_TOOLTIP = localStrings.getLocalString("ui.uirolerefstable.type_tooltip", "Click to edit role link");
    private static String ROLE_LINK = localStrings.getLocalString("ui.uirolerefstable.role_link", "Role Link");
    private static String ROLE_TABLE_TITLE_TOOLTIP = localStrings.getLocalString("ui.uirolerefstable.role_table_title_tooltip", "Add or Delete role names referenced in code");
    private static String ROLE_NAME = localStrings.getLocalString("ui.uirolerefstable.rolename", "Role name");
    private static String CODED_NAME = localStrings.getLocalString("ui.uirolerefstable.codedname", "Coded name");
    private String fileNameType = null;
    private JButton pbEditRoles = null;
    private boolean selectBlankName = false;

    public UIRoleRefsTable() {
        this(true, null);
    }

    public UIRoleRefsTable(boolean showBorder, String fileType) {
        super(ROLE_TABLE_TITLE, showBorder);
        this.fileNameType = fileType;
        RoleRefsTable table = new RoleRefsTable();
        this.setTableView(table);
        ActionListener actions = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String cmd = ae.getActionCommand();
                if (cmd.equals("add")) {
                    UIRoleRefsTable.this.addRoleRefAction();
                } else if (cmd.equals("delete")) {
                    UIRoleRefsTable.this.deleteRoleRefAction();
                } else if (cmd.equals("edit")) {
                    UIRoleRefsTable.this.editRolesAction();
                } else {
                    Print.printStackTrace((String)("Unknown action-command: " + cmd));
                }
            }
        };
        UIButton addPB = UIButton.createAddButton(actions);
        this.addControlButton(addPB);
        UIButton delPB = UIButton.createDeleteButton(actions);
        this.addSelectionEnabledButton(delPB);
        this.pbEditRoles = RolesDialog.getEditRolesButton(this, new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                UIRoleRefsTable.this.getRoleRefsTable().updateRolesCombo();
            }
        });
        this.addControlButton(this.pbEditRoles);
    }

    private RoleRefsTable getRoleRefsTable() {
        return (RoleRefsTable)this.getTableView();
    }

    private RoleRefsTableModel getRoleRefsModel() {
        return (RoleRefsTableModel)this.getModel();
    }

    public abstract Collection getRoleReferences();

    public abstract void addRoleReference(RoleReference var1);

    public abstract void removeRoleReference(RoleReference var1);

    public abstract Roles getRolesDescriptor();

    public abstract void roleReferenceChanged(RoleReference var1);

    public Class getDescriptorClass() {
        return Roles.class;
    }

    public void setDescriptor(Descriptor d) {
    }

    public Descriptor getDescriptor() {
        return (Descriptor)this.getRolesDescriptor();
    }

    public void refresh() {
        this.updateTableData(this.getRoleReferences());
        this.getRoleRefsTable().updateRolesCombo();
        if (this.selectBlankName) {
            int x = this.getRoleRefsModel().getNamedRoleReference("");
            if (x >= 0) {
                this.getSelectionModel().setSelectionInterval(x, x);
                this.getRoleRefsTable().getColumnSelectionModel().setSelectionInterval(0, 0);
            }
            this.selectBlankName = false;
        }
    }

    private void addRoleRefAction() {
        RoleReference rr = new RoleReference("", "");
        rr.setValue("");
        this.selectBlankName = true;
        this.addRoleReference(rr);
    }

    private void deleteRoleRefAction() {
        boolean n;
        int index = this.getRoleRefsTable().getSelectedRow();
        if (index >= 0 && (n = UIOptionPane.showConfirmDialog(this, localStrings.getLocalString("ui.uirolerefstable.confirm_delete_selection", "Are you sure you want to delete the selected role?")))) {
            this.removeRoleReference((RoleReference)this.getRoleRefsModel().getRowObject(index));
        }
    }

    private void editRolesAction() {
        RolesDialog rolesDialog = RolesDialog.newRolesDialog(this);
        rolesDialog.showDialog((Descriptor)this.getRolesDescriptor());
    }

    public class RoleRefsTableModel
    extends InspectorTableModel {
        public RoleRefsTableModel() {
            super(new String[]{ROLE_NAME, ROLE_LINK, DescriptionInspector.DESCRIPTION_COLUMN_INIT});
            this.setDataOrdering(1);
        }

        public Object getObjectValue(Object obj, int col) {
            String value = null;
            RoleReference rr = (RoleReference)obj;
            switch (col) {
                case 0: {
                    value = rr.getName();
                    break;
                }
                case 1: {
                    value = rr.getValue();
                    break;
                }
                case 2: {
                    value = rr.getDescription();
                    break;
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            if (!(obj instanceof RoleReference)) {
                return;
            }
            RoleReference rr = (RoleReference)obj;
            String v = value.toString().trim();
            switch (col) {
                case 0: {
                    rr.setName(v);
                    UIRoleRefsTable.this.roleReferenceChanged(rr);
                    break;
                }
                case 1: {
                    rr.setValue(v);
                    UIRoleRefsTable.this.roleReferenceChanged(rr);
                    break;
                }
                case 2: {
                    rr.setDescription(v);
                    break;
                }
            }
        }

        public int getNamedRoleReference(String name) {
            Iterator itr = this.getData().iterator();
            int i = 0;
            while (itr.hasNext()) {
                String nextName = ((RoleReference)itr.next()).getName();
                if (name.equals(nextName)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
    }

    private class RoleRefsTable
    extends InspectorTable {
        private JComboBox typeCellEditor = new JComboBox();

        public RoleRefsTable() {
            this.typeCellEditor.getAccessibleContext().setAccessibleName(CBOX_NAME);
            this.typeCellEditor.getAccessibleContext().setAccessibleDescription(CBOX_DESC);
            this.setModel(new RoleRefsTableModel());
            this.setSelectionMode(0);
            this.setAutoResizeMode(4);
            this.setHandleDescriptionUpdates(true);
            this.setToolTipText(ROLE_TABLE_TITLE_TOOLTIP);
            TableColumn rolesCol = this.getColumnModel().getColumn(1);
            rolesCol.setCellEditor(new DefaultCellEditor(this.typeCellEditor));
            DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
            renderer.setToolTipText(TYPE_TOOLTIP);
            rolesCol.setCellRenderer(renderer);
        }

        public void updateRolesCombo() {
            Roles rolesDesc = UIRoleRefsTable.this.getRolesDescriptor();
            Set rolesSet = rolesDesc != null ? rolesDesc.getRoles() : null;
            this.typeCellEditor.removeAllItems();
            if (rolesSet != null) {
                Iterator i = rolesSet.iterator();
                while (i.hasNext()) {
                    this.typeCellEditor.addItem(((Role)i.next()).getName());
                }
            }
        }
    }
}

