/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.utils.ListTools;
import com.sun.enterprise.tools.deployment.ui.utils.UICheckBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledList;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTree;
import com.sun.enterprise.tools.deployment.ui.utils.WinTools;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.tree.MutableTreeNode;

public class UIOptionPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UIOptionPane.class);
    private static final String SEPARATOR_NAME = localStrings.getLocalString("ui.uioptionpane.separator_name", "Separator");
    private static final String SEPARATOR_DESC = localStrings.getLocalString("ui.uioptionpane.separator_desc", "This is a Separator");
    private static final String TEXT_INPUT_TITLE = localStrings.getLocalString("ui.uioptionpane.text_input_title", "Text Input Dialog");
    private static final String FILE_INPUT_TITLE = localStrings.getLocalString("ui.uioptionpane.file_input_title", "File Input Dialog");
    private static final String DIRECTORY_INPUT_TITLE = localStrings.getLocalString("ui.uioptionpane.directory_input_title", "Directory Input Dialog");
    private static final String LIST_INPUT_TITLE = localStrings.getLocalString("ui.uioptionpane.list_input_title", "List Selection Dialog");
    private static final String CONFIRM_TITLE = localStrings.getLocalString("ui.uioptionpane.confirmation_title", "Confirmation Dialog");
    private static final String PROGRESS_TITLE = localStrings.getLocalString("ui.uioptionpane.progress_title", "Progress Dialog");
    private static final String INFORMATION_TITLE = localStrings.getLocalString("ui.uioptionpane.information_title", "Information Dialog");
    private static final String WARNING_TITLE = localStrings.getLocalString("ui.uioptionpane.warning_title", "Warning Dialog");
    private static final String ERROR_TITLE = localStrings.getLocalString("ui.uioptionpane.error_title", "Error Dialog");
    private static final String OK_BUTTON = localStrings.getLocalString("ui.uioptionpane.ok_button", "Ok");
    private static final String CANCEL_BUTTON = localStrings.getLocalString("ui.uioptionpane.cancel_button", "Cancel");
    private static final String DONT_SHOW_THIS_DIALOG_AGAIN = localStrings.getLocalString("ui.uioptionpane.dont_show_this_dialog_again", "Don't show this dialog again");
    public static String[] OK_CANCEL_OPTIONS = new String[]{OK_BUTTON, CANCEL_BUTTON};
    public static String[] YES_NO_OPTIONS = new String[]{"*YES/NO*"};
    public static String[] YES_NO_CANCEL_OPTIONS = new String[]{"*YES/NO/CANCEL*"};
    public static int YES_OPTION = 0;
    public static int NO_OPTION = 1;
    public static int CANCEL_OPTION = 2;
    private static int QUESTION_MESSAGE = 3;
    private static int INFORMATION_MESSAGE = 1;
    private static int WARNING_MESSAGE = 2;
    private static int ERROR_MESSAGE = 0;
    private static int YES_NO_OPTION = 0;
    private static int YES_NO_CANCEL_OPTION = 1;

    public static boolean showOkCancelDialog(Component c, Object m) {
        return UIOptionPane.showOkCancelDialog(c, m, null);
    }

    public static boolean showOkCancelDialog(Component c, Object m, String t) {
        int sel = UIOptionPane.showConfirmDialog(c, m, t, OK_CANCEL_OPTIONS);
        return sel == 0;
    }

    public static boolean showYesNoDialog(Component c, Object m) {
        return UIOptionPane.showYesNoDialog(c, m, null);
    }

    public static boolean showYesNoDialog(Component c, Object m, String t) {
        return UIOptionPane.showConfirmDialog(c, m, t);
    }

    public static boolean showConfirmDialog(Component c, Object m) {
        return UIOptionPane.showConfirmDialog(c, m, (String)null);
    }

    public static boolean showConfirmDialog(Component c, Object m, String t) {
        Component frame = c != null ? c : DT.getApplicationFrame();
        String title = t != null ? t : CONFIRM_TITLE;
        int sel = JOptionPane.showConfirmDialog(frame, UIOptionPane._checkMessage(m), title, YES_NO_OPTION);
        return sel == YES_OPTION;
    }

    public static int showConfirmDialog(Component c, Object m, String[] options) {
        return UIOptionPane.showConfirmDialog(c, m, null, options);
    }

    public static int showConfirmDialog(Component c, Object m, String t, String[] options) {
        Component frame = c != null ? c : DT.getApplicationFrame();
        String title = t != null ? t : CONFIRM_TITLE;
        int sel = -1;
        sel = options == OK_CANCEL_OPTIONS ? JOptionPane.showOptionDialog(frame, UIOptionPane._checkMessage(m), title, YES_NO_OPTION, QUESTION_MESSAGE, null, OK_CANCEL_OPTIONS, OK_CANCEL_OPTIONS[0]) : (options == YES_NO_OPTIONS ? JOptionPane.showConfirmDialog(frame, UIOptionPane._checkMessage(m), title, YES_NO_OPTION, QUESTION_MESSAGE) : (options == YES_NO_CANCEL_OPTIONS ? JOptionPane.showConfirmDialog(frame, UIOptionPane._checkMessage(m), title, YES_NO_CANCEL_OPTION, QUESTION_MESSAGE) : (options.length == 2 ? JOptionPane.showOptionDialog(frame, UIOptionPane._checkMessage(m), title, YES_NO_OPTION, QUESTION_MESSAGE, null, options, options[0]) : (options.length == 3 ? JOptionPane.showOptionDialog(frame, UIOptionPane._checkMessage(m), title, YES_NO_CANCEL_OPTION, QUESTION_MESSAGE, null, options, options[0]) : JOptionPane.showOptionDialog(frame, UIOptionPane._checkMessage(m), title, YES_NO_CANCEL_OPTION, QUESTION_MESSAGE, null, options, options[0])))));
        return sel;
    }

    public static void showKeyInfoDialog(Component c, String key, Object m) {
        UIOptionPane.showKeyInfoDialog(c, key, m, null);
    }

    public static void showKeyInfoDialog(Component c, String key, Object m, String t) {
        if (!UIConfig.getConfigBoolean("ui.dontShowAgain_" + key)) {
            Component frame = c != null ? c : DT.getApplicationFrame();
            String title = t != null ? t : INFORMATION_TITLE;
            Object msg = UIOptionPane._checkMessage(m);
            Vector<Object> msgList = new Vector<Object>();
            if (msg instanceof Object[]) {
                ListTools.toList((Object[])msg, msgList);
            } else {
                msgList.add(msg);
            }
            JSeparator js = new JSeparator();
            js.getAccessibleContext().setAccessibleName(SEPARATOR_NAME);
            js.getAccessibleContext().setAccessibleDescription(SEPARATOR_DESC);
            msgList.add(js);
            UICheckBox ckbox = new UICheckBox(DONT_SHOW_THIS_DIALOG_AGAIN);
            ckbox.setSelected(false);
            msgList.add(ckbox);
            JOptionPane.showMessageDialog(frame, msgList.toArray(), title, INFORMATION_MESSAGE);
            if (ckbox.isSelected()) {
                UIConfig.setConfigBoolean("ui.dontShowAgain_" + key, true);
                UIConfig.saveConfig();
            }
        }
    }

    public static Dialog showProgressDialog(Runnable runnable, Component c, Object m) {
        return UIOptionPane.showProgressDialog(runnable, c, m, null);
    }

    public static Dialog showProgressDialog(Runnable runnable, Component c, Object m, String t) {
        Component frame = c != null ? c : DT.getApplicationFrame();
        String title = t != null ? t : PROGRESS_TITLE;
        JOptionPane pane = new JOptionPane(UIOptionPane._checkMessage(m), INFORMATION_MESSAGE, -1, null, new Object[0]);
        JDialog dialog = pane.createDialog(frame, title);
        dialog.setDefaultCloseOperation(0);
        if (runnable == null) {
            Print.dprintln((String)"Non-Modal Progress Dialog");
            dialog.setModal(false);
            dialog.show();
            return dialog;
        }
        Print.dprintln((String)"Modal Progress Dialog");
        ProgressThread pt = new ProgressThread(pane, dialog, runnable);
        pt.start();
        dialog.show();
        Print.dprintln((String)"Returned from Modal Progress Dialog");
        if (!pt.isDone()) {
            Print.dprintln((String)("ERROR: Premature return from show! [" + pane.getValue() + "]"));
            pane.setValue("");
            while (!pt.isDone()) {
                try {
                    Thread.sleep(500L);
                }
                catch (Throwable ie) {}
            }
        }
        return null;
    }

    public static void showInfoDialog(Component c, Object m) {
        UIOptionPane.showInfoDialog(c, m, null);
    }

    public static void showInfoDialog(Component c, Object m, String t) {
        Component frame = c != null ? c : DT.getApplicationFrame();
        String title = t != null ? t : INFORMATION_TITLE;
        JOptionPane.showMessageDialog(frame, UIOptionPane._checkMessage(m), title, INFORMATION_MESSAGE);
    }

    public static void showWarningDialog(Component c, Object m) {
        UIOptionPane.showWarningDialog(c, m, null);
    }

    public static void showWarningDialog(Component c, Object m, String t) {
        Component frame = c != null ? c : DT.getApplicationFrame();
        String title = t != null ? t : WARNING_TITLE;
        JOptionPane.showMessageDialog(frame, UIOptionPane._checkMessage(m), title, WARNING_MESSAGE);
    }

    public static void showErrorDialog(Component c, Object m) {
        UIOptionPane.showErrorDialog(c, m, null);
    }

    public static void showErrorDialog(Component c, Object m, String t) {
        Component frame = c != null ? c : DT.getApplicationFrame();
        String title = t != null ? t : ERROR_TITLE;
        JOptionPane.showMessageDialog(frame, UIOptionPane._checkMessage(m), title, ERROR_MESSAGE);
    }

    public static String showTextInputDialog(Component c, Object m, String v) {
        return UIOptionPane.showTextInputDialog(c, m, null, v);
    }

    public static String showTextInputDialog(Component c, Object m, String t, String v) {
        Component frame = c != null ? c : DT.getApplicationFrame();
        String title = t != null ? t : TEXT_INPUT_TITLE;
        String s = (String)JOptionPane.showInputDialog(frame, UIOptionPane._checkMessage(m), title, QUESTION_MESSAGE, null, null, v);
        return s != null ? s.trim() : null;
    }

    public static File showFileInputDialog(Component c, Object m, File v, String filterKey) {
        return UIOptionPane.showFileInputDialog(c, m, null, v, filterKey);
    }

    public static File showFileInputDialog(Component c, Object m, String t, File v, String filterKey) {
        Component frame = c != null ? c : DT.getApplicationFrame();
        String title = t != null ? t : FILE_INPUT_TITLE;
        UITitledTextField fileText = new UITitledTextField(null, false);
        fileText.setText(v != null ? v.getAbsolutePath() : "");
        fileText.setBrowserFilterKey(filterKey);
        fileText.setPreferredWidth(400);
        m = new Object[]{m, fileText};
        int sel = JOptionPane.showOptionDialog(frame, UIOptionPane._checkMessage(m), title, YES_NO_OPTION, QUESTION_MESSAGE, null, OK_CANCEL_OPTIONS, OK_CANCEL_OPTIONS[0]);
        return sel == YES_OPTION ? new File(fileText.getText()) : null;
    }

    public static File showDirInputDialog(Component c, Object m, File d) {
        return UIOptionPane.showDirInputDialog(c, m, null, d);
    }

    public static File showDirInputDialog(Component c, Object m, String t, File d) {
        Component frame = c != null ? c : DT.getApplicationFrame();
        String title = t != null ? t : DIRECTORY_INPUT_TITLE;
        UITitledTextField dirText = new UITitledTextField(null, false);
        dirText.setText(d != null ? d.getAbsolutePath() : "");
        dirText.setBrowserFilterKey(null);
        dirText.setPreferredWidth(400);
        m = new Object[]{m, dirText};
        int sel = JOptionPane.showOptionDialog(frame, UIOptionPane._checkMessage(m), title, YES_NO_OPTION, QUESTION_MESSAGE, null, OK_CANCEL_OPTIONS, OK_CANCEL_OPTIONS[0]);
        return sel == YES_OPTION ? new File(dirText.getText()) : null;
    }

    public static Object showListInputDialog(Component c, Object msg, Object[] list) {
        return UIOptionPane.showListInputDialog(c, msg, null, list, list[0]);
    }

    public static Object showListInputDialog(Component c, Object msg, Object[] list, Object dft) {
        return UIOptionPane.showListInputDialog(c, msg, null, list, dft);
    }

    public static Object showListInputDialog(Component c, Object msg, String t, Object[] list) {
        return UIOptionPane.showListInputDialog(c, msg, t, list, list[0]);
    }

    public static Object showListInputDialog(Component c, Object msg, String t, Object[] list, Object dft) {
        Component frame = c != null ? c : DT.getApplicationFrame();
        String title = t != null ? t : LIST_INPUT_TITLE;
        Object s = JOptionPane.showInputDialog(frame, UIOptionPane._checkMessage(msg), title, QUESTION_MESSAGE, null, list, dft);
        return s != null ? s : null;
    }

    private static Object _checkMessage(Object msg) {
        if (msg instanceof Collection) {
            msg = ((Collection)msg).toArray();
        }
        if (msg instanceof Object[]) {
            Object[] m = msg;
            for (int i = 0; i < m.length; ++i) {
                UITitledList list;
                if (m[i] instanceof Vector) {
                    list = new UITitledList(null, false);
                    list.setListData((Vector)m[i]);
                    list.setEnabled(false);
                    m[i] = list;
                    continue;
                }
                if (m[i] instanceof String[]) {
                    list = new UITitledList(null, false);
                    list.setListData((String[])m[i]);
                    list.setEnabled(false);
                    m[i] = list;
                    continue;
                }
                if (!(m[i] instanceof MutableTreeNode)) continue;
                UITitledTree tree = new UITitledTree(null, false);
                tree.setRootNode((MutableTreeNode)m[i]);
                m[i] = tree;
            }
        }
        return msg;
    }

    public static void showNotImplemented() {
        UIOptionPane.showNotImplemented(null, null);
    }

    public static void showNotImplemented(Component c) {
        UIOptionPane.showNotImplemented(c, null);
    }

    public static void showNotImplemented(Component c, String m) {
        String msg = "This function is not yet implemented.\n";
        String noBugs = "\n(Please wait until fully functional before filing bugs - Thanks)";
        msg = msg + (m != null ? m + noBugs : noBugs);
        UIOptionPane.showInfoDialog(c, msg);
    }

    private static JDialog createDialog(final JOptionPane optPane, Component parentComponent, String title) {
        Window window = WinTools.getAncestorWindow(parentComponent);
        final UIDialog dialog = window instanceof Frame ? new UIDialog((Frame)window, title, true) : new UIDialog((Dialog)window, title, true);
        Container contentPane = ((JDialog)dialog).getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)optPane, "Center");
        dialog.setResizable(false);
        dialog.pack();
        dialog.setLocationRelativeTo(parentComponent);
        ((Window)dialog).addWindowListener(new WindowAdapter(){
            private boolean gotFocus = false;

            public void windowClosing(WindowEvent we) {
                Print.dprintStackTrace((String)"");
                optPane.setValue(null);
            }

            public void windowGainedFocus(WindowEvent we) {
                if (!this.gotFocus) {
                    optPane.selectInitialValue();
                    this.gotFocus = true;
                }
            }
        });
        dialog.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent ce) {
                Print.dprintStackTrace((String)"");
                optPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
            }
        });
        optPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (dialog.isVisible() && event.getSource() == optPane && event.getPropertyName().equals("value") && event.getNewValue() != null && event.getNewValue() != JOptionPane.UNINITIALIZED_VALUE) {
                    Print.dprintStackTrace((String)"");
                    dialog.setVisible(false);
                }
            }
        });
        return dialog;
    }

    private static class ProgressThread
    extends Thread {
        private JOptionPane option = null;
        private JDialog dialog = null;
        private Runnable runnable = null;
        private boolean isDone = false;

        public ProgressThread(JOptionPane option, JDialog dialog, Runnable runnable) {
            this.option = option;
            this.dialog = dialog;
            this.runnable = runnable;
        }

        public boolean isDone() {
            return this.isDone;
        }

        public void run() {
            if (this.runnable != null) {
                try {
                    this.runnable.run();
                }
                catch (Throwable t) {
                    Print.dprintStackTrace((String)"Progress runnable error", (Throwable)t);
                }
                this.isDone = true;
            }
            if (this.dialog != null) {
                try {
                    int ms;
                    for (int maxWait = 3000; maxWait > 0 && !this.dialog.isShowing(); maxWait -= ms) {
                        ms = 500;
                        Thread.sleep(ms);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Print.dprintln((String)("Set JOptionPane Value: " + this.dialog.getTitle()));
                this.option.setValue("done");
            }
        }
    }
}

