/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIPanel;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledList;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class UIListSelector
extends UITitledBox {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UIListSelector.class);
    private static String LIST_NAME = localStrings.getLocalString("ui.uilistselector.list_name", "List");
    private static String LIST_DESC = localStrings.getLocalString("ui.uilistselector.list_desc", "This is a list of items");
    private static String ADD_BUTTON = localStrings.getLocalString("ui.uilistselector.add_button", "Add>");
    private static String REMOVE_BUTTON = localStrings.getLocalString("ui.uilistselector.remove_button", "<Remove");
    private static final String AVAILABLE_ITEMS = localStrings.getLocalString("ui.uilistselector.available_items", "Available Items");
    private static final String SELECTED_ITEMS = localStrings.getLocalString("ui.uilistselector.selected_items", "Selected Items");
    private static final char ADD_BUTTON_MNEMONIC = localStrings.getLocalString("ui.uilistselector.add_button_mnemonic", "a").charAt(0);
    private static final char REMOVE_BUTTON_MNEMONIC = localStrings.getLocalString("ui.uilistselector.remove_button_mnemonic", "v").charAt(0);
    private UITitledList listLeft = null;
    private UITitledList listRight = null;
    private JButton addButton = null;
    private JButton delButton = null;

    public UIListSelector(String titleLeft, String titleRight) {
        super((String)null, false);
        this.initLayout(titleLeft, titleRight);
    }

    private void initLayout(String titleLeft, String titleRight) {
        GridBagConstraints gbc = this.getGBConstraints();
        gbc.gridx = -1;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        JList jl = new JList();
        this.listLeft = new UITitledList(titleLeft, false, jl);
        jl.getAccessibleContext().setAccessibleName(LIST_NAME);
        jl.getAccessibleContext().setAccessibleDescription(LIST_DESC);
        this.addWithGBConstraints(this.listLeft);
        this.listLeft.getListView().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent lse) {
                if (lse.getValueIsAdjusting()) {
                    return;
                }
                UIListSelector.this.addButton.setEnabled(!UIListSelector.this.listLeft.isSelectionEmpty());
            }
        });
        UIPanel buttons = new UIPanel();
        buttons.setLayout(new GridBagLayout());
        GridBagConstraints bc = new GridBagConstraints();
        bc.weightx = 0.0;
        bc.weighty = 0.0;
        bc.gridx = 0;
        bc.gridy = -1;
        bc.insets = new Insets(3, 7, 3, 7);
        bc.fill = 2;
        bc.anchor = 10;
        gbc = this.getGBConstraintsCopy();
        gbc.weightx = 0.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.fill = 0;
        this.add((Component)buttons, gbc);
        this.addButton = new UIButton(ADD_BUTTON, ADD_BUTTON_MNEMONIC, new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                UIListSelector.this.addAction();
            }
        });
        this.addButton.setMargin(new Insets(3, 5, 3, 5));
        buttons.add((Component)this.addButton, bc);
        this.addButton.setEnabled(false);
        this.delButton = new UIButton(REMOVE_BUTTON, REMOVE_BUTTON_MNEMONIC, new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                UIListSelector.this.removeAction();
            }
        });
        this.delButton.setMargin(new Insets(3, 5, 3, 5));
        buttons.add((Component)this.delButton, bc);
        this.delButton.setEnabled(false);
        jl = new JList();
        this.listRight = new UITitledList(titleRight, false, jl);
        jl.getAccessibleContext().setAccessibleName(LIST_NAME);
        jl.getAccessibleContext().setAccessibleDescription(LIST_DESC);
        this.addWithGBConstraints(this.listRight);
        this.listRight.getListView().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent lse) {
                if (lse.getValueIsAdjusting()) {
                    return;
                }
                UIListSelector.this.delButton.setEnabled(!UIListSelector.this.listRight.isSelectionEmpty());
            }
        });
    }

    public void setDescriptorCellRenderer() {
        this.listLeft.setDescriptorCellRenderer();
        this.listRight.setDescriptorCellRenderer();
    }

    public void setTitleLeft(String title) {
        this.listLeft.setTitle(title);
    }

    public void setTitleRight(String title) {
        this.listRight.setTitle(title);
    }

    public void setListContentsLeft(Vector content) {
        this.listLeft.setListData(content);
        this.addButton.setEnabled(false);
    }

    public void setListContentsLeft(Enumeration content) {
        this.listLeft.setListData(content);
        this.addButton.setEnabled(false);
    }

    public void setListContentsRight(Vector content) {
        this.listRight.setListData(content);
        this.delButton.setEnabled(false);
    }

    public void setListContentsRight(Enumeration content) {
        this.listRight.setListData(content);
        this.delButton.setEnabled(false);
    }

    public Vector getListContentsRight() {
        return this.listRight.getListData();
    }

    protected void addAction() {
        this.listRight.addListItems(this.listLeft.getSelectedValues());
        this.listLeft.clearSelection();
        this.addButton.setEnabled(false);
    }

    protected void removeAction() {
        this.listRight.removeListItems(this.listRight.getSelectedValues());
        this.listRight.clearSelection();
        this.delButton.setEnabled(false);
    }

    public void sortListContentsLeft(boolean sort) {
        this.listLeft.setSorted(sort);
    }

    public void sortListContentsRight(boolean sort) {
        this.listRight.setSorted(sort);
    }

    public void setMnemonicLeft(char c) {
        this.listLeft.setMnemonic(c);
    }

    public void setMnemonicRight(char c) {
        this.listRight.setMnemonic(c);
    }
}

