/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelp;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.help.CSH;
import javax.swing.AbstractButton;

public class UIHelpButton
extends UIButton {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UIHelpButton.class);
    private static String HELP_TITLE = localStrings.getLocalString("ui.uihelpbutton.button_title", "Help...");
    private static char HELP_TITLE_MNEMONIC = localStrings.getLocalString("ui.uihelpbutton.button_title_mnemonic", "H").charAt(0);
    private String helpID = null;

    public UIHelpButton() {
        UIButton.setButtonText((AbstractButton)this, HELP_TITLE, HELP_TITLE_MNEMONIC);
        this.setActionCommand("help");
    }

    public UIHelpButton(String helpID) {
        this();
        this.setHelpID(helpID);
    }

    public UIHelpButton(Component helpComp) {
        this(CSH.getHelpIDString((Component)helpComp));
    }

    public void setHelpID(String helpID) {
        if (helpID != null && !helpID.equals("")) {
            this.helpID = helpID;
            UIHelp.getInstance().enableHelpOnButton(this, this.helpID);
            this.setEnabled(true);
        } else {
            this.helpID = null;
            this.setEnabled(false);
        }
    }

    public void setHelpID(Component helpComp) {
        this.setHelpID(CSH.getHelpIDString((Component)helpComp));
    }

    public String getHelpID() {
        return this.helpID;
    }

    protected void fireActionPerformed(ActionEvent ae) {
        if (UIHelp.getInstance().isHelpValid(this, this.helpID)) {
            super.fireActionPerformed(ae);
        }
    }
}

