/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import com.sun.jdo.modules.persistence.mapping.core.util.MappingContext;
import java.awt.Component;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.MenuItem;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.net.URL;
import javax.help.CSH;
import javax.help.DefaultHelpBroker;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.Map;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;

public class UIHelp {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UIHelp.class);
    private static String NULL_HELP = localStrings.getLocalString("ui.uihelp.null_help", "Help has not been enabled for this button.");
    private static final String HELP_SET_NAME = "Help";
    private static final String HELP_SET_CMP = "com/sun/jdo/modules/persistence/docs/tp";
    public static final String UNDEFINED_GROUP = "??";
    private static final boolean createCustomHelpBroker = true;
    private static final UIDialog hiddenDialog = new UIDialog((Frame)null, true);
    protected static UIHelpButton usingHelpHiddenButton = null;
    protected static UIHelpButton contentHiddenButton = null;
    private static UIHelp helpInstance = null;
    private HelpSet mainHelpSet;
    private HelpBroker mainHelpBroker;
    private _DisplayHelpFromFocus displayHelpFromFocus;
    private static final boolean INIT_HELP_BROKER_PRESENTATION = false;
    private static final int HELP_OK = 0;
    private static final int HELP_NULL = 1;
    private static final int HELP_NOT_FOUND = 2;
    private static final int HELP_ERROR = 3;

    private static String CANT_LOAD_HELPSET(String v0) {
        return localStrings.getLocalString("ui.uihelp.cant_init_helpset", "Unable to initialize HelpSet ''{0}''.", new Object[]{v0});
    }

    private static String NO_HELP(String v0) {
        return localStrings.getLocalString("ui.uihelp.no_help", "No help available at this time.\n[help-id ''{0}'']", new Object[]{v0});
    }

    private static String ERROR_HELP(String v0) {
        return localStrings.getLocalString("ui.uihelp.error_getting_help", "Unable to obtain help at this time.\n[help-id ''{0}'']", new Object[]{v0});
    }

    public static UIHelp getInstance() {
        if (helpInstance == null) {
            helpInstance = new UIHelp();
            usingHelpHiddenButton = new UIHelpButton("UsingHelp");
            hiddenDialog.getContentPane().add(usingHelpHiddenButton);
            contentHiddenButton = new UIHelpButton("PrimaryWindow");
            hiddenDialog.getContentPane().add(contentHiddenButton);
        }
        return helpInstance;
    }

    private UIHelp() {
        block11: {
            this.mainHelpSet = null;
            this.mainHelpBroker = null;
            this.displayHelpFromFocus = null;
            try {
                ClassLoader cl = UIHelp.class.getClassLoader();
                URL url = HelpSet.findHelpSet((ClassLoader)cl, (String)HELP_SET_NAME);
                if (url == null) break block11;
                this.mainHelpSet = new UIHelpSet(cl, url);
                HelpSet cmpHelpSet = null;
                try {
                    cmpHelpSet = MappingContext.getHelpSet();
                }
                catch (Throwable t) {
                    cmpHelpSet = null;
                    Print.dprintln((String)("MappingContext.getHelpSet error: " + t));
                }
                if (cmpHelpSet == null) {
                    try {
                        ClassLoader cmpCl = ClassLoader.getSystemClassLoader();
                        URL cmpUrl = HelpSet.findHelpSet((ClassLoader)cmpCl, (String)HELP_SET_CMP);
                        if (cmpUrl != null) {
                            cmpHelpSet = new UIHelpSet(cl, cmpUrl);
                        }
                    }
                    catch (Exception ex) {
                        Print.dprintln((String)("Error loading CMP HelpSet: " + ex));
                    }
                }
                if (cmpHelpSet != null) {
                    this.mainHelpSet.add(cmpHelpSet);
                    Print.dprintln((String)"CMP HelpSet loaded");
                } else {
                    Print.dprintln((String)"CMP HelpSet not available.");
                }
            }
            catch (Exception ex) {
                this.mainHelpSet = null;
            }
        }
        this._initHelpBroker();
        if (!this.isValid()) {
            Print.println((String)UIHelp.CANT_LOAD_HELPSET(HELP_SET_NAME));
        }
    }

    public boolean isValid() {
        return this.mainHelpSet != null && this.mainHelpBroker != null;
    }

    public String getHelpSetName() {
        return HELP_SET_NAME;
    }

    public HelpSet getHelpSet() {
        return this.mainHelpSet;
    }

    public HelpBroker getHelpBroker() {
        return this.mainHelpBroker;
    }

    public void addHelpSet(HelpSet hs) {
        if (this.mainHelpSet != null) {
            this.mainHelpSet.add(hs);
        }
    }

    private void _initHelpBroker() {
        if (this.mainHelpSet != null && this.mainHelpBroker == null) {
            this.mainHelpBroker = new UIHelpBroker(this.mainHelpSet);
        }
    }

    public void enableHelpOnButton(Component comp, String helpId) {
        if (this.isValid()) {
            boolean helpOk = this._checkHelpId(helpId);
            comp.setVisible(helpOk || !UIConfig.getConfigBoolean("ui.Help.hideInvalidHelp"));
            this.mainHelpBroker.enableHelpOnButton(comp, helpId, this.mainHelpSet);
        } else {
            comp.setVisible(false);
        }
    }

    public void enableHelpOnButton(MenuItem comp, String helpId) {
        if (this.isValid()) {
            boolean helpOk = this._checkHelpId(helpId);
            comp.setEnabled(helpOk || !UIConfig.getConfigBoolean("ui.Help.hideInvalidHelp"));
            this.mainHelpBroker.enableHelpOnButton(comp, helpId, this.mainHelpSet);
        } else {
            comp.setEnabled(false);
        }
    }

    public void enableHelpKey(Component comp, String helpId) {
        if (!this._checkHelpId(helpId) && UIConfig.getConfigBoolean("ui.Help.hideInvalidHelp")) {
            return;
        }
        CSH.setHelpIDString((Component)comp, (String)helpId);
        if (this.mainHelpSet != null) {
            CSH.setHelpSet((Component)comp, (HelpSet)this.mainHelpSet);
        }
        if (comp instanceof JComponent) {
            JComponent root = (JComponent)comp;
            if (this.displayHelpFromFocus == null) {
                this.displayHelpFromFocus = new _DisplayHelpFromFocus(this.mainHelpBroker);
            }
            root.registerKeyboardAction(this.displayHelpFromFocus, KeyStroke.getKeyStroke(156, 0), 2);
            root.registerKeyboardAction(this.displayHelpFromFocus, KeyStroke.getKeyStroke(112, 0), 2);
        } else {
            comp.addKeyListener((KeyListener)this.mainHelpBroker);
        }
    }

    private boolean _checkHelpId(String helpId) {
        boolean preCheck = UIConfig.getConfigBoolean("ui.Help.preCheck");
        switch (this._isHelpValid(helpId, preCheck)) {
            case 1: {
                Print.dprintStackTrace((String)"Help-ID is 'null'");
                return false;
            }
            case 2: {
                Print.dprintln((String)("Help-ID '" + helpId + "' was not found."));
                return false;
            }
            case 3: {
                Print.dprintStackTrace((String)("Error looking up Help-ID '" + helpId + "'."));
                return false;
            }
        }
        return true;
    }

    public boolean isHelpValid(Component comp, String helpID) {
        switch (this._isHelpValid(helpID, true)) {
            case 1: {
                UIOptionPane.showWarningDialog(comp, NULL_HELP);
                return false;
            }
            case 2: {
                Print.println((String)("Help-ID '" + helpID + "' was not found."));
                UIOptionPane.showWarningDialog(comp, UIHelp.NO_HELP(helpID));
                return false;
            }
            case 3: {
                Print.println((String)("Error looking up Help-ID: " + helpID));
                UIOptionPane.showWarningDialog(comp, UIHelp.ERROR_HELP(helpID));
                return false;
            }
        }
        return true;
    }

    private int _isHelpValid(String helpId, boolean preCheck) {
        if (helpId == null) {
            return 1;
        }
        if (helpId.startsWith(UNDEFINED_GROUP)) {
            return 2;
        }
        if (preCheck) {
            try {
                HelpSet hs = this.getHelpSet();
                if (!hs.getCombinedMap().isValidID(helpId, hs)) {
                    return 2;
                }
            }
            catch (Throwable t) {
                Print.dprintStackTrace((String)("Error looking up '" + helpId + "'"), (Throwable)t);
                return 3;
            }
        }
        return 0;
    }

    private class UIHelpSet
    extends HelpSet {
        public UIHelpSet(ClassLoader cl, URL url) throws HelpSetException {
            super(cl, url);
        }
    }

    private class UIHelpBroker
    extends DefaultHelpBroker {
        public UIHelpBroker(HelpSet hs) {
            this();
            this.setHelpSet(hs);
        }

        public UIHelpBroker() {
        }

        public void setActivationWindow(Window window) {
            super.setActivationWindow(window);
        }
    }

    private static class _DisplayHelpFromFocus
    implements ActionListener {
        private HelpBroker hb = null;

        public _DisplayHelpFromFocus(HelpBroker hb) {
            if (hb == null) {
                Print.printStackTrace((String)"Null help-broker specified");
            }
            this.hb = hb;
        }

        public void actionPerformed(ActionEvent e) {
            block7: {
                Component comp;
                Component src = (Component)e.getSource();
                if (this.hb instanceof DefaultHelpBroker) {
                    ((DefaultHelpBroker)this.hb).setActivationWindow((Window)hiddenDialog);
                }
                if ((comp = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) == null) {
                    comp = src;
                }
                if (comp instanceof JTabbedPane) {
                    comp = ((JTabbedPane)comp).getSelectedComponent();
                }
                String helpID = CSH.getHelpIDString((Component)comp);
                HelpSet hs = CSH.getHelpSet((Component)comp);
                if (hs == null) {
                    hs = this.hb.getHelpSet();
                }
                try {
                    Map.ID id = Map.ID.create((String)helpID, (HelpSet)hs);
                    if (id == null) {
                        id = hs.getHomeID();
                    }
                    this.hb.setCurrentID(id);
                    this.hb.setDisplayed(true);
                }
                catch (Exception e2) {
                    Print.dprintln((String)("Invalid F1 Help-ID: " + helpID));
                    if (UIConfig.getConfigBoolean("ui.Help.hideInvalidHelp")) break block7;
                    UIOptionPane.showWarningDialog(null, UIHelp.NO_HELP(helpID));
                }
            }
        }
    }
}

