/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UICheckBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIPanel;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeSelectionModel;

public class UIControlButtonBox
extends UITitledBox
implements ListSelectionListener,
TreeSelectionListener {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UIControlButtonBox.class);
    private final String SCROLL_NAME = localStrings.getLocalString("ui.userdialog.scroll_name", "Scroll Panel");
    private final String SCROLL_DESC = localStrings.getLocalString("ui.userdialog.scroll_desc", "This is a scroll pane");
    private final String PANEL_NAME = localStrings.getLocalString("ui.userdialog.panel_name", "Panel");
    private final String PANEL_DESC = localStrings.getLocalString("ui.userdialog.panel_desc", "This is a  panel");
    public static final int UNDEFINED = 0;
    public static final int RIGHT = 13;
    public static final int LEFT = 17;
    public static final int TOP = 11;
    public static final int BOTTOM = 15;
    public static final int BOTTOM_RIGHT = 101;
    public static final int BOTTOM_LEFT = 102;
    public static final int BOTTOM_FILL = 103;
    public static final int RIGHT_TOP = 201;
    public static final int RIGHT_BOTTOM = 202;
    public static final int FILL = 300;
    private static final int BUTTON_RIGHT_COLUMN = 1;
    private static final int BUTTON_BOTTOM_ROW = 3;
    private static final int NEXT_BUTTON = -1;
    private static final int LAST_BUTTON = 16;
    private GridBagConstraints viewContainerGBC = new GridBagConstraints();
    private JPanel viewContainer = null;
    private JComponent bannerView = null;
    private JComponent view = null;
    private JComponent accessoryView = null;
    private boolean _addAccessoryView = false;
    private boolean isScrollable = false;
    private JPanel controlPanel = null;
    private int controlLocation = 0;
    private int controlAnchor = 0;
    private boolean controlFill = false;
    private boolean adjustControlSize = false;
    protected Vector controlList = null;
    protected Vector selectionControlList = null;
    protected SelectionEnabledSpecifier selectionEnabledSpecifier = null;
    protected boolean isSelectionEnabled = false;
    private Component lastComponent = null;

    public UIControlButtonBox() {
        this((String)null, false);
    }

    public UIControlButtonBox(String title, boolean showBorder) {
        super(title, showBorder);
        this.viewContainerGBC.weightx = 0.5;
        this.viewContainerGBC.weighty = 0.5;
        this.viewContainerGBC.gridx = 0;
        this.viewContainerGBC.gridy = -1;
        this.viewContainerGBC.gridwidth = 1;
        this.viewContainerGBC.gridheight = 1;
        this.viewContainerGBC.insets = new Insets(0, 0, 0, 0);
        this.viewContainerGBC.fill = 1;
        this.viewContainerGBC.anchor = 10;
        this.viewContainer = new UIPanel(new GridBagLayout());
        this.setGBConstraints(this.viewContainer);
        this.add(this.viewContainer);
    }

    public GridBagConstraints getViewContainerGBConstraints() {
        return this.viewContainerGBC;
    }

    public GridBagConstraints getViewContainerGBConstraintsCopy() {
        return (GridBagConstraints)this.viewContainerGBC.clone();
    }

    public JPanel getContainerView() {
        if (!this.viewContainer.isVisible()) {
            this.viewContainer.setVisible(true);
        }
        return this.viewContainer;
    }

    public void setView(JComponent view) {
        this.setView(view, false);
    }

    public void setView(JComponent view, boolean scrollable) {
        JComponent ctlView;
        if (view == null) {
            if (this.viewContainer.isVisible()) {
                this.viewContainer.setVisible(false);
            }
            return;
        }
        if (this.view != null) {
            Print.dprintStackTrace((String)"'setView' ignored: View already set");
            return;
        }
        JPanel vc = this.getContainerView();
        this.view = view;
        if (!this.isEnabled()) {
            this._setComponentEnabled(this.view, false);
        }
        this.isScrollable = scrollable;
        if (this.isScrollable) {
            ctlView = new JScrollPane(this.view);
            ctlView.getAccessibleContext().setAccessibleName(this.SCROLL_NAME);
            ctlView.getAccessibleContext().setAccessibleDescription(this.SCROLL_DESC);
            Border border = ctlView.getBorder();
            ctlView.setBorder(new EmptyBorder(0, 0, 0, 0));
            vc.setBorder(BorderFactory.createLoweredBevelBorder());
        } else {
            ctlView = this.view;
        }
        GridBagConstraints c = this.getViewContainerGBConstraintsCopy();
        c.weighty = 0.5;
        c.gridy = 1;
        c.fill = 1;
        vc.add((Component)ctlView, c);
        ctlView.invalidate();
    }

    public JComponent getView() {
        return this.view;
    }

    public boolean isScrollable() {
        return this.isScrollable;
    }

    public void setBannerView(JComponent banner) {
        if (this.viewContainer.isVisible()) {
            this.bannerView = banner;
            if (!this.isEnabled()) {
                this._setComponentEnabled(this.bannerView, false);
            }
            GridBagConstraints c = this.getViewContainerGBConstraintsCopy();
            c.weighty = 0.0;
            c.gridy = 0;
            c.fill = 2;
            this.viewContainer.add((Component)this.bannerView, c);
        }
    }

    public JComponent getBannerView() {
        return this.bannerView;
    }

    public void setAccessoryView(JComponent accessory) {
        if (this.accessoryView != null && this.accessoryView.getParent() != null) {
            this.remove(this.accessoryView);
        }
        this.accessoryView = accessory;
        if (!this.isEnabled()) {
            this._setComponentEnabled(this.accessoryView, false);
        }
        GridBagConstraints c = this.getGBConstraintsCopy();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 2, 2, 2);
        this.add((Component)this.accessoryView, c);
    }

    public JComponent getAccessoryView() {
        return this.accessoryView;
    }

    public void setControlButtonLocation(int location, boolean fillWidth) {
        if (this.controlPanel == null) {
            if (location == 15 && fillWidth) {
                location = 103;
            }
            if (location == 15) {
                this.controlLocation = 15;
            } else if (location == 103) {
                this.controlLocation = 15;
                this.controlFill = true;
                this.controlAnchor = 0;
            } else if (location == 101) {
                this.controlLocation = 15;
                this.controlAnchor = 13;
            } else if (location == 102) {
                this.controlLocation = 15;
                this.controlAnchor = 17;
            } else if (location == 13) {
                this.controlLocation = 13;
            } else if (location == 201) {
                this.controlLocation = 13;
                this.controlAnchor = 11;
            } else if (location == 202) {
                this.controlLocation = 13;
                this.controlAnchor = 15;
            } else {
                this.controlLocation = 13;
            }
        }
    }

    public void setControlButtonLocation(int location) {
        this.setControlButtonLocation(location, false);
    }

    public void setControlButtonAnchor(int anchor) {
        if (anchor == 300) {
            if (this.controlLocation == 15) {
                this.controlFill = true;
            } else {
                Print.dprintStackTrace((String)"'FILL' is valid for 'BOTTOM' button placement only");
            }
        } else {
            this.controlAnchor = anchor;
        }
    }

    public void addControlButton(AbstractButton button) {
        this.addControlComponent(button);
    }

    public void addSelectionEnabledButton(AbstractButton button) {
        this.addSelectionEnabledComponent(button);
    }

    public void addControlComponent(Component comp) {
        this.addControlComponent(comp, -1);
    }

    private void addControlComponent(Component comp, int gridLoc) {
        int compFill;
        double compWeight;
        boolean isSpacer = false;
        if (comp instanceof Spacer) {
            isSpacer = true;
            compWeight = ((Spacer)comp).getGridBagWeight();
        } else {
            compWeight = this.controlFill ? 0.5 : 0.0;
        }
        int n = compFill = isSpacer ? ((Spacer)comp).getGridBagFill() : 0;
        if (this.controlLocation == 0) {
            this.controlLocation = 13;
        }
        if (this.controlPanel == null) {
            this.controlList = new Vector();
            this.selectionControlList = new Vector();
            this.controlPanel = new UIPanel();
            this.controlPanel.setLayout(new GridBagLayout());
            if (UIConfig.getConfigBoolean("ui.debug.showControlBorders")) {
                this.controlPanel.setBorder(LineBorder.createGrayLineBorder());
            }
            GridBagConstraints c = this.getGBConstraintsCopy();
            if (this.controlLocation == 13) {
                c.weightx = 0.0;
                c.weighty = 0.0;
                c.gridx = 1;
                c.gridy = 0;
                c.fill = 0;
                c.insets.left = 5;
                c.insets.right = 5;
                c.anchor = this.controlAnchor == 15 ? 15 : (this.controlAnchor == 11 ? 11 : 10);
            } else {
                c.weightx = 1.0;
                c.weighty = 0.0;
                c.gridx = 0;
                c.gridy = 3;
                c.fill = 2;
                c.insets.top = 5;
                c.insets.bottom = 5;
                c.anchor = 13;
            }
            this.add((Component)this.controlPanel, c);
        }
        int fixedGridLoc = 0;
        GridBagConstraints bc = new GridBagConstraints();
        bc.ipadx = 0;
        bc.ipady = 0;
        bc.gridwidth = 1;
        bc.gridheight = 1;
        if (this.controlLocation == 13) {
            bc.weightx = 0.5;
            bc.weighty = compWeight;
            bc.gridx = fixedGridLoc;
            bc.gridy = gridLoc >= 0 ? gridLoc : this.controlList.size();
            bc.fill = compFill != 0 ? compFill : 2;
            bc.insets = new Insets(5, 0, 5, 0);
            if (this.lastComponent instanceof Spacer) {
                bc.insets.top = 0;
            }
            switch (this.controlAnchor) {
                case 15: {
                    bc.anchor = 15;
                    break;
                }
                case 11: {
                    bc.anchor = 11;
                    break;
                }
                default: {
                    bc.anchor = 10;
                    break;
                }
            }
        } else {
            if (!(comp instanceof Spacer) && this.controlList.isEmpty()) {
                if (this.controlAnchor == 13) {
                    this.addControlComponent(new LeftSpacer(true), -1);
                } else if (this.controlAnchor == 17) {
                    this.addControlComponent(new RightSpacer(true), 16);
                }
            }
            bc.weightx = compWeight;
            bc.weighty = 0.5;
            bc.gridx = gridLoc >= 0 ? gridLoc : this.controlList.size();
            bc.gridy = fixedGridLoc;
            bc.fill = compFill != 0 ? compFill : (this.controlFill ? 2 : 0);
            Insets insets = bc.insets = isSpacer || bc.gridx == 0 ? new Insets(0, 0, 0, 0) : new Insets(0, 8, 0, 0);
            if (this.lastComponent instanceof Spacer) {
                bc.insets.left = 0;
            }
            switch (this.controlAnchor) {
                case 13: {
                    bc.anchor = 13;
                    break;
                }
                case 17: {
                    bc.anchor = 17;
                    break;
                }
                default: {
                    bc.anchor = 10;
                }
            }
            boolean bl = this.adjustControlSize = !this.controlFill;
        }
        if (this.controlFill && comp instanceof JButton) {
            Insets insets = (Insets)((JButton)comp).getMargin().clone();
            insets.left = 3;
            insets.right = 3;
            ((JButton)comp).setMargin(insets);
        }
        this.lastComponent = comp;
        this.controlPanel.add(comp, bc);
        if (!(comp instanceof RightSpacer)) {
            this.controlList.add(comp);
        }
        if (!(comp instanceof Spacer) && !this.isEnabled()) {
            this._setComponentEnabled(comp, false);
        }
    }

    public void addSelectionEnabledComponent(Component comp) {
        this.addControlComponent(comp);
        this.addComponentToSelectionEnabledList(comp);
    }

    public void addComponentToSelectionEnabledList(Component comp) {
        this.selectionControlList.add(comp);
        this._setComponentEnabled(comp, false);
    }

    public void addControlSpacer() {
        this.addControlSpacer(10);
    }

    public void addControlSpacer(int pixels) {
        boolean horz = this.controlLocation == 15;
        this.addControlComponent(new Spacer(pixels, horz));
    }

    protected GridBagConstraints getDefaultGBConstraints(GridBagConstraints c) {
        c = super.getDefaultGBConstraints(c);
        c.gridx = 0;
        c.gridy = -1;
        c.gridwidth = 1;
        c.gridheight = 2;
        return c;
    }

    public void doLayout() {
        if (this.viewContainer.isVisible() && this.view == null) {
            this.viewContainer.setVisible(false);
        }
        if (this.adjustControlSize) {
            JComponent c;
            Dimension prefSize = new Dimension(0, 0);
            Enumeration e = this.controlList.elements();
            while (e.hasMoreElements()) {
                c = (JComponent)e.nextElement();
                if (c instanceof Spacer) continue;
                Dimension d = c.getPreferredSize();
                if (d.width > prefSize.width) {
                    prefSize.width = d.width;
                }
                if (d.height <= prefSize.height) continue;
                prefSize.height = d.height;
            }
            e = this.controlList.elements();
            while (e.hasMoreElements()) {
                c = (JComponent)e.nextElement();
                c.setPreferredSize(prefSize);
            }
            this.adjustControlSize = false;
        }
        super.doLayout();
    }

    public void valueChanged(ListSelectionEvent lse) {
        ListSelectionModel lsm = (ListSelectionModel)lse.getSource();
        if (lse.getValueIsAdjusting()) {
            return;
        }
        boolean state = lsm.isSelectionEmpty() ? false : this.shouldEnableControlsForSelection(lsm);
        this.setSelectionButtonsEnabled(state);
    }

    protected boolean shouldEnableControlsForSelection(ListSelectionModel lsm) {
        return this.selectionEnabledSpecifier != null ? this.selectionEnabledSpecifier.shouldEnableControlsForSelection(lsm) : true;
    }

    public boolean isSelectionEmpty() {
        return true;
    }

    public void valueChanged(TreeSelectionEvent tse) {
        TreeSelectionModel tsm = (TreeSelectionModel)tse.getSource();
        boolean state = tsm.isSelectionEmpty() ? false : this.shouldEnableControlsForSelection(tsm);
        this.setSelectionButtonsEnabled(state);
    }

    protected boolean shouldEnableControlsForSelection(TreeSelectionModel tsm) {
        return this.selectionEnabledSpecifier != null ? this.selectionEnabledSpecifier.shouldEnableControlsForSelection(tsm) : true;
    }

    public void setSelectionEnabledSpecifier(SelectionEnabledSpecifier ses) {
        this.selectionEnabledSpecifier = ses;
    }

    public void setReadOnly(boolean state) {
        super.setReadOnly(state);
        this.setButtonsReadOnly(state);
    }

    protected void setButtonsReadOnly(boolean state) {
        if (this.controlList != null) {
            Enumeration e = this.controlList.elements();
            while (e.hasMoreElements()) {
                Object c = e.nextElement();
                this._setComponentReadOnly(c, state);
            }
        }
    }

    private void _setComponentReadOnly(Object c, boolean state) {
        if (!(c instanceof Spacer)) {
            if (c instanceof UITitledBox) {
                ((UITitledBox)c).setReadOnly(state);
            } else if (c instanceof UIButton) {
                ((UIButton)c).setReadOnly(state);
            } else if (c instanceof UICheckBox) {
                ((UICheckBox)c).setReadOnly(state);
            } else if (c instanceof AbstractButton) {
                Print.dprintln((String)("Convert this to a UIButton: " + DT.className(c)));
                ((AbstractButton)c).setEnabled(!state);
            } else if (c instanceof Component) {
                Print.dprintln((String)("Convert this to a UI?????: " + DT.className(c)));
                ((Component)c).setEnabled(!state);
            } else {
                Print.printStackTrace((String)("Unsupported class - " + DT.className(c)));
            }
        }
    }

    private void _setComponentEnabled(Object c, boolean state) {
        if (!(c instanceof Spacer)) {
            if (c instanceof UITitledBox) {
                ((UITitledBox)c).setEnabled(state);
            } else if (c instanceof UIButton) {
                ((UIButton)c).setEnabled(state);
            } else if (c instanceof UICheckBox) {
                ((UICheckBox)c).setEnabled(state);
            } else if (c instanceof AbstractButton) {
                Print.dprintln((String)("Convert this to a UIButton: " + DT.className(c)));
                ((AbstractButton)c).setEnabled(state && !this.isReadOnly());
            } else if (c instanceof Component) {
                Print.dprintln((String)("Convert this to a UI?????: " + DT.className(c)));
                ((Component)c).setEnabled(state && !this.isReadOnly());
            } else {
                Print.printStackTrace((String)("Unsupported class - " + DT.className(c)));
            }
        }
    }

    public void setButtonsEnabled(boolean state) {
        this.setButtonsEnabled(state, null, false);
    }

    protected void setButtonsEnabled(boolean state, Collection exceptList, boolean exceptState) {
        if (this.controlList != null) {
            Enumeration e = this.controlList.elements();
            while (e.hasMoreElements()) {
                Object c = e.nextElement();
                boolean f = exceptList == null || !exceptList.contains(c) ? state : exceptState;
                this._setComponentEnabled(c, f);
            }
        }
    }

    protected void setSelectionButtonsEnabled(boolean state) {
        this.isSelectionEnabled = state;
        if (this.selectionControlList != null) {
            Enumeration enumeration = this.selectionControlList.elements();
            while (enumeration.hasMoreElements()) {
                this._setComponentEnabled(enumeration.nextElement(), this.isSelectionEnabled);
            }
        }
    }

    protected boolean areSelectionButtonsEnabled() {
        return this.isSelectionEnabled;
    }

    public void setEnabled(boolean state) {
        if (this.view != null) {
            this.view.setEnabled(state);
        }
        if (this.bannerView != null) {
            this.bannerView.setEnabled(state);
        }
        this.setButtonsEnabled(state);
        super.setEnabled(state);
    }

    public String toString() {
        return this.view != null ? this.view.toString() : super.toString();
    }

    public static interface SelectionEnabledSpecifier {
        public boolean shouldEnableControlsForSelection(ListSelectionModel var1);

        public boolean shouldEnableControlsForSelection(TreeSelectionModel var1);
    }

    private class RightSpacer
    extends Spacer {
        public RightSpacer(boolean horizontal) {
            super(-1, horizontal);
        }
    }

    private class LeftSpacer
    extends Spacer {
        public LeftSpacer(boolean horizontal) {
            super(-1, horizontal);
        }
    }

    private class Spacer
    extends JPanel {
        private int pixelSize = -1;
        private boolean horizontal = true;

        public Spacer(int pixelSize, boolean horizontal) {
            this.getAccessibleContext().setAccessibleName(UIControlButtonBox.this.PANEL_NAME);
            this.getAccessibleContext().setAccessibleDescription(UIControlButtonBox.this.PANEL_DESC);
            this.pixelSize = pixelSize;
            this.horizontal = horizontal;
            if (UIConfig.getConfigBoolean("ui.debug.showControlBorders")) {
                this.setBorder(LineBorder.createGrayLineBorder());
            }
        }

        public void setPreferredSize(Dimension size) {
            if (this.pixelSize >= 0) {
                Dimension d = new Dimension(size);
                if (this.horizontal) {
                    d.width = this.pixelSize;
                } else {
                    d.height = this.pixelSize;
                }
                super.setPreferredSize(d);
            }
        }

        public void setMinimumSize(Dimension size) {
        }

        public int getGridBagFill() {
            if (this.pixelSize >= 0) {
                return 0;
            }
            return this.horizontal ? 2 : 3;
        }

        public double getGridBagWeight() {
            if (this.pixelSize >= 0) {
                return 0.0;
            }
            return 1.0;
        }
    }
}

