/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;

public class UIButtonEnabler {
    private static UIButtonEnabler globalEnabler = null;
    private Hashtable keyTable = new Hashtable();
    private Hashtable xrefTable = new Hashtable();

    public static UIButtonEnabler GetGlobalEnabler() {
        if (globalEnabler == null) {
            globalEnabler = new UIButtonEnabler();
        }
        return globalEnabler;
    }

    public void add(String key, AbstractButton button) {
        this._add(key, button);
    }

    public void add(String[] key, AbstractButton button) {
        this._add(key, button);
    }

    public void add(EnablerKey key, AbstractButton button) {
        this._add(key, button);
    }

    public void add(EnablerKey[] key, AbstractButton button) {
        this._add(key, button);
    }

    private void _add(Object key, AbstractButton button) {
        if (key != null && !key.equals("")) {
            if (key instanceof String && !key.equals("")) {
                ButtonHolder holder = this._addToHolder(key, button);
                this._addToXRef(holder, button);
            } else if (key instanceof EnablerKey) {
                ButtonHolder holder = this._addToHolder(key, button);
                this._addToXRef(holder, button);
            } else if (key instanceof String[] || key instanceof EnablerKey[]) {
                Vector<ButtonHolder> v = new Vector<ButtonHolder>();
                Object[] k = (Object[])key;
                for (int i = 0; i < k.length; ++i) {
                    if (k[i] == null || k[i].equals("")) continue;
                    v.add(this._addToHolder(k[i], button));
                }
                if (v.size() == 1) {
                    this._addToXRef(v.elementAt(0), button);
                } else if (v.size() > 0) {
                    this._addToXRef(v.toArray(new ButtonHolder[v.size()]), button);
                }
            } else {
                Print.dprintStackTrace((String)("Unsupported key type: " + DT.className(key)));
            }
        }
    }

    private ButtonHolder _addToHolder(Object key, AbstractButton button) {
        ButtonHolder holder = (ButtonHolder)this.keyTable.get(key);
        if (holder == null) {
            holder = new ButtonHolder(key);
            this.keyTable.put(key, holder);
        }
        holder.add(button);
        return holder;
    }

    private void _addToXRef(Object holder, AbstractButton button) {
        Vector<Object> xref = (Vector<Object>)this.xrefTable.get(button);
        if (xref == null) {
            xref = new Vector<Object>();
            this.xrefTable.put(button, xref);
        }
        xref.add(holder);
    }

    public void setEnabled(EnablerKey key) {
        if (key != null) {
            this._set_Enabled(key, key.getEnable());
        }
    }

    public void setEnabled(EnablerKey key, boolean state) {
        if (key != null) {
            this._set_Enabled(key, state);
        }
    }

    public void setEnabled(String key, boolean state) {
        Print.printStackTrace((String)"This shouldn't be called");
        if (key != null) {
            this._set_Enabled(key, state);
        }
    }

    private void _set_Enabled(Object key, boolean state) {
        if (key == null) {
            return;
        }
        ButtonHolder holder = (ButtonHolder)this.keyTable.get(key);
        if (holder == null) {
            return;
        }
        holder.setState(state);
        boolean newState = true;
        Iterator be = holder.getButtonList().iterator();
        while (be.hasNext()) {
            Object b = be.next();
            Vector v = (Vector)this.xrefTable.get(b);
            Enumeration se = v.elements();
            while (newState && se.hasMoreElements()) {
                Object bh = se.nextElement();
                if (bh instanceof ButtonHolder[]) {
                    boolean orstate = false;
                    ButtonHolder[] h = (ButtonHolder[])bh;
                    for (int i = 0; i < h.length; ++i) {
                        if (h[i] == null || !h[i].getState()) continue;
                        orstate = true;
                        break;
                    }
                    newState = newState && orstate;
                    continue;
                }
                ButtonHolder h = (ButtonHolder)bh;
                newState = newState && h.getState();
            }
            UIButtonEnabler._setEnabled(b, newState);
        }
    }

    private static void _setEnabled(Object b, boolean state) {
        if (b instanceof AbstractButton) {
            ((AbstractButton)b).setEnabled(state);
        } else if (b instanceof UITitledBox) {
            ((UITitledBox)b).setEnabled(state);
        } else if (b instanceof Component) {
            ((Component)b).setEnabled(state);
        }
    }

    private class ButtonHolder {
        private Object key = null;
        public boolean state = true;
        private List buttonList = new Vector();

        public ButtonHolder(Object key) {
            this.key = key;
        }

        public void add(Object b) {
            this.buttonList.add(b);
            UIButtonEnabler._setEnabled(b, this.state);
        }

        public boolean getState() {
            return this.state;
        }

        public void setState(boolean state) {
            this.state = state;
        }

        public List getButtonList() {
            return this.buttonList;
        }
    }

    public static class EnablerKey {
        private String name = "";
        private boolean enable = false;

        public EnablerKey(String name) {
            this.name = name;
        }

        public void setEnable(boolean state) {
            this.enable = state;
        }

        public boolean getEnable() {
            return this.enable;
        }

        public String toString() {
            return this.name;
        }
    }
}

