/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

public class UIButton
extends JButton {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UIButton.class);
    private static final String BTN_ADD = localStrings.getLocalString("ui.uibutton.add_button", "Add");
    private static final String BTN_ADD__ = localStrings.getLocalString("ui.uibutton.add_button_ellipsis", "Add...");
    private static final String BTN_DELETE = localStrings.getLocalString("ui.uibutton.delete_button", "Delete");
    private static final String BTN_DELETE__ = localStrings.getLocalString("ui.uibutton.delete_button_ellipsis", "Delete...");
    private static final String BTN_EDIT = localStrings.getLocalString("ui.uibutton.edit_button", "Edit");
    private static final String BTN_EDIT__ = localStrings.getLocalString("ui.uibutton.edit_button_ellipsis", "Edit...");
    private static final String BTN_EDIT_CONTENTS = localStrings.getLocalString("ui.uibutton.edit_contents_button", "Edit Contents");
    private static final String BTN_EDIT_CONTENTS__ = localStrings.getLocalString("ui.uibutton.edit_contents_button_ellipsis", "Edit Contents...");
    private static final String BTN_NEW = localStrings.getLocalString("ui.uibutton.new_button", "New");
    private static final String BTN_NEW__ = localStrings.getLocalString("ui.uibutton.new_button_ellipsis", "New...");
    private static final String BTN_REMOVE = localStrings.getLocalString("ui.uibutton.remove_button", "Remove");
    private static final String BTN_REMOVE__ = localStrings.getLocalString("ui.uibutton.remove_button_ellipsis", "Remove...");
    private static final String BTN_SAVE = localStrings.getLocalString("ui.uibutton.save_button", "Save");
    private static final String BTN_SAVEAS = localStrings.getLocalString("ui.uibutton.saveas_button", "Save As");
    private static final String BTN_OK = localStrings.getLocalString("ui.uibutton.ok_button", "OK");
    private static final String BTN_APPLY = localStrings.getLocalString("ui.uibutton.apply_button", "Apply");
    private static final String BTN_CANCEL = localStrings.getLocalString("ui.uibutton.cancel_button", "Cancel");
    private static final String BTN_CLOSE = localStrings.getLocalString("ui.uibutton.close_button", "Close");
    private static final String BTN_MOVE_UP = localStrings.getLocalString("ui.uibutton.move_up_button", "Move Up");
    private static final String BTN_MOVE_DOWN = localStrings.getLocalString("ui.uibutton.move_down_button", "Move Down");
    private static final String BTN_IMPORT__ = localStrings.getLocalString("ui.uibutton.import_button", "Import...");
    private static char MNEMONIC_ESC = (char)125;
    private static boolean UseIndexOf_MNEMONIC_ESC = false;
    public static final String ACTION_OK = "ok";
    public static final String ACTION_APPLY = "apply";
    public static final String ACTION_CANCEL = "cancel";
    public static final String ACTION_ADD = "add";
    public static final String ACTION_DELETE = "delete";
    public static final String ACTION_REMOVE = "remove";
    public static final String ACTION_EDIT = "edit";
    public static final String ACTION_SAVE = "save";
    public static final String ACTION_SAVEAS = "saveas";
    public static final String ACTION_CLOSE = "close";
    public static final String ACTION_MOVE_UP = "move up";
    public static final String ACTION_MOVE_DOWN = "move down";
    public static final String ACTION_IMPORT = "import";
    public static final int OK_BUTTON = 1;
    public static final int APPLY_BUTTON = 2;
    public static final int CANCEL_BUTTON = 3;
    public static final int HELP_BUTTON = 4;
    public static final int ADD_BUTTON = 5;
    public static final int DELETE_BUTTON = 6;
    public static final int REMOVE_BUTTON = 7;
    public static final int EDIT_BUTTON = 8;
    public static final int NEW_BUTTON = 9;
    public static final int SAVE_BUTTON = 10;
    public static final int SAVEAS_BUTTON = 11;
    public static final int CLOSE_BUTTON = 12;
    public static final int MOVE_UP_BUTTON = 13;
    public static final int MOVE_DOWN_BUTTON = 14;
    public static final int IMPORT_BUTTON = 15;
    public static final int EDIT_CONTENTS_BUTTON = 16;
    private static final char mnemonic_Add = localStrings.getLocalString("ui.uibutton.add_button_mnemonic", "A").charAt(0);
    private static final char mnemonic_Delete = localStrings.getLocalString("ui.uibutton.delete_button_mnemonic", "D").charAt(0);
    private static final char mnemonic_Remove = localStrings.getLocalString("ui.uibutton.remove_button_mnemonic", "R").charAt(0);
    private static final char mnemonic_Edit = localStrings.getLocalString("ui.uibutton.edit_button_mnemonic", "I").charAt(0);
    private static final char mnemonic_New = localStrings.getLocalString("ui.uibutton.new_button_mnemonic", "N").charAt(0);
    private static final char mnemonic_Ok = localStrings.getLocalString("ui.uibutton.ok_button_mnemonic", "O").charAt(0);
    private static final char mnemonic_Apply = localStrings.getLocalString("ui.uibutton.apply_button_mnemonic", "Y").charAt(0);
    private static final char mnemonic_Cancel = localStrings.getLocalString("ui.uibutton.cancel_button_mnemonic", "C").charAt(0);
    private static final char mnemonic_Help = localStrings.getLocalString("ui.uibutton.help_button_mnemonic", "P").charAt(0);
    private static final char mnemonic_Save = localStrings.getLocalString("ui.uibutton.save_button_mnemonic", "S").charAt(0);
    private static final char mnemonic_SaveAs = localStrings.getLocalString("ui.uibutton.save_as_button_mnemonic", "V").charAt(0);
    private static final char mnemonic_Close = localStrings.getLocalString("ui.uibutton.close_button_mnemonic", "L").charAt(0);
    private static final char mnemonic_MoveUp = localStrings.getLocalString("ui.uibutton.moveup_button_mnemonic", "U").charAt(0);
    private static final char mnemonic_MoveDown = localStrings.getLocalString("ui.uibutton.movedown_button_mnemonic", "M").charAt(0);
    private static final char mnemonic_Import = localStrings.getLocalString("ui.uibutton.import_button_mnemonic", "I").charAt(0);
    private boolean isReadOnly = false;
    private boolean lastEnabledState = true;

    public static UIButton createAddButton(ActionListener al) {
        return UIButton.createAddButton(al, false);
    }

    public static UIButton createAddButton(ActionListener al, boolean el) {
        return UIButton.createButton(5, el, mnemonic_Add, ACTION_ADD, al);
    }

    public static UIButton createAddButton(String title, int mnemonic, ActionListener al, boolean el) {
        return UIButton.createButton(title, mnemonic, ACTION_ADD, al);
    }

    public static UIButton createDeleteButton(ActionListener al) {
        return UIButton.createDeleteButton(al, false);
    }

    public static UIButton createDeleteButton(ActionListener al, boolean el) {
        return UIButton.createButton(6, el, mnemonic_Delete, ACTION_DELETE, al);
    }

    public static UIButton createDeleteButton(String title, int mnemonic, ActionListener al, boolean el) {
        return UIButton.createButton(title, mnemonic, ACTION_DELETE, al);
    }

    public static UIButton createRemoveButton(ActionListener al) {
        return UIButton.createRemoveButton(al, false);
    }

    public static UIButton createRemoveButton(ActionListener al, boolean el) {
        return UIButton.createButton(7, el, mnemonic_Remove, ACTION_REMOVE, al);
    }

    public static UIButton createRemoveButton(String title, int mnemonic, ActionListener al, boolean el) {
        return UIButton.createButton(title, mnemonic, ACTION_REMOVE, al);
    }

    public static UIButton createEditButton(ActionListener al) {
        return UIButton.createEditButton(al, false);
    }

    public static UIButton createEditButton(ActionListener al, boolean el) {
        return UIButton.createButton(8, el, mnemonic_Edit, ACTION_EDIT, al);
    }

    public static UIButton createEditButton(String title, int mnemonic, ActionListener al, boolean el) {
        return UIButton.createButton(title, mnemonic, ACTION_EDIT, al);
    }

    public static UIButton createEditContentsButton(ActionListener al, boolean el) {
        return UIButton.createButton(16, el, mnemonic_Edit, ACTION_EDIT, al);
    }

    public static UIButton createNewButton(ActionListener al) {
        return UIButton.createNewButton(al, false);
    }

    public static UIButton createNewButton(ActionListener al, boolean el) {
        return UIButton.createButton(9, el, mnemonic_New, ACTION_EDIT, al);
    }

    public static UIButton createNewButton(String title, int mnemonic, ActionListener al, boolean el) {
        return UIButton.createButton(title, mnemonic, ACTION_EDIT, al);
    }

    public static UIButton createOkButton(ActionListener al) {
        return UIButton.createButton(1, false, mnemonic_Ok, ACTION_OK, al);
    }

    public static UIButton createApplyButton(ActionListener al) {
        return UIButton.createButton(2, false, mnemonic_Apply, ACTION_APPLY, al);
    }

    public static UIButton createCancelButton(ActionListener al) {
        return UIButton.createButton(3, false, mnemonic_Cancel, ACTION_CANCEL, al);
    }

    public static UIButton createHelpButton(String helpId) {
        return UIButton.createButton(4, false, mnemonic_Help, helpId, null);
    }

    public static UIButton createSaveButton(ActionListener al) {
        return UIButton.createButton(10, false, mnemonic_Save, ACTION_SAVE, al);
    }

    public static UIButton createSaveAsButton(ActionListener al, boolean el) {
        return UIButton.createButton(11, el, mnemonic_SaveAs, ACTION_SAVEAS, al);
    }

    public static UIButton createCloseButton(ActionListener al) {
        return UIButton.createButton(12, false, mnemonic_Close, ACTION_CLOSE, al);
    }

    public static UIButton createMoveUpButton(ActionListener al) {
        return UIButton.createButton(13, false, mnemonic_MoveUp, ACTION_MOVE_UP, al);
    }

    public static UIButton createMoveUpButton(ActionListener al, boolean el) {
        return UIButton.createButton(13, el, mnemonic_MoveUp, ACTION_MOVE_UP, al);
    }

    public static UIButton createMoveDownButton(ActionListener al) {
        return UIButton.createButton(14, false, mnemonic_MoveDown, ACTION_MOVE_DOWN, al);
    }

    public static UIButton createMoveDownButton(ActionListener al, boolean el) {
        return UIButton.createButton(14, el, mnemonic_MoveDown, ACTION_MOVE_DOWN, al);
    }

    public static UIButton createImportButton(ActionListener al) {
        return UIButton.createImportButton(al, true);
    }

    public static UIButton createImportButton(ActionListener al, boolean el) {
        return UIButton.createButton(15, el, mnemonic_Import, ACTION_IMPORT, al);
    }

    private static UIButton createButton(int type, boolean ellipsis, int mnemonic, String command, ActionListener listener) {
        if (type == 4) {
            Print.dprintln((String)"Please use 'new UIHelpButton(...)'");
            if (listener != null) {
                Print.printStackTrace((String)"ActionListener cannot be specified for 'Help' buttons");
            }
            if (command == null) {
                Print.printStackTrace((String)"Command(Help-id) must be specified for 'Help' buttons");
            }
            return new UIHelpButton(command);
        }
        String title = "Button";
        switch (type) {
            case 1: {
                title = BTN_OK;
                break;
            }
            case 2: {
                title = BTN_APPLY;
                break;
            }
            case 3: {
                title = BTN_CANCEL;
                break;
            }
            case 10: {
                title = BTN_SAVE;
                break;
            }
            case 11: {
                title = BTN_SAVEAS;
                break;
            }
            case 12: {
                title = BTN_CLOSE;
                break;
            }
            case 5: {
                title = ellipsis ? BTN_ADD__ : BTN_ADD;
                break;
            }
            case 6: {
                title = ellipsis ? BTN_DELETE__ : BTN_DELETE;
                break;
            }
            case 8: {
                title = ellipsis ? BTN_EDIT__ : BTN_EDIT;
                break;
            }
            case 16: {
                title = ellipsis ? BTN_EDIT_CONTENTS__ : BTN_EDIT_CONTENTS;
                break;
            }
            case 9: {
                title = ellipsis ? BTN_NEW__ : BTN_NEW;
                break;
            }
            case 7: {
                title = ellipsis ? BTN_REMOVE__ : BTN_REMOVE;
                break;
            }
            case 13: {
                title = BTN_MOVE_UP;
                break;
            }
            case 14: {
                title = BTN_MOVE_DOWN;
                break;
            }
            case 15: {
                title = BTN_IMPORT__;
                break;
            }
            default: {
                Print.dprintStackTrace((String)"Unrecognized button type");
            }
        }
        return UIButton.createButton(title, mnemonic, command, listener);
    }

    private static UIButton createButton(String title, int mnemonic, String command, ActionListener listener) {
        if (title == null) {
            title = "Button";
        }
        if (mnemonic < 0) {
            mnemonic = title.charAt(0);
        }
        UIButton btn = new UIButton();
        btn.getAccessibleContext().setAccessibleName(localStrings.getLocalString("ui.uibutton.button_name", "The name of the button is {0}", new Object[]{title}));
        btn.getAccessibleContext().setAccessibleDescription(localStrings.getLocalString("ui.uibutton.button_desc", "This is the button for {0} action", new Object[]{title}));
        UIButton.setButtonText((AbstractButton)btn, title, mnemonic);
        if (command != null) {
            btn.setActionCommand(command);
        }
        if (listener != null) {
            btn.addActionListener(listener);
        }
        return btn;
    }

    public static boolean setButtonText(AbstractButton b, String t) {
        return UIButton.setButtonText(b, t, 0);
    }

    public static boolean setButtonText(AbstractButton b, String t, char d) {
        int vk = d;
        if (vk >= 97 && vk <= 122) {
            vk -= 32;
        }
        return UIButton.setButtonText(b, t, vk);
    }

    public static boolean setButtonText(AbstractButton b, String t, int d) {
        if (t != null) {
            String text;
            boolean hasMnemonic;
            int p = UIButton.getIndexOfMnemonic(t);
            boolean bl = hasMnemonic = p >= 0;
            if (hasMnemonic) {
                text = p < t.length() - 1 ? t.substring(p + 1) : "";
                b.setText(text);
                b.setMnemonic(p > 0 ? t.charAt(0) : (char)'\u0000');
            } else {
                text = t;
                b.setText(text);
                b.setMnemonic(d);
            }
            String ttt = b.getToolTipText();
            if ((ttt == null || ttt.equals("")) && !text.equals("")) {
                b.setToolTipText(text);
            }
            return hasMnemonic;
        }
        return false;
    }

    protected static int getIndexOfMnemonic(String t) {
        if (t != null && t.length() >= 3) {
            return UseIndexOf_MNEMONIC_ESC ? t.indexOf(MNEMONIC_ESC) : (t.charAt(1) == MNEMONIC_ESC ? 1 : -1);
        }
        return -1;
    }

    public static String setDefaultMnemonic(char d, String t) {
        int p;
        if (t != null && (p = UIButton.getIndexOfMnemonic(t)) < 0) {
            t = String.valueOf(new char[]{d, MNEMONIC_ESC}) + t;
        }
        return t;
    }

    public UIButton() {
        Insets insets = this.getMargin();
        if (insets != null) {
            insets = (Insets)insets.clone();
            --insets.left;
            --insets.right;
            this.setMargin(insets);
        }
    }

    public UIButton(String title) {
        this();
        UIButton.setButtonText(this, title);
    }

    public UIButton(String title, char dftMnemonic) {
        this();
        UIButton.setButtonText((AbstractButton)this, title, dftMnemonic);
    }

    public UIButton(Icon icon) {
        super(icon);
    }

    public UIButton(String title, char dftMnemonic, String ac, ActionListener al) {
        this(title, dftMnemonic);
        if (ac != null) {
            this.setActionCommand(ac);
        }
        if (al != null) {
            this.addActionListener(al);
        }
    }

    public UIButton(String title, char dftMnemonic, ActionListener al) {
        this(title, dftMnemonic, null, al);
    }

    public UIButton(String title, String ac, ActionListener al) {
        this(title);
        if (ac != null) {
            this.setActionCommand(ac);
        }
        if (al != null) {
            this.addActionListener(al);
        }
    }

    public UIButton(String title, ActionListener al) {
        this(title, null, al);
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void setReadOnly(boolean state) {
        this.setReadOnly(state, this.isEnabled());
    }

    protected void setReadOnly(boolean state, boolean enabled) {
        this.isReadOnly = state;
        if (this.isReadOnly) {
            if (enabled) {
                this._setEnabled(false);
            }
        } else {
            this._setEnabled(this.lastEnabledState);
        }
    }

    public void setEnabled(boolean state) {
        this.setEnabled(state, this.isReadOnly());
    }

    protected void setEnabled(boolean state, boolean readOnly) {
        this.lastEnabledState = state;
        this._setEnabled(state && !readOnly);
    }

    protected void _setEnabled(boolean state) {
        super.setEnabled(state);
    }

    public void clearMnemonic() {
        this.setMnemonic(0);
    }

    public void makeDefaultButton(boolean state) {
        JRootPane root = SwingUtilities.getRootPane(this);
        if (root != null) {
            if (state) {
                if (root.getDefaultButton() != this) {
                    root.setDefaultButton(this);
                }
            } else if (root.getDefaultButton() == this) {
                root.setDefaultButton(null);
            }
        } else {
            Print.printStackTrace((String)"Button must first be added to a JRootPane");
        }
    }

    public void setAccessibleDescription(String text) {
        this.getAccessibleContext().setAccessibleDescription(text);
    }
}

