/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.utils.UIEventQueue;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.KeyStroke;

public class UIActionDispatcher
extends AbstractAction
implements Runnable,
ActionListener {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UIActionDispatcher.class);
    public static final String CONSTRUCTOR = "<init>";
    private Object target = null;
    private String methodName = null;
    private Object[] methodArgs = null;
    private Class[] methodArgTypes = null;
    private AccessibleObject methodSig = null;
    private Object methodReturn = null;
    private Throwable invokeException = null;
    private String description = null;
    static /* synthetic */ Class class$java$lang$Object;

    public static void addKeyAction(JComponent comp, int keyCode, Action action) {
        KeyStroke ks = KeyStroke.getKeyStroke(keyCode, 0);
        String cmd = "Action_" + String.valueOf(action.hashCode());
        comp.getInputMap(1).put(ks, cmd);
        comp.getActionMap().put(cmd, action);
    }

    public static void addKeyAction(JComponent comp, int keyCode, UIActionDispatcher action) {
        KeyStroke ks = KeyStroke.getKeyStroke(keyCode, 0);
        String cmd = action.getMethodName() + "_";
        Object[] args = action.getMethodArgs();
        if (args == null) {
            args = action.getMethodArgTypes();
        }
        if (args != null && args.length > 0) {
            cmd = cmd + String.valueOf(args[0].hashCode());
        }
        comp.getInputMap(1).put(ks, cmd);
        comp.getActionMap().put(cmd, action);
    }

    public static void addKeyAction(Component comp, String strCode, ActionListener action) {
        comp.addKeyListener(new ActionKeyListener(comp, strCode, action));
    }

    public UIActionDispatcher(ActionListener target) {
        this((Object)target, "actionPerformed", new Class[]{ActionEvent.class});
        this.setMethodArgs(new Object[]{null});
    }

    public UIActionDispatcher(Object target, String meth) {
        this(target, meth, null);
    }

    public UIActionDispatcher(Object target, String meth, Object arg) {
        this.setTarget(target);
        this.methodName = meth;
        this.methodSig = null;
        if (arg instanceof Class[]) {
            this.methodArgTypes = (Class[])arg;
            this.setMethodArgs(null);
        } else if (arg instanceof Object[]) {
            this.methodArgTypes = null;
            this.setMethodArgs((Object[])arg);
        } else if (arg != null) {
            this.methodArgTypes = null;
            this.setMethodArgs(new Object[]{arg});
        } else {
            this.methodArgTypes = null;
            this.setMethodArgs(null);
        }
    }

    public UIActionDispatcher(Object target, String meth, Class[] argTypes) {
        this(target, meth, (Object)argTypes);
    }

    public UIActionDispatcher(String className, String meth, Class[] argTypes) {
        this((Object)className, meth, (Object)argTypes);
    }

    public UIActionDispatcher(Object target, Method methSig) {
        this(target, methSig, (Object)null);
    }

    public UIActionDispatcher(Object target, Method methSig, Object arg) {
        this.setTarget(target);
        this.methodName = methSig.getName();
        this.methodSig = methSig;
        this.methodArgTypes = methSig.getParameterTypes();
        if (arg instanceof Object[]) {
            this.setMethodArgs((Object[])arg);
        } else if (arg != null) {
            this.setMethodArgs(new Object[]{arg});
        } else {
            this.setMethodArgs(null);
        }
    }

    public UIActionDispatcher(Class target) {
        this((Object)target, CONSTRUCTOR, (Object)null);
    }

    public UIActionDispatcher(Class target, Object[] args) {
        this((Object)target, CONSTRUCTOR, (Object)args);
    }

    public UIActionDispatcher(Constructor constSig) {
        this(constSig, (Object)null);
    }

    public UIActionDispatcher(Constructor constSig, Object arg) {
        this.setTarget(constSig);
        this.methodName = constSig.getName();
        this.methodSig = constSig;
        this.methodArgTypes = constSig.getParameterTypes();
        if (arg instanceof Object[]) {
            this.setMethodArgs((Object[])arg);
        } else if (arg != null) {
            this.setMethodArgs(new Object[]{arg});
        } else {
            this.setMethodArgs(null);
        }
    }

    private UIActionDispatcher() {
    }

    public Object clone() {
        UIActionDispatcher copy = new UIActionDispatcher();
        copy.target = this.target;
        copy.methodName = this.methodName;
        copy.methodArgs = this.methodArgs;
        copy.methodArgTypes = this.methodArgTypes;
        copy.methodSig = this.methodSig;
        copy.methodReturn = this.methodReturn;
        copy.invokeException = this.invokeException;
        return copy;
    }

    public UIActionDispatcher setTarget(Object target) {
        if (target instanceof Class) {
            this.target = target;
        } else if (target instanceof String) {
            try {
                this.target = UIActionDispatcher.classForName((String)target);
            }
            catch (ClassNotFoundException ex) {
                Print.dprintStackTrace((String)("Can't find class: " + (String)target));
                return null;
            }
        } else {
            this.target = target instanceof Constructor ? ((Constructor)target).getDeclaringClass() : target;
        }
        return this;
    }

    public Object getTarget() {
        return this.target;
    }

    public UIActionDispatcher setMethodArgs(Object[] args) {
        Object[] objectArray = this.methodArgs = args != null ? args : new Object[]{};
        if (this.methodArgTypes != null) {
            // empty if block
        }
        return this;
    }

    public Object[] getMethodArgs() {
        return this.methodArgs;
    }

    public Class[] getMethodArgTypes() {
        if (this.methodArgTypes == null) {
            this.methodArgTypes = UIActionDispatcher.getArgumentTypes(this.methodArgs);
        }
        return this.methodArgTypes;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Object getReturn() {
        return this.methodReturn;
    }

    public Throwable getException() {
        return this.invokeException;
    }

    public boolean isValid() {
        Object[] argTypes = this.methodArgTypes != null ? this.methodArgTypes : UIActionDispatcher.getArgumentTypes(this.methodArgs);
        try {
            UIActionDispatcher.getTargetMethod(this.target, this.methodName, argTypes);
            return true;
        }
        catch (NoSuchMethodException nsm) {
            Print.dprintln((String)("NoSuchMethodException: " + this.getFormattedMethodName()));
            return false;
        }
        catch (Throwable x) {
            Print.dprintln((String)("Exception: " + x.toString()));
            return false;
        }
    }

    public Object invoke(Object[] args) {
        this.methodReturn = null;
        this.invokeException = null;
        if (this.target instanceof ActionListener) {
            try {
                return UIActionDispatcher.invoke((ActionListener)this.target);
            }
            catch (Throwable t) {
                this.invokeException = t;
                Print.printStackTrace((String)this.getFormattedMethodName(), (Throwable)t);
                return null;
            }
        }
        if (args != null) {
            this.setMethodArgs(args);
            args = this.methodArgs;
        } else {
            args = this.methodArgs != null ? this.methodArgs : new Object[]{};
        }
        Object[] argTypes = this.getMethodArgTypes();
        if (this.methodSig == null) {
            try {
                this.methodSig = UIActionDispatcher.getTargetMethod(this.target, this.methodName, argTypes);
            }
            catch (NoSuchMethodException nsm) {
                this.invokeException = nsm;
                Print.printStackTrace((String)this.getFormattedMethodName(), (Throwable)nsm);
                return null;
            }
            catch (Throwable t) {
                this.invokeException = t;
                Print.printStackTrace((String)this.getFormattedMethodName(), (Throwable)t);
                return null;
            }
        }
        try {
            this.methodReturn = this.methodSig instanceof Constructor ? ((Constructor)this.methodSig).newInstance(args) : ((Method)this.methodSig).invoke(this.target, args);
            return this.methodReturn;
        }
        catch (IllegalAccessException iae) {
            this.invokeException = iae;
            Print.printStackTrace((String)(this.getFormattedMethodName() + " : (method not 'public'?)"), (Throwable)iae);
        }
        catch (InvocationTargetException ite) {
            this.invokeException = ite.getCause();
            Print.printStackTrace(null, (Throwable)this.invokeException);
        }
        catch (Throwable t) {
            this.invokeException = t;
            Print.printStackTrace((String)this.getFormattedMethodName(), (Throwable)t);
        }
        return null;
    }

    public Object invoke() {
        return this.invoke(null);
    }

    public void run() {
        this.invoke();
    }

    public void invokeLater() {
        UIEventQueue.invokeLater(this);
    }

    public void invokeLater(Object[] args) {
        if (args != null) {
            this.setMethodArgs(args);
        }
        UIEventQueue.invokeLater(this);
    }

    public Object invokeSuspend() {
        return this.invokeSuspend(null);
    }

    public Object invokeSuspend(Object[] args) {
        if (EventQueue.isDispatchThread()) {
            if (args != null) {
                this.setMethodArgs(args);
            }
            ActionDialog dd = new ActionDialog(this);
            Print.dprintln((String)"Suspend invoke");
            return dd.showDialog();
        }
        Print.dprintln((String)"Direct invoke");
        return this.invoke(args);
    }

    public void actionPerformed(ActionEvent ae) {
        this.invoke();
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFormattedMethodName() {
        Class[] argTypes = this.methodArgTypes != null ? this.methodArgTypes : UIActionDispatcher.getArgumentTypes(this.methodArgs);
        return UIActionDispatcher.formatMethodName(this.target, this.methodName, argTypes);
    }

    public String toString() {
        if (this.description != null) {
            return this.description;
        }
        StringBuffer sb = new StringBuffer("(UIActionDispatcher)");
        sb.append(" Target=").append(UIUtils.debugClassName(this.target));
        sb.append(", Method=").append(this.methodName);
        return sb.toString();
    }

    public static Class classForName(String className) throws ClassNotFoundException {
        return ClassLoader.getSystemClassLoader().loadClass(className);
    }

    public static Object invoke(ActionListener action) {
        return UIActionDispatcher.invoke(action, "<unknown>");
    }

    public static Object invoke(ActionListener action, Object src) {
        if (action instanceof UIActionDispatcher) {
            return ((UIActionDispatcher)action).invoke();
        }
        if (action != null) {
            ActionEvent ae = new ActionEvent(src, 1001, "");
            action.actionPerformed(ae);
            return null;
        }
        return null;
    }

    public static void invokeLater(final ActionListener action) {
        if (action instanceof UIActionDispatcher) {
            ((UIActionDispatcher)action).invokeLater();
        } else if (action != null) {
            UIEventQueue.invokeLater(new Runnable(){

                public void run() {
                    UIActionDispatcher.invoke(action);
                }
            });
        }
    }

    public static Class[] getArgumentTypes(Object[] args) {
        Class[] argTypes = null;
        if (args == null) {
            argTypes = new Class[]{};
        } else if (args instanceof Class[]) {
            argTypes = (Class[])args;
        } else {
            argTypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                argTypes[i] = args[i] != null ? args[i].getClass() : (class$java$lang$Object == null ? UIActionDispatcher.class$("java.lang.Object") : class$java$lang$Object);
            }
        }
        return argTypes;
    }

    private static AccessibleObject getTargetMethod(Object target, String methName, Object[] args) throws NoSuchMethodException, SecurityException {
        if (target == null) {
            throw new NoSuchMethodException("Specified target is 'null'");
        }
        if (target instanceof Class && (methName == null || methName.equals(CONSTRUCTOR))) {
            return ((Class)target).getConstructor(UIActionDispatcher.getArgumentTypes(args));
        }
        Class<?> targetClass = target instanceof Class ? (Class<?>)target : target.getClass();
        Class[] argTypes = UIActionDispatcher.getArgumentTypes(args);
        try {
            return targetClass.getMethod(methName, argTypes);
        }
        catch (NoSuchMethodException nsme) {
            try {
                targetClass.getDeclaredMethod(methName, argTypes);
                nsme = new NoSuchMethodException("Method not delared 'public'");
            }
            catch (NoSuchMethodException t) {
                // empty catch block
            }
            throw nsme;
        }
    }

    public static String formatMethodName(Object target, String meth, Class[] argTypes) {
        int cdot;
        String cn;
        String className = null;
        if (target == null) {
            className = "<NullTarget>";
        } else if (target instanceof Class) {
            cn = ((Class)target).getName();
            cdot = cn.lastIndexOf(".");
            className = cdot >= 0 ? cn.substring(cdot + 1) : cn;
        } else {
            cn = target.getClass().getName();
            cdot = cn.lastIndexOf(".");
            className = "<" + (cdot >= 0 ? cn.substring(cdot + 1) : cn) + ">";
        }
        String methName = meth != null ? meth : "<NullMethod>";
        String argList = "";
        if (argTypes != null) {
            for (int i = 0; i < argTypes.length; ++i) {
                String name;
                int pdot;
                if (i > 0) {
                    argList = argList + ", ";
                }
                if ((pdot = (name = argTypes[i].getName()).lastIndexOf(".")) >= 0) {
                    name = name.substring(pdot + 1);
                }
                argList = argList + name;
            }
        }
        return className + "." + methName + "(" + argList + ")";
    }

    private class ActionDialog
    extends JDialog {
        private UIActionDispatcher action;
        private Object rtnValue;

        public ActionDialog(UIActionDispatcher action) {
            super((Frame)null, true);
            this.action = null;
            this.rtnValue = null;
            this.action = action;
            this.getAccessibleContext().setAccessibleName(localStrings.getLocalString("ui.uiactiondispatcher.dialog_name", "Dialog box"));
            this.getAccessibleContext().setAccessibleDescription(localStrings.getLocalString("ui.uiactiondispatcher.dialog_desc", "This is a dialog box waiting for your action"));
        }

        public Object showDialog() {
            super.show();
            return this.rtnValue;
        }

        protected void processEvent(AWTEvent e) {
            super.processEvent(e);
            Print.dprintln((String)("IsVisible: " + this.isVisible()));
            if (this.isShowing()) {
                this.rtnValue = this.action.invoke();
                this.dispose();
            }
        }
    }

    private static class ActionKeyListener
    extends KeyAdapter {
        private Component keyComp = null;
        private int charIndex = 0;
        private char[] charCode = null;
        private String stringCode = null;
        private ActionListener action = null;

        public ActionKeyListener(Component comp, String strCode, ActionListener action) {
            this.keyComp = comp;
            this.stringCode = strCode;
            this.charCode = this.stringCode.toCharArray();
            this.action = action;
        }

        public void keyTyped(KeyEvent ke) {
            if (this.charCode[this.charIndex] == ke.getKeyChar()) {
                if (++this.charIndex < this.charCode.length) {
                    return;
                }
                if (this.action instanceof UIActionDispatcher) {
                    ((UIActionDispatcher)this.action).invoke();
                } else if (this.action instanceof ActionListener) {
                    String ac = this.keyComp instanceof AbstractButton ? ((AbstractButton)this.keyComp).getActionCommand() : "";
                    ActionEvent ae = new ActionEvent(this.keyComp, 1001, ac);
                    this.action.actionPerformed(ae);
                }
            }
            this.charIndex = 0;
        }
    }
}

