/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.util.Print;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class TeeOutputStream
extends PrintStream {
    private OutputStream _primaryOutput = null;
    private OutputStream _altOutput = null;

    public TeeOutputStream(OutputStream primaryOut, OutputStream altOut) throws IllegalArgumentException {
        this(primaryOut, altOut, true);
    }

    public TeeOutputStream(OutputStream primaryOut, OutputStream altOut, boolean flush) throws IllegalArgumentException {
        super(primaryOut, flush);
        if (primaryOut == null) {
            throw new IllegalArgumentException("'primaryOut' cannot be null!");
        }
        if (altOut == null) {
            throw new IllegalArgumentException("'altOut' cannot be null!");
        }
        this._primaryOutput = primaryOut;
        this._altOutput = altOut;
    }

    public void close() {
        try {
            this._altOutput.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.setError();
        }
        super.close();
    }

    public void close(boolean both) {
        if (both) {
            this.close();
        } else {
            super.close();
        }
    }

    public void write(int b) {
        try {
            this._altOutput.write(b);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.setError();
        }
        super.write(b);
    }

    public void write(byte[] buf, int off, int len) {
        try {
            this._altOutput.write(buf, off, len);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.setError();
        }
        super.write(buf, off, len);
    }

    public OutputStream getPrimaryOutputStream() {
        return this._primaryOutput;
    }

    public OutputStream getAltOutputStream() {
        return this._altOutput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Print.println((String)"Start...");
        TeeOutputStream ts = null;
        try {
            ts = new TeeOutputStream((OutputStream)new FileOutputStream("test.file"), System.out);
            ts.print("Test output\n");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            ts.close();
        }
        Print.println((String)"...finished.");
    }
}

