/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorTools;
import com.sun.enterprise.tools.deployment.ui.utils.PublicCloneable;
import com.sun.enterprise.util.Print;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;

public class ListTools {
    private static Comparator stringComparator = null;

    public static Vector toList(Object[] array) {
        return (Vector)ListTools.toList(array, new Vector());
    }

    public static List toList(Object[] a, List v) {
        return (List)ListTools.toList(a, (Collection)v);
    }

    public static Collection toList(Object[] a, Collection v) {
        if (v == null) {
            v = new Vector<Object>();
        }
        if (a != null) {
            for (int i = 0; i < a.length; ++i) {
                v.add(a[i]);
            }
        }
        return v;
    }

    public static Vector toList(ListModel m) {
        return (Vector)ListTools.toList(m, new Vector());
    }

    public static List toList(ListModel m, List v) {
        return (List)ListTools.toList(m, (Collection)v);
    }

    public static Collection toList(ListModel m, Collection v) {
        if (v == null) {
            v = new Vector();
        }
        if (m != null) {
            for (int i = 0; i < m.getSize(); ++i) {
                v.add(m.getElementAt(i));
            }
        }
        return v;
    }

    public static Vector toList(Iterator i) {
        return (Vector)ListTools.toList(i, new Vector());
    }

    public static List toList(Iterator i, List v) {
        return (List)ListTools.toList(i, (Collection)v);
    }

    public static Collection toList(Iterator i, Collection v) {
        if (v == null) {
            v = new Vector();
        }
        if (i != null) {
            while (i.hasNext()) {
                v.add(i.next());
            }
        }
        return v;
    }

    public static DefaultListModel toListModel(Iterator i) {
        return (DefaultListModel)ListTools.toListModel(i, new DefaultListModel());
    }

    public static ListModel toListModel(Iterator i, DefaultListModel m) {
        if (m == null) {
            m = new DefaultListModel();
        }
        if (i != null) {
            while (i.hasNext()) {
                m.addElement(i.next());
            }
        }
        return m;
    }

    public static DefaultListModel toListModel(List list) {
        return (DefaultListModel)ListTools.toListModel(list, new DefaultListModel());
    }

    public static ListModel toListModel(List list, DefaultListModel m) {
        return ListTools.toListModel(list != null ? list.iterator() : null, m);
    }

    public static Enumeration toEnumeration(final Iterator i) {
        return new Enumeration(){

            public boolean hasMoreElements() {
                return i.hasNext();
            }

            public Object nextElement() {
                return i.next();
            }
        };
    }

    public static Enumeration toEnumeration(List list) {
        if (list instanceof Vector) {
            return ((Vector)list).elements();
        }
        return ListTools.toEnumeration(list.iterator());
    }

    public static Vector toList(Enumeration e) {
        return (Vector)ListTools.toList(e, new Vector());
    }

    public static List toList(Enumeration e, List v) {
        if (v == null) {
            v = new Vector();
        }
        if (e != null) {
            while (e.hasMoreElements()) {
                v.add(e.nextElement());
            }
        }
        return v;
    }

    public static Iterator toIterator(final Enumeration e) {
        return new Iterator(){

            public boolean hasNext() {
                return e.hasMoreElements();
            }

            public Object next() {
                return e.nextElement();
            }

            public void remove() {
                throw new UnsupportedOperationException("'remove()' Not Supported");
            }
        };
    }

    public static ArrayIterator toIterator(Object[] list) {
        return new ArrayIterator(list);
    }

    public static Object[] listToArray(List v) {
        return ListTools.listToArray(v, null);
    }

    public static Object[] listToArray(List v, Class classTypeHint) {
        if (v == null) {
            return null;
        }
        if (classTypeHint != null) {
            boolean classMatch = true;
            Iterator i = v.iterator();
            while (i.hasNext() && classMatch) {
                classMatch = classTypeHint.isInstance(i.next());
            }
            if (classMatch) {
                return v.toArray((Object[])Array.newInstance(classTypeHint, v.size()));
            }
        }
        Object[] array = v.toArray();
        for (int i = 0; i < array.length; ++i) {
            if (!(array[i] instanceof List)) continue;
            array[i] = ListTools.listToArray((List)array[i], classTypeHint);
        }
        return array;
    }

    public static boolean arrayContains(Object[] array, Object obj) {
        return ListTools.arrayContains(array, obj, false);
    }

    public static boolean arrayContains(Object[] array, Object obj, boolean checkString) {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] == null) {
                    if (obj != null) continue;
                    return true;
                }
                if (array[i] == obj) {
                    return true;
                }
                if (array[i].equals(obj)) {
                    return true;
                }
                if (!checkString || obj == null || !array[i].toString().equals(obj.toString())) continue;
                return true;
            }
        }
        return false;
    }

    public static Object[] arrayTreeCopy(Object[] array) {
        if (array != null) {
            Object[] topCopy = ListTools.arrayCopy(array);
            int size = topCopy.length;
            for (int i = 0; i < size; ++i) {
                Object obj = topCopy[i];
                if (obj instanceof List) {
                    topCopy[i] = ListTools.listTreeCopy((List)obj);
                    continue;
                }
                if (!(obj instanceof Object[])) continue;
                topCopy[i] = ListTools.arrayTreeCopy((Object[])obj);
            }
            return topCopy;
        }
        return null;
    }

    public static Object[] arrayCopy(Object[] src) {
        return ListTools.arrayCopy(src, null);
    }

    public static Object[] arrayCopy(Object[] src, Class classTypeHint) {
        Object[] dst = null;
        if (classTypeHint != null) {
            boolean classMatch = true;
            for (int i = 0; i < src.length && classMatch; ++i) {
                classMatch = classTypeHint.isInstance(src[i]);
            }
            dst = classMatch ? (Object[])Array.newInstance(classTypeHint, src.length) : new Object[src.length];
        } else {
            dst = new Object[src.length];
        }
        System.arraycopy(src, 0, dst, 0, src.length);
        return dst;
    }

    public static boolean listContains(List list, Object item, boolean compareEquals) {
        return ListTools.listIndexOf(list, item, compareEquals) >= 0;
    }

    public static int listIndexOf(List list, Object item, boolean compareEquals) {
        boolean checkEquals = compareEquals ? true : item instanceof String;
        int size = list.size();
        for (int row = 0; row < size; ++row) {
            Object obj = list.get(row);
            if (obj == item) {
                return row;
            }
            if (!checkEquals || !obj.equals(item)) continue;
            return row;
        }
        return -1;
    }

    public static int listLastIndexOf(List list, Object item, boolean compareEquals) {
        boolean checkEquals = compareEquals ? true : item instanceof String;
        for (int row = list.size() - 1; row >= 0; --row) {
            Object obj = list.get(row);
            if (obj == item) {
                return row;
            }
            if (!checkEquals || !obj.equals(item)) continue;
            return row;
        }
        return -1;
    }

    public static Collection createEmptyCollection(Class listType) {
        if (Collection.class.isAssignableFrom(listType)) {
            try {
                return (Collection)listType.newInstance();
            }
            catch (Throwable t) {
                Print.dprintStackTrace((String)"Unable to create new instance of Collection", (Throwable)t);
                return null;
            }
        }
        Print.dprintStackTrace((String)("Not a Collection: " + DT.className(listType)));
        return null;
    }

    public static List listTreeCopy(List list) {
        if (list != null) {
            List topCopy = (List)ListTools.listCopy(list, false);
            int size = topCopy.size();
            for (int i = 0; i < size; ++i) {
                Object obj = topCopy.get(i);
                if (obj instanceof List) {
                    topCopy.set(i, ListTools.listTreeCopy((List)obj));
                    continue;
                }
                if (!(obj instanceof Object[])) continue;
                topCopy.set(i, ListTools.arrayTreeCopy((Object[])obj));
            }
            return topCopy;
        }
        return null;
    }

    public static Collection listCopy(Collection list) {
        return ListTools._collectionCopy(null, list, false);
    }

    public static Collection listCopy(Collection list, boolean deep) {
        return ListTools._collectionCopy(null, list, deep);
    }

    public static Collection listCopy(Iterator list) {
        return ListTools._collectionCopy(new Vector(), list, false);
    }

    public static Collection listCopy(Iterator list, boolean deep) {
        return ListTools._collectionCopy(new Vector(), list, deep);
    }

    public static Collection listCopy(Enumeration list) {
        return ListTools._collectionCopy(new Vector(), ListTools.toIterator(list), false);
    }

    public static Collection listCopy(Enumeration list, boolean deep) {
        return ListTools._collectionCopy(new Vector(), ListTools.toIterator(list), deep);
    }

    private static Collection _collectionCopy(Collection copy, Object list, boolean deep) {
        if (list == null) {
            return null;
        }
        if (!(list instanceof Collection) && !(list instanceof Iterator)) {
            return null;
        }
        if (copy == null) {
            if (list != null) {
                copy = ListTools.createEmptyCollection(list.getClass());
            }
            if (copy == null) {
                Print.dprintStackTrace((String)"Destination Collection not specified");
                return null;
            }
        }
        if (deep) {
            Iterator i;
            boolean deepCopyCreated = true;
            HashMap objConstMap = new HashMap();
            Iterator iterator = i = list instanceof Collection ? ((Collection)list).iterator() : (Iterator)list;
            while (i.hasNext()) {
                Object m = i.next();
                if (m instanceof PublicCloneable) {
                    copy.add(((PublicCloneable)m).clone());
                    continue;
                }
                Class<?> objClass = m.getClass();
                Constructor<?> objConst = (Constructor<?>)objConstMap.get(objClass);
                if (!objConstMap.containsKey(objClass)) {
                    try {
                        objConst = objClass.getConstructor(objClass);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    objConstMap.put(objClass, objConst);
                }
                if (objConst != null) {
                    try {
                        copy.add(objConst.newInstance(m));
                    }
                    catch (InvocationTargetException ite) {
                        Print.dprintStackTrace((String)("Copy constructor threw exception: " + objConst), (Throwable)ite);
                        copy.add(m);
                        deepCopyCreated = false;
                    }
                    catch (Throwable t) {
                        Print.dprintStackTrace((String)("Copy constructor failed: " + objConst), (Throwable)t);
                        objConstMap.put(objClass, null);
                        copy.add(m);
                        deepCopyCreated = false;
                    }
                    continue;
                }
                copy.add(m);
                deepCopyCreated = false;
            }
            if (!deepCopyCreated) {
                Print.dprintln((String)"Unable to create deep copy");
            }
        } else if (list instanceof Collection) {
            copy.addAll((Collection)list);
        } else if (list instanceof Iterator) {
            ListTools.toList((Iterator)list, copy);
        }
        return copy;
    }

    public static Vector parseList(String list, String delims) {
        return (Vector)ListTools.parseList(list, delims, new Vector());
    }

    public static List parseList(String list, String delims, List v) {
        if (v == null) {
            v = new Vector<String>();
        }
        if (list != null) {
            StringTokenizer st = new StringTokenizer(list, delims);
            while (st.hasMoreTokens()) {
                v.add(st.nextToken());
            }
        }
        return v;
    }

    public static boolean replaceElement(Collection c, Object oldObj, Object newObj) {
        if (c == null || !c.contains(oldObj)) {
            return false;
        }
        if (c instanceof List) {
            List list = (List)c;
            int oldNdx = list.indexOf(oldObj);
            if (oldNdx >= 0) {
                try {
                    list.set(oldNdx, newObj);
                    return true;
                }
                catch (UnsupportedOperationException uoe) {
                    Print.printStackTrace((String)("'set' not supported for list: " + DT.className(list)));
                    return false;
                }
            }
            Print.dprintln((String)"Can't find index of contained object?");
            return false;
        }
        try {
            Print.dprintln((String)("Not a java.util.List: " + DT.className(c)));
            if (c.remove(oldObj)) {
                c.add(newObj);
                return true;
            }
            Print.dprintln((String)"Contained object not removed?");
            return false;
        }
        catch (UnsupportedOperationException uoe) {
            Print.printStackTrace((String)("'remove/add' not supported for collection: " + DT.className(c)));
            return false;
        }
    }

    public static boolean moveElement(List list, Object item, int dir) {
        return list != null ? ListTools.moveElement(list, list.indexOf(item), dir) : false;
    }

    public static boolean moveElement(List list, int index, int direction) {
        if (list == null || index < 0 || index >= list.size()) {
            return false;
        }
        int n = index + direction;
        if (n < 0 || n >= list.size() || n == index) {
            return false;
        }
        Object oldItem = list.remove(index);
        list.add(n, oldItem);
        return true;
    }

    public static List sortList(List list, Comparator comparator, boolean inPlace) {
        if (list != null) {
            if (!inPlace) {
                list = new Vector(list);
            }
            Collections.sort(list, comparator);
        }
        return list;
    }

    public static List sortList(List list, boolean inPlace) {
        return list != null ? ListTools.sortList(list, ListTools.getStringComparator(), inPlace) : null;
    }

    public static List sortList(Collection coll) {
        return coll != null ? ListTools.sortList(new Vector(coll), true) : null;
    }

    public static Comparator getStringComparator() {
        if (stringComparator == null) {
            stringComparator = new Comparator(){

                public int compare(Object o1, Object o2) {
                    String n1 = ListTools._ObjString(o1).toLowerCase();
                    String n2 = ListTools._ObjString(o2).toLowerCase();
                    return n1.compareTo(n2);
                }

                public boolean equals(Object o) {
                    return super.equals(o);
                }
            };
        }
        return stringComparator;
    }

    private static String _ObjString(Object obj) {
        if (obj instanceof Class) {
            return ((Class)obj).getName();
        }
        if (obj instanceof Descriptor) {
            return DescriptorTools.getDisplayName(obj);
        }
        return obj.toString();
    }

    public static class OrderedSet
    extends Vector
    implements Set {
        public OrderedSet() {
        }

        public OrderedSet(Collection c) {
            this.addAll(c);
        }

        public boolean add(Object o) {
            return o != null && !this.contains(o) ? super.add(o) : false;
        }

        public boolean addAll(Collection c) {
            boolean setChanged = false;
            if (c != null) {
                Iterator itr = c.iterator();
                while (itr.hasNext()) {
                    if (!this.add(itr.next())) continue;
                    setChanged = true;
                }
            }
            return setChanged;
        }
    }

    protected static class ListAdapter
    implements List {
        protected List list = null;

        public ListAdapter(List list) {
            this.setList(list);
        }

        public List setList(List list) {
            this.list = list;
            return this;
        }

        public int size() {
            return this.list.size();
        }

        public void clear() {
            this.list.clear();
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        public boolean add(Object o) {
            return this.list.add(o);
        }

        public void add(int index, Object element) {
            this.list.add(index, element);
        }

        public boolean addAll(Collection c) {
            return this.list.addAll(c);
        }

        public boolean addAll(int index, Collection c) {
            return this.list.addAll(index, c);
        }

        public Object set(int index, Object element) {
            return this.list.set(index, element);
        }

        public Object remove(int index) {
            return this.list.remove(index);
        }

        public int hashCode() {
            return ((Object)this.list).hashCode();
        }

        public Iterator iterator() {
            return this.list.iterator();
        }

        public Object[] toArray() {
            return this.list.toArray();
        }

        public Object[] toArray(Object[] a) {
            return this.list.toArray(a);
        }

        public boolean containsAll(Collection c) {
            return this.list.containsAll(c);
        }

        public boolean removeAll(Collection c) {
            return this.list.removeAll(c);
        }

        public boolean retainAll(Collection c) {
            return this.list.retainAll(c);
        }

        public ListIterator listIterator() {
            return this.list.listIterator();
        }

        public ListIterator listIterator(int index) {
            return this.list.listIterator(index);
        }

        public List subList(int fromNdx, int toNdx) {
            return this.list.subList(fromNdx, toNdx);
        }

        public boolean equals(Object o) {
            return ((Object)this.list).equals(o);
        }

        public boolean contains(Object o) {
            return this.list.contains(o);
        }

        public boolean remove(Object o) {
            return this.list.remove(o);
        }

        public Object get(int index) {
            return this.list.get(index);
        }

        public int indexOf(Object o) {
            return this.list.indexOf(o);
        }

        public int lastIndexOf(Object o) {
            return this.list.lastIndexOf(o);
        }
    }

    public static class ArrayIterator
    implements Iterator {
        private int nextNdx = 0;
        private Object[] list = null;

        public ArrayIterator(Object[] list, int ndx) {
            this.list = list != null ? list : new Object[]{};
            this.nextNdx = ndx >= 0 ? ndx : 0;
        }

        public ArrayIterator(Object[] list) {
            this(list, 0);
        }

        public boolean hasNext() {
            return this.nextNdx < this.list.length;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("" + this.nextNdx);
            }
            return this.list[this.nextNdx++];
        }

        public void remove() {
            throw new UnsupportedOperationException("'remove()' Not Supported");
        }

        public Object peekNext() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("" + this.nextNdx);
            }
            return this.list[this.nextNdx];
        }

        public int getNextIndex() {
            return this.nextNdx;
        }

        public Object[] getArray() {
            return this.list;
        }
    }
}

