/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.util.ConnectorClassLoader;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.Print;
import com.sun.logging.LogDomains;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;

public class J2EEClassLoader
extends SecureClassLoader {
    private static String EJB_CODE_BASE = "ejb_impls/ejb.jar";
    private Set manifestChecked = new HashSet();
    private List urlSet = Collections.synchronizedList(new ArrayList());
    private Set ejbClassSet = new HashSet();
    private boolean webClassExpansion = false;
    private List locations = new ArrayList();
    private List expandDirs = new ArrayList();
    private File rootDir = null;
    private static CodeSource ejbCodeSource = null;
    private static Logger logger = LogDomains.getLogger((String)"javax.enterprise.system.util");

    public J2EEClassLoader() {
        super((ClassLoader)ConnectorClassLoader.getInstance());
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "ClassLoader: " + this + " is getting created.");
            Thread.dumpStack();
        }
    }

    public J2EEClassLoader(String noConnectorLoader) {
    }

    public J2EEClassLoader(ClassLoader parent) {
        super(parent);
    }

    public void setWarClassExpansion(boolean value) {
        this.webClassExpansion = value;
    }

    public boolean getWarClassExpansion() {
        return this.webClassExpansion;
    }

    private static File module2Dir(File module) {
        File dir = module.getParentFile();
        String name = module.getName();
        return new File(dir, name.replace('.', '_') + "__dir");
    }

    public void cleanup() {
        int size = this.locations.size();
        for (int i = 0; i < size; ++i) {
            File location = (File)this.locations.get(i);
            if (location.isDirectory()) continue;
            this.cleanup0((File)this.expandDirs.get(i));
        }
    }

    private void cleanup0(File dir) {
        if (!dir.isDirectory()) {
            return;
        }
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.cleanup0(files[i]);
            }
            if (files[i].delete() || !files[i].isFile()) continue;
            Print.dprintln((String)("Could not delete " + files[i].getAbsolutePath()));
        }
        if (!dir.delete()) {
            Print.dprintln((String)("Could not delete " + dir.getAbsolutePath()));
        }
    }

    public void setLocation(File module) throws IOException {
        this.setLocation(module, true);
    }

    public void setLocation(File module, boolean forceExpand) throws IOException {
        this.setLocation(module, J2EEClassLoader.module2Dir(module), forceExpand);
    }

    public void setLocation(File module, File expandDir, boolean forceExpand) throws IOException {
        if (!module.exists()) {
            throw new FileNotFoundException(module.toString());
        }
        if (module.isDirectory()) {
            this.appendURL(module.toURL());
            this.rootDir = module;
            return;
        }
        this.rootDir = expandDir;
        this.locations.add(module);
        this.expandDirs.add(expandDir);
        String fileName = module.getName();
        long t1 = module.lastModified();
        if (!expandDir.exists() || forceExpand || module.lastModified() > expandDir.lastModified()) {
            if (expandDir.exists()) {
                this.cleanup0(expandDir);
            }
            if (FileUtil.isEARFile((File)module)) {
                this.extractEAR(module, expandDir);
            } else if (FileUtil.isWARFile((File)module)) {
                this.extractWAR(module, expandDir);
            } else if (FileUtil.isRARFile((File)module)) {
                this.extractRAR(module, expandDir);
            }
        }
        if (FileUtil.isWARFile((File)module) || FileUtil.isAppClientJar((File)module) || FileUtil.isRARFile((File)module) || FileUtil.isEJBJar((File)module)) {
            this.appendURL(module.toURL());
        }
        if (expandDir.exists()) {
            List fileList = J2EEClassLoader.getJarsWars(expandDir);
            Iterator iter = fileList.iterator();
            while (iter.hasNext()) {
                File file = (File)iter.next();
                this.appendURL(file.toURL());
            }
        }
    }

    public File getRootDir() {
        return this.rootDir;
    }

    private void extractEAR(File module, File destdir) throws IOException {
        destdir.mkdirs();
        JarFile jar = new JarFile(module);
        Enumeration<JarEntry> e = jar.entries();
        while (e.hasMoreElements()) {
            ZipEntry zipEntry = e.nextElement();
            if (zipEntry.isDirectory()) continue;
            String zipName = zipEntry.getName();
            InputStream is = jar.getInputStream(zipEntry);
            File target = new File(destdir, zipName);
            this.copy(is, target);
            is.close();
            if (FileUtil.isWARFile((File)target)) {
                this.extractWAR(target, J2EEClassLoader.module2Dir(new File(destdir, zipName)));
                continue;
            }
            if (!FileUtil.isRARFile((File)target)) continue;
            this.extractRAR(target, J2EEClassLoader.module2Dir(new File(destdir, zipName)));
        }
        jar.close();
    }

    private void extractWAR(File module, File destDir) throws IOException {
        destDir.mkdirs();
        JarFile jar = new JarFile(module);
        Enumeration<JarEntry> e = jar.entries();
        while (e.hasMoreElements()) {
            ZipEntry zipEntry = e.nextElement();
            String zipName = zipEntry.getName();
            if (zipEntry.isDirectory() || !zipName.startsWith("WEB-INF/lib") && (!this.webClassExpansion || !zipName.startsWith("WEB-INF/classes"))) continue;
            InputStream is = jar.getInputStream(zipEntry);
            File target = new File(destDir, zipName);
            this.copy(is, target);
            is.close();
        }
        jar.close();
    }

    private void extractRAR(File module, File destDir) throws IOException {
        destDir.mkdirs();
        JarFile jar = new JarFile(module);
        Enumeration<JarEntry> e = jar.entries();
        while (e.hasMoreElements()) {
            ZipEntry zipEntry = e.nextElement();
            String zipName = zipEntry.getName();
            if (zipEntry.isDirectory() || !zipName.endsWith(".jar")) continue;
            InputStream is = jar.getInputStream(zipEntry);
            File target = new File(destDir, zipName);
            this.copy(is, target);
            is.close();
        }
        jar.close();
    }

    private void copy(InputStream is, File file) throws IOException {
        file.getParentFile().mkdirs();
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
        byte[] buf = new byte[4096];
        int len = 0;
        while (len != -1) {
            try {
                len = is.read(buf, 0, buf.length);
            }
            catch (EOFException eof) {
                break;
            }
            if (len == -1) continue;
            os.write(buf, 0, len);
        }
        os.close();
    }

    public void addEjbClassNames(Set ejbClasses) {
        this.ejbClassSet.addAll(ejbClasses);
    }

    public void appendURL(URL url) {
        this.urlSet.add(url);
    }

    public void prependURL(URL url) {
        if (this.urlSet.isEmpty()) {
            this.urlSet.add(0, url);
        } else {
            URL firstURL = (URL)this.urlSet.get(0);
            if (!firstURL.equals(url)) {
                this.urlSet.add(0, url);
            }
        }
    }

    public boolean removeURL(URL url) {
        return this.urlSet.remove(url);
    }

    public URL[] getURLs() {
        return this.urlSet.toArray(new URL[0]);
    }

    private URL findResource0(final File thisFile, final URL classpathURL, String name0) {
        if (name0.startsWith("/")) {
            name0 = name0.substring(1);
        }
        final String name = name0;
        Object result = AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public Object run() {
                if (!thisFile.exists()) {
                    return null;
                }
                if (thisFile.isFile()) {
                    JarFile jarFile;
                    block18: {
                        block17: {
                            jarFile = null;
                            jarFile = new JarFile(thisFile);
                            URL resourceURL = new URL("jar:" + classpathURL + "!/" + name);
                            JarEntry jarEntry = jarFile.getJarEntry(name);
                            if (jarEntry == null) {
                                jarEntry = jarFile.getJarEntry("WEB-INF/classes/" + name);
                                resourceURL = new URL("jar:" + classpathURL + "!/WEB-INF/classes/" + name);
                            }
                            if (jarEntry == null) break block17;
                            if (logger.isLoggable(Level.FINEST)) {
                                logger.log(Level.FINEST, "JCL: Found " + name + " at " + thisFile);
                                logger.log(Level.FINEST, "Found resource : " + resourceURL);
                            }
                            URL uRL = resourceURL;
                            Object var6_9 = null;
                            if (jarFile == null) return uRL;
                            try {
                                jarFile.close();
                                return uRL;
                            }
                            catch (IOException ioe) {
                                logger.log(Level.FINE, "Error closing jarFile " + jarFile);
                            }
                            return uRL;
                        }
                        Manifest man = jarFile.getManifest();
                        if (man == null) break block18;
                        J2EEClassLoader.this.checkManifest(classpathURL, thisFile, man);
                    }
                    Object var6_10 = null;
                    if (jarFile == null) return null;
                    try {
                        jarFile.close();
                        return null;
                    }
                    catch (IOException ioe) {
                        logger.log(Level.FINE, "Error closing jarFile " + jarFile);
                    }
                    return null;
                    {
                        catch (IOException e) {
                            if (logger.isLoggable(Level.FINE)) {
                                logger.log(Level.FINE, e.getMessage(), e);
                            }
                            Object var6_11 = null;
                            if (jarFile == null) return null;
                            try {
                                jarFile.close();
                                return null;
                            }
                            catch (IOException ioe) {
                                logger.log(Level.FINE, "Error closing jarFile " + jarFile);
                            }
                            return null;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_12 = null;
                        if (jarFile == null) throw throwable;
                        try {
                            jarFile.close();
                            throw throwable;
                        }
                        catch (IOException ioe) {
                            logger.log(Level.FINE, "Error closing jarFile " + jarFile);
                        }
                        throw throwable;
                    }
                }
                File resourceFile = new File(thisFile.toString() + File.separator + name);
                if (!resourceFile.exists()) return null;
                try {
                    if (!logger.isLoggable(Level.FINEST)) return resourceFile.toURL();
                    logger.log(Level.FINEST, "JCL: Found " + name + " at " + resourceFile);
                    return resourceFile.toURL();
                }
                catch (IOException e) {
                    if (!logger.isLoggable(Level.FINE)) return null;
                    logger.log(Level.FINE, e.getMessage(), e);
                }
                return null;
            }
        });
        return (URL)result;
    }

    protected URL findResource(String name) {
        this.print("findResource : " + name);
        for (int i = 0; i < this.urlSet.size(); ++i) {
            URL classpathURL = (URL)this.urlSet.get(i);
            File thisFile = new File(classpathURL.getFile());
            URL url = this.findResource0(thisFile, classpathURL, name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkManifest(URL url, File file, Manifest man) {
        if (man == null) {
            return;
        }
        List list = this.urlSet;
        synchronized (list) {
            if (this.manifestChecked.contains(url)) {
                return;
            }
            this.manifestChecked.add(url);
            String cp = man.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
            if (cp == null) {
                return;
            }
            StringTokenizer st = new StringTokenizer(cp, " ");
            while (st.hasMoreTokens()) {
                String entry = st.nextToken();
                File newFile = new File(file.getParentFile(), entry);
                try {
                    this.appendURL(newFile.toURL());
                }
                catch (MalformedURLException ex) {
                    logger.log(Level.FINEST, ex.getMessage(), ex);
                }
            }
        }
    }

    private byte[] loadClassData0(final URL url, final File thisFile, final String entryName) {
        Object result = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                block11: {
                    try {
                        InputStream classStream = null;
                        if (!thisFile.exists()) {
                            return null;
                        }
                        if (thisFile.isFile()) {
                            JarFile zip = new JarFile(thisFile);
                            ZipEntry entry = zip.getEntry(entryName);
                            if (entry == null) {
                                entry = zip.getEntry("WEB-INF/classes/" + entryName);
                            }
                            if (entry != null) {
                                if (logger.isLoggable(Level.FINEST)) {
                                    logger.log(Level.FINEST, "JCL: Found " + entryName + " at " + thisFile);
                                }
                                classStream = zip.getInputStream(entry);
                                byte[] classData = J2EEClassLoader.this.getClassData(classStream);
                                classStream.close();
                                zip.close();
                                return classData;
                            }
                            Manifest man = zip.getManifest();
                            if (man != null) {
                                J2EEClassLoader.this.checkManifest(url, thisFile, man);
                            }
                            zip.close();
                        } else {
                            File classFile = new File(thisFile, entryName.replace('/', File.separatorChar));
                            if (classFile.exists()) {
                                if (logger.isLoggable(Level.FINEST)) {
                                    logger.log(Level.FINEST, "JCL: Found " + entryName + " at " + classFile);
                                }
                                classStream = new FileInputStream(classFile);
                                byte[] classData = J2EEClassLoader.this.getClassData(classStream);
                                classStream.close();
                                return classData;
                            }
                        }
                    }
                    catch (IOException ex) {
                        if (!logger.isLoggable(Level.FINE)) break block11;
                        logger.log(Level.FINE, ex.getMessage(), ex);
                    }
                }
                return null;
            }
        });
        return (byte[])result;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        this.print("JCL: findClass " + name);
        String entryName = name.replace('.', '/') + ".class";
        for (int i = 0; i < this.urlSet.size(); ++i) {
            URL thisURL = (URL)this.urlSet.get(i);
            File thisFile = new File(thisURL.getFile());
            byte[] result = this.loadClassData0(thisURL, thisFile, entryName);
            if (result == null) continue;
            CodeSource cs = null;
            cs = this.ejbClassSet.contains(name) ? ejbCodeSource : new CodeSource(thisURL, null);
            Class<?> clz = this.defineClass(name, result, 0, result.length, cs);
            return clz;
        }
        throw new ClassNotFoundException(name);
    }

    private byte[] getClassData(InputStream istream) throws IOException {
        byte[] buf = new byte[1024];
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        int num = 0;
        while ((num = istream.read(buf)) != -1) {
            bout.write(buf, 0, num);
        }
        return bout.toByteArray();
    }

    private void print(String o) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, o);
        }
    }

    public String toString() {
        return "J2EECL: \n " + this.urlSet + " \n ";
    }

    public String getClasspath() {
        return "";
    }

    public String getClassPath() {
        StringBuffer sb = new StringBuffer();
        Iterator iter = this.urlSet.iterator();
        while (iter.hasNext()) {
            URL url = (URL)iter.next();
            sb.append(url.getPath());
            if (!iter.hasNext()) continue;
            sb.append(File.pathSeparator);
        }
        return sb.toString();
    }

    public Set getAllClasses() throws IOException {
        String webinfclass = "WEB-INF/classes/";
        HashSet<String> result = new HashSet<String>();
        Iterator iter = this.urlSet.iterator();
        while (iter.hasNext()) {
            URL url = (URL)iter.next();
            File file = new File(url.getFile());
            if (!file.exists()) {
                logger.log(Level.FINEST, "Non-existent file on classpath: " + file);
                continue;
            }
            if (file.isDirectory()) continue;
            boolean isWarFile = FileUtil.isWARFile((File)file);
            JarFile jar = new JarFile(file);
            Enumeration<JarEntry> e = jar.entries();
            while (e.hasMoreElements()) {
                ZipEntry zipEntry = e.nextElement();
                String zipName = zipEntry.getName();
                if (!zipName.endsWith(".class")) continue;
                if (isWarFile && zipName.startsWith(webinfclass)) {
                    result.add(this.file2class(zipName.substring(webinfclass.length())));
                    continue;
                }
                result.add(this.file2class(zipName));
            }
            jar.close();
        }
        return result;
    }

    private String file2class(String filename) {
        String result = filename.substring(0, filename.indexOf(".class"));
        result = result.replace('/', '.');
        if ((result = result.replace(File.separatorChar, '.')).charAt(0) == '.') {
            result = result.substring(1);
        }
        return result;
    }

    private static List getJarsWars(File dir) {
        ArrayList list = new ArrayList();
        J2EEClassLoader.getJarsWars0(dir, list);
        return list;
    }

    private static void getJarsWars0(File dir, List list) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                if (file.getName().equals("classes") && file.getParentFile().getName().equals("WEB-INF")) {
                    list.add(file);
                    continue;
                }
                J2EEClassLoader.getJarsWars0(file, list);
                continue;
            }
            String name = file.getName();
            if (!name.endsWith(".jar") && !FileUtil.isEJBJar((File)file) && !FileUtil.isAppClientJar((File)file) && !FileUtil.isWARFile((File)file)) continue;
            list.add(files[i]);
        }
    }

    public static void main(String[] args) {
        try {
            String jarfile = args[0];
            J2EEClassLoader cl = new J2EEClassLoader();
            cl.setLocation(new File(jarfile));
            Print.dprintln((String)cl.getClassPath());
            Print.dprintln((String)cl.getAllClasses().toString());
            Print.dprintln((String)("" + cl.findResource("/error.html")));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        try {
            String path = FileUtil.getAbsolutePath((String)EJB_CODE_BASE);
            ejbCodeSource = new CodeSource(new File(path).toURL(), null);
        }
        catch (MalformedURLException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }
}

