/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.ListTools;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.Print;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public abstract class InspectorTableModel
extends AbstractTableModel {
    public static final int ORDERING_DEFAULT = 0;
    public static final int ORDERING_SORTED = 1;
    public static final int ORDERING_ORIGINAL = 2;
    protected Object[] columnNames = null;
    private boolean compareWithEquals = false;
    private int dataOrder = 0;
    private Comparator sortCompare = null;
    private InspectorTable inspTable = null;
    private List data = Collections.synchronizedList(new ArrayList());
    private DelegateList delegateList = new DelegateList();
    private int _currentRow = -1;

    protected InspectorTableModel() {
    }

    public InspectorTableModel(String[] columnNames) {
        this.setColumnNames(columnNames);
    }

    public InspectorTableModel(List data, String[] columnNames) {
        this.getData().addAll(data);
        this.setColumnNames(columnNames);
    }

    public InspectorTableModel(ArrayList data, String[] columnNames) {
        this.getData().addAll(data);
        this.setColumnNames(columnNames);
    }

    public UITitledTable getTableOwner() {
        return this.getInspectorTable().getTableOwner();
    }

    public InspectorTable getInspectorTable() {
        return this.inspTable;
    }

    public void setInspectorTable(InspectorTable table) {
        this.inspTable = table;
    }

    public boolean isReadOnly() {
        return this.inspTable != null ? this.inspTable.isReadOnly() : false;
    }

    public int getDescriptionColumn() {
        return this.inspTable != null ? this.inspTable.getDescriptionColumn() : -1;
    }

    public List getData() {
        if (this.data == null) {
            this.setData(null);
        }
        return this.data;
    }

    public void setData(List data) {
        this.data = data == null ? new ArrayList() : data;
        this.fireTableDataChanged();
    }

    public void setColumnNames(Object[] columnNames) {
        this.columnNames = columnNames;
    }

    public void setColumnNames(Vector columnNames) {
        this.columnNames = columnNames.toArray();
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int col) {
        return this.columnNames[col].toString();
    }

    public boolean isValidColumn(int column) {
        return column >= 0 && column < this.columnNames.length;
    }

    public Class getColumnClass(int c) {
        Object value = this.getValueAt(0, c);
        if (value == null) {
            Print.dprintln((String)("Value at <*," + c + "> is null! [rowCount = " + this.getRowCount() + "]"));
            return String.class;
        }
        return value.getClass();
    }

    public int getRowCount() {
        return this.getData().size();
    }

    public Object getRowObject(int row) {
        return this.isValidRow(row) ? this.getData().get(row) : null;
    }

    public int getObjectIndex(Object obj) {
        return this.delegateList.setList(this.getData()).indexOf(obj);
    }

    public Object getRowWithValue(int startRow, int col, Object value) {
        return this.getRowObject(this.findRowWithValue(startRow, col, value));
    }

    public Object getRowWithValue(int col, Object value) {
        return this.getRowObject(this.findRowWithValue(-1, col, value));
    }

    public int findRowWithValue(int col, Object value) {
        return this.findRowWithValue(-1, col, value);
    }

    public int findRowWithValue(int startRow, int col, Object value) {
        int rowCnt = this.getRowCount();
        for (int row = startRow <= 0 ? 0 : startRow; row < rowCnt; ++row) {
            Object objVal = this.getValueAt(row, col);
            if (objVal == null || !objVal.equals(value)) continue;
            return row;
        }
        return -1;
    }

    public boolean isValidRow(int row) {
        return row >= 0 && row < this.getRowCount();
    }

    public boolean isCellEditable(int row, int col) {
        return !this.isReadOnly();
    }

    public int getCurrentRow() {
        return this._currentRow;
    }

    public Object getValueAt(int row, int col) {
        Object obj = this.getRowObject(row);
        this._currentRow = row;
        Object val = obj != null ? this.getObjectValue(obj, col) : null;
        this._currentRow = -1;
        return val instanceof String ? ((String)val).trim() : val;
    }

    public abstract Object getObjectValue(Object var1, int var2);

    public void setValueAt(Object value, int row, int col) {
        if (value != null) {
            Object obj = this.getRowObject(row);
            if (obj != null) {
                Object val = value instanceof String ? ((String)value).trim() : value;
                this._currentRow = row;
                this.setObjectValue(obj, col, val);
                this._currentRow = -1;
                this.fireTableCellUpdated(row, col);
            }
        } else {
            Print.printStackTrace((String)"Attempting to set a 'null' value!");
        }
    }

    public abstract void setObjectValue(Object var1, int var2, Object var3);

    public InspectorDataWrapper wrapDataItem(Object obj) {
        return obj instanceof InspectorDataWrapper ? (InspectorDataWrapper)obj : new InspectorDataWrapper(obj);
    }

    public InspectorDataWrapper wrapDataItem(Object[] obj) {
        return new InspectorDataWrapper(obj);
    }

    public Vector wrapData(Collection objSet) {
        Vector<InspectorDataWrapper> v = new Vector<InspectorDataWrapper>();
        Iterator i = objSet.iterator();
        while (i.hasNext()) {
            v.add(this.wrapDataItem(i.next()));
        }
        return v;
    }

    public Vector wrapData(Enumeration objEnum) {
        Vector<InspectorDataWrapper> v = new Vector<InspectorDataWrapper>();
        while (objEnum.hasMoreElements()) {
            v.add(this.wrapDataItem(objEnum.nextElement()));
        }
        return v;
    }

    public Vector wrapData(Iterator objIter) {
        Vector<InspectorDataWrapper> v = new Vector<InspectorDataWrapper>();
        while (objIter.hasNext()) {
            v.add(this.wrapDataItem(objIter.next()));
        }
        return v;
    }

    public List unwrapData(List wrapperList) {
        Vector<Object> v = new Vector<Object>();
        Iterator i = wrapperList.iterator();
        while (i.hasNext()) {
            Object wrapper = i.next();
            if (wrapper instanceof InspectorDataWrapper) {
                v.add(((InspectorDataWrapper)wrapper).getWrappedObject());
                continue;
            }
            Print.dprintln((String)("Expected InspectorDataWrapper: " + DT.className(wrapper)));
            v.add(wrapper);
        }
        return v;
    }

    public static Vector cloneWrapperData(Vector wrapperData) {
        if (wrapperData != null) {
            Vector<Object> v = new Vector<Object>();
            Iterator i = wrapperData.iterator();
            while (i.hasNext()) {
                Object data = i.next();
                if (data instanceof InspectorDataWrapper) {
                    v.add(((InspectorDataWrapper)data).clone());
                    continue;
                }
                Print.dprintStackTrace((String)("Invalid class: " + UIUtils.debugClassName(data)));
                v.add(data);
            }
            return v;
        }
        return null;
    }

    public int getDataOrdering() {
        return this.dataOrder;
    }

    public void setDataOrdering(int order) {
        this.setDataOrdering(order, 0, 0, null);
    }

    public void setDataOrdering(int order, Comparator compare) {
        this.setDataOrdering(order, 0, 0, compare);
    }

    public void setDataOrdering(int order, int colFirst, int colLast) {
        this.setDataOrdering(order, colFirst, colLast, null);
    }

    public void setDataOrdering(int order, int colFirst, int colLast, Comparator compare) {
        if (this.dataOrder != 1 && this.dataOrder == order) {
            return;
        }
        this.dataOrder = order;
        if (this.dataOrder == 1) {
            this.sortCompare = compare != null ? compare : this.createSortComparator(colFirst, colLast);
            Collections.sort(this.getData(), this.sortCompare);
        } else {
            this.sortCompare = null;
        }
    }

    public boolean isOriginalDataOrdering() {
        return this.dataOrder == 2;
    }

    public boolean isSortedDataOrdering() {
        return this.dataOrder == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _updateTableData(Collection c) {
        List list = this.getData();
        synchronized (list) {
            int lastRow;
            if (c == null || this.isOriginalDataOrdering()) {
                try {
                    this.getData().clear();
                }
                catch (UnsupportedOperationException uso) {
                    // empty catch block
                }
            }
            Iterator i = this.getData().iterator();
            while (i.hasNext()) {
                if (c != null && !this.isOriginalDataOrdering() && this._listContainsObject(c, i.next())) continue;
                i.remove();
            }
            if (c != null) {
                i = c.iterator();
                while (i.hasNext()) {
                    this.addRowObject(i.next(), false);
                }
            }
            if ((lastRow = this.getRowCount() - 1) < 0 || this.isOriginalDataOrdering()) {
                this.fireTableDataChanged();
            } else {
                this.fireTableRowsInserted(0, lastRow);
            }
        }
    }

    public void _updateTableData(Set s) {
        this._updateTableData((Collection)s);
    }

    public void _updateTableData(Enumeration e) {
        ArrayList c = null;
        if (e != null) {
            c = new ArrayList();
            while (e.hasMoreElements()) {
                c.add(e.nextElement());
            }
        }
        this._updateTableData(c);
    }

    public void _updateTableData(Iterator i) {
        ArrayList c = null;
        if (i != null) {
            c = new ArrayList();
            while (i.hasNext()) {
                c.add(i.next());
            }
        }
        this._updateTableData(c);
    }

    public void _updateTableData(Object[] list) {
        Vector<Object> v = new Vector<Object>();
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                v.add(list[i]);
            }
        }
        this._updateTableData(v);
    }

    public void clearTableData() {
        this._updateTableData((Collection)null);
    }

    public void addRowObject(Object obj) {
        this.addRowObject(obj, false);
    }

    public void addRowObject(Object obj, boolean fireChanged) {
        if (!this._listContainsObject(this.getData(), obj)) {
            if (this.sortCompare != null) {
                int loc = Collections.binarySearch(this.getData(), obj, this.sortCompare);
                if (loc < 0) {
                    int newRow = -(loc + 1);
                    this.getData().add(newRow, obj);
                    if (fireChanged) {
                        this.fireTableRowsInserted(newRow, newRow);
                    }
                } else {
                    this.getData().add(loc, obj);
                    if (fireChanged) {
                        this.fireTableRowsUpdated(loc, loc);
                    }
                }
            } else {
                int newRow = this.getRowCount();
                this.getData().add(obj);
                if (fireChanged) {
                    this.fireTableRowsInserted(newRow, newRow);
                }
            }
        }
    }

    public int replaceRowObject(Object obj, Object newObj) {
        return this.replaceRowObject(obj, newObj, false);
    }

    public int replaceRowObject(Object obj, Object newObj, boolean fireChanged) {
        int row = this.getObjectIndex(obj);
        return this.replaceRowObject(row, newObj, fireChanged);
    }

    public int replaceRowObject(int row, Object newObj, boolean fireChanged) {
        if (this.isValidRow(row)) {
            this.getData().set(row, newObj);
            if (fireChanged) {
                this.fireTableRowsUpdated(row, row);
            }
            return row;
        }
        return -1;
    }

    public boolean removeRowObject(Object obj) {
        return this.removeRowObject(obj, false);
    }

    public boolean removeRowObject(Object obj, boolean fireChanged) {
        int row = this.getObjectIndex(obj);
        return this.removeRowObject(row, fireChanged);
    }

    public boolean removeRowObject(int ndx, boolean fireChanged) {
        if (this.isValidRow(ndx)) {
            this.getData().remove(ndx);
            if (fireChanged) {
                this.fireTableRowsDeleted(ndx, ndx);
            }
            return true;
        }
        return false;
    }

    private boolean _listContainsObject(Collection c, Object item) {
        return this.delegateList.setCollection(c).contains(item);
    }

    public void setCompareWithEquals(boolean state) {
        this.compareWithEquals = state;
    }

    protected Comparator createSortComparator(int colFirst, int colLast) {
        return new StringSortComparator(colFirst, colLast);
    }

    public String validatePrimitiveValue(String type, String value) {
        String v;
        String string = v = value != null ? value : "";
        if (type == null || type.equals("java.lang.String")) {
            return v;
        }
        if (type.equals("java.lang.Character")) {
            String cval = v.length() > 0 ? v.substring(0, 1) : " ";
            return cval;
        }
        Class<?> tc = null;
        try {
            tc = Class.forName(type);
        }
        catch (Throwable t) {
            Print.dprintStackTrace((String)("Invalid type: " + type));
            return "";
        }
        Constructor<?> c = null;
        try {
            c = tc.getConstructor(String.class);
        }
        catch (Throwable t) {
            Print.dprintln((String)("No constructor: " + type + "(String)"));
        }
        String newValue = null;
        if (c != null) {
            try {
                newValue = c.newInstance(v).toString();
            }
            catch (Throwable t) {
                Print.dprintln((String)("Can't instantiate: " + type + "(\"" + v + "\")"));
            }
        }
        if (newValue == null) {
            try {
                newValue = tc.newInstance().toString();
            }
            catch (Throwable t) {
                Print.dprintln((String)("Can't instantiate: " + type + "()"));
            }
        }
        return newValue != null ? newValue : "";
    }

    protected class StringSortComparator
    implements Comparator {
        private int colFirst = 0;
        private int colLast = 0;

        public StringSortComparator(int colFirst, int colLast) {
            this.colFirst = colFirst;
            this.colLast = colLast;
        }

        public int compare(Object r1, Object r2) {
            for (int i = this.colFirst; i <= this.colLast; ++i) {
                Object c2;
                Object c1 = InspectorTableModel.this.getObjectValue(r1, i);
                int comp = this.compareStrings(c1 != null ? c1.toString() : null, (c2 = InspectorTableModel.this.getObjectValue(r2, i)) != null ? c2.toString() : null);
                if (comp == 0) continue;
                return comp;
            }
            return 0;
        }

        private int compareStrings(String s1, String s2) {
            if (s1 == s2) {
                return 0;
            }
            if (s1 == null) {
                return -1;
            }
            if (s2 == null) {
                return 1;
            }
            if (s1.equals(s2)) {
                return 0;
            }
            if (s1.equals("")) {
                return 1;
            }
            if (s2.equals("")) {
                return -1;
            }
            return s1.compareTo(s2);
        }
    }

    public static class InspectorDataWrapper {
        private Object DefaultNullValue = null;
        private Object[] items = null;
        private boolean isSingleItem = false;

        private InspectorDataWrapper(Object[] items, boolean single, Object dftNull) {
            this.items = items;
            this.isSingleItem = single;
            this.DefaultNullValue = dftNull;
        }

        public InspectorDataWrapper(Object[] obj) {
            this.isSingleItem = false;
            this.setObject(obj);
        }

        public void setObject(Object[] obj) {
            Object[] objectArray;
            if (obj != null && obj.length > 0) {
                objectArray = obj;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = null;
            }
            this.items = objectArray;
        }

        public Object setObject(int index, Object obj) {
            if (this.items == null) {
                this.items = new Object[index + 1];
            } else if (index >= this.items.length) {
                Object[] newItems = new Object[index + 1];
                System.arraycopy(this.items, 0, newItems, 0, this.items.length);
                this.items = newItems;
            }
            this.items[index] = obj;
            return obj;
        }

        public Object getObject(int index, Object dftValue) {
            Object v = this.items != null && this.items.length > index ? this.items[index] : dftValue;
            return v != null ? v : this.DefaultNullValue;
        }

        public Object getObject(int index) {
            return this.getObject(index, null);
        }

        public Object[] getObjects() {
            return this.items;
        }

        public InspectorDataWrapper(Object obj) {
            this.isSingleItem = true;
            if (obj instanceof Object[]) {
                this.setObject((Object[])obj);
            } else {
                this.setObject(obj);
            }
        }

        public Object setObject(Object obj) {
            return this.setObject(0, obj);
        }

        public Object getObject(Object dftValue) {
            return this.getObject(0, dftValue);
        }

        public Object getObject() {
            return this.getObject(0);
        }

        public Object getWrappedObject() {
            return this.isSingleItem ? this.getObject() : this.getObjects();
        }

        public void setDefaultNullValue(Object val) {
            this.DefaultNullValue = val;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof InspectorDataWrapper) {
                if (obj == this) {
                    return true;
                }
                Object v1 = this.getObject();
                Object v2 = ((InspectorDataWrapper)obj).getObject();
                return v1 != null ? v1.equals(v2) : v2 == null;
            }
            Object v = this.getObject();
            return v != null ? v.equals(obj) : false;
        }

        public String toString() {
            Object v = this.getObject();
            return v != null ? v.toString() : "";
        }

        public Object clone() {
            Object[] cloneItems = null;
            if (this.items != null) {
                Class<?> arrayClass = this.items.getClass().getComponentType();
                cloneItems = (Object[])Array.newInstance(arrayClass, this.items.length);
                System.arraycopy(this.items, 0, cloneItems, 0, this.items.length);
            } else {
                cloneItems = null;
            }
            return new InspectorDataWrapper(cloneItems, this.isSingleItem, this.DefaultNullValue);
        }
    }

    public static class InspectorDataRecord {
        private InspectorDataWrapper rcd = null;

        private InspectorDataRecord(InspectorDataWrapper rcd) {
            this.rcd = rcd;
        }

        public InspectorDataRecord(Object[] obj) {
            this.rcd = new InspectorDataWrapper(obj);
        }

        public InspectorDataRecord(Object obj) {
            this.rcd = new InspectorDataWrapper(obj);
        }

        public Object setObject(int index, Object obj) {
            return this.rcd.setObject(index, obj);
        }

        public Object getObject(int index, Object dftValue) {
            return this.rcd.getObject(index, dftValue);
        }

        public Object[] getObjects() {
            return this.rcd.getObjects();
        }

        public void setDefaultNullValue(Object val) {
            this.rcd.setDefaultNullValue(val);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof InspectorDataRecord)) {
                return false;
            }
            Object[] d1 = this.rcd.getObjects();
            Object[] d2 = ((InspectorDataRecord)obj).getObjects();
            if (d1 == null) {
                return d2 == null;
            }
            if (d2 == null) {
                return false;
            }
            if (d1.length != d2.length) {
                return false;
            }
            for (int i = 0; i < d1.length; ++i) {
                if (!(d1[i] != null ? d2[i] == null || !d1[i].equals(d2[i]) : d2[i] != null)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            Object[] d = this.rcd.getObjects();
            if (d != null) {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < d.length; ++i) {
                    sb.append(d[i]).append("::");
                }
                return sb.toString();
            }
            return "";
        }

        public Object clone() {
            return new InspectorDataRecord((InspectorDataWrapper)this.rcd.clone());
        }
    }

    protected class DelegateList
    extends ListTools.ListAdapter {
        private Collection collection;

        public DelegateList() {
            super(null);
            this.collection = null;
        }

        public List setList(List list) {
            super.setList(list);
            this.collection = null;
            return this;
        }

        public List setCollection(Collection collection) {
            if (collection instanceof List) {
                this.setList((List)collection);
            } else {
                this.setList(null);
                this.collection = collection;
            }
            return this;
        }

        public boolean contains(Object o) {
            if (this.list != null) {
                return this.indexOf(o) >= 0;
            }
            Object obj = o instanceof InspectorDataWrapper ? ((InspectorDataWrapper)o).getObject() : o;
            boolean compareEquals = InspectorTableModel.this.compareWithEquals || obj instanceof String;
            Iterator i = this.collection.iterator();
            while (i.hasNext()) {
                Object n = i.next();
                if (n instanceof InspectorDataWrapper) {
                    n = ((InspectorDataWrapper)n).getObject();
                }
                if (n == o) {
                    return true;
                }
                if (!compareEquals || !n.equals(o)) continue;
                return true;
            }
            return false;
        }

        public boolean remove(Object o) {
            int row = this.indexOf(o);
            if (row >= 0) {
                this.remove(row);
            }
            return row >= 0;
        }

        public Object get(int index) {
            Object obj = super.get(index);
            return obj instanceof InspectorDataWrapper ? ((InspectorDataWrapper)obj).getObject() : obj;
        }

        public int indexOf(Object o) {
            Object obj = o instanceof InspectorDataWrapper ? ((InspectorDataWrapper)o).getObject() : o;
            boolean compareEquals = InspectorTableModel.this.compareWithEquals || obj instanceof String;
            return ListTools.listIndexOf(this, obj, compareEquals);
        }

        public int lastIndexOf(Object o) {
            Object obj = o instanceof InspectorDataWrapper ? ((InspectorDataWrapper)o).getObject() : o;
            boolean compareEquals = InspectorTableModel.this.compareWithEquals || obj instanceof String;
            return ListTools.listLastIndexOf(this, obj, compareEquals);
        }
    }
}

