/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorInspector;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorTools;
import com.sun.enterprise.tools.deployment.ui.shared.ModuleArchive;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIEventQueue;
import com.sun.enterprise.tools.deployment.ui.utils.UITabbedPane;
import com.sun.enterprise.tools.deployment.ui.utils.WinTools;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import com.sun.enterprise.util.Print;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.help.CSH;
import javax.swing.JFrame;

public abstract class InspectorTabbedPane
extends UITabbedPane
implements DescriptorInspector,
InspectorPane.InspectorPaneOwner {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(InspectorTabbedPane.class);
    private static String CONFIG_REMOVE_DISABLED_TABS = "ui.InspectorTabbedPane.removeDisabledTabs";
    private Vector inspectorList = new Vector();
    private int addingInspectorPane = 0;
    private boolean isReadOnly = false;
    private int lastRefreshedInspector = -1;
    private int refreshInspectorAt_recursion = 0;
    private boolean refreshInspectorAt_recursionCheck = false;
    private boolean cacheClassList = false;
    private Vector archiveClassList = null;
    private DeferredNotification deferredNotification = new DeferredNotification();
    private static int deferredNotifyCount = 0;
    protected static DeferredNotification currentRunningNotification = null;

    public InspectorTabbedPane() {
        this.addInspectors();
        this.invalidate();
    }

    public abstract String getHelpGroup();

    protected int getInspectorCount() {
        return this.inspectorList.size();
    }

    protected InspectorPane getInspectorAt(int ndx) {
        return (InspectorPane)this.inspectorList.elementAt(ndx);
    }

    protected abstract void addInspectors();

    public InspectorPane getInspectorPane(int index) {
        return this.getInspectorAt(index);
    }

    public InspectorPane getInspectorPane(Class inspClass) {
        if (inspClass != null) {
            if (InspectorPane.class.isAssignableFrom(inspClass)) {
                Iterator i = this.inspectorList.iterator();
                while (i.hasNext()) {
                    Object c = i.next();
                    if (!inspClass.isAssignableFrom(c.getClass())) continue;
                    return (InspectorPane)c;
                }
                Print.dprintln((String)("InspectorPane not found: " + UIUtils.debugClassName(inspClass)));
            } else {
                Print.dprintln((String)("Not an InspectorPane: " + UIUtils.debugClassName(inspClass)));
            }
        }
        return null;
    }

    public InspectorPane getInspectorPane(String inspClassName) {
        try {
            return this.getInspectorPane(Class.forName(inspClassName));
        }
        catch (Throwable t) {
            Print.dprintln((String)("Class not found: " + inspClassName));
            return null;
        }
    }

    public InspectorPane addInspectorPane(String inspClassName) {
        InspectorPane insp = InspectorPane.createInspectorPane(inspClassName, "DeploymentMode");
        if (insp != null) {
            this._addInspectorPane(insp, -1);
            return insp;
        }
        Print.printStackTrace((String)("'NULL' InspectorPane! [" + inspClassName + "]"));
        return null;
    }

    public InspectorPane addInspectorPane(InspectorPane insp) {
        this._addInspectorPane(insp, -1);
        return insp;
    }

    private int _addInspectorPane(InspectorPane insp, int index) {
        int rtnIndex;
        if (insp == null) {
            Print.printStackTrace((String)"'NULL' InspectorPane!");
            return -1;
        }
        if (!this.inspectorList.contains(insp)) {
            this.inspectorList.add(insp);
        }
        if ((rtnIndex = this.indexOfComponent(insp)) >= 0) {
            return rtnIndex;
        }
        insp.setOwner(this);
        ++this.addingInspectorPane;
        if (index < 0) {
            super.addTab(insp.getTabName(), insp);
            rtnIndex = this.indexOfComponent(insp);
        } else {
            super.insertTab(insp.getTabName(), null, insp, null, index);
            rtnIndex = index;
        }
        --this.addingInspectorPane;
        String helpId = insp.getHelpID();
        if (helpId != null && helpId.length() > 0) {
            CSH.setHelpIDString((Component)insp, (String)(this.getHelpGroup() + helpId));
        }
        WinTools.resetDuplicateMnemonics(insp, WinTools.getApplicationFrameMnemonics());
        return rtnIndex;
    }

    protected void tabWillChange(int fromNdx) {
        if (fromNdx > 0 && this.getDescriptor() != null) {
            InspectorPane inspPane = (InspectorPane)super.getComponentAt(fromNdx);
            this.setValidAt(fromNdx, inspPane.validateEntries(false));
        }
    }

    public void removeNotify() {
        this.tabWillChange(this.getSelectedIndex());
        this.setDescriptor(null);
        super.removeNotify();
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void setReadOnly(boolean state) {
        if (state != this.isReadOnly) {
            this.isReadOnly = state;
        }
    }

    public void setInspectorPaneEnabled(InspectorPane insp, boolean enable) {
        if (enable) {
            this._enableInspectorPane(insp);
        } else {
            this._disableInspectorPane(insp);
        }
    }

    private void _enableInspectorPane(InspectorPane insp) {
        int ndx = this.indexOfComponent(insp);
        if (ndx >= 0) {
            this.setEnabledAt(ndx, true);
        } else {
            int p = this.inspectorList.indexOf(insp);
            if (p < 0) {
                this._addInspectorPane(insp, -1);
            } else {
                int insertPos = -1;
                int len = this.getTabCount();
                for (int i = 0; i < len; ++i) {
                    if (this.inspectorList.indexOf(this.getComponentAt(i)) <= p) continue;
                    insertPos = i;
                    break;
                }
                this._addInspectorPane(insp, insertPos);
            }
        }
    }

    private void _disableInspectorPane(InspectorPane insp) {
        int ndx = this.indexOfComponent(insp);
        if (ndx >= 0) {
            int sel = this.getSelectedIndex();
            if (UIConfig.getConfigBoolean(CONFIG_REMOVE_DISABLED_TABS, true)) {
                this.removeTabAt(ndx);
            } else {
                this.setEnabledAt(ndx, false);
            }
            if (sel == ndx) {
                super.setSelectedIndex(this.getTabCount() > 0 ? 0 : -1);
            }
        }
    }

    public InspectorPane getCurrentInspectorPane() {
        int index = this.getSelectedIndex();
        return index < 0 ? null : (InspectorPane)super.getComponentAt(index);
    }

    public void refreshCurrentInspector() {
        this.refreshInspectorAt(this.getSelectedIndex());
    }

    public synchronized void refreshInspectorAt(int index) {
        if (index < 0) {
            return;
        }
        if (!DT.getInspectorManager().isCurrentInspector(this)) {
            return;
        }
        if (this.refreshInspectorAt_recursion > 0) {
            if (UIConfig.debugMode()) {
                Print.printStackTrace((String)("**RECURSION CHECK** (" + this.refreshInspectorAt_recursion + ")"));
            }
            this.refreshInspectorAt_recursionCheck = true;
            return;
        }
        ++this.refreshInspectorAt_recursion;
        if (this.refreshInspectorAt_recursionCheck) {
            this.refreshInspectorAt_recursionCheck = false;
            Print.dprintStackTrace((String)"Unexpected 'true' recursion check ...");
        }
        boolean resetShowErrors = false;
        if (index != this.lastRefreshedInspector) {
            this.tabWillChange(this.lastRefreshedInspector);
            DescriptionInspector din = DescriptionInspector.findDescriptionInspector(this);
            if (din != null) {
                din.clearDescription();
            }
            this.lastRefreshedInspector = index;
            resetShowErrors = true;
        }
        if (this.getDescriptor() != null) {
            DescriptorInspector insp = (DescriptorInspector)((Object)this.getComponentAt(index));
            InspectorPane inspPane = insp instanceof InspectorPane ? (InspectorPane)insp : null;
            Descriptor d = this.getDescriptor();
            if (d != insp.getDescriptor() || inspPane == null) {
                if (!insp.getDescriptorClass().isAssignableFrom(d.getClass())) {
                    Print.dprintln((String)(DT.className(insp) + " doesn't support " + DT.className(d)));
                }
                insp.setDescriptor(d);
                if (inspPane != null) {
                    inspPane.resetFirstRefresh();
                }
                resetShowErrors = true;
            }
            if (inspPane != null) {
                if (resetShowErrors) {
                    inspPane.resetShowValidationErrors();
                }
                inspPane.setReadOnly(this.isReadOnly());
                inspPane.invokeRefresh();
            } else {
                Print.dprintStackTrace((String)("Not an InspectorPane: " + DT.className(insp)));
            }
        }
        if (this.refreshInspectorAt_recursionCheck) {
            if (UIConfig.debugMode()) {
                Print.printStackTrace((String)"**RECURSION CHECK** - prior invocation stack");
            }
            this.refreshInspectorAt_recursionCheck = false;
        }
        --this.refreshInspectorAt_recursion;
    }

    private InspectorTabbedPane makeCopy() {
        String mode = "DeploymentMode";
        InspectorTabbedPane copy = DT.getInspectorManager().createNewInspector(this.getClass(), mode);
        copy.setDescriptor(this.getDescriptor());
        int selNdx = this.getSelectedIndex();
        copy.setSelectedIndex(selNdx);
        return copy;
    }

    public void showClone(String title) {
        ClonedTabbedFrame frame = new ClonedTabbedFrame(title);
        Rectangle b = this.getBounds();
        Point p = this.getLocationOnScreen();
        frame.setBounds(p.x + 10, p.y + 10, b.width, b.height);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add(this.makeCopy());
        frame.setVisible(true);
    }

    public void selectionChanged() {
        super.selectionChanged();
        if (!super.isAddingTab()) {
            this.refreshInspectorAt(this.getSelectedIndex());
        }
    }

    public void setSelectedIndex(int ndx) {
        super.setSelectedIndex(ndx);
    }

    protected void _setValidTabAt(int n, boolean v) {
        this.setForegroundAt(n, v ? Color.black : Color.red);
    }

    public boolean isValid() {
        return DescriptorTools.isTabValid(this.getDescriptor());
    }

    public boolean isValidAt(int ndx) {
        return DescriptorTools.isTabValid(this.getDescriptor(), ndx);
    }

    public void setValidAt(int ndx, boolean valid) {
        DescriptorTools.setTabValid(this.getDescriptor(), ndx, valid);
        this._setValidTabAt(ndx, valid);
    }

    public void resetTabValidation() {
        Descriptor d = this.getDescriptor();
        if (d != null) {
            BitSet b = DescriptorTools.getTabValidation(d);
            int len = this.getTabCount();
            for (int i = 0; i < len; ++i) {
                this._setValidTabAt(i, b.get(i));
            }
        }
    }

    public Vector getArchiveContents() {
        Descriptor d = this.getDescriptor();
        BundleDescriptor bd = DescriptorTools.getBundleDescriptor(d);
        if (bd == null) {
            Print.dprintln((String)("Unable to determine BundleDescriptor from " + DescriptorTools.getDisplayName(d)));
            return null;
        }
        try {
            Vector contents = new Vector();
            List entries = ModuleArchive.getModuleArchive((Descriptor)bd).getEntryNames();
            Iterator i = entries.iterator();
            while (i.hasNext()) {
                Object item = i.next();
                contents.add(item);
            }
            return contents;
        }
        catch (Throwable t) {
            Print.dprintln((String)("Contents exception: " + t.toString()));
            return null;
        }
    }

    public Vector getArchiveClasses() {
        return this.getArchiveClasses(false);
    }

    public Vector getArchiveClasses(boolean inApplication) {
        if (this.cacheClassList && this.archiveClassList != null && !this.archiveClassList.isEmpty()) {
            return this.archiveClassList;
        }
        Descriptor d = this.getDescriptor();
        BundleDescriptor bd = DescriptorTools.getBundleDescriptor(d);
        if (bd == null) {
            Print.dprintln((String)("Unable to determine BundleDescriptor from " + DescriptorTools.getDisplayName(d)));
            return null;
        }
        if (DescriptorTools.isStandAlone(d) || !inApplication) {
            ModuleArchive modArch = ModuleArchive.getModuleArchive((Descriptor)bd);
            this.archiveClassList = (Vector)modArch.getClasses();
        } else {
            Set s = bd.getApplication().getBundleDescriptors();
            this.archiveClassList = new Vector();
            Iterator iter = s.iterator();
            while (iter.hasNext()) {
                BundleDescriptor bunDesc = (BundleDescriptor)iter.next();
                ModuleArchive modArch = ModuleArchive.getModuleArchive((Descriptor)bunDesc);
                this.archiveClassList.addAll((Vector)modArch.getClasses());
            }
        }
        return this.archiveClassList;
    }

    public void resetArchiveClasses() {
        this.archiveClassList = null;
    }

    public Class getDescriptorClass() {
        Descriptor d = this.getDescriptor();
        return d != null ? d.getClass() : null;
    }

    public void resetDescriptor(Descriptor d) {
        if (d != this.getDescriptor()) {
            this.tabWillChange(this.getSelectedIndex());
        }
        this.setDescriptor(d);
        this.resetTabValidation();
        this.refreshCurrentInspector();
    }

    public abstract Descriptor getDescriptor();

    public abstract void setDescriptor(Descriptor var1);

    public boolean isCurrentInspectorPane(InspectorPane pane) {
        if (!DT.getInspectorManager().isCurrentInspector(this)) {
            return false;
        }
        return this.getCurrentInspectorPane() == pane;
    }

    public String getLargeIconUri() {
        Descriptor desc = this.getDescriptor();
        return desc != null ? desc.getLargeIconUri() : "";
    }

    public String getSmallIconUri() {
        Descriptor desc = this.getDescriptor();
        return desc != null ? desc.getSmallIconUri() : "";
    }

    public void addApplicationManagerNotification() {
        this.addModuleManagerNotification();
    }

    public void addModuleManagerNotification() {
        if (this instanceof NotificationListener) {
            if (this.deferredNotification != null) {
                DT.getModuleManager().addNotificationListener(this.deferredNotification);
            } else {
                DT.getModuleManager().addNotificationListener((NotificationListener)this);
            }
        } else {
            Print.printStackTrace((String)"This class does not implement NotificationListener");
        }
    }

    public void addServerManagerNotification() {
        if (this instanceof NotificationListener) {
            if (this.deferredNotification != null) {
                DT.getServerManager().addNotificationListener(this.deferredNotification);
            } else {
                DT.getServerManager().addNotificationListener((NotificationListener)this);
            }
        } else {
            Print.printStackTrace((String)"This class does not implement NotificationListener");
        }
    }

    public static void resetNotificationPending() {
        deferredNotifyCount = 0;
    }

    public static boolean isNotificationPending() {
        return deferredNotifyCount > 0;
    }

    public static Throwable getDeferredNotificationStackTrace() {
        return currentRunningNotification != null ? currentRunningNotification.getStackTrace() : null;
    }

    public class NotificationEventWrapper {
        private Throwable stackTrace = new Throwable();
        private NotificationEvent notificationEvent = null;

        public NotificationEventWrapper(NotificationEvent ne) {
            this.notificationEvent = ne;
            this.stackTrace.fillInStackTrace();
        }

        public NotificationEvent getNotificationEvent() {
            return this.notificationEvent;
        }

        public Throwable getStackTrace() {
            return this.stackTrace;
        }
    }

    private class DeferredNotification
    implements NotificationListener,
    Runnable {
        private Hashtable notifyHash = null;
        private int hitCount = 0;
        private NotificationEventWrapper currentNotification = null;

        private DeferredNotification() {
        }

        public void notification(NotificationEvent ne) {
            String type = ne.getType();
            if (type == null) {
                return;
            }
            if (type.equals(Descriptor.DESCRIPTOR_CHANGED)) {
                NotificationEventWrapper neWrap = new NotificationEventWrapper(ne);
                if (this.notifyHash == null) {
                    this.notifyHash = new Hashtable();
                    this.hitCount = 0;
                }
                ++this.hitCount;
                if (this.notifyHash.containsKey(type)) {
                    this.notifyHash.put(type, neWrap);
                } else {
                    this.notifyHash.put(type, neWrap);
                    deferredNotifyCount++;
                    UIEventQueue.invokeLater(this);
                }
            } else {
                InspectorTabbedPane target = InspectorTabbedPane.this;
                if (target.isVisible()) {
                    ((NotificationListener)target).notification(ne);
                }
            }
        }

        public void run() {
            deferredNotifyCount--;
            if (deferredNotifyCount < 0) {
                deferredNotifyCount = 0;
            }
            if (this.notifyHash == null) {
                Print.printStackTrace((String)"Somehow we got here with an empty notification list");
                return;
            }
            InspectorTabbedPane target = InspectorTabbedPane.this;
            if (!target.isVisible()) {
                return;
            }
            currentRunningNotification = this;
            Enumeration keys = this.notifyHash.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                this.currentNotification = (NotificationEventWrapper)this.notifyHash.get(key);
                NotificationEvent ne = this.currentNotification.getNotificationEvent();
                ((NotificationListener)target).notification(ne);
                this.currentNotification = null;
            }
            this.notifyHash = null;
            currentRunningNotification = null;
        }

        public Throwable getStackTrace() {
            return this.currentNotification != null ? this.currentNotification.getStackTrace() : null;
        }
    }

    private class ClonedTabbedFrame
    extends JFrame
    implements DescriptionInspector.DescriptionInspectorManager {
        private DescriptionInspector descriptionInspector;

        public ClonedTabbedFrame(String title) {
            super(title);
            this.descriptionInspector = null;
            Object[] obj = new Object[]{title};
            this.getAccessibleContext().setAccessibleName(localStrings.getLocalString("ui.clonedtabbedframe.frame_name", "Name is {0}", obj));
            this.getAccessibleContext().setAccessibleDescription(localStrings.getLocalString("ui.clonedtabbedframe.frame_desc", "This is a frame for {0}", obj));
            this.descriptionInspector = new DescriptionInspector(this);
        }

        public InspectorTabbedPane getInspector() {
            return InspectorTabbedPane.this;
        }

        public DescriptionInspector getDescriptionInspector() {
            return this.descriptionInspector;
        }
    }
}

