/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorInspector;
import com.sun.enterprise.tools.deployment.ui.shared.ModuleArchive;
import com.sun.enterprise.tools.deployment.ui.shared.ModuleContent;
import com.sun.enterprise.tools.deployment.ui.utils.FileTools;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTabbedPane;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.ListTools;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UICheckBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIEventQueue;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIInvocationEvent;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.tools.deployment.ui.utils.WinTools;
import com.sun.enterprise.tools.deployment.ui.utils.Wizard;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;

public abstract class InspectorPane
extends JPanel
implements DescriptorInspector {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(InspectorPane.class);
    private static final String PANEL_NAME = localStrings.getLocalString("ui.inspectorpane.panel_name", "Panel");
    private static final String PANEL_DESC = localStrings.getLocalString("ui.inspectorpane.panel_desc", "This is the panel for the generic inspector window");
    private static final String defaultMode = "DeploymentMode";
    private String mode = null;
    private InspectorPaneOwner inspectorOwner = null;
    private boolean isReadOnly = false;
    protected static final int ALL_CLASSES = 0;
    protected static final int INTERFACES_ONLY = 1;
    protected static final int IMPLEMENTATIONS_ONLY = 2;
    protected static final String LARGE_ICON = "large";
    protected static final String SMALL_ICON = "small";
    private boolean showValidationErrors = true;
    private static String DEFAULT_HELP_GROUP = "XX";
    private Vector dialogButtonList = null;
    private Vector updaterList = null;
    private DescriptionInspector.UpdateListener buttonUpdateListener = null;
    protected static DeferredRefresh currentRunningRefresh = null;
    private int refreshInProcess = 0;
    private boolean firstRefresh = false;
    private int refreshCount = 0;
    private DeferredRefresh _doRefresh = null;
    private int invokePendingRetry = 0;

    public static InspectorPane newInspectorPane(String mode) {
        throw new UnsupportedOperationException("This class doesn't implement the static method 'newInspectorPane(String)'");
    }

    public static InspectorPane createInspectorPane(String className, String mode) {
        Class<?> inspPaneClass = null;
        try {
            inspPaneClass = Class.forName(className);
        }
        catch (ExceptionInInitializerError eii) {
            Print.printStackTrace((String)("Error initializing class - " + className), (Throwable)eii);
            return null;
        }
        catch (Throwable t) {
            Print.printStackTrace((String)("Error obtaining class - " + className), (Throwable)t);
            return null;
        }
        return InspectorPane.createInspectorPane(inspPaneClass, mode);
    }

    public static InspectorPane createInspectorPane(Class inspPaneClass, String mode) {
        String className = inspPaneClass.getName();
        if (!InspectorPane.class.isAssignableFrom(inspPaneClass)) {
            Print.printStackTrace((String)("Not a subclass of InspectorPane: " + className));
            return null;
        }
        Method newInspPane = null;
        try {
            newInspPane = inspPaneClass.getMethod("newInspectorPane", String.class);
        }
        catch (Exception x) {
            Print.printStackTrace((String)("Not Found: <" + className + ">.newInspectorPane(String)"), (Throwable)x);
            return null;
        }
        Object[] args = new Object[]{mode};
        InspectorPane inspPane = null;
        try {
            inspPane = (InspectorPane)newInspPane.invoke(null, args);
        }
        catch (InvocationTargetException ite) {
            Print.printStackTrace((String)("Error: <" + className + ">.newInspectorPane(mode)"), (Throwable)ite.getCause());
            return null;
        }
        catch (Throwable t) {
            Print.printStackTrace((String)("Error: <" + className + ">.newInspectorPane(mode)"), (Throwable)t);
            return null;
        }
        inspPane.getAccessibleContext().setAccessibleName(PANEL_NAME);
        inspPane.getAccessibleContext().setAccessibleDescription(PANEL_DESC);
        return inspPane;
    }

    public void setOwner(InspectorPaneOwner owner) {
        this.inspectorOwner = owner;
    }

    public InspectorPaneOwner getOwner() {
        if (this.inspectorOwner == null) {
            Print.dprintStackTrace((String)("Unknown owner for " + DT.className(this)));
        }
        return this.inspectorOwner;
    }

    public Vector getArchiveContents() {
        InspectorPaneOwner owner = this.getOwner();
        if (owner != null) {
            return owner.getArchiveContents();
        }
        Print.dprintln((String)"No owner!");
        return null;
    }

    public List getArchiveContents(String type) {
        return this.getArchiveContents(new String[]{type});
    }

    public List getArchiveContents(String[] type) {
        Vector<String> list = new Vector<String>();
        Iterator i = this.getArchiveContents().iterator();
        while (i.hasNext()) {
            String archItem = FileTools.ToArchSep(i.next().toString());
            if (type == null) {
                list.add(archItem);
                continue;
            }
            if (!FileTools.StrFileHasExtension(archItem, type)) continue;
            list.add(archItem);
        }
        return list;
    }

    public List getArchiveContentsFiltered(String[] type) {
        Vector<String> list = new Vector<String>();
        Iterator i = this.getArchiveContents().iterator();
        while (i.hasNext()) {
            String archItem = FileTools.ToArchSep(i.next().toString());
            if (type == null || FileTools.StrFileHasExtension(archItem, type)) continue;
            list.add(archItem);
        }
        return list;
    }

    public Descriptor getBundleDescriptor() {
        InspectorPaneOwner owner = this.getOwner();
        if (owner instanceof DescriptorInspector) {
            return ((DescriptorInspector)((Object)owner)).getDescriptor();
        }
        Print.printStackTrace((String)("Owner doesn't implement 'DescriptorInspector' - " + DT.className(owner)));
        return null;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void setReadOnly(boolean state) {
        this.isReadOnly = state;
        this.invokeRefresh();
    }

    protected void setChildrenReadOnly(boolean state) {
        InspectorPane._setChildrenReadOnly(this, state);
    }

    private static void _setChildrenReadOnly(Container container, boolean state) {
        Component[] c = container.getComponents();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] instanceof UITitledBox) {
                ((UITitledBox)c[i]).setReadOnly(state, true);
                continue;
            }
            if (c[i] instanceof UIButton) {
                ((UIButton)c[i]).setReadOnly(state);
                continue;
            }
            if (c[i] instanceof UICheckBox) {
                ((UICheckBox)c[i]).setReadOnly(state);
                continue;
            }
            if (!(c[i] instanceof Container)) continue;
            InspectorPane._setChildrenReadOnly((Container)c[i], state);
        }
    }

    public List getArchiveImplementations() {
        return this._getArchiveClasses(null, 2);
    }

    public Vector getArchiveImplementations(Class[] classTypes) {
        return this._getArchiveClasses(classTypes, 2);
    }

    public Vector getArchiveImplementationNames() {
        return this._cvtClassToName(this._getArchiveClasses(null, 2));
    }

    public Vector getArchiveImplementationNames(Class[] classTypes) {
        return this._cvtClassToName(this._getArchiveClasses(classTypes, 2));
    }

    public List getArchiveInterfaces() {
        return this._getArchiveClasses(null, 1);
    }

    public Vector getArchiveInterfaces(Class[] classTypes) {
        return this._getArchiveClasses(classTypes, 1);
    }

    public Vector getArchiveInterfaceNames() {
        return this._cvtClassToName(this._getArchiveClasses(null, 1));
    }

    public Vector getArchiveInterfaceNames(Class[] classTypes) {
        return this._cvtClassToName(this._getArchiveClasses(classTypes, 1));
    }

    public Vector getArchiveClasses() {
        return this._getArchiveClasses(null, 0);
    }

    public Vector getArchiveClasses(Class[] classTypes) {
        return this._getArchiveClasses(classTypes, 0);
    }

    public Vector getArchiveClassNames() {
        return this._cvtClassToName(this._getArchiveClasses(null, 0));
    }

    public Vector getArchiveClassNames(Class[] classTypes) {
        return this.getArchiveClassNames(classTypes, false);
    }

    public Vector getArchiveClassNames(Class[] classTypes, boolean inApplication) {
        return this._cvtClassToName(this._getArchiveClasses(classTypes, 0, inApplication));
    }

    protected Vector _getArchiveClasses(Class[] classTypes, int classImpl) {
        return this._getArchiveClasses(classTypes, classImpl, false);
    }

    protected Vector _getArchiveClasses(Class[] classTypes, int classImpl, boolean inApplication) {
        Vector classList;
        InspectorPaneOwner owner = this.getOwner();
        Vector vector = classList = owner != null ? owner.getArchiveClasses(inApplication) : null;
        if (classList == null) {
            return null;
        }
        if (classTypes == null && classImpl == 0) {
            return new Vector(classList);
        }
        Vector<Class> impClasses = new Vector<Class>();
        Enumeration e = classList.elements();
        block2: while (e.hasMoreElements()) {
            Class c = (Class)e.nextElement();
            if (classImpl == 1 && !c.isInterface() || classImpl == 2 && c.isInterface()) continue;
            if (classTypes != null) {
                for (int i = 0; i < classTypes.length; ++i) {
                    try {
                        Class<?> ct = c.getClassLoader().loadClass(classTypes[i].getName());
                        if (!ct.isAssignableFrom(c)) continue;
                        impClasses.add(c);
                        continue block2;
                    }
                    catch (Throwable t) {
                        Print.dprintStackTrace((String)"", (Throwable)t);
                    }
                }
                continue;
            }
            impClasses.add(c);
        }
        return impClasses;
    }

    private Vector _cvtClassToName(Vector classObj) {
        Vector<String> classNam = null;
        if (classObj != null) {
            classNam = new Vector<String>();
            Enumeration e = classObj.elements();
            while (e.hasMoreElements()) {
                classNam.add(((Class)e.nextElement()).getName());
            }
        }
        ListTools.sortList(classNam, true);
        return classNam;
    }

    public abstract Class getDescriptorClass();

    public abstract Descriptor getDescriptor();

    public abstract void setDescriptor(Descriptor var1);

    public void resetFirstRefresh() {
        this.firstRefresh = true;
    }

    public boolean isFirstRefresh() {
        return this.firstRefresh;
    }

    public boolean isRefreshInProcess() {
        return this.refreshInProcess > 0;
    }

    public String getIconInspectorName() {
        Descriptor desc = this.getDescriptor();
        return desc != null ? desc.getDisplayName() : "";
    }

    public String getLargeIconUri() {
        Descriptor desc = this.getDescriptor();
        return desc != null ? desc.getLargeIconUri() : "";
    }

    public File getLargeIconUriFile() {
        String name = this.getLargeIconUri();
        return name != null ? new File(name) : null;
    }

    public String getSmallIconUri() {
        Descriptor desc = this.getDescriptor();
        return desc != null ? desc.getSmallIconUri() : "";
    }

    public File getSmallIconUriFile() {
        String name = this.getSmallIconUri();
        return name != null ? new File(name) : null;
    }

    protected void _addWizardIcon(String iconType, File iconFile, ModuleContent contentsMap, Descriptor desc) {
        String fileName;
        if (iconType == null || !iconType.equals(SMALL_ICON) && !iconType.equals(LARGE_ICON)) {
            Print.printStackTrace((String)("Invalid icon type specified: " + iconType));
            return;
        }
        String string = fileName = iconType.equals(SMALL_ICON) ? desc.getSmallIconUri() : desc.getLargeIconUri();
        if (!fileName.equals("")) {
            File file = new File(fileName);
            contentsMap.removeEntry(file.getName());
        }
        String iconFileName = null;
        if (iconFile != null) {
            File absIcon = iconFile.getAbsoluteFile();
            contentsMap.addEntry(absIcon.getName(), absIcon);
            iconFileName = absIcon.getPath();
        }
        if (iconType.equals(SMALL_ICON)) {
            desc.setSmallIconUri(iconFileName);
        } else {
            desc.setLargeIconUri(iconFileName);
        }
    }

    protected void _addDeploymentIcon(String iconType, File iconFile, Descriptor archDesc, Descriptor appliedDesc) {
        if (iconType == null || !iconType.equals(SMALL_ICON) && !iconType.equals(LARGE_ICON)) {
            Print.printStackTrace((String)("Invalid icon type specified: " + iconType));
            return;
        }
        try {
            String iconName;
            String string = iconName = iconFile != null ? iconFile.getName() : null;
            if (iconType.equals(SMALL_ICON)) {
                appliedDesc.setSmallIconUri(iconName != null ? iconName : "");
            } else {
                appliedDesc.setLargeIconUri(iconName != null ? iconName : "");
            }
            if (iconFile != null) {
                ModuleArchive.getModuleArchive(archDesc).addArchiveEntry(iconName, iconFile);
            }
        }
        catch (Throwable t) {
            Print.printStackTrace((String)"Adding Icons", (Throwable)t);
            UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.inspectorpane.cant_add_icon", "Icon could not be added/removed.\n {0}", new Object[]{t.getMessage()}));
        }
    }

    public void _checkForRemovedIcons(Object[] removed) {
        Descriptor desc = this.getDescriptor();
        File smallFile = this.getSmallIconUriFile();
        File largeFile = this.getLargeIconUriFile();
        if (removed != null && (smallFile != null || largeFile != null)) {
            for (int i = 0; i < removed.length; ++i) {
                if (!(removed[i] instanceof File)) continue;
                File file = (File)removed[i];
                if (smallFile != null && smallFile.getName().equals(file.getName())) {
                    desc.setSmallIconUri(null);
                    smallFile = null;
                }
                if (largeFile != null && largeFile.getName().equals(file.getName())) {
                    desc.setLargeIconUri(null);
                    largeFile = null;
                }
                if (smallFile == null && largeFile == null) break;
            }
        }
    }

    public void resetShowValidationErrors() {
        this.showValidationErrors = true;
    }

    protected boolean skipValidateRefresh() {
        return false;
    }

    public void validateRefresh() {
        InspectorPaneOwner owner = this.getOwner();
        if (owner == null) {
            this.showValidationErrors = false;
        } else if (owner instanceof InspectorPaneDialog) {
            this.showValidationErrors = false;
        } else if (owner instanceof InspectorPaneDialogInferface) {
            this.showValidationErrors = false;
        } else if (this.skipValidateRefresh()) {
            this.showValidationErrors = false;
        } else {
            boolean showErrors = this.isWizardMode() ? false : this.showValidationErrors;
            boolean isValid = this.getDescriptor() != null ? this.validateEntries(showErrors) : true;
            this.showValidationErrors = false;
            if (owner instanceof InspectorTabbedPane) {
                InspectorTabbedPane tabOwner = (InspectorTabbedPane)owner;
                tabOwner.setValidAt(tabOwner.getSelectedIndex(), isValid);
            }
        }
    }

    public boolean validateEntries(boolean showErrors) {
        return this.validateEntries();
    }

    public boolean validateEntries() {
        return true;
    }

    public abstract String getTabName();

    public abstract String getHelpID();

    public String getHelpGroup() {
        String hg = this.getOwner().getHelpGroup();
        return hg != null ? hg : DEFAULT_HELP_GROUP;
    }

    public String getHelpIDKey() {
        String helpKey = null;
        String id = this.getHelpID();
        if (id != null && this.getOwner() != null) {
            String hg = this.getOwner().getHelpGroup();
            helpKey = (hg != null ? hg : DEFAULT_HELP_GROUP) + id;
        }
        return helpKey;
    }

    public void setInspectorMode(String m) {
        this.mode = m != null ? m : defaultMode;
    }

    public String getInspectorMode() {
        if (this.mode == null) {
            this.mode = this.getOwner() instanceof Wizard ? "WizardMode" : defaultMode;
        }
        return this.mode;
    }

    public boolean isDeploymentMode() {
        return this.getInspectorMode().equals(defaultMode);
    }

    public boolean isDevelopmentMode() {
        return this.isWizardMode();
    }

    public boolean isWizardMode() {
        return this.getInspectorMode().equals("WizardMode");
    }

    protected static String getCurrentApplicationName() {
        Descriptor d = DT.getActiveModule();
        return d == null ? "" : d.getDisplayName();
    }

    protected String getApplicationName() {
        return InspectorPane.getCurrentApplicationName();
    }

    private DescriptionInspector getDescriptionInspector() {
        return DescriptionInspector.findDescriptionInspector(this);
    }

    public void _setDescriptionInspector(String description, String refName, DescriptionInspector.UpdateListener listener, Object refObject) {
        DescriptionInspector din;
        if (this.buttonUpdateListener == null) {
            this.buttonUpdateListener = new DescriptionInspector.UpdateListener(){

                public void descriptionUpdated(String d, Object refObject) {
                    if (InspectorPane.this.dialogButtonList != null) {
                        boolean hd = d != null && !d.equals("");
                        Enumeration enumeration = InspectorPane.this.dialogButtonList.elements();
                        while (enumeration.hasMoreElements()) {
                            ((DescriptionInspector.DialogDisplayButton)enumeration.nextElement()).setHasDescription(hd);
                        }
                    }
                }
            };
        }
        if (this.updaterList == null || !this.updaterList.contains(listener)) {
            this.updaterList = new Vector();
            this.updaterList.add(listener);
            this.updaterList.add(this.buttonUpdateListener);
        }
        if ((din = this.getDescriptionInspector()) != null) {
            din.setDescription(description, refName, this.updaterList, refObject, this.isReadOnly());
        }
        this.buttonUpdateListener.descriptionUpdated(description, null);
    }

    public void _clearDescriptionInspector() {
        DescriptionInspector din = this.getDescriptionInspector();
        if (din != null) {
            din.clearDescription();
        }
    }

    public void _showDescriptionInspector() {
        DescriptionInspector din = this.getDescriptionInspector();
        if (din != null) {
            din.showDescriptionInspector();
        }
    }

    public void addDescriptionButtonUpdate(DescriptionInspector.DialogDisplayButton button) {
        if (this.dialogButtonList == null) {
            this.dialogButtonList = new Vector();
        }
        this.dialogButtonList.add(button);
    }

    public static Throwable getDeferredRefreshStackTrace() {
        return currentRunningRefresh != null ? currentRunningRefresh.getStackTrace() : null;
    }

    protected abstract void refresh();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void privateRefresh() {
        ++this.refreshInProcess;
        try {
            this.refresh();
        }
        finally {
            --this.refreshInProcess;
        }
    }

    private boolean isDelayedRefreshOk() {
        if (this.inspectorOwner == null) {
            return false;
        }
        if (this.inspectorOwner instanceof Wizard) {
            Wizard wiz = (Wizard)this.inspectorOwner;
            return true;
        }
        if (this.inspectorOwner instanceof InspectorTabbedPane) {
            InspectorTabbedPane tab = (InspectorTabbedPane)this.inspectorOwner;
            return true;
        }
        return true;
    }

    public void invokeRefresh() {
        if (this.isRefreshInProcess()) {
            Print.dprintln((String)"Refresh already in process: skipping 'invokeRefresh()'");
            return;
        }
        if (!this.isDelayedRefreshOk()) {
            this.privateRefresh();
            this.validateRefresh();
            this.firstRefresh = false;
            return;
        }
        if (!this.isCurrentInspectorPane()) {
            Print.dprintStackTrace((String)("Non-visible inspector: " + UIUtils.debugClassName(this)));
            return;
        }
        if (this.refreshCount == 0) {
            if (this._doRefresh == null) {
                this._doRefresh = new DeferredRefresh();
            }
            ++this.refreshCount;
            this._doRefresh.saveStackTrace();
            UIEventQueue.invokeLater(this._doRefresh);
        } else {
            ++this.refreshCount;
        }
    }

    public boolean isRefreshPending() {
        return this.refreshCount > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _refresh() {
        if (!this.isCurrentInspectorPane()) {
            this.refreshCount = 0;
            return;
        }
        if (UIEventQueue.isInvokeLaterPending()) {
            Runnable r;
            UIInvocationEvent ie = UIEventQueue.peekInvocationEvent();
            Runnable runnable = r = ie != null ? ie.getRunnable() : null;
            if (r instanceof DeferredRefresh) {
                Print.dprintln((String)"DeferredRefresh detected, continuing with normal refresh.");
            } else if (this.invokePendingRetry >= 3) {
                Print.dprintStackTrace((String)("Endless loop detected: " + UIUtils.debugClassName(this)));
            } else {
                ++this.invokePendingRetry;
                UIEventQueue.invokeLater(this._doRefresh);
                return;
            }
        }
        this.invokePendingRetry = 0;
        try {
            this.privateRefresh();
            this.validateRefresh();
            this.firstRefresh = false;
        }
        finally {
            this.refreshCount = 0;
        }
    }

    public boolean isCurrentInspectorPane() {
        InspectorPaneOwner owner = this.getOwner();
        return owner != null && owner.isCurrentInspectorPane(this);
    }

    protected void _clearTables(Container container) {
        Component[] c = container.getComponents();
        for (int i = 0; i < c.length; ++i) {
            JTable table;
            if (c[i] instanceof UITitledTable && (table = ((UITitledTable)c[i]).getTableView()) instanceof InspectorTable) {
                ((InspectorTable)table).clearTableData();
            }
            if (!(c[i] instanceof Container)) continue;
            this._clearTables((Container)c[i]);
        }
    }

    public Window getMyParentWindow() {
        return WinTools.getAncestorWindow(this);
    }

    public Frame getMyParentFrame() {
        return WinTools.getAncestorFrame(this);
    }

    public Dialog getMyParentDialog() {
        return WinTools.getAncestorDialog(this);
    }

    public InspectorPaneDialog createInspectorPaneDialog(InspectorPaneOwner inspOwner, Component winOwner, boolean modal) {
        if (winOwner == null && inspOwner instanceof Component) {
            winOwner = (Component)((Object)inspOwner);
        }
        if (winOwner == null) {
            Print.printStackTrace((String)"Window owner not specified");
        } else if (this.getParent() != null) {
            Print.printStackTrace((String)"This InspectorPane is already part of another container");
        } else {
            Window win = WinTools.getAncestorWindow(winOwner);
            InspectorPaneDialog ipd = this._createInspectorPaneDialog(win, inspOwner, modal);
            if (ipd != null) {
                return ipd;
            }
            Print.printStackTrace((String)"Could not find an ancestor Frame/Dialog");
        }
        return null;
    }

    protected InspectorPaneDialog _createInspectorPaneDialog(Window win, InspectorPaneOwner inspOwner, boolean modal) {
        if (win instanceof Frame) {
            return new InspectorPaneDialog((Frame)win, inspOwner, modal);
        }
        if (win instanceof Dialog) {
            return new InspectorPaneDialog((Dialog)win, inspOwner, modal);
        }
        return null;
    }

    public static interface InspectorPaneOwner {
        public Vector getArchiveContents();

        public Vector getArchiveClasses();

        public Vector getArchiveClasses(boolean var1);

        public String getHelpGroup();

        public boolean isCurrentInspectorPane(InspectorPane var1);
    }

    public class InspectorPaneDialog
    extends UIDialog
    implements InspectorPaneDialogInferface,
    InspectorPaneOwner,
    DescriptionInspector.DescriptionInspectorManager,
    ActionListener {
        private InspectorPaneOwner delegateOwner;
        private JButton okButton;
        private JButton cancelButton;
        private DescriptionInspector descriptionInspector;

        public InspectorPaneDialog(Frame frame, InspectorPaneOwner owner, boolean isModal) {
            super(frame, isModal);
            this.delegateOwner = null;
            this.okButton = null;
            this.cancelButton = null;
            this.descriptionInspector = null;
            this.setDelegateOwner(owner);
            InspectorPane.this.setOwner(this);
            this._init();
        }

        public InspectorPaneDialog(Dialog dialog, InspectorPaneOwner owner, boolean isModal) {
            super(dialog, isModal);
            this.delegateOwner = null;
            this.okButton = null;
            this.cancelButton = null;
            this.descriptionInspector = null;
            this.setDelegateOwner(owner);
            InspectorPane.this.setOwner(this);
            this._init();
        }

        protected void _init() {
            this.descriptionInspector = new DescriptionInspector(this);
            UIControlButtonBox content = new UIControlButtonBox(null, false);
            super.getContentBox().addWithGBConstraints(content);
            content.setControlButtonLocation(101);
            content.setView(InspectorPane.this);
            this.okButton = UIButton.createOkButton(this);
            content.addControlButton(this.okButton);
            this.cancelButton = UIButton.createCancelButton(this);
            content.addControlButton(this.cancelButton);
            this.setCancelEnabled(false);
            UIHelpButton hb = new UIHelpButton(InspectorPane.this.getHelpIDKey());
            content.addControlButton(hb);
        }

        public void setLocationRelativeTo(Component comp) {
            if (comp instanceof InspectorPane) {
                Rectangle b = comp.getBounds();
                Point sl = comp.getLocationOnScreen();
                this.setBounds(sl.x + 10, sl.y + 10, b.width, b.height);
            } else {
                super.setLocationRelativeTo(comp);
            }
        }

        public void setDescriptor(Descriptor d) {
            InspectorPane.this.setDescriptor(d);
        }

        public void setCancelEnabled(boolean enable) {
            this.cancelButton.setVisible(enable);
        }

        public void actionPerformed(ActionEvent ae) {
            JButton btn = (JButton)ae.getSource();
            if (btn == this.okButton) {
                this.okAction();
            } else if (this.cancelButton != null && btn == this.cancelButton) {
                this.cancelAction();
            }
        }

        protected void okAction() {
            if (InspectorPane.this.validateEntries(true)) {
                this.hide();
            }
        }

        protected void cancelAction() {
            this.hide();
        }

        protected void _showDialog() {
            InspectorPane.this.privateRefresh();
            InspectorPane.this.firstRefresh = false;
            super._showDialog();
        }

        public DescriptionInspector getDescriptionInspector() {
            return this.descriptionInspector;
        }

        public void setDelegateOwner(InspectorPaneOwner owner) {
            this.delegateOwner = owner;
            if (this.delegateOwner == null) {
                Print.dprintStackTrace((String)"'delegateOwner' is null (HELP won't work)");
            }
        }

        public Vector getArchiveContents() {
            return this.delegateOwner != null ? this.delegateOwner.getArchiveContents() : null;
        }

        public Vector getArchiveClasses() {
            return this.getArchiveClasses(false);
        }

        public String getHelpGroup() {
            if (this.delegateOwner != null) {
                return this.delegateOwner.getHelpGroup();
            }
            Print.dprintStackTrace((String)"HelpGroup is not defined");
            return "??";
        }

        public boolean isCurrentInspectorPane(InspectorPane pane) {
            return pane == InspectorPane.this;
        }

        public Vector getArchiveClasses(boolean inApplication) {
            return this.delegateOwner != null ? this.delegateOwner.getArchiveClasses(inApplication) : null;
        }
    }

    public static interface InspectorPaneDialogInferface {
        public void setDescriptor(Descriptor var1);
    }

    private class DeferredRefresh
    implements Runnable {
        private Throwable invocationStackTrace = new Throwable();

        private DeferredRefresh() {
        }

        public void saveStackTrace() {
            this.invocationStackTrace.fillInStackTrace();
        }

        public Throwable getStackTrace() {
            return this.invocationStackTrace;
        }

        public void run() {
            currentRunningRefresh = this;
            InspectorPane.this._refresh();
            currentRunningRefresh = null;
        }

        public String toString() {
            return "DeferredRefresh: " + UIUtils.debugClassName(this);
        }
    }
}

