/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.loader.EJBClassLoader;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.utils.J2EEClassLoader;
import com.sun.enterprise.tools.deployment.ui.utils.ListTools;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIProject;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.Print;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class DTClassLoader
extends J2EEClassLoader {
    private static DTClassLoader defaultClassLoader = null;
    private static String[] defaultClasspaths = null;
    private ClassLoader parent = null;
    private boolean searchParentFirst = false;
    private Vector classLoaderList = null;

    public static DTClassLoader getDefaultClassLoader() {
        String[] list = DTClassLoader.getDefaultClasspath();
        if (list != null) {
            DTClassLoader cl = new DTClassLoader();
            cl.addFiles(list);
            return cl;
        }
        return null;
    }

    public static String[] getDefaultClasspath() {
        Object[] path = UIConfig.getStringArray("ui.defaultClasspath");
        Vector v = (Vector)ListTools.toList(path, new Vector());
        ListTools.toList((Object[])defaultClasspaths, (List)v);
        return v.toArray(new String[v.size()]);
    }

    public static void setDefaultClasspath(String[] path) {
        defaultClasspaths = path;
    }

    public static boolean isAssignableFrom(Class p, Class c) {
        ClassLoader cl;
        if (p == null || c == null) {
            return false;
        }
        ClassLoader pl = p.getClassLoader();
        if (pl == (cl = c.getClassLoader())) {
            return p.isAssignableFrom(c);
        }
        Print.dprintln((String)("Differing ClassLoaders: " + p.getName() + " => " + c.getName()));
        try {
            String pn = p.getName();
            Class<?> _p = cl != null ? cl.loadClass(pn) : Class.forName(pn);
            return _p.isAssignableFrom(c);
        }
        catch (Throwable t) {
            Print.dprintln((String)("Error loading class: " + t));
            return false;
        }
    }

    public static List getClassInterfaces(Class c) {
        return DTClassLoader.getClassInterfaces(c, new Vector());
    }

    public static List getClassInterfaces(Class c, List v) {
        if (c == null) {
            return v;
        }
        Class<?>[] intf = c.getInterfaces();
        for (int i = 0; i < intf.length; ++i) {
            if (v.contains(intf[i])) continue;
            v.add(intf[i]);
        }
        return DTClassLoader.getClassInterfaces(c.getSuperclass(), v);
    }

    public DTClassLoader() {
        this.setSearchParentFirst(false);
    }

    public DTClassLoader(ClassLoader parent) {
        this(parent, false);
    }

    public DTClassLoader(ClassLoader parent, boolean parentFirst) {
        this.setParent(parent, parentFirst);
    }

    public void setParent(ClassLoader parent, boolean parentFirst) {
        this.parent = parent;
        this.setSearchParentFirst(parentFirst);
    }

    public void setSearchParentFirst(boolean flag) {
        this.searchParentFirst = flag;
    }

    public boolean isSearchParentFirst() {
        return this.searchParentFirst;
    }

    public void addClassLoader(ClassLoader cl) {
        if (cl instanceof EJBClassLoader) {
            URL[] urls = ((EJBClassLoader)cl).getURLs();
            for (int i = 0; i < urls.length; ++i) {
                this.addURL(urls[i]);
            }
        } else if (cl != null) {
            if (this.classLoaderList == null) {
                this.classLoaderList = new Vector();
            }
            this.classLoaderList.add(cl);
        }
    }

    public void removeClassLoader(ClassLoader cl) {
        if (cl != null && this.classLoaderList != null) {
            this.classLoaderList.remove(cl);
        }
    }

    public void addDefaultClasspath() {
        String[] list = DTClassLoader.getDefaultClasspath();
        if (list != null) {
            this.addFiles(list);
        }
    }

    public void addArchiveJar(File jarFile) {
        if (jarFile != null && UIProject.isJar(jarFile.getPath()) && jarFile.exists()) {
            try {
                File tmpDir = new File(UIConfig.getTempDirectory(), "ClassLoader");
                if (!tmpDir.exists()) {
                    tmpDir.mkdirs();
                    FileUtil.deleteOnExit((File)tmpDir, (boolean)true);
                }
                File tmpJarDir = File.createTempFile(jarFile.getName(), ".dir", tmpDir);
                tmpJarDir.delete();
                super.setLocation(jarFile, tmpJarDir, false);
                return;
            }
            catch (IOException ioe) {
                Print.dprintStackTrace((String)("Unable to add jar: " + jarFile), (Throwable)ioe);
                this.addFile(jarFile);
            }
        } else {
            Print.dprintln((String)("Invalid jar: " + jarFile));
        }
    }

    public void addURL(URL url) {
        if (url != null) {
            super.appendURL(url);
        }
    }

    public void addFile(File file) {
        try {
            if (file != null && file.exists()) {
                super.appendURL(file.getAbsoluteFile().toURL());
            }
        }
        catch (Exception ex) {
            Print.dprintln((String)("Invalid URL: " + file));
        }
    }

    public void addFiles(File[] file) {
        if (file != null) {
            for (int i = 0; i < file.length; ++i) {
                this.addFile(file[i]);
            }
        }
    }

    public void addFile(String file) {
        if (file != null) {
            try {
                if (file.toLowerCase().startsWith("http:")) {
                    this.addURL(new URL(file));
                } else if (file.endsWith(File.separator + "*")) {
                    File dir = new File(file.substring(0, file.length() - 2));
                    if (dir.isDirectory()) {
                        File[] list = dir.listFiles();
                        for (int i = 0; i < list.length; ++i) {
                            if (list[i].isDirectory()) {
                                this.addFile(list[i]);
                                continue;
                            }
                            if (!list[i].getName().toLowerCase().endsWith(".jar")) continue;
                            this.addFile(list[i]);
                        }
                    }
                } else {
                    this.addFile(new File(file));
                }
            }
            catch (Exception ex) {
                Print.dprintln((String)("Invalid URL: " + file));
            }
        }
    }

    public void addFiles(String[] file) {
        if (file != null) {
            for (int i = 0; i < file.length; ++i) {
                this.addFile(file[i]);
            }
        }
    }

    public void addFiles(Iterator iter) {
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj instanceof URL) {
                this.addURL((URL)obj);
                continue;
            }
            if (obj instanceof File) {
                this.addFile((File)obj);
                continue;
            }
            if (obj instanceof String) {
                this.addFile((String)obj);
                continue;
            }
            Print.dprintStackTrace((String)("Unsupported type: " + UIUtils.debugClassName(obj)));
        }
    }

    private void _printParentClassPath() {
        if (this.parent instanceof DTClassLoader) {
            ((DTClassLoader)this.parent)._printClassPaths();
        } else if (this.parent instanceof JarClassLoader) {
            Print.println((String)("  (JarClassLoader)ClassPath: " + ((JarClassLoader)this.parent).getClassPath()));
        } else if (this.parent instanceof J2EEClassLoader) {
            Print.println((String)("  (J2EEClassLoader)ClassPath: " + ((J2EEClassLoader)this.parent).getClassPath()));
        } else if (this.parent != null) {
            Print.println((String)("  Parent ClassLoader: " + UIUtils.debugClassName(this.parent)));
        }
    }

    private void _printClassPaths() {
        if (this.searchParentFirst) {
            this._printParentClassPath();
            Print.println((String)("  ClassPath: " + this.getClassPath()));
        } else {
            Print.println((String)("  ClassPath: " + this.getClassPath()));
            this._printParentClassPath();
        }
    }

    public void printClassPaths() {
        Print.dprintln((String)"DTClassLoader ClassPaths:");
        this._printClassPaths();
        Print.println((String)"");
    }

    public String getClassPath() {
        StringBuffer cpath = new StringBuffer();
        URL[] urls = this.getURLs();
        for (int i = 0; i < urls.length; ++i) {
            cpath.append(urls[i].getFile()).append(File.pathSeparator);
        }
        return cpath.toString();
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        try {
            return super.loadClass(name);
        }
        catch (ClassNotFoundException cnfe) {
            Class c = this._loadFromAlternateClassLoaders(name);
            if (c != null) {
                return c;
            }
            throw cnfe;
        }
        catch (NoClassDefFoundError ncd) {
            Class c = this._loadFromAlternateClassLoaders(name);
            if (c != null) {
                return c;
            }
            throw new ClassNotFoundException(ncd.getMessage(), ncd);
        }
    }

    private Class _loadFromAlternateClassLoaders(String name) {
        if (this.classLoaderList != null) {
            Iterator i = this.classLoaderList.iterator();
            while (i.hasNext()) {
                try {
                    return ((ClassLoader)i.next()).loadClass(name);
                }
                catch (Throwable throwable) {
                }
            }
        }
        return null;
    }

    private synchronized Class _loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class c = super.findLoadedClass(name);
        if (c == null) {
            try {
                c = this.findClass(name);
            }
            catch (Throwable t) {
                return super.loadClass(name, resolve);
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.searchParentFirst) {
            if (this.parent != null) {
                try {
                    return this.parent.loadClass(name);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            return this._loadClass(name, resolve);
        }
        try {
            return this._loadClass(name, resolve);
        }
        catch (ClassNotFoundException cnf) {
            if (this.parent != null) {
                return this.parent.loadClass(name);
            }
            throw cnf;
        }
        catch (NoClassDefFoundError ncd) {
            if (this.parent != null) {
                return this.parent.loadClass(name);
            }
            throw new ClassNotFoundException(ncd.getMessage(), ncd);
        }
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        if (this.searchParentFirst) {
            if (this.parent != null) {
                try {
                    return this.parent.loadClass(name);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            return super.findClass(name);
        }
        try {
            return super.findClass(name);
        }
        catch (ClassNotFoundException cnfe) {
            if (this.parent != null) {
                return this.parent.loadClass(name);
            }
            throw cnfe;
        }
        catch (NoClassDefFoundError ncd) {
            if (this.parent != null) {
                return this.parent.loadClass(name);
            }
            throw new ClassNotFoundException(ncd.getMessage(), ncd);
        }
    }

    public URL findResource(String name) {
        if (this.searchParentFirst) {
            URL resource;
            URL uRL = resource = this.parent != null ? this.parent.getResource(name) : null;
            if (resource != null) {
                return resource;
            }
            return resource != null ? resource : super.findResource(name);
        }
        URL resource = super.findResource(name);
        if (resource != null) {
            return resource;
        }
        return this.parent != null ? this.parent.getResource(name) : null;
    }
}

