/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.sunone;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.common.dd.webapp.MetaData;
import com.sun.enterprise.tools.common.dd.webapp.WebProperty;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.ListTools;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Vector;
import javax.swing.table.TableCellEditor;

public class WebPropertyTableModel
extends InspectorTableModel {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(WebPropertyTableModel.class);
    private static final String COLUMN_NAME = localStrings.getLocalString("ui.sunone.WebPropertyTableModel.table_column_name_header", "Name");
    private static final String COLUMN_VALUE = localStrings.getLocalString("ui.sunone.WebPropertyTableModel.table_column_value_header", "Value");
    private static final String MISSING_VALUE = localStrings.getLocalString("ui.sunone.WebPropertyTableModel.missing_value", "Property value is required.");
    private static final String MISSING_NAME = localStrings.getLocalString("ui.sunone.WebPropertyTableModel.missing_name", "Property name is required.");
    public static final String ATR_NAME = "name";
    public static final String ATR_VALUE = "value";
    private WebBundleDescriptor descriptor = null;
    private boolean autoValueUpdate = true;
    private Vector paramNames;
    private int type = 0;

    public WebPropertyTableModel(WebBundleDescriptor desc, int index) {
        super(new String[]{COLUMN_NAME, COLUMN_VALUE, DescriptionInspector.DESCRIPTION_COLUMN_INIT});
        this.descriptor = desc;
        this.type = index;
        this.paramNames = ListTools.toList(MetaData.getParamNames((int)this.type));
    }

    public void setDescriptor(WebBundleDescriptor desc) {
        this.descriptor = desc;
    }

    public void setAutoValueUpdate(boolean b) {
        this.autoValueUpdate = b;
    }

    public WebProperty getRow(int index) {
        return (WebProperty)this.getRowObject(index);
    }

    public Object getObjectValue(Object obj, int col) {
        WebProperty ref = (WebProperty)obj;
        if (ref == null) {
            return null;
        }
        String value = null;
        switch (col) {
            case 0: {
                value = ref.getAttributeValue(ATR_NAME);
                break;
            }
            case 1: {
                value = ref.getAttributeValue(ATR_VALUE);
                break;
            }
            case 2: {
                value = ref.getDescription();
            }
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    public void setObjectValue(Object obj, int col, Object value) {
        WebProperty ref = (WebProperty)obj;
        if (ref == null) {
            return;
        }
        String valStr = value.toString();
        switch (col) {
            case 0: {
                if (valStr.equals("")) {
                    UIOptionPane.showErrorDialog(null, MISSING_NAME);
                    break;
                }
                if (valStr.equals(ref.getAttributeValue(ATR_NAME))) break;
                ref.setAttributeValue(ATR_NAME, valStr);
                if (!this.autoValueUpdate || !this.paramNames.contains(valStr)) break;
                String def = MetaData.getDefaultValue((int)this.type, (String)valStr);
                if (def == null) {
                    def = "";
                }
                ref.setAttributeValue(ATR_VALUE, "");
                break;
            }
            case 1: {
                if (valStr.equals("")) {
                    UIOptionPane.showErrorDialog(null, MISSING_VALUE);
                    break;
                }
                ref.setAttributeValue(ATR_VALUE, valStr);
                break;
            }
            case 2: {
                ref.setDescription(value.toString());
            }
        }
        if (this.descriptor != null) {
            this.descriptor.changed();
        }
    }

    public static WebProperty findNewWebProperty(WebProperty[] inUse, int type) {
        String use;
        Vector paramName = ListTools.toList(MetaData.getParamNames((int)type));
        if (inUse == null || inUse.length == 0) {
            use = (String)paramName.get(0);
        } else {
            for (int i = 0; i < inUse.length; ++i) {
                paramName.remove(inUse[i].getAttributeValue(ATR_NAME));
            }
            if (paramName.size() == 0) {
                return null;
            }
            use = (String)paramName.get(0);
        }
        WebProperty wp = new WebProperty();
        wp.setAttributeValue(ATR_NAME, use);
        String def = MetaData.getDefaultValue((int)type, (String)use);
        if (def != null && !def.equals("")) {
            wp.setAttributeValue(ATR_VALUE, def);
        }
        wp.setDescription("");
        return wp;
    }

    public static Vector findFilteredParam(WebProperty[] inUse, Vector pName, int row) {
        Vector paramName = (Vector)pName.clone();
        for (int i = 0; i < inUse.length; ++i) {
            if (i == row) continue;
            paramName.remove(inUse[i].getAttributeValue(ATR_NAME));
        }
        return paramName;
    }

    public static TableCellEditor getTableCellEditor(String[] values, InspectorTable it) {
        InspectorTable.TableComboBoxEditor rtn = null;
        if (WebPropertyTableModel.isEmptyList(values)) {
            return it.getDefaultEditor(Object.class);
        }
        rtn = it.getComboBoxEditor(values);
        if (!WebPropertyTableModel.isBoolean(values)) {
            rtn.setEditable(true);
        }
        return rtn;
    }

    private static boolean isBoolean(String[] val) {
        Vector values = ListTools.toList(val);
        return values.size() == 2 && values.contains("true") && values.contains("false");
    }

    private static boolean isEmptyList(String[] values) {
        if (values == null || values.length == 0) {
            return true;
        }
        if (values.length > 1) {
            return false;
        }
        return values[0].equals("") || values[0] == null;
    }
}

