/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.sunone;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.Group;
import com.sun.enterprise.deployment.PrincipalImpl;
import com.sun.enterprise.deployment.Role;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapper;
import com.sun.enterprise.tools.common.dd.SecurityRoleMapping;
import com.sun.enterprise.tools.common.dd.webapp.SunWebApp;
import com.sun.enterprise.tools.deployment.ui.shared.DTRoleMapper;
import com.sun.enterprise.tools.deployment.ui.shared.RolesDialog;
import com.sun.enterprise.tools.deployment.ui.sunone.SunOneUtils;
import com.sun.enterprise.tools.deployment.ui.sunone.UsersDialog;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIPanel;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.help.CSH;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class WebAppRoleInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(WebAppRoleInspector.class);
    private static String TABNAME = localStrings.getLocalString("ui.webapproleinspector.tabname", "Role");
    private static String EDIT_ROLES = localStrings.getLocalString("ui.webapproleinspector.edit_roles", "Edit Roles...");
    private static char EDIT_ROLES_MNEMONIC = localStrings.getLocalString("ui.webapproleinspector.edit_roles_mnemonic", "E").charAt(0);
    private static String wizardHelpID = "Role";
    private static String deployHelpID = "Role";
    private WebBundleDescriptor descriptor;
    private Application application;
    RoleNamesTableModel roleNamesTableModel;
    RoleNamesTable roleNamesTable;
    RoleUsersTableModel usersTableModel;
    RoleUsersTable usersTable;
    RoleUsersTableModel userGroupsTableModel;
    RoleUsersTable userGroupsTable;
    UsersDialog usersDialog;
    JButton delSecConstPB;

    public static InspectorPane newInspectorPane(String mode) {
        return new WebAppRoleInspector();
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return WebBundleDescriptor.class;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor object) {
        if (object instanceof WebBundleDescriptor) {
            this.descriptor = (WebBundleDescriptor)object;
            this.application = this.descriptor.getApplication();
            this.invokeRefresh();
        } else {
            this.descriptor = null;
        }
    }

    private WebAppRoleInspector() {
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        UIControlButtonBox tablesBox = new UIControlButtonBox(null, false);
        tablesBox.setControlButtonLocation(15);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)tablesBox, c);
        UIPanel tabledPanel = new UIPanel();
        GridBagLayout tgb = new GridBagLayout();
        tabledPanel.setLayout(tgb);
        tablesBox.setView(tabledPanel, false);
        UITitledTable roleNamesView = new UITitledTable(localStrings.getLocalString("at.webapproleinspector.role_names_label", "Role names referenced:"), false);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(2, 0, 0, 5);
        c.fill = 1;
        tabledPanel.add((Component)roleNamesView, c);
        this.roleNamesTableModel = new RoleNamesTableModel();
        this.roleNamesTable = new RoleNamesTable(this.roleNamesTableModel);
        roleNamesView.setTableView(this.roleNamesTable);
        this.roleNamesTable.setSelectionMode(0);
        this.roleNamesTable.setAutoResizeMode(4);
        this.roleNamesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel sm = (ListSelectionModel)e.getSource();
                if (sm.isSelectionEmpty()) {
                    WebAppRoleInspector.this.usersTable.clearSelection();
                    WebAppRoleInspector.this.userGroupsTable.clearSelection();
                } else {
                    WebAppRoleInspector.this.showUsersInSelectedRole();
                }
            }
        });
        UITitledTable roleUsersView = new UITitledTable(localStrings.getLocalString("webapproleinspector.users_label", "Users in role:"), false);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(2, 0, 0, 0);
        c.fill = 1;
        tabledPanel.add((Component)roleUsersView, c);
        this.usersTableModel = new RoleUsersTableModel(true);
        this.usersTable = new RoleUsersTable(this.usersTableModel);
        roleUsersView.setTableView(this.usersTable);
        this.usersTable.setSelectionMode(0);
        this.usersTable.setAutoResizeMode(4);
        ListSelectionModel usersSelectionModel = this.usersTable.getSelectionModel();
        usersSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel sm = (ListSelectionModel)e.getSource();
                if (!sm.isSelectionEmpty()) {
                    WebAppRoleInspector.this.userGroupsTable.clearSelection();
                    WebAppRoleInspector.this.delSecConstPB.setEnabled(true);
                } else if (WebAppRoleInspector.this.userGroupsTable.getSelectedRow() < 0) {
                    WebAppRoleInspector.this.delSecConstPB.setEnabled(false);
                }
            }
        });
        UITitledTable userGroupsView = new UITitledTable(null, false);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 0, 2, 0);
        c.fill = 1;
        tabledPanel.add((Component)userGroupsView, c);
        this.userGroupsTableModel = new RoleUsersTableModel(false);
        this.userGroupsTable = new RoleUsersTable(this.userGroupsTableModel);
        userGroupsView.setTableView(this.userGroupsTable);
        this.userGroupsTable.setSelectionMode(0);
        this.userGroupsTable.setAutoResizeMode(4);
        ListSelectionModel userGroupsSelectionModel = this.userGroupsTable.getSelectionModel();
        userGroupsSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel sm = (ListSelectionModel)e.getSource();
                if (!sm.isSelectionEmpty()) {
                    WebAppRoleInspector.this.usersTable.clearSelection();
                    WebAppRoleInspector.this.delSecConstPB.setEnabled(true);
                } else if (WebAppRoleInspector.this.usersTable.getSelectedRow() < 0) {
                    WebAppRoleInspector.this.delSecConstPB.setEnabled(false);
                }
            }
        });
        UIButton addSecConstPB = UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WebAppRoleInspector.this.addUserAction();
            }
        });
        tablesBox.addControlButton(addSecConstPB);
        this.delSecConstPB = UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WebAppRoleInspector.this.deleteUserAction();
            }
        });
        tablesBox.addControlButton(this.delSecConstPB);
        this.delSecConstPB.setEnabled(false);
        UIButton editRolesPB = new UIButton(EDIT_ROLES, EDIT_ROLES_MNEMONIC);
        editRolesPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WebAppRoleInspector.this.editRolesAction();
            }
        });
        tablesBox.addControlButton(editRolesPB);
    }

    private void showUsersInSelectedRole() {
        this.usersTable.clearTableData();
        this.userGroupsTable.clearTableData();
        if (this.descriptor == null) {
            return;
        }
        String role = this.roleNamesTable.getSelectedRole();
        if (role == null) {
            return;
        }
        SecurityRoleMapper roleMapper = this.descriptor.getApplication().getRoleMapper();
        ArrayList associatedPrincipals = new ArrayList();
        Enumeration e = null;
        e = roleMapper.getUsersAssignedTo(new Role(role));
        while (e.hasMoreElements()) {
            associatedPrincipals.add(e.nextElement());
        }
        ArrayList associatedGroups = new ArrayList();
        e = roleMapper.getGroupsAssignedTo(new Role(role));
        while (e.hasMoreElements()) {
            associatedGroups.add(e.nextElement());
        }
        Vector<StringBuffer> userNames = new Vector<StringBuffer>();
        Iterator iter = associatedPrincipals.iterator();
        while (iter.hasNext()) {
            PrincipalImpl principal = (PrincipalImpl)iter.next();
            String n = principal.getName();
            userNames.add(new StringBuffer(n));
        }
        this.usersTable.updateTableData(userNames);
        Vector<StringBuffer> groupNames = new Vector<StringBuffer>();
        iter = associatedGroups.iterator();
        while (iter.hasNext()) {
            PrincipalImpl principal = (PrincipalImpl)iter.next();
            String n = principal.getName();
            groupNames.add(new StringBuffer(n));
        }
        this.userGroupsTable.updateTableData(groupNames);
    }

    private SecurityRoleMapping getSecurityRoleMapping(String roleName) {
        SecurityRoleMapping[] roleMaps = ((SunWebApp)SunOneUtils.getSunDescriptor((Descriptor)this.descriptor)).getSecurityRoleMapping();
        for (int i = 0; i < roleMaps.length; ++i) {
            if (!roleMaps[i].getRoleName().equals(roleName)) continue;
            return roleMaps[i];
        }
        return null;
    }

    private void addRoleMapping(String roleName, String userName, String groupName) {
        SecurityRoleMapping roleMap = this.getSecurityRoleMapping(roleName);
        if (roleMap == null) {
            roleMap = new SecurityRoleMapping();
            ((SunWebApp)SunOneUtils.getSunDescriptor((Descriptor)this.descriptor)).addSecurityRoleMapping(roleMap);
            roleMap.setRoleName(roleName);
        }
        if (userName != null) {
            roleMap.addPrincipalName(userName);
        } else if (groupName != null) {
            roleMap.addGroupName(groupName);
        }
    }

    private void addUserToRoleMapper(String selectedUser) {
        String roleName = this.roleNamesTable.getSelectedRole();
        Role role = new Role(roleName);
        SecurityRoleMapper roleMapper = this.application.getRoleMapper();
        roleMapper.assignRole((Principal)new PrincipalImpl(selectedUser), role);
        this.addRoleMapping(roleName, selectedUser, null);
    }

    private void addGroupToRoleMapper(String selectedUser) {
        String roleName = this.roleNamesTable.getSelectedRole();
        Role role = new Role(roleName);
        SecurityRoleMapper roleMapper = this.application.getRoleMapper();
        roleMapper.assignRole((Principal)new Group(selectedUser), role);
        this.addRoleMapping(roleName, null, selectedUser);
    }

    private void addUserAction() {
        if (this.roleNamesTable.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this, localStrings.getLocalString("webapproleinspector.must_select_role", "You must select a role before attempting to add users."));
            return;
        }
        if (this.usersDialog == null) {
            Frame frame = this.getMyParentFrame();
            this.usersDialog = new UsersDialog(frame, ((SunWebApp)SunOneUtils.getSunDescriptor((Descriptor)this.descriptor)).getSecurityRoleMapping(), true);
            CSH.setHelpIDString((Component)this.usersDialog, (String)"AIAddUser");
            this.usersDialog.addComponentListener(new ComponentAdapter(){

                public void componentHidden(ComponentEvent we) {
                    if (WebAppRoleInspector.this.usersDialog.isFinished()) {
                        String selectedGroup;
                        String selectedUser = WebAppRoleInspector.this.usersDialog.getSelectedUser();
                        if (selectedUser != null) {
                            WebAppRoleInspector.this.addUserToRoleMapper(selectedUser);
                        }
                        if ((selectedGroup = WebAppRoleInspector.this.usersDialog.getSelectedGroup()) != null) {
                            WebAppRoleInspector.this.addGroupToRoleMapper(selectedGroup);
                        }
                        WebAppRoleInspector.this.showUsersInSelectedRole();
                    }
                }
            });
            this.usersDialog.pack();
        }
        this.usersDialog.setLocationRelativeTo(this.usersDialog.getOwner());
        this.usersDialog.setRoleMaps(((SunWebApp)SunOneUtils.getSunDescriptor((Descriptor)this.descriptor)).getSecurityRoleMapping());
        this.usersDialog.show();
    }

    private void deleteRoleMapping(String roleName, String userName, String groupName) {
        SecurityRoleMapping roleMap = this.getSecurityRoleMapping(roleName);
        if (roleMap == null) {
            return;
        }
        if (userName != null) {
            roleMap.removePrincipalName(userName);
        } else if (groupName != null) {
            roleMap.removeGroupName(groupName);
        }
    }

    private void deleteUserAction() {
        JFrame frame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this);
        SecurityRoleMapper roleMapper = this.descriptor.getApplication().getRoleMapper();
        String roleName = this.roleNamesTable.getSelectedRole();
        Role role = new Role(roleName);
        String selUserName = this.usersTable.getSelectedUser();
        String selGroupName = this.userGroupsTable.getSelectedUser();
        if (selUserName != null) {
            int n = JOptionPane.showConfirmDialog(frame, localStrings.getLocalString("webapproleinspector.sure_delete_user", "Are you sure you want to delete selected user?"), localStrings.getLocalString("webapproleinspector.delete_user", "Delete user"), 0);
            if (n == 0) {
                if (roleMapper instanceof DTRoleMapper) {
                    ((DTRoleMapper)roleMapper).unassignRole((Principal)new PrincipalImpl(selUserName), role);
                }
                this.deleteRoleMapping(roleName, selUserName, null);
                this.showUsersInSelectedRole();
            }
        } else if (selGroupName != null) {
            int n = JOptionPane.showConfirmDialog(frame, localStrings.getLocalString("webapproleinspector.sure_delete_group", "Are you sure you want to delete selected group?"), localStrings.getLocalString("webapproleinspector.delete_group", "Delete Group"), 0);
            if (n == 0) {
                if (roleMapper instanceof DTRoleMapper) {
                    ((DTRoleMapper)roleMapper).unassignRole((Principal)new Group(selGroupName), role);
                }
                this.deleteRoleMapping(roleName, null, selGroupName);
                this.showUsersInSelectedRole();
            }
        } else {
            JOptionPane.showMessageDialog(frame, localStrings.getLocalString("webapproleinspector.must_select_user_or_group", "You must first select a user or group from the list"));
        }
    }

    private void editRolesAction() {
        RolesDialog rolesDialog = RolesDialog.newRolesDialog(this, true);
        rolesDialog.showDialog((Descriptor)this.application);
    }

    public void refresh() {
        if (this.application == null) {
            return;
        }
        Vector<StringBuffer> roleNames = new Vector<StringBuffer>();
        Iterator itr = this.application.getRoles().iterator();
        while (itr.hasNext()) {
            Role nextRole = (Role)itr.next();
            String n = nextRole.getName();
            roleNames.add(new StringBuffer(n));
        }
        this.roleNamesTable.updateTableData(roleNames);
        this.showUsersInSelectedRole();
    }

    public class RoleUsersTableModel
    extends InspectorTableModel {
        public RoleUsersTableModel(boolean isUserTable) {
            super(new String[]{isUserTable ? localStrings.getLocalString("userstablemodel.user_name", "User name") : localStrings.getLocalString("userstablemodel.group_name", "Group name")});
            this.columnNames = this.columnNames;
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public Object getObjectValue(Object obj, int col) {
            return obj.toString();
        }

        public void setObjectValue(Object obj, int col, Object value) {
            StringBuffer sb = (StringBuffer)obj;
            sb.setLength(0);
            sb.append(value.toString());
        }
    }

    private class RoleUsersTable
    extends InspectorTable {
        public RoleUsersTable(RoleUsersTableModel model) {
            super(model);
            this.setSelectionMode(0);
        }

        public String getSelectedUser() {
            Object ref = this.getSelectedRowObject();
            return ref != null ? ref.toString() : null;
        }
    }

    private class RoleNamesTableModel
    extends InspectorTableModel {
        public RoleNamesTableModel() {
            super(new String[]{localStrings.getLocalString("webapproleinspector.role_names_table_col_name", "Role Name")});
        }

        public Object getObjectValue(Object obj, int col) {
            return obj.toString();
        }

        public void setObjectValue(Object obj, int col, Object value) {
            StringBuffer sb = (StringBuffer)obj;
            sb.setLength(0);
            sb.append(value.toString());
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    private class RoleNamesTable
    extends InspectorTable {
        public RoleNamesTable(RoleNamesTableModel model) {
            super(model);
            this.setToolTipText(localStrings.getLocalString("webapproleinspector.role_names_tool_tip", "Table of role names"));
            this.setSelectionMode(0);
        }

        public String getSelectedRole() {
            Object ref = this.getSelectedRowObject();
            return ref != null ? ref.toString() : null;
        }
    }
}

