/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.sunone;

import com.sun.enterprise.tools.common.dd.webapp.ConstraintField;
import com.sun.enterprise.tools.common.dd.webapp.MetaData;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.DefaultCellEditor;
import javax.swing.JPanel;
import javax.swing.table.TableColumn;

public class ValueDialog
extends UIDialog {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ValueDialog.class);
    private final String VALUE_TITLE = localStrings.getLocalString("ui.sunone.ValueDialog.Constraint_title", "Constraint Field Values");
    private final String VALUE_TOOLTIP = localStrings.getLocalString("ui.sunone.ValueDialog.Constraint_tool_tip", "Set values for constraint field");
    private final String CS_MSG = localStrings.getLocalString("ui.sunone.ValueDialog.Constraint_box_msg", "Value for Constraint {0}");
    private final String COLUMN_VALUE = localStrings.getLocalString("ui.sunone.ValueDialog.Value_column_header", "Value");
    private final String COLUMN_MATCH_EXPR = localStrings.getLocalString("ui.sunone.ValueDialog.Match_expr_column_header", "Match Expr");
    private final String COLUMN_CACHE_ON_MATCH = localStrings.getLocalString("ui.sunone.ValueDialog.Cache_on_match_column_header", "Cache on Match");
    private final String COLUMN_FAILURE = localStrings.getLocalString("ui.sunone.ValueDialog.Failure_column_header", "Failure");
    private final String MSG_MISSING_VALUE = localStrings.getLocalString("ui.sunone.ValueDialog.Missing_value", "Value column must be specified.");
    private final String TRUE = "true";
    private final String FALSE = "false";
    private static String valueDialogHelpSetMapID = "WWEditValue";
    private boolean okSelected = false;
    private ValueTable valueTable = null;
    private ConstraintField constraintField = null;
    private UITitledTable pnlValue = null;

    public ValueDialog(Frame frame, JPanel j, ConstraintField cf) {
        super(frame, true);
        this.constraintField = cf;
        this._initLayout(j);
        this.valueTable.updateTableData(cf.getConstraintFieldValue());
    }

    public ValueDialog(Dialog dialog, JPanel j, ConstraintField cf) {
        super(dialog, true);
        this.constraintField = cf;
        this._initLayout(j);
        this.valueTable.updateTableData(cf.getConstraintFieldValue());
    }

    private void _initLayout(JPanel jj) {
        this.setTitle(this.VALUE_TITLE);
        this.setWindowClosingAction(new ActionListener(){

            public void actionPerformed(ActionEvent we) {
                ValueDialog.this.cancelAction();
            }
        });
        UITitledBox contentPane = new UITitledBox(null, false);
        contentPane.setToolTipText(this.VALUE_TOOLTIP);
        contentPane.getGBConstraints().insets = new Insets(5, 5, 5, 5);
        String msg = MessageFormat.format(this.CS_MSG, this.constraintField.getName());
        this.pnlValue = new UITitledTable(msg, true);
        contentPane.addWithGBConstraints(this.pnlValue);
        this.valueTable = new ValueTable(new ValueTableModel());
        this.pnlValue.setTableView(this.valueTable);
        UIButton btnAddValue = UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ValueDialog.this.addValueAction();
            }
        });
        this.pnlValue.addControlButton(btnAddValue);
        UIButton btnDeleteValue = UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ValueDialog.this.deleteValueAction();
            }
        });
        this.pnlValue.addSelectionEnabledButton(btnDeleteValue);
        UIControlButtonBox dialogPane = new UIControlButtonBox(null, false);
        dialogPane.setControlButtonLocation(101);
        dialogPane.setView(contentPane);
        UIButton okPB = UIButton.createOkButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ValueDialog.this.okAction();
            }
        });
        dialogPane.addControlButton(okPB);
        UIButton canPB = UIButton.createCancelButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ValueDialog.this.cancelAction();
            }
        });
        dialogPane.addControlButton(canPB);
        UIHelpButton helpPB = new UIHelpButton(valueDialogHelpSetMapID);
        dialogPane.addControlButton(helpPB);
        this.setContentPane(dialogPane);
        this.setSize(500, 300);
        this.pack();
        this.setBounds(0, 0, 500, 245);
        this.setLocationRelativeTo(jj);
    }

    private void addValueAction() {
        if (this.valueTable.getRowWithValue(0, "") == null) {
            String newstr = "";
            int ix = this.constraintField.addConstraintFieldValue(newstr);
            this.constraintField.setConstraintFieldValueMatchExpr(ix, MetaData.CACHE_KEY_EXPR[0]);
            this.constraintField.setConstraintFieldValueCacheOnMatch(ix, "true");
            this.constraintField.setConstraintFieldValueCacheOnMatchFailure(ix, "false");
        }
        this.valueTable.selectRowWithValueOnUpdate(0, "");
        this.valueTable.updateTableData(this.constraintField.getConstraintFieldValue());
    }

    private void deleteValueAction() {
        Object[] list = this.valueTable.confirmDeleteSelection(null, null);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                String ref = (String)list[i];
                this.constraintField.removeConstraintFieldValue(ref);
            }
            this.valueTable.updateTableData(this.constraintField.getConstraintFieldValue());
        }
    }

    public void setConstraintField(ConstraintField cf) {
        this.constraintField = cf;
        String msg = MessageFormat.format(this.CS_MSG, this.constraintField.getName());
        this.pnlValue.setTitle(msg);
        this.valueTable.updateTableData(this.constraintField.getConstraintFieldValue());
    }

    private boolean validateEntries(boolean showErrors) {
        if (this.valueTable.getRowWithValue(0, "") != null) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, this.MSG_MISSING_VALUE);
            }
            return false;
        }
        return true;
    }

    public void okAction() {
        if (!this.validateEntries(true)) {
            return;
        }
        this.okSelected = true;
        this.hide();
    }

    public void cancelAction() {
        this.okSelected = false;
        this.hide();
    }

    public boolean userSelectedOK() {
        return this.okSelected;
    }

    public class ValueTableModel
    extends InspectorTableModel {
        public ValueTableModel() {
            super(new String[]{ValueDialog.this.COLUMN_VALUE, ValueDialog.this.COLUMN_MATCH_EXPR, ValueDialog.this.COLUMN_CACHE_ON_MATCH, ValueDialog.this.COLUMN_FAILURE});
        }

        public Object getObjectValue(Object obj, int col) {
            String value = null;
            int ix = this.getObjectIndex(obj);
            switch (col) {
                case 0: {
                    value = ValueDialog.this.constraintField.getConstraintFieldValue(ix);
                    break;
                }
                case 1: {
                    value = ValueDialog.this.constraintField.getConstraintFieldValueMatchExpr(ix);
                    break;
                }
                case 2: {
                    value = ValueDialog.this.constraintField.getConstraintFieldValueCacheOnMatch(ix);
                    break;
                }
                case 3: {
                    value = ValueDialog.this.constraintField.getConstraintFieldValueCacheOnMatchFailure(ix);
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            String str = (String)value;
            int ix = this.getObjectIndex(obj);
            switch (col) {
                case 0: {
                    ValueDialog.this.constraintField.setConstraintFieldValue(ix, str);
                    break;
                }
                case 1: {
                    ValueDialog.this.constraintField.setConstraintFieldValueMatchExpr(ix, str);
                    break;
                }
                case 2: {
                    ValueDialog.this.constraintField.setConstraintFieldValueCacheOnMatch(ix, str);
                    break;
                }
                case 3: {
                    ValueDialog.this.constraintField.setConstraintFieldValueCacheOnMatchFailure(ix, str);
                }
            }
        }
    }

    private class ValueTable
    extends InspectorTable {
        public ValueTable(ValueTableModel model) {
            super(model);
            this.setToolTipText(ValueDialog.this.VALUE_TOOLTIP);
            this.setSelectionMode(0);
            this.setAutoResizeMode(4);
            TableColumn valueColumn = this.getColumnModel().getColumn(0);
            UITitledTextField valueText = new UITitledTextField(null, false);
            valueColumn.setCellEditor(new DefaultCellEditor(valueText.getTextField()));
            TableColumn exprColumn = this.getColumnModel().getColumn(1);
            exprColumn.setCellEditor(this.getComboBoxEditor(MetaData.CACHE_KEY_EXPR));
            TableColumn matchColumn = this.getColumnModel().getColumn(2);
            matchColumn.setCellEditor(this.getComboBoxEditor(MetaData.CACHE_KEY_BOOLEAN));
            TableColumn failColumn = this.getColumnModel().getColumn(3);
            failColumn.setCellEditor(this.getComboBoxEditor(MetaData.CACHE_KEY_BOOLEAN));
        }
    }
}

