/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.sunone;

import com.sun.enterprise.tools.common.dd.SecurityRoleMapping;
import com.sun.enterprise.tools.deployment.ui.server.DTServerManager;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIPanel;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;

public class UsersDialog
extends UIDialog {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UsersDialog.class);
    private final String SCROLL_NAME = localStrings.getLocalString("ui.userdialog.scroll_name", "Scroll Panel");
    private final String SCROLL_DESC = localStrings.getLocalString("ui.userdialog.scroll_desc", "This scroll pane is for the user dialog box");
    private static String LABEL_NAME = localStrings.getLocalString("ui.userdialog.label_name", "user/group Label");
    private static String LABEL_DESC = localStrings.getLocalString("ui.userdialog.label_desc", "This is a label for user/group list options");
    private static String USERS = localStrings.getLocalString("ui.usersdialog.users", "Users");
    private static String TOOLTIP = localStrings.getLocalString("ui.usersdialog.tool_tip", "Select a user from list and press OK");
    private static String USERS_LABEL = localStrings.getLocalString("ui.usersdialog.users_label", "Users:");
    private static String GROUPS_LABEL = localStrings.getLocalString("ui.usersdialog.groups_label", "User Groups:");
    private static String SERVER_CHANGED = localStrings.getLocalString("ui.usersdialog.server_changed", "Server Changed!!");
    private static String helpSetMapID = "AIAddUser";
    DTServerManager serverManager = null;
    UsersTableModel usersTableModel = null;
    UsersTable usersTable = null;
    UsersTableModel userGroupsTableModel = null;
    UsersTable userGroupsTable = null;
    boolean finished = true;
    SecurityRoleMapping[] roleMaps = null;
    private static String[] usersColumnNames = new String[]{localStrings.getLocalString("userstablemodel.user_name", "User name")};
    private static String[] userGroupsColumnNames = new String[]{localStrings.getLocalString("userstablemodel.group_name", "Group name")};

    public UsersDialog(Frame frame, SecurityRoleMapping[] maps, boolean modal) {
        super(frame, modal);
        this.roleMaps = maps;
        this.doNothingOnClose();
        this.setTitle(USERS);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                UsersDialog.this.cancelAction();
            }
        });
        UIPanel contentPane = new UIPanel();
        contentPane.setToolTipText(TOOLTIP);
        GridBagLayout gb1 = new GridBagLayout();
        contentPane.setLayout(gb1);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.gridwidth = 1;
        JLabel tblLabel = new JLabel(USERS_LABEL);
        tblLabel.getAccessibleContext().setAccessibleName(LABEL_NAME);
        tblLabel.getAccessibleContext().setAccessibleDescription(LABEL_DESC);
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(5, 5, 0, 5);
        gb1.setConstraints(tblLabel, c);
        contentPane.add(tblLabel);
        this.usersTableModel = new UsersTableModel(usersColumnNames);
        this.userGroupsTableModel = new UsersTableModel(userGroupsColumnNames);
        this.initializeUsersTableModel();
        this.usersTable = new UsersTable(this.usersTableModel);
        JScrollPane usersTablePane = new JScrollPane(this.usersTable);
        usersTablePane.getAccessibleContext().setAccessibleName(this.SCROLL_NAME);
        usersTablePane.getAccessibleContext().setAccessibleDescription(this.SCROLL_DESC);
        this.usersTable.setSelectionMode(0);
        this.usersTable.setAutoResizeMode(4);
        this.userGroupsTable = new UsersTable(this.userGroupsTableModel);
        JScrollPane userGroupsTablePane = new JScrollPane(this.userGroupsTable);
        userGroupsTablePane.getAccessibleContext().setAccessibleName(this.SCROLL_NAME);
        userGroupsTablePane.getAccessibleContext().setAccessibleDescription(this.SCROLL_DESC);
        this.userGroupsTable.setSelectionMode(0);
        this.userGroupsTable.setAutoResizeMode(4);
        ListSelectionModel usersSelectionModel = this.usersTable.getSelectionModel();
        usersTablePane.setPreferredSize(new Dimension(300, 200));
        userGroupsTablePane.setPreferredSize(new Dimension(300, 200));
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        gb1.setConstraints(usersTablePane, c);
        contentPane.add(usersTablePane);
        UIPanel addUserButtonPanel = new UIPanel();
        UIButton addUserPB = UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String name = JOptionPane.showInputDialog(localStrings.getLocalString("ui.usersdialog.adduser_label", "Please enter a user name:"));
                UsersDialog.this.usersTableModel.addUser(name);
            }
        });
        addUserButtonPanel.add(addUserPB);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = 2;
        c.insets = new Insets(5, 5, 5, 5);
        c.anchor = 10;
        c.fill = 0;
        gb1.setConstraints(addUserButtonPanel, c);
        contentPane.add(addUserButtonPanel);
        JLabel tblGroupLabel = new JLabel(GROUPS_LABEL);
        tblGroupLabel.getAccessibleContext().setAccessibleName(LABEL_NAME);
        tblGroupLabel.getAccessibleContext().setAccessibleDescription(LABEL_DESC);
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 3;
        c.insets = new Insets(5, 5, 0, 5);
        gb1.setConstraints(tblGroupLabel, c);
        contentPane.add(tblGroupLabel);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        gb1.setConstraints(userGroupsTablePane, c);
        contentPane.add(userGroupsTablePane);
        UIPanel addGroupButtonPanel = new UIPanel();
        UIButton addGroupPB = UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String name = JOptionPane.showInputDialog(localStrings.getLocalString("ui.usersdialog.addgroup_label", "Please enter a user group name:"));
                UsersDialog.this.userGroupsTableModel.addUser(name);
            }
        });
        addGroupButtonPanel.add(addGroupPB);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = 5;
        c.insets = new Insets(5, 5, 5, 5);
        c.anchor = 10;
        c.fill = 0;
        gb1.setConstraints(addGroupButtonPanel, c);
        contentPane.add(addGroupButtonPanel);
        UIPanel dialogButtonPanel = new UIPanel();
        dialogButtonPanel.setLayout(new GridLayout(1, 3, 5, 5));
        UIButton okPB = UIButton.createOkButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UsersDialog.this.okAction();
            }
        });
        dialogButtonPanel.add(okPB);
        UIButton cancelPB = UIButton.createCancelButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UsersDialog.this.cancelAction();
            }
        });
        dialogButtonPanel.add(cancelPB);
        UIButton helpPB = UIButton.createHelpButton(helpSetMapID);
        dialogButtonPanel.add(helpPB);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = 6;
        c.insets = new Insets(5, 5, 5, 5);
        c.anchor = 13;
        c.fill = 0;
        gb1.setConstraints(dialogButtonPanel, c);
        contentPane.add(dialogButtonPanel);
        this.setContentPane(contentPane);
        contentPane.setMinimumSize(contentPane.getPreferredSize());
    }

    public String getSelectedUser() {
        int index;
        String selectedUser = null;
        ListSelectionModel sm = this.usersTable.getSelectionModel();
        if (!sm.isSelectionEmpty() && (index = this.usersTable.getSelectedRow()) >= 0) {
            UsersTableModel model = (UsersTableModel)this.usersTable.getModel();
            selectedUser = model.getUserAt(index);
        }
        return selectedUser;
    }

    public String getSelectedGroup() {
        int index;
        String selectedGroup = null;
        ListSelectionModel sm = this.userGroupsTable.getSelectionModel();
        if (!sm.isSelectionEmpty() && (index = this.userGroupsTable.getSelectedRow()) >= 0) {
            UsersTableModel model = (UsersTableModel)this.userGroupsTable.getModel();
            selectedGroup = model.getUserAt(index);
        }
        return selectedGroup;
    }

    private void initializeUsersTableModel() {
        int j;
        int i;
        try {
            Vector<String> userNames = new Vector<String>();
            for (i = 0; i < this.roleMaps.length; ++i) {
                String[] principals = this.roleMaps[i].getPrincipalName();
                for (j = 0; j < principals.length; ++j) {
                    userNames.add(principals[j]);
                }
            }
            for (i = 0; i < userNames.size(); ++i) {
                this.usersTableModel.addUser((String)userNames.get(i));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Vector<String> groupNames = new Vector<String>();
            for (i = 0; i < this.roleMaps.length; ++i) {
                String[] groups = this.roleMaps[i].getGroupName();
                for (j = 0; j < groups.length; ++j) {
                    groupNames.add(groups[j]);
                }
            }
            for (i = 0; i < groupNames.size(); ++i) {
                this.userGroupsTableModel.addUser((String)groupNames.get(i));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isFinished() {
        return this.finished;
    }

    private void okAction() {
        this.finished = true;
        this.hide();
    }

    protected void cancelAction() {
        this.usersTable.clearSelection();
        this.finished = false;
        this.hide();
    }

    public void show() {
        this.displayUsers();
        super.show();
    }

    private void displayUsers() {
        this.usersTable.clearTableData();
        this.userGroupsTable.clearTableData();
        this.initializeUsersTableModel();
    }

    public void setRoleMaps(SecurityRoleMapping[] maps) {
        this.roleMaps = maps;
    }

    private class UsersTableModel
    extends InspectorTableModel {
        public UsersTableModel(String[] columnNames) {
            super(columnNames);
        }

        public void addUser(String user) {
            super.addRowObject(super.wrapDataItem(user), true);
        }

        public String getUserAt(int index) {
            InspectorTableModel.InspectorDataWrapper ref = (InspectorTableModel.InspectorDataWrapper)super.getRowObject(index);
            return ref != null ? (String)ref.getObject() : null;
        }

        public void removeRowAt(int index) {
            super.removeRowObject(index, true);
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public Object getObjectValue(Object obj, int col) {
            InspectorTableModel.InspectorDataWrapper ref = (InspectorTableModel.InspectorDataWrapper)obj;
            return col == 0 ? (String)ref.getObject() : "";
        }

        public void setObjectValue(Object obj, int col, Object value) {
            InspectorTableModel.InspectorDataWrapper ref = (InspectorTableModel.InspectorDataWrapper)obj;
            if (col == 0) {
                ref.setObject(value);
            }
        }
    }

    private class UsersTable
    extends InspectorTable {
        public UsersTable(UsersTableModel model) {
            super(model);
            this.setSelectionMode(0);
        }
    }
}

