/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.sunone;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.tools.common.dd.DefaultResourcePrincipal;
import com.sun.enterprise.tools.common.dd.ejb.CmpResource;
import com.sun.enterprise.tools.common.dd.ejb.EnterpriseBeans;
import com.sun.enterprise.tools.common.dd.ejb.SunEjbJar;
import com.sun.enterprise.tools.deployment.ui.sunone.SunOneUtils;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.UICheckBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIPanel;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledPasswordField;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextArea;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import com.sun.jdo.api.persistence.mapping.ejb.beans.SunCmpMappings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.io.StringWriter;
import java.io.Writer;

public class SunONEEjbJarInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(SunONEEjbJarInspector.class);
    private static String CMP_RESOURCE = localStrings.getLocalString("ui.sunoneejbjarinspector.cmp_resource", "Cmp Resource");
    private static String DEFAULT_RESOURCE_PRINCIPAL = localStrings.getLocalString("ui.sunoneejbjarinspector.default_resource_principal", "Default Resource Principal");
    private static String JNDI_NAME = localStrings.getLocalString("ui.sunoneejbjarinspector.jndi_name", "Jndi Name");
    private static String JNDI_NAME_TOOLTIP = localStrings.getLocalString("ui.sunoneejbjarinspector.jndi_name_tool_tip", "Jndi Name");
    private static String MAPPING_TITLE = localStrings.getLocalString("ui.sunoneejbjarinspector.mapping_title", "Sun Cmp Mappings");
    private static String MAPPING_TOOLTIP = localStrings.getLocalString("ui.sunoneejbjarinspector.mapping_tool_tip", "Edit sun-cmp-mappings for this EJB module");
    private static String NAME = localStrings.getLocalString("ui.sunoneejbjarinspector.name", "Name");
    private static String NAME_TOOLTIP = localStrings.getLocalString("ui.sunoneejbjarinspector.name_tool_tip", "Name");
    private static String PASSWORD = localStrings.getLocalString("ui.sunoneejbjarinspector.password", "Password");
    private static String PASSWORD_TOOLTIP = localStrings.getLocalString("ui.sunoneejbjarinspector.password_tool_tip", "Password");
    private static String DATABASE_SETTINGS = localStrings.getLocalString("ui.sunoneejbjarinspector.db.title", "Database Settings...");
    private static final String DB_TABLE_TITLE = localStrings.getLocalString("ui.sunoneejbjarinspector.db.table.title", "Database Table");
    private static final String DB_TABLE_CREATE_ON_DEPLOY = localStrings.getLocalString("ui.sunoneejbjarinspector.db.table.create_table_on_deploy", "Create table on deploy");
    private static final String DB_TABLE_DELETE_ON_UNDEPLOY = localStrings.getLocalString("ui.sunoneejbjarinspector.db.table.delete_table_on_undeploy", "Delete table on undeploy");
    private static final String DB_VENDOR_NAME = localStrings.getLocalString("ui.sunoneejbjarinspector.db.vendor_name", "Vendor Name:");
    private static final String MISSING_DB_VENDOR_NAME = localStrings.getLocalString("ui.sunoneejbjarinspector.db.missing_vendor_name", "Please provide a Database Vendor Name");
    private static String CMP_RESOURCE_ACC_DSC = localStrings.getLocalString("ui.sunoneejbjarinspector.cmp_resource_acc_dsc", "Edit values for Cmp Resource");
    private static String DEFAULT_RESOURCE_PRINCIPAL_ACC_DSC = localStrings.getLocalString("ui.sunoneejbjarinspector.default_resource_principal_acc_dsc", "Edit values for default resource principal of CMP Resource");
    private static final char DB_TABLE_CREATE_ON_DEPLOY_MNEMONIC = localStrings.getLocalString("ui.sunoneejbjarinspector.db.table.create_table_on_deploy_mnemonic", "D").charAt(0);
    private static final char DB_TABLE_DELETE_ON_UNDEPLOY_MNEMONIC = localStrings.getLocalString("ui.sunoneejbjarinspector.db.table.delete_table_on_undeploy_mnemonic", "U").charAt(0);
    private UITitledBox titledBox = null;
    private UITitledBox resourcePrincipalTitledBox = null;
    private UITitledTextField jndiNameText = null;
    private UITitledTextField nameText = null;
    private UITitledPasswordField passwordText = null;
    private UITitledTextArea mappingText = null;
    private UICheckBox dbCreateOnDeploy = null;
    private UICheckBox dbDeleteOnUndeploy = null;
    private UITitledComboBox dbVendorName = null;
    private CmpResource cmpResource = null;
    private SunCmpMappings sunCmpMappings = null;
    private EjbBundleDescriptor descriptor;

    public static InspectorPane newInspectorPane(String mode) {
        return new SunONEEjbJarInspector(mode);
    }

    public String getTabName() {
        return CMP_RESOURCE;
    }

    public String getHelpID() {
        return "Cmp";
    }

    public Class getDescriptorClass() {
        return EjbBundleDescriptor.class;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor obj) {
        boolean newDescriptor;
        boolean bl = newDescriptor = obj != this.descriptor;
        if (obj instanceof EjbBundleDescriptor) {
            this.descriptor = (EjbBundleDescriptor)obj;
            SunEjbJar sunEjbJar = (SunEjbJar)SunOneUtils.getSunDescriptor((Descriptor)this.descriptor);
            EnterpriseBeans enterpriseBeans = sunEjbJar.getEnterpriseBeans();
            if (enterpriseBeans == null) {
                enterpriseBeans = new EnterpriseBeans();
                sunEjbJar.setEnterpriseBeans(enterpriseBeans);
                this.cmpResource = new CmpResource();
                enterpriseBeans.setCmpResource(this.cmpResource);
            } else {
                this.cmpResource = enterpriseBeans.getCmpResource();
                if (this.cmpResource == null) {
                    this.cmpResource = new CmpResource();
                    enterpriseBeans.setCmpResource(this.cmpResource);
                }
            }
            this.initialize(this.cmpResource);
            this.sunCmpMappings = SunOneUtils.getSunCmpMappings((Descriptor)this.descriptor);
            if (newDescriptor && null != this.sunCmpMappings) {
                this.initialize(this.sunCmpMappings);
            }
        } else {
            this.descriptor = null;
        }
        this.invokeRefresh();
    }

    private SunONEEjbJarInspector(String mode) {
        this.setInspectorMode(mode);
        this.initializeLayout();
        this.initializeAccessibility();
    }

    private void initializeLayout() {
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.titledBox = new UITitledBox(CMP_RESOURCE, true);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.titledBox, c);
        this.jndiNameText = new UITitledTextField(JNDI_NAME, false);
        this.jndiNameText.setToolTipText(JNDI_NAME_TOOLTIP);
        this.jndiNameText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                SunONEEjbJarInspector.this.cmpResource.setJndiName(SunONEEjbJarInspector.this.jndiNameText.getText());
                SunONEEjbJarInspector.this.descriptor.changed();
            }
        });
        GridBagConstraints gbc = this.titledBox.getGBConstraints();
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 18;
        this.titledBox.add((Component)this.jndiNameText, gbc);
        this.resourcePrincipalTitledBox = new UITitledBox(DEFAULT_RESOURCE_PRINCIPAL, true);
        this.titledBox.add((Component)this.resourcePrincipalTitledBox, gbc);
        this.resourcePrincipalTitledBox.getGBConstraints().weighty = 0.0;
        this.resourcePrincipalTitledBox.getGBConstraints().fill = 2;
        this.resourcePrincipalTitledBox.getGBConstraints().gridx = -1;
        this.resourcePrincipalTitledBox.getGBConstraints().gridy = 0;
        this.nameText = new UITitledTextField(NAME, false);
        this.nameText.setToolTipText(NAME_TOOLTIP);
        this.nameText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String value = SunONEEjbJarInspector.this.nameText.getText();
                if (value.length() == 0) {
                    SunONEEjbJarInspector.this.cmpResource.setDefaultResourcePrincipal(null);
                } else {
                    DefaultResourcePrincipal defaultResourcePrincipal = SunONEEjbJarInspector.this.cmpResource.getDefaultResourcePrincipal();
                    if (defaultResourcePrincipal == null) {
                        defaultResourcePrincipal = new DefaultResourcePrincipal();
                        SunONEEjbJarInspector.this.cmpResource.setDefaultResourcePrincipal(defaultResourcePrincipal);
                    }
                    defaultResourcePrincipal.setName(value);
                }
                SunONEEjbJarInspector.this.descriptor.changed();
            }
        });
        this.resourcePrincipalTitledBox.addWithGBConstraints(this.nameText);
        this.passwordText = new UITitledPasswordField(PASSWORD, false);
        this.passwordText.setToolTipText(PASSWORD_TOOLTIP);
        this.passwordText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String value = SunONEEjbJarInspector.this.passwordText.getText();
                if (value.length() == 0) {
                    SunONEEjbJarInspector.this.cmpResource.setDefaultResourcePrincipal(null);
                } else {
                    DefaultResourcePrincipal defaultResourcePrincipal = SunONEEjbJarInspector.this.cmpResource.getDefaultResourcePrincipal();
                    if (defaultResourcePrincipal == null) {
                        defaultResourcePrincipal = new DefaultResourcePrincipal();
                        SunONEEjbJarInspector.this.cmpResource.setDefaultResourcePrincipal(defaultResourcePrincipal);
                    }
                    defaultResourcePrincipal.setPassword(value);
                }
                SunONEEjbJarInspector.this.descriptor.changed();
            }
        });
        this.resourcePrincipalTitledBox.addWithGBConstraints(this.passwordText);
        this.mappingText = new UITitledTextArea(MAPPING_TITLE, false);
        this.mappingText.setToolTipText(MAPPING_TOOLTIP);
        this.mappingText.setEditable(true);
        this.mappingText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                SunONEEjbJarInspector.this.pushChange(false);
                SunONEEjbJarInspector.this.descriptor.changed();
            }
        });
        gbc.weighty = 0.5;
        gbc.fill = 1;
        this.titledBox.add((Component)this.mappingText, gbc);
        UITitledBox depSetBox = new UITitledBox(DATABASE_SETTINGS, true);
        gbc.weighty = 0.0;
        gbc.fill = 2;
        this.titledBox.add((Component)depSetBox, gbc);
        GridBagConstraints dbg = depSetBox.getGBConstraints();
        dbg.weighty = 0.0;
        dbg.fill = 2;
        UITitledBox dbTableBox = new UITitledBox(DB_TABLE_TITLE, true);
        dbg.weightx = 0.0;
        dbg.weighty = 0.0;
        dbg.fill = 0;
        dbg.gridx = 0;
        dbg.gridy = 0;
        dbg.gridwidth = 1;
        dbg.gridheight = 2;
        depSetBox.add((Component)dbTableBox, dbg);
        this.dbCreateOnDeploy = new UICheckBox(DB_TABLE_CREATE_ON_DEPLOY, DB_TABLE_CREATE_ON_DEPLOY_MNEMONIC);
        this.dbCreateOnDeploy.setSelected(false);
        this.dbCreateOnDeploy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                boolean sel = SunONEEjbJarInspector.this.dbCreateOnDeploy.isSelected();
                Print.dprintln((String)("Create On Deploy: " + sel));
                SunONEEjbJarInspector.this.cmpResource.setCreateTablesAtDeploy(Boolean.toString(sel));
                SunONEEjbJarInspector.this.descriptor.changed();
            }
        });
        dbTableBox.addWithGBConstraints(this.dbCreateOnDeploy);
        this.dbDeleteOnUndeploy = new UICheckBox(DB_TABLE_DELETE_ON_UNDEPLOY, DB_TABLE_DELETE_ON_UNDEPLOY_MNEMONIC);
        this.dbDeleteOnUndeploy.setSelected(false);
        this.dbDeleteOnUndeploy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                boolean sel = SunONEEjbJarInspector.this.dbDeleteOnUndeploy.isSelected();
                Print.dprintln((String)("Delete On Undeploy: " + sel));
                SunONEEjbJarInspector.this.cmpResource.setDropTablesAtUndeploy(Boolean.toString(sel));
                SunONEEjbJarInspector.this.descriptor.changed();
            }
        });
        dbTableBox.addWithGBConstraints(this.dbDeleteOnUndeploy);
        this.dbVendorName = new UITitledComboBox(DB_VENDOR_NAME, false);
        this.dbVendorName.setEditable(true);
        this.dbVendorName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String vendorName = SunONEEjbJarInspector.this.dbVendorName.getText();
                Print.dprintln((String)("Vendor save: " + vendorName));
                SunONEEjbJarInspector.this.cmpResource.setDatabaseVendorName(vendorName);
                SunONEEjbJarInspector.this.descriptor.changed();
            }
        });
        dbg.weightx = 0.5;
        dbg.weighty = 0.0;
        dbg.fill = 2;
        dbg.gridx = 1;
        dbg.gridy = 0;
        dbg.gridwidth = 1;
        dbg.gridheight = 1;
        dbg.insets.left = 5;
        depSetBox.add((Component)this.dbVendorName, dbg);
        this.dbVendorName.setModel(new String[]{"", "pointbase", "oracle", "sybase", "db2", "mssql", "sql92"});
        UIPanel dbFiller = new UIPanel();
        dbg.weightx = 0.5;
        dbg.weighty = 0.5;
        dbg.fill = 1;
        dbg.gridx = 1;
        dbg.gridy = 1;
        dbg.gridwidth = 1;
        dbg.gridheight = 1;
        depSetBox.add((Component)dbFiller, dbg);
    }

    private void initializeAccessibility() {
        this.titledBox.getAccessibleContext().setAccessibleDescription(CMP_RESOURCE_ACC_DSC);
        this.resourcePrincipalTitledBox.getAccessibleContext().setAccessibleDescription(DEFAULT_RESOURCE_PRINCIPAL_ACC_DSC);
    }

    public void refresh() {
        if (this.descriptor == null) {
            return;
        }
        if (null != this.sunCmpMappings) {
            this.initialize(this.sunCmpMappings);
        }
        if (this.cmpResource.getCreateTablesAtDeploy() != null) {
            this.dbCreateOnDeploy.setSelected(this.cmpResource.getCreateTablesAtDeploy().equals("true"));
        } else {
            this.dbCreateOnDeploy.setSelected(false);
        }
        if (this.cmpResource.getDropTablesAtUndeploy() != null) {
            this.dbDeleteOnUndeploy.setSelected(this.cmpResource.getDropTablesAtUndeploy().equals("true"));
        } else {
            this.dbDeleteOnUndeploy.setSelected(false);
        }
        if (this.cmpResource.getDatabaseVendorName() != null) {
            this.dbVendorName.setSelectedItem(this.cmpResource.getDatabaseVendorName(), true);
        } else {
            this.dbVendorName.setSelectedItem("", true);
        }
    }

    public boolean validateEntries(boolean showErrors) {
        return this.pushChange(showErrors);
    }

    private boolean pushChange(boolean showErrors) {
        boolean incorrectXml = false;
        try {
            if (this.mappingText.getText() != null && !this.mappingText.getText().trim().equals("")) {
                SunCmpMappings newMappings;
                StringBufferInputStream strstream = new StringBufferInputStream(this.mappingText.getText());
                this.sunCmpMappings = newMappings = SunCmpMappings.createGraph((InputStream)strstream);
                SunOneUtils.setSunCmpMappings((Descriptor)this.descriptor, newMappings);
            } else {
                SunOneUtils.removeSunCmpMappings((Descriptor)this.descriptor);
                this.sunCmpMappings = null;
            }
        }
        catch (Throwable t) {
            incorrectXml = true;
        }
        if (incorrectXml) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.sunoneejbjarinspector.descriptor_no_updated", "Errors encountered while parsing the 'Sun Cmp Mappings'."));
            }
            return false;
        }
        return true;
    }

    private void initialize(CmpResource cmpResource) {
        this.jndiNameText.setText(cmpResource.getJndiName());
        DefaultResourcePrincipal defaultResourcePrincipal = cmpResource.getDefaultResourcePrincipal();
        if (defaultResourcePrincipal != null) {
            this.nameText.setText(defaultResourcePrincipal.getName());
            this.passwordText.setText(defaultResourcePrincipal.getPassword());
        }
    }

    private void initialize(SunCmpMappings scm) {
        StringWriter dest = new StringWriter();
        try {
            scm.write((Writer)dest);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.mappingText.setText(((Object)dest).toString());
    }
}

