/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.sunone;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.common.dd.webapp.ClassLoader;
import com.sun.enterprise.tools.common.dd.webapp.Servlet;
import com.sun.enterprise.tools.common.dd.webapp.SunWebApp;
import com.sun.enterprise.tools.deployment.ui.sunone.SunOneUtils;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class ServletInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ServletInspector.class);
    private static final String CBOX_NAME = localStrings.getLocalString("ui.servletinspector.cbox_name", "Sun Specific Servlet Inspector ComboBox");
    private static final String CBOX_DESC = localStrings.getLocalString("ui.servletinspector.cbox_desc", "This is a ComboBox for Sun Specific Servlet inspector window");
    private final String SERVLET_TABNAME = localStrings.getLocalString("ui.sunone.servletInspector.tabname_servlet", "Servlet");
    private final String SERVLET_TITLE = localStrings.getLocalString("ui.sunone.servletInspector.servlet_tabletitle", "Servlet");
    private final String SERVLET_NAME = localStrings.getLocalString("ui.sunone.servletInspector.servlet_name", "Servlet Name");
    private final String PRINCIPAL_NAME = localStrings.getLocalString("ui.sunone.servletInspector.principal_name", "Principal Name");
    private final String SERVLET_TABLE_TOOLTIP = localStrings.getLocalString("ui.sunone.servletInspector.servlet_tooltip", "Set Servletand Principal Name");
    private final String MISSING_SERVLET_NAME = localStrings.getLocalString("ui.sunone.servletInspector.missing_servlet_name", "Missing Servlet name");
    private final String MISSING_PRINCIPAL_NAME = localStrings.getLocalString("ui.sunone.servletInspector.missing_principal_name", "Missing Principal name");
    private final String CLASS_TOOLTIP = localStrings.getLocalString("ui.sunone.JspInspector.Class_tool_tip", "Class Loader Properties");
    private final String CLASS_TITLE = localStrings.getLocalString("ui.sunone.JspInspector.Class_title", "Class Loader");
    private final String CLASS_PATH_HEADER = localStrings.getLocalString("ui.sunone.JspInspector.Class_extra_path", "Extra Class Path");
    private final String CLASS_DEL_HEADER = localStrings.getLocalString("ui.sunone.JspInspector.Class_delegate", "Delegate to Parent");
    private final String MISSING_EXTRA_CLASSPATH = localStrings.getLocalString("ui.sunone.JspInspector.missing_extra_classpath", "Enter value for Extra Class Path in Class Loader\nor remove 'Delegate to Parent' assignment");
    private final String ATR_NAME = "name";
    private final String ATR_VALUE = "value";
    private final String TRUE = "true";
    private final String FALSE = "false";
    private static String wizardHelpID = "SunWebAppServlet";
    private static String deployHelpID = "SunWebAppServlet";
    private WebBundleDescriptor descriptor = null;
    private SunWebApp sunWebApp = null;
    private ServletTable servletTable = null;
    private JButton btnAdd;
    private JButton btnDelete;
    private ClassTable classTable = null;
    private ClassLoader classLoader = null;

    public static InspectorPane newInspectorPane(String mode) {
        return new ServletInspector(mode);
    }

    public String getTabName() {
        return this.SERVLET_TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return WebBundleDescriptor.class;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor desc) {
        if (this.descriptor != desc) {
            this.descriptor = desc instanceof WebBundleDescriptor ? (WebBundleDescriptor)desc : null;
            this.servletTable.clearTableData();
            this.classTable.clearTableData();
            this.sunWebApp = (SunWebApp)SunOneUtils.getSunDescriptor((Descriptor)this.descriptor);
            if (this.descriptor != null) {
                this.initialize(this.sunWebApp);
            }
        }
    }

    private void initialize(SunWebApp swa) {
    }

    private ServletInspector(String mode) {
        this.setInspectorMode(mode);
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout gb1 = new GridBagLayout();
        this.setLayout(gb1);
        UITitledTable pnlServlet = new UITitledTable(this.SERVLET_TITLE, true);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)pnlServlet, c);
        this.servletTable = new ServletTable(new ServletTableModel());
        pnlServlet.setTableView(this.servletTable);
        this.btnAdd = UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ServletInspector.this.addAction();
            }
        });
        pnlServlet.addControlButton(this.btnAdd);
        this.btnDelete = UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ServletInspector.this.deleteAction();
            }
        });
        pnlServlet.addSelectionEnabledButton(this.btnDelete);
        UITitledTable pnlClass = new UITitledTable(this.CLASS_TITLE, true);
        c.weightx = 0.5;
        c.weighty = 0.2;
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)pnlClass, c);
        this.classTable = new ClassTable(new ClassTableModel());
        pnlClass.setTableView(this.classTable);
    }

    public void refresh() {
        if (this.descriptor == null) {
            return;
        }
        this.servletTable.updateTableData(this.sunWebApp.getServlet());
        this.classTable.updateTableData(this.classTable.getClassLoader());
    }

    public boolean validateEntries(boolean showErrors) {
        if (this.servletTable.getRowWithValue(0, "") != null) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, this.MISSING_SERVLET_NAME);
            }
            return false;
        }
        return true;
    }

    private void addAction() {
        int index = 0;
        Object obj0 = this.servletTable.getRowWithValue(0, "");
        Object obj1 = this.servletTable.getRowWithValue(1, "");
        if (obj0 == null && obj1 == null) {
            Servlet s = new Servlet();
            s.setServletName("");
            s.setPrincipalName("");
            this.sunWebApp.addServlet(s);
            index = 2;
            this.descriptor.changed();
        }
        if (index == 2 || obj0 != null) {
            this.servletTable.selectRowWithValueOnUpdate(0, "");
        } else {
            this.servletTable.selectRowWithValueOnUpdate(1, "");
        }
        this.invokeRefresh();
    }

    private void deleteAction() {
        Object[] list = this.servletTable.confirmDeleteSelection(null, null);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                Servlet s = (Servlet)list[i];
                this.sunWebApp.removeServlet(s);
            }
            this.descriptor.changed();
            this.invokeRefresh();
        }
    }

    public class ClassTableModel
    extends InspectorTableModel {
        private static final String CL = "ClassLoader";
        private static final String EX = "ExtraClassPath";
        private static final String DE = "Delegate";

        public ClassTableModel() {
            super(new String[]{ServletInspector.this.CLASS_PATH_HEADER, ServletInspector.this.CLASS_DEL_HEADER});
        }

        public Object getObjectValue(Object obj, int col) {
            String value = null;
            switch (col) {
                case 0: {
                    value = ServletInspector.this.sunWebApp.getAttributeValue(CL, EX);
                    break;
                }
                case 1: {
                    value = ServletInspector.this.sunWebApp.getAttributeValue(CL, DE);
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            String str = (String)value;
            ServletInspector.this.classLoader = ServletInspector.this.sunWebApp.getClassLoader();
            switch (col) {
                case 0: {
                    if (str.length() > 0) {
                        String del;
                        if (ServletInspector.this.classLoader == null) {
                            ServletInspector.this.classLoader = new ClassLoader();
                            ServletInspector.this.sunWebApp.setClassLoader(ServletInspector.this.classLoader);
                        }
                        if ((del = ServletInspector.this.sunWebApp.getAttributeValue(CL, DE)) == null || del.equals("")) {
                            ServletInspector.this.sunWebApp.setAttributeValue(CL, DE, "false");
                        }
                        ServletInspector.this.sunWebApp.setAttributeValue(CL, EX, str);
                        break;
                    }
                    ServletInspector.this.sunWebApp.setClassLoader(null);
                    break;
                }
                case 1: {
                    if (str.length() > 0) {
                        if (ServletInspector.this.classLoader == null) {
                            ServletInspector.this.classLoader = new ClassLoader();
                            ServletInspector.this.sunWebApp.setClassLoader(ServletInspector.this.classLoader);
                        }
                        ServletInspector.this.sunWebApp.setAttributeValue(CL, DE, str);
                        break;
                    }
                    String exclass = ServletInspector.this.sunWebApp.getAttributeValue(CL, EX);
                    if (exclass != null) {
                        ServletInspector.this.sunWebApp.setAttributeValue(CL, DE, ServletInspector.this.sunWebApp.getAttributeValue(CL, DE));
                        break;
                    }
                    ServletInspector.this.sunWebApp.setClassLoader(null);
                }
            }
            ServletInspector.this.descriptor.changed();
        }
    }

    private class ClassTable
    extends InspectorTable {
        public ClassTable(ClassTableModel model) {
            super(model);
            this.setToolTipText(ServletInspector.this.CLASS_TOOLTIP);
            this.setSelectionMode(0);
            this.setAutoResizeMode(4);
            TableColumn dColumn = this.getColumnModel().getColumn(1);
            Object[] booleanArray = new Object[]{"false", "true", ""};
            JComboBox<Object> dComboBox = new JComboBox<Object>(booleanArray);
            dComboBox.getAccessibleContext().setAccessibleName(CBOX_NAME);
            dComboBox.getAccessibleContext().setAccessibleDescription(CBOX_DESC);
            dColumn.setCellEditor(new DefaultCellEditor(dComboBox));
            DefaultTableCellRenderer rend = new DefaultTableCellRenderer();
            dColumn.setCellRenderer(rend);
        }

        public String[] getClassLoader() {
            String[] dummy = new String[]{""};
            return dummy;
        }
    }

    public class ServletTableModel
    extends InspectorTableModel {
        public ServletTableModel() {
            super(new String[]{ServletInspector.this.SERVLET_NAME, ServletInspector.this.PRINCIPAL_NAME});
        }

        public Object getObjectValue(Object obj, int col) {
            int ix = this.getObjectIndex(obj);
            String value = null;
            switch (col) {
                case 0: {
                    if (ServletInspector.this.sunWebApp.sizeServlet() <= 0) break;
                    value = ServletInspector.this.sunWebApp.getServlet(ix).getServletName();
                    break;
                }
                case 1: {
                    if (ServletInspector.this.sunWebApp.sizeServlet() <= 0) break;
                    value = ServletInspector.this.sunWebApp.getServlet(ix).getPrincipalName();
                }
            }
            if (value == null) {
                value = "";
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            String str = (String)value;
            int ix = this.getObjectIndex(obj);
            switch (col) {
                case 0: {
                    Servlet[] s = ServletInspector.this.sunWebApp.getServlet();
                    s[ix].setServletName(str);
                    ServletInspector.this.sunWebApp.setServlet(s);
                    break;
                }
                case 1: {
                    Servlet[] sa = ServletInspector.this.sunWebApp.getServlet();
                    sa[ix].setPrincipalName(str);
                    ServletInspector.this.sunWebApp.setServlet(sa);
                }
            }
            ServletInspector.this.descriptor.changed();
        }
    }

    private class ServletTable
    extends InspectorTable {
        public ServletTable(ServletTableModel model) {
            super(model);
            this.setToolTipText(ServletInspector.this.SERVLET_TABLE_TOOLTIP);
            this.setSelectionMode(0);
            this.setAutoResizeMode(4);
        }
    }
}

